#
# TABLE STRUCTURE FOR: payment_gateway_transaction
#

DROP TABLE IF EXISTS `payment_gateway_transaction`;

CREATE TABLE `payment_gateway_transaction` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `vendor` text NOT NULL,
  `external_id` text NOT NULL,
  `method` text NOT NULL,
  `code_number` text NOT NULL,
  `customer_id` text NOT NULL,
  `no_services` text NOT NULL,
  `invoice` text NOT NULL,
  `reference` text NOT NULL,
  `payment_url` text NOT NULL,
  `transaction_time` text NOT NULL,
  `date_created` text NOT NULL,
  `expired` text NOT NULL,
  `instructions` text NOT NULL,
  `status_payment` text NOT NULL,
  `amount` text NOT NULL,
  `paid_at` text NOT NULL,
  `result` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1030 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1, 'Tripay', '117210-230301338', 'INDOMARET', '', '', '220823143133', '230301338', 'T150017782896PYW6T', 'https://tripay.co.id/checkout/T150017782896PYW6T', '1679361367', '', '1679404567', '', '', '187220', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (2, 'Tripay', '53598-230302267', 'ALFAMART', '', '', '221229141103', '230302267', 'T150017451896GA4UA', 'https://tripay.co.id/checkout/T150017451896GA4UA', '1677721825', '', '1677765025', '', '', '167067', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (3, 'Tripay', '325460-230401382', 'INDOMARET', '', '', '220824082614', '230401382', 'T150018127527SF3LX', 'https://tripay.co.id/checkout/T150018127527SF3LX', '1680930330', '', '1680973530', '', '', '227499', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (4, 'Tripay', '108739-230402044', 'ALFAMART', '', '', '220918153421', '230402044', 'T150018190275VGQUE', 'https://tripay.co.id/checkout/T150018190275VGQUE', '1681007452', '', '1681050652', '', '', '286895', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (5, 'Tripay', '135654-230502417', 'INDOMARET', '', '', '230413125633', '230502417', 'T150019243261KMEY8', 'https://tripay.co.id/checkout/T150019243261KMEY8', '1684666783', '', '1684709983', '', '', '167835', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (6, 'Tripay', '747262-230601402', 'ALFAMART', '', '', '220824100714', '230601402', 'T1500194016434BTVL', 'https://tripay.co.id/checkout/T1500194016434BTVL', '1685576225', '', '1685619425', '', '', '187448', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (7, 'Tripay', '62403-230821001', 'INDOMARET', '', '', '230630155736', '230821001', 'T1500110638077W5WA4', 'https://tripay.co.id/checkout/T1500110638077W5WA4', '1692606733', '', '1692649933', '', '', '122208', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (8, 'Tripay', '276588-240102834', 'ALFAMART', '', '', '231120154753', '240102834', 'T1500113077120D20EX', 'https://tripay.co.id/checkout/T1500113077120D20EX', '1704604731', '', '1704647931', '', '', '166877', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (9, 'Tripay', '721066-240203117', 'ALFAMART', '', '', '231219090396', '240203117', 'T150011361932119GWR', 'https://tripay.co.id/checkout/T150011361932119GWR', '1707266964', '', '1707310164', '', '', '167489', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (10, 'Tripay', '46081-240302360', 'INDOMARET', '', '', '230630155788', '240302360', 'T1500115342013HBF4V', 'https://tripay.co.id/checkout/T1500115342013HBF4V', '1714567444', '', '1714610644', '', '', '122294', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (11, 'Tripay', '132563-240402410', 'INDOMARET', '', '', '230630155788', '240402410', 'T15001153419008MAOU', 'https://tripay.co.id/checkout/T15001153419008MAOU', '1714567257', '', '1714610457', '', '', '121927', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (12, 'Tripay', '89335-240402955', 'DANA', '', '', '231219090270', '240402955', 'T1500115223341M0YAL', 'https://tripay.co.id/checkout/T1500115223341M0YAL', '1714022763', '', '1714065963', '', '', '167680', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (13, 'Tripay', '771970-240602598', 'QRIS2', '', '', '231020095525', '240602598', 'T1500116208089QB6AX', 'https://tripay.co.id/checkout/T1500116208089QB6AX', '1718014641', '', '1718057841', '', '', '227526', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (14, 'Tripay', '490304-240603363', 'ALFAMART', '', '', '240326122281', '240603363', 'T15001160942813GKM6', 'https://tripay.co.id/checkout/T15001160942813GKM6', '1717565427', '', '1717608627', '', '', '166856', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (15, 'Tripay', '545765-240702477', 'BCAVA', '', '', '230630155960', '240702477', 'T1500116581311KKKTF', 'https://tripay.co.id/checkout/T1500116581311KKKTF', '1719882495', '', '1719925695', '', '', '122890', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (16, 'Tripay', '989310-240703366', 'SHOPEEPAY', '', '', '240326122326', '240703366', 'T15001166998375DSAS', 'https://tripay.co.id/checkout/T15001166998375DSAS', '1720357047', '', '1720400247', '', '', '124098', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (17, 'Tripay', '746699-240703443', 'ALFAMART', '', '', '240326122406', '240703443', 'T1500116645379ODCB9', 'https://tripay.co.id/checkout/T1500116645379ODCB9', '1720149612', '', '1720192812', '', '', '166956', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (18, 'Tripay', '530084-240901466', 'SHOPEEPAY', '', '', '220825101518', '240901466', 'T1500118163561QDBSC', 'https://tripay.co.id/checkout/T1500118163561QDBSC', '1725941308', '', '1726027708', '', '', '191138', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (19, 'Tripay', '776542-241103196', 'ALFAMART', '', '', '240326122272', '241103196', 'T1500120251432GTCCB', 'https://tripay.co.id/checkout/T1500120251432GTCCB', '1733034086', '', '1733120486', '', '', '167358', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (20, 'Tripay', '396451-241103346', 'INDOMARET', '', '', '240517132216', '241103346', 'T1500120771983XKUYN', 'https://tripay.co.id/checkout/T1500120771983XKUYN', '1735617624', '', '1735704024', '', '', '121831', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (21, 'Tripay', '792901-241202031', 'BRIVA', '', '', '230131154468', '241202031', 'T1500120450733W2CTU', 'https://tripay.co.id/checkout/T1500120450733W2CTU', '1733828210', '', '1733914610', '', '', '228059', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (22, 'Tripay', '135392-241202195', 'MANDIRIVA', '', '', '230617125104', '241202195', 'T1500120503488E25ZO', 'https://tripay.co.id/checkout/T1500120503488E25ZO', '1734076428', '', '1734162828', '', '', '209608', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (23, 'Tripay', '655149-241204301', 'INDOMARET', '', '', '240915081505', '241204301', 'T15001202719267R0XN', 'https://tripay.co.id/checkout/T15001202719267R0XN', '1733110149', '', '1733196549', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (24, 'Tripay', '457729-250505554', 'BRIVA', '', '', '250122091149', '250505554', 'T15001234022646052L', 'https://tripay.co.id/checkout/T15001234022646052L', '1746455804', '', '1746542204', '', '', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (25, 'Tripay', '886312-250505838', 'DANA', '', '', '250226145842', '250505838', 'T1500123332231GGVOC', 'https://tripay.co.id/checkout/T1500123332231GGVOC', '1746275515', '', '1746361915', '', '', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (26, 'Tripay', '557382-250505919', 'INDOMARET', '', '', '240907151419', '250505919', 'T1500124263436UCP0F', 'https://tripay.co.id/checkout/T1500124263436UCP0F', '1748403384', '', '1748489784', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (27, 'Tripay', '202838-250603182', 'DANA', '', '', '240608143736', '250603182', 'T1500124452329OB0XY', 'https://tripay.co.id/checkout/T1500124452329OB0XY', '1749016682', '', '1749103082', '', '', '167806', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (28, 'Tripay', '935978-250619001', 'ALFAMART', '', '', '250612140720', '250619001', 'T1500124862087WILGU', 'https://tripay.co.id/checkout/T1500124862087WILGU', '1750403968', '', '1750490368', '', '', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (29, 'Tripay', '445145-250704675', 'BCAVA', '', '', '100104460', '250704675', 'T1500125686307AD8CU', 'https://tripay.co.id/checkout/T1500125686307AD8CU', '1753189596', '', '1753275996', '', '', '128340', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (30, 'Tripay', '488342-250704942', 'INDOMARET', '', '', '300016', '250704942', 'T1500125117484XJZGS', 'https://tripay.co.id/checkout/T1500125117484XJZGS', '1751420399', '', '1751506799', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (31, 'Tripay', '80959-250802340', 'INDOMARET', '', '', '231020102470', '250802340', 'T150012588767065EYU', 'https://tripay.co.id/checkout/T150012588767065EYU', '1754054105', '', '1754140505', '', '', '122163', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (32, 'Tripay', '184623-250803411', 'BCAVA', '', '', '100103291', '250803411', 'T1500125972317BG2CX', 'https://tripay.co.id/checkout/T1500125972317BG2CX', '1754306645', '', '1754393045', '', '', '252750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (33, 'Tripay', '123155-250803430', 'SHOPEEPAY', '', '', '100103325', '250803430', 'T1500125898855PDXCI', 'https://tripay.co.id/checkout/T1500125898855PDXCI', '1754097812', '', '1754184212', '', '', '169950', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (34, 'Tripay', '882557-250805151', 'DANA', '', '', '250520104437', '250805151', 'T1500126680189NHYXS', 'https://tripay.co.id/checkout/T1500126680189NHYXS', '1756967293', '', '1757053693', '', '', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (35, 'Tripay', '43018-250805532', 'DANA', '', '', '100105049', '250805532', 'T150012599069905QXS', 'https://tripay.co.id/checkout/T150012599069905QXS', '1754366877', '', '1754453277', '', '', '253750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (36, 'Tripay', '28235-250901758', 'BCAVA', '', '', '221128125031', '250901758', 'T1500127343484NEH32', 'https://tripay.co.id/checkout/T1500127343484NEH32', '1759414558', '', '1759500958', '', '', '168201', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (37, 'Tripay', '848843-250903672', 'ALFAMART', '', '', '100040', '250903672', 'T1500126772730NLEXJ', 'https://tripay.co.id/checkout/T1500126772730NLEXJ', '1757246915', '', '1757333315', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (38, 'Tripay', '301725-250904771', 'INDOMARET', '', '', '100117', '250904771', 'T1500127610531AWTRG', 'https://tripay.co.id/checkout/T1500127610531AWTRG', '1760242373', '', '1760328773', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (39, 'Tripay', '703549-250904772', 'ALFAMART', '', '', '100118', '250904772', 'T15001267486173OYSI', 'https://tripay.co.id/checkout/T15001267486173OYSI', '1757156154', '', '1757242554', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (40, 'Tripay', '795937-250905053', 'BCAVA', '', '', '100170', '250905053', 'T15001273171161WRGC', 'https://tripay.co.id/checkout/T15001273171161WRGC', '1759361980', '', '1759448380', '', '', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (41, 'Tripay', '285349-250905877', 'BCAVA', '', '', '100225', '250905877', 'T1500127523981ZURQS', 'https://tripay.co.id/checkout/T1500127523981ZURQS', '1759985225', '', '1760071625', '', '', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (42, 'Tripay', '525573-251003143', 'DANA', '', '', '100103134', '251003143', 'T1500127712136WKVYX', 'https://tripay.co.id/checkout/T1500127712136WKVYX', '1760608050', '', '1760694450', '', '', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (43, 'Tripay', '124621-251004312', 'MANDIRIVA', '', '', '100104299', '251004312', 'T1500127616773ZOVYM', 'https://tripay.co.id/checkout/T1500127616773ZOVYM', '1760263386', '', '1760349786', '', '', '129521', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (44, 'Tripay', '405353-251004890', 'INDOMARET', '', '', '100154', '251004890', 'T1500127349908NZXQD', 'https://tripay.co.id/checkout/T1500127349908NZXQD', '1759450261', '', '1759536661', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (45, 'Tripay', '167571-251005439', 'INDOMARET', '', '', '100105196', '251005439', 'T15001273969503JDQR', 'https://tripay.co.id/checkout/T15001273969503JDQR', '1759575402', '', '1759661802', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (46, 'Tripay', '866291-251005535', 'ALFAMART', '', '', '100215', '251005535', 'T1500127480443JATFA', 'https://tripay.co.id/checkout/T1500127480443JATFA', '1759827681', '', '1759914081', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (47, 'Tripay', '800974-251004980', 'QRIS', '', '1680', '250527102517', '251004980', 'T1500127926892HJNWZ', 'https://tripay.co.id/checkout/T1500127926892HJNWZ', '1761552024', '2025-10-27', '1761553824', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (48, 'Tripay', '356824-251005439', 'ALFAMART', '', '1861', '100105196', '251005439', 'T1500127997513GOS8X', 'https://tripay.co.id/checkout/T1500127997513GOS8X', '1761894021', '2025-10-31', '1761980301', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (49, 'Tripay', '652652-251005439', 'INDOMARET', '', '1861', '100105196', '251005439', 'T1500127997524CILEL', 'https://tripay.co.id/checkout/T1500127997524CILEL', '1761894071', '2025-10-31', '1761980470', '', 'PAID', '126750', '1761910885', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (50, 'Tripay', '782700-251102493', 'ALFAMART', '', '1859', '100105189', '251102493', 'T1500128048769ZBRIL', 'https://tripay.co.id/checkout/T1500128048769ZBRIL', '1762046435', '2025-11-02', '1762132715', '', 'PAID', '126750', '1762047858', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (51, 'Tripay', '408202-251101471', 'ALFAMART', '', '714', '100103193', '251101471', 'T1500128058629Y9CIU', 'https://tripay.co.id/checkout/T1500128058629Y9CIU', '1762067416', '2025-11-02', '1762153692', '', 'PAID', '126750', '1762068493', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (52, 'Tripay', '92721-251102034', 'DANA', '', '1370', '100104318', '251102034', 'T1500128060816DRWVM', 'https://tripay.co.id/checkout/T1500128060816DRWVM', '1762072491', '2025-11-02', '1762075970', '', 'PAID', '126949', '1762072515', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (53, 'Tripay', '577348-251101239', 'INDOMARET', '', '396', '231020102454', '251101239', 'T1500128062311GBI1T', 'https://tripay.co.id/checkout/T1500128062311GBI1T', '1762076085', '2025-11-02', '1762162485', '', 'UNPAID', '126752', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (54, 'Tripay', '979054-251101239', 'INDOMARET', '', '396', '231020102454', '251101239', 'T1500128062339XZLKK', 'https://tripay.co.id/checkout/T1500128062339XZLKK', '1762076143', '2025-11-02', '1762162542', '', 'PAID', '126752', '1762076845', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (55, 'Tripay', '937646-251101679', 'ALFAMART', '', '959', '100103628', '251101679', 'T15001280628432KF9U', 'https://tripay.co.id/checkout/T15001280628432KF9U', '1762077276', '2025-11-02', '1762163556', '', 'PAID', '126750', '1762078853', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (56, 'Tripay', '816890-251101744', 'INDOMARET', '', '1041', '241223084446', '251101744', 'T1500128064805L7ZRY', 'https://tripay.co.id/checkout/T1500128064805L7ZRY', '1762081489', '2025-11-02', '1762167888', '', 'PAID', '116750', '1762081526', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (57, 'Tripay', '151588-251102452', 'DANA', '', '1816', '100105096', '251102452', 'T15001280649283OOHX', 'https://tripay.co.id/checkout/T15001280649283OOHX', '1762081747', '2025-11-02', '1762085226', '', 'PAID', '126875', '1762081766', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (58, 'Tripay', '144916-251102514', 'DANA', '', '1881', '100105228', '251102514', 'T15001280654810EF0E', 'https://tripay.co.id/checkout/T15001280654810EF0E', '1762082768', '2025-11-02', '1762086247', '', 'PAID', '126875', '1762082811', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (59, 'Tripay', '238150-251102227', 'DANA', '', '1580', '250509102410', '251102227', 'T1500128065658GBQHT', 'https://tripay.co.id/checkout/T1500128065658GBQHT', '1762083113', '2025-11-02', '1762086589', '', 'PAID', '126875', '1762083147', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (60, 'Tripay', '529402-251101483', 'QRIS2', '', '727', '100103221', '251101483', 'T1500128066065DPVWG', 'https://tripay.co.id/checkout/T1500128066065DPVWG', '1762083833', '2025-11-02', '1762085633', '', 'PAID', '126625', '1762083910', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (61, 'Tripay', '167747-251101960', 'BCAVA', '', '1282', '250215145619', '251101960', 'T150012806665673EXE', 'https://tripay.co.id/checkout/T150012806665673EXE', '1762084890', '2025-11-02', '1762171289', '', 'PAID', '127750', '1762084951', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (62, 'Tripay', '226413-251102632', 'INDOMARET', '', '2002', '100105465', '251102632', 'T1500128067078EIYOR', 'https://tripay.co.id/checkout/T1500128067078EIYOR', '1762085658', '2025-11-02', '1762172057', '', 'PAID', '126750', '1762087092', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (63, 'Tripay', '910780-251102302', 'ALFAMART', '', '1659', '250522110910', '251102302', 'T1500128076943XKLJO', 'https://tripay.co.id/checkout/T1500128076943XKLJO', '1762130385', '2025-11-03', '1762216665', '', 'PAID', '126750', '1762162719', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (64, 'Tripay', '939710-251103001', 'INDOMARET', '', '976', '100103675', '251103001', 'T1500128077141CUNIS', 'https://tripay.co.id/checkout/T1500128077141CUNIS', '1762130914', '2025-11-03', '1762217314', '', 'PAID', '126750', '1762131790', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (65, 'Tripay', '464335-251102519', 'QRIS2', '', '1886', '100105239', '251102519', 'T15001280771996M5OR', 'https://tripay.co.id/checkout/T15001280771996M5OR', '1762131036', '2025-11-03', '1762132835', '', 'PAID', '126625', '1762131087', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (66, 'Tripay', '20086-251102243', 'INDOMARET', '', '1597', '100104747', '251102243', 'T1500128077467R12HW', 'https://tripay.co.id/checkout/T1500128077467R12HW', '1762131731', '2025-11-03', '1762218131', '', 'PAID', '126750', '1762136057', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (67, 'Tripay', '513748-251101137', 'BRIVA', '', '229', '221022090613', '251101137', 'T1500128077674CSWAA', 'https://tripay.co.id/checkout/T1500128077674CSWAA', '1762132245', '2025-11-03', '1762218639', '', 'PAID', '127977', '1762132322', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (68, 'Tripay', '286704-251102235', 'QRIS2', '', '1589', '100104729', '251102235', 'T1500128078204S88H9', 'https://tripay.co.id/checkout/T1500128078204S88H9', '1762133378', '2025-11-03', '1762135177', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (69, 'Tripay', '705488-251102235', 'QRIS2', '', '1589', '100104729', '251102235', 'T1500128078406XVQYZ', 'https://tripay.co.id/checkout/T1500128078406XVQYZ', '1762133756', '2025-11-03', '1762135555', '', 'PAID', '126625', '1762133915', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (70, 'Tripay', '52205-251101524', 'QRIS', '', '777', '100103298', '251101524', 'T1500128079934S4RPT', 'https://tripay.co.id/checkout/T1500128079934S4RPT', '1762136843', '2025-11-03', '1762138643', '', 'PAID', '125812', '1762136900', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (71, 'Tripay', '9030-251101523', 'QRIS', '', '776', '100103297', '251101523', 'T1500128079991JQQ9S', 'https://tripay.co.id/checkout/T1500128079991JQQ9S', '1762136953', '2025-11-03', '1762138752', '', 'PAID', '125812', '1762137008', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (72, 'Tripay', '509263-251101285', 'INDOMARET', '', '469', '231219090491', '251101285', 'T1500128082709AKQEK', 'https://tripay.co.id/checkout/T1500128082709AKQEK', '1762141649', '2025-11-03', '1762228048', '', 'PAID', '127357', '1762141931', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (73, 'Tripay', '263047-251102061', 'SHOPEEPAY', '', '1400', '100104367', '251102061', 'T15001280828668T8SF', 'https://tripay.co.id/checkout/T15001280828668T8SF', '1762141937', '2025-11-03', '1762145417', '', 'PAID', '129348', '1762141987', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (74, 'Tripay', '378014-251102077', 'BRIVA', '', '1416', '100104438', '251102077', 'T1500128083442N6ESD', 'https://tripay.co.id/checkout/T1500128083442N6ESD', '1762142907', '2025-11-03', '1762229300', '', 'PAID', '128059', '1762143049', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (75, 'Tripay', '611745-251102226', 'QRIS2', '', '1579', '250509102156', '251102226', 'T1500128085819O2KWW', 'https://tripay.co.id/checkout/T1500128085819O2KWW', '1762147790', '2025-11-03', '1762149589', '', 'PAID', '126625', '1762147897', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (76, 'Tripay', '52221-251101433', 'QRIS', '', '666', '100103113', '251101433', 'T15001280868524OBO5', 'https://tripay.co.id/checkout/T15001280868524OBO5', '1762149811', '2025-11-03', '1762151611', '', 'PAID', '125812', '1762149860', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (77, 'Tripay', '661882-251101561', 'INDOMARET', '', '820', '100103403', '251101561', 'T1500128089485SANSX', 'https://tripay.co.id/checkout/T1500128089485SANSX', '1762154899', '2025-11-03', '1762241299', '', 'PAID', '126750', '1762154980', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (78, 'Tripay', '906322-251101525', 'SHOPEEPAY', '', '779', '100103300', '251101525', 'T1500128089659EUQXG', 'https://tripay.co.id/checkout/T1500128089659EUQXG', '1762155270', '2025-11-03', '1762158749', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (79, 'Tripay', '511897-251101525', 'SHOPEEPAY', '', '779', '100103300', '251101525', 'T1500128089660UL8IB', 'https://tripay.co.id/checkout/T1500128089660UL8IB', '1762155270', '2025-11-03', '1762158750', '', 'PAID', '128750', '1762155386', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (80, 'Tripay', '87979-251102549', 'QRIS2', '', '1917', '100105308', '251102549', 'T1500128089863YW1QI', 'https://tripay.co.id/checkout/T1500128089863YW1QI', '1762155737', '2025-11-03', '1762157537', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (81, 'Tripay', '503747-251102549', 'BCAVA', '', '1917', '100105308', '251102549', 'T1500128089924PQAPZ', 'https://tripay.co.id/checkout/T1500128089924PQAPZ', '1762155850', '2025-11-03', '1762242250', '', 'PAID', '127750', '1762155956', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (82, 'Tripay', '662358-251101696', 'INDOMARET', '', '980', '100103683', '251101696', 'T1500128090965P9MEX', 'https://tripay.co.id/checkout/T1500128090965P9MEX', '1762158198', '2025-11-03', '1762244597', '', 'PAID', '126750', '1762162023', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (83, 'Tripay', '814527-251101927', 'DANA', '', '1246', '250215075839', '251101927', 'T1500128091226A2CWR', 'https://tripay.co.id/checkout/T1500128091226A2CWR', '1762158800', '2025-11-03', '1762162280', '', 'PAID', '126875', '1762158817', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (84, 'Tripay', '574857-251102376', 'DANA', '', '1737', '100104939', '251102376', 'T1500128094629KQOF6', 'https://tripay.co.id/checkout/T1500128094629KQOF6', '1762165923', '2025-11-03', '1762169402', '', 'PAID', '126875', '1762166001', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (85, 'Tripay', '75073-251102487', 'DANA', '', '1853', '100105171', '251102487', 'T1500128097228GVMDG', 'https://tripay.co.id/checkout/T1500128097228GVMDG', '1762170542', '2025-11-03', '1762174021', '', 'PAID', '126875', '1762170566', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (86, 'Tripay', '184218-251102109', 'DANA', '', '1450', '100104485', '251102109', 'T1500128097989GOTY9', 'https://tripay.co.id/checkout/T1500128097989GOTY9', '1762171762', '2025-11-03', '1762175241', '', 'PAID', '127559', '1762171787', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (87, 'Tripay', '158184-251101923', 'INDOMARET', '', '1242', '250214152145', '251101923', 'T1500128099498QVOZH', 'https://tripay.co.id/checkout/T1500128099498QVOZH', '1762174364', '2025-11-03', '1762260764', '', 'PAID', '126750', '1762174628', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (88, 'Tripay', '846996-251101411', 'SHOPEEPAY', '', '636', '240608143822', '251101411', 'T15001281010257UBXI', 'https://tripay.co.id/checkout/T15001281010257UBXI', '1762177085', '2025-11-03', '1762180564', '', 'UNPAID', '129131', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (89, 'Tripay', '302585-251101411', 'QRIS', '', '636', '240608143822', '251101411', 'T1500128101187IYT3B', 'https://tripay.co.id/checkout/T1500128101187IYT3B', '1762177408', '2025-11-03', '1762179207', '', 'PAID', '126183', '1762177554', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (90, 'Tripay', '504806-251101863', 'OVO', '', '1177', '250121092237', '251101863', 'T1500128103335LZ8BY', 'https://tripay.co.id/checkout/T1500128103335LZ8BY', '1762183847', '2025-11-03', '1762270247', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (91, 'Tripay', '838241-251101863', 'OVO', '', '1177', '250121092237', '251101863', 'T1500128103349TCRGG', 'https://tripay.co.id/checkout/T1500128103349TCRGG', '1762183952', '2025-11-03', '1762270352', '', 'PAID', '126875', '1762183964', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (92, 'Tripay', '158035-251102273', 'INDOMARET', '', '1627', '100104796', '251102273', 'T1500128107630YXQ6E', 'https://tripay.co.id/checkout/T1500128107630YXQ6E', '1762214866', '2025-11-04', '1762301266', '', 'PAID', '126750', '1762217127', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (93, 'Tripay', '571277-251102592', 'INDOMARET', '', '1961', '100105395', '251102592', 'T1500128111193KLJJE', 'https://tripay.co.id/checkout/T1500128111193KLJJE', '1762222832', '2025-11-04', '1762309231', '', 'PAID', '126750', '1762223365', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (94, 'Tripay', '855554-251102643', 'QRIS2', '', '2013', '100105498', '251102643', 'T1500128111226X0N6E', 'https://tripay.co.id/checkout/T1500128111226X0N6E', '1762222894', '2025-11-04', '1762224694', '', 'PAID', '126625', '1762222972', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (95, 'Tripay', '481073-251102154', 'DANA', '', '1500', '100104531', '251102154', 'T15001281113490OHTT', 'https://tripay.co.id/checkout/T15001281113490OHTT', '1762223139', '2025-11-04', '1762226617', '', 'PAID', '127841', '1762223256', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (96, 'Tripay', '179796-251102667', 'QRIS2', '', '2037', '100105540', '251102667', 'T1500128111925WCGRR', 'https://tripay.co.id/checkout/T1500128111925WCGRR', '1762224336', '2025-11-04', '1762226135', '', 'PAID', '126625', '1762224360', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (97, 'Tripay', '143154-251101452', 'QRIS2', '', '691', '100103162', '251101452', 'T1500128112641BTTSI', 'https://tripay.co.id/checkout/T1500128112641BTTSI', '1762225728', '2025-11-04', '1762227528', '', 'PAID', '126625', '1762225872', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (98, 'Tripay', '64154-251102342', 'DANA', '', '1701', '100104876', '251102342', 'T1500128119863DQNDA', 'https://tripay.co.id/checkout/T1500128119863DQNDA', '1762241004', '2025-11-04', '1762244483', '', 'PAID', '126875', '1762241138', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (99, 'Tripay', '406958-251102245', 'MANDIRIVA', '', '1599', '100104753', '251102245', 'T1500128120989GBNDC', 'https://tripay.co.id/checkout/T1500128120989GBNDC', '1762243372', '2025-11-04', '1762329772', '', 'PAID', '167125', '1762243610', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (100, 'Tripay', '737214-251102245', 'MANDIRIVA', '', '1599', '100104753', '251102245', 'T1500128121046Y2NUT', 'https://tripay.co.id/checkout/T1500128121046Y2NUT', '1762243528', '2025-11-04', '1762329928', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (101, 'Tripay', '941244-251102291', 'BCAVA', '', '1646', '250516093112', '251102291', 'T1500128122274JVDBG', 'https://tripay.co.id/checkout/T1500128122274JVDBG', '1762246455', '2025-11-04', '1762332855', '', 'PAID', '127750', '1762246656', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (102, 'Tripay', '801363-251101368', 'SHOPEEPAY', '', '589', '240608143739', '251101368', 'T1500128122762PT7BV', 'https://tripay.co.id/checkout/T1500128122762PT7BV', '1762247586', '2025-11-04', '1762251065', '', 'PAID', '129166', '1762247625', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (103, 'Tripay', '527241-251102188', 'SHOPEEPAY', '', '1537', '100104599', '251102188', 'T1500128123411UTCDC', 'https://tripay.co.id/checkout/T1500128123411UTCDC', '1762249071', '2025-11-04', '1762252550', '', 'UNPAID', '129549', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (104, 'Tripay', '80299-251102442', 'INDOMARET', '', '1806', '100105073', '251102442', 'T1500128123422TFJDA', 'https://tripay.co.id/checkout/T1500128123422TFJDA', '1762249099', '2025-11-04', '1762335499', '', 'PAID', '126750', '1762249180', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (105, 'Tripay', '31528-251102188', 'QRIS', '', '1537', '100104599', '251102188', 'T1500128123433MO5VF', 'https://tripay.co.id/checkout/T1500128123433MO5VF', '1762249127', '2025-11-04', '1762250926', '', 'PAID', '126590', '1762249570', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (106, 'Tripay', '189989-251102748', 'DANA', '', '2118', '100105646', '251102748', 'T1500128123662MQKYV', 'https://tripay.co.id/checkout/T1500128123662MQKYV', '1762249638', '2025-11-04', '1762253115', '', 'PAID', '126875', '1762249667', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (107, 'Tripay', '577413-251101681', 'QRIS2', '', '961', '100103635', '251101681', 'T1500128123747FXVKB', 'https://tripay.co.id/checkout/T1500128123747FXVKB', '1762249835', '2025-11-04', '1762251635', '', 'PAID', '126625', '1762249951', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (108, 'Tripay', '503680-251101306', 'DANA', '', '494', '231219090639', '251101306', 'T1500128124393C1PN6', 'https://tripay.co.id/checkout/T1500128124393C1PN6', '1762251125', '2025-11-04', '1762254604', '', 'PAID', '127866', '1762251176', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (109, 'Tripay', '72840-251101363', 'BRIVA', '', '582', '240608143715', '251101363', 'T1500128124717JRAFC', 'https://tripay.co.id/checkout/T1500128124717JRAFC', '1762251826', '2025-11-04', '1762338219', '', 'PAID', '128047', '1762251872', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (110, 'Tripay', '268836-251102657', 'DANA', '', '2027', '100105525', '251102657', 'T1500128124835YWUV3', 'https://tripay.co.id/checkout/T1500128124835YWUV3', '1762252094', '2025-11-04', '1762255573', '', 'PAID', '126875', '1762252366', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (111, 'Tripay', '26507-251102170', 'QRIS2', '', '1519', '100104567', '251102170', 'T1500128124928L9FPC', 'https://tripay.co.id/checkout/T1500128124928L9FPC', '1762252339', '2025-11-04', '1762254138', '', 'UNPAID', '127608', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (112, 'Tripay', '567527-251102626', 'QRIS2', '', '1996', '100105457', '251102626', 'T1500128125240AXWMW', 'https://tripay.co.id/checkout/T1500128125240AXWMW', '1762252952', '2025-11-04', '1762254752', '', 'PAID', '126625', '1762253026', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (113, 'Tripay', '977148-251104001', 'BCAVA', '', '2088', '100105594', '251104001', 'T1500128125242BUBUG', 'https://tripay.co.id/checkout/T1500128125242BUBUG', '1762252961', '2025-11-04', '1762339360', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (114, 'Tripay', '822581-251102673', 'BCAVA', '', '2043', '100105548', '251102673', 'T1500128125376RROHH', 'https://tripay.co.id/checkout/T1500128125376RROHH', '1762253282', '2025-11-04', '1762339682', '', 'PAID', '127750', '1762253439', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (115, 'Tripay', '508452-251102636', 'QRIS2', '', '2006', '100105481', '251102636', 'T1500128125450REFW4', 'https://tripay.co.id/checkout/T1500128125450REFW4', '1762253444', '2025-11-04', '1762255244', '', 'PAID', '126625', '1762253826', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (116, 'Tripay', '441840-251102636', 'QRIS2', '', '2006', '100105481', '251102636', 'T1500128125487OBLJG', 'https://tripay.co.id/checkout/T1500128125487OBLJG', '1762253524', '2025-11-04', '1762255323', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (117, 'Tripay', '209061-251102636', 'BCAVA', '', '2006', '100105481', '251102636', 'T1500128125508CFKWP', 'https://tripay.co.id/checkout/T1500128125508CFKWP', '1762253564', '2025-11-04', '1762339964', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (118, 'Tripay', '196224-251102636', 'QRIS2', '', '2006', '100105481', '251102636', 'T1500128125539WP9RN', 'https://tripay.co.id/checkout/T1500128125539WP9RN', '1762253624', '2025-11-04', '1762255424', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (119, 'Tripay', '255783-251102358', 'QRIS2', '', '1718', '250613114049', '251102358', 'T1500128126578GB2TD', 'https://tripay.co.id/checkout/T1500128126578GB2TD', '1762255574', '2025-11-04', '1762257373', '', 'PAID', '126625', '1762255624', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (120, 'Tripay', '61472-251102511', 'DANA', '', '1878', '100105222', '251102511', 'T15001281266478KR7F', 'https://tripay.co.id/checkout/T15001281266478KR7F', '1762255668', '2025-11-04', '1762259147', '', 'PAID', '126875', '1762255681', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (121, 'Tripay', '542275-251102536', 'SHOPEEPAY', '', '1904', '100105275', '251102536', 'T1500128127050UUPBT', 'https://tripay.co.id/checkout/T1500128127050UUPBT', '1762256350', '2025-11-04', '1762259829', '', 'PAID', '128750', '1762256410', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (122, 'Tripay', '829496-251102722', 'DANA', '', '2092', '100105605', '251102722', 'T15001281277367TRCW', 'https://tripay.co.id/checkout/T15001281277367TRCW', '1762257486', '2025-11-04', '1762260965', '', 'PAID', '126875', '1762257556', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (123, 'Tripay', '279537-251102360', 'DANA', '', '1720', '100104906', '251102360', 'T1500128127804JPEPK', 'https://tripay.co.id/checkout/T1500128127804JPEPK', '1762257595', '2025-11-04', '1762261074', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (124, 'Tripay', '774810-251102250', 'MANDIRIVA', '', '1604', '100104760', '251102250', 'T1500128128940MIESH', 'https://tripay.co.id/checkout/T1500128128940MIESH', '1762259379', '2025-11-04', '1762345771', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (125, 'Tripay', '980920-251102250', 'MANDIRIVA', '', '1604', '100104760', '251102250', 'T1500128129005DEXWT', 'https://tripay.co.id/checkout/T1500128129005DEXWT', '1762259478', '2025-11-04', '1762345878', '', 'PAID', '127125', '1762259554', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (126, 'Tripay', '711909-251101731', 'BNIVA', '', '1024', '241214091841', '251101731', 'T1500128129046CVLCJ', 'https://tripay.co.id/checkout/T1500128129046CVLCJ', '1762259561', '2025-11-04', '1762345841', '', 'PAID', '129250', '1762259606', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (127, 'Tripay', '603517-251102319', 'DANA', '', '1676', '100104840', '251102319', 'T1500128129503E54U6', 'https://tripay.co.id/checkout/T1500128129503E54U6', '1762260332', '2025-11-04', '1762263811', '', 'PAID', '126875', '1762260354', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (128, 'Tripay', '857293-251101430', 'SHOPEEPAY', '', '662', '100103102', '251101430', 'T1500128130307X8AHA', 'https://tripay.co.id/checkout/T1500128130307X8AHA', '1762261741', '2025-11-04', '1762265221', '', 'PAID', '128750', '1762262275', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (129, 'Tripay', '314765-251102306', 'QRIS2', '', '1663', '250522112400', '251102306', 'T1500128130359FW7TB', 'https://tripay.co.id/checkout/T1500128130359FW7TB', '1762261809', '2025-11-04', '1762263608', '', 'PAID', '126625', '1762261858', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (130, 'Tripay', '925405-251102548', 'ALFAMART', '', '1916', '100105304', '251102548', 'T1500128130407KYFUG', 'https://tripay.co.id/checkout/T1500128130407KYFUG', '1762261893', '2025-11-04', '1762348173', '', 'PAID', '126750', '1762262004', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (131, 'Tripay', '81351-251102111', 'ALFAMART', '', '1452', '100104488', '251102111', 'T15001281304901STJZ', 'https://tripay.co.id/checkout/T15001281304901STJZ', '1762262048', '2025-11-04', '1762348327', '', 'PAID', '127159', '1762262289', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (132, 'Tripay', '836048-251101704', 'BCAVA', '', '989', '241212130651', '251101704', 'T1500128132040CNKRK', 'https://tripay.co.id/checkout/T1500128132040CNKRK', '1762265128', '2025-11-04', '1762351527', '', 'PAID', '127750', '1762265308', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (133, 'Tripay', '856094-251102073', 'MANDIRIVA', '', '1412', '100104394', '251102073', 'T1500128132085RTPHK', 'https://tripay.co.id/checkout/T1500128132085RTPHK', '1762265262', '2025-11-04', '1762351661', '', 'UNPAID', '128058', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (134, 'Tripay', '44438-251102073', 'BCAVA', '', '1412', '100104394', '251102073', 'T1500128132135UMO7L', 'https://tripay.co.id/checkout/T1500128132135UMO7L', '1762265365', '2025-11-04', '1762351765', '', 'PAID', '128683', '1762265458', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (135, 'Tripay', '558998-251101806', 'BCAVA', '', '1113', '250116151649', '251101806', 'T1500128132484MJ2TU', 'https://tripay.co.id/checkout/T1500128132484MJ2TU', '1762266140', '2025-11-04', '1762352540', '', 'PAID', '127750', '1762266229', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (136, 'Tripay', '85005-251101788', 'DANA', '', '1092', '100103895', '251101788', 'T1500128133012A4B5K', 'https://tripay.co.id/checkout/T1500128133012A4B5K', '1762267407', '2025-11-04', '1762270886', '', 'PAID', '126875', '1762267446', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (137, 'Tripay', '888375-251102379', 'BRIVA', '', '1740', '100104946', '251102379', 'T1500128133229BQZ5C', 'https://tripay.co.id/checkout/T1500128133229BQZ5C', '1762267911', '2025-11-04', '1762354305', '', 'PAID', '127125', '1762268643', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (138, 'Tripay', '596597-251102363', 'QRIS2', '', '1723', '100104912', '251102363', 'T1500128136671ORHGJ', 'https://tripay.co.id/checkout/T1500128136671ORHGJ', '1762293671', '2025-11-05', '1762295471', '', 'PAID', '126625', '1762293693', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (139, 'Tripay', '774217-251102012', 'BCAVA', '', '1346', '100104282', '251102012', 'T1500128137337RTKVP', 'https://tripay.co.id/checkout/T1500128137337RTKVP', '1762296805', '2025-11-05', '1762383205', '', 'PAID', '127750', '1762296889', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (140, 'Tripay', '877630-251101487', 'INDOMARET', '', '732', '100103227', '251101487', 'T1500128138466ICAV5', 'https://tripay.co.id/checkout/T1500128138466ICAV5', '1762300717', '2025-11-05', '1762387116', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (141, 'Tripay', '721402-251101487', 'ALFAMART', '', '732', '100103227', '251101487', 'T15001281385025IWGP', 'https://tripay.co.id/checkout/T15001281385025IWGP', '1762300801', '2025-11-05', '1762387081', '', 'PAID', '126750', '1762303410', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (142, 'Tripay', '338031-251101320', 'BRIVA', '', '519', '240326122269', '251101320', 'T1500128138945YOXYC', 'https://tripay.co.id/checkout/T1500128138945YOXYC', '1762301885', '2025-11-05', '1762388284', '', 'PAID', '127916', '1762301971', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (143, 'Tripay', '125455-251102758', 'QRIS2', '', '2128', '100105672', '251102758', 'T1500128140015ART55', 'https://tripay.co.id/checkout/T1500128140015ART55', '1762304685', '2025-11-05', '1762306485', '', 'PAID', '97422', '1762304802', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (144, 'Tripay', '817118-251101078', 'BRIVA', '', '130', '220825153154', '251101078', 'T1500128140239JBB6C', 'https://tripay.co.id/checkout/T1500128140239JBB6C', '1762305171', '2025-11-05', '1762391564', '', 'UNPAID', '112435', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (145, 'Tripay', '749952-251102743', 'MANDIRIVA', '', '2113', '100105639', '251102743', 'T1500128140642D9IOT', 'https://tripay.co.id/checkout/T1500128140642D9IOT', '1762305979', '2025-11-05', '1762392379', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (146, 'Tripay', '667097-251102743', 'MANDIRIVA', '', '2113', '100105639', '251102743', 'T1500128140700SIDLF', 'https://tripay.co.id/checkout/T1500128140700SIDLF', '1762306118', '2025-11-05', '1762392517', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (147, 'Tripay', '879517-251102558', 'BRIVA', '', '1926', '100105328', '251102558', 'T1500128140807UNAYD', 'https://tripay.co.id/checkout/T1500128140807UNAYD', '1762306372', '2025-11-05', '1762392772', '', 'PAID', '127125', '1762306845', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (148, 'Tripay', '941548-251102423', 'QRIS2', '', '1786', '100105039', '251102423', 'T15001281413077CVHD', 'https://tripay.co.id/checkout/T15001281413077CVHD', '1762307338', '2025-11-05', '1762309138', '', 'PAID', '126625', '1762307406', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (149, 'Tripay', '410665-251101262', 'BNIVA', '', '429', '231219083199', '251101262', 'T1500128141336HL4YD', 'https://tripay.co.id/checkout/T1500128141336HL4YD', '1762307387', '2025-11-05', '1762393667', '', 'UNPAID', '129958', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (150, 'Tripay', '531935-251102288', 'DANA', '', '1642', '100104820', '251102288', 'T1500128141347E7KHC', 'https://tripay.co.id/checkout/T1500128141347E7KHC', '1762307400', '2025-11-05', '1762310879', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (151, 'Tripay', '109285-251101262', 'BRIVA', '', '429', '231219083199', '251101262', 'T1500128141402D3UZM', 'https://tripay.co.id/checkout/T1500128141402D3UZM', '1762307511', '2025-11-05', '1762393911', '', 'PAID', '127833', '1762307535', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (152, 'Tripay', '861143-251102288', 'DANA', '', '1642', '100104820', '251102288', 'T150012814145158T2M', 'https://tripay.co.id/checkout/T150012814145158T2M', '1762307615', '2025-11-05', '1762311095', '', 'PAID', '126875', '1762307670', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (153, 'Tripay', '820738-251102128', 'BCAVA', '', '1470', '250411132422', '251102128', 'T1500128141814YSKG7', 'https://tripay.co.id/checkout/T1500128141814YSKG7', '1762308297', '2025-11-05', '1762394697', '', 'PAID', '128480', '1762308505', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (154, 'Tripay', '224709-251102233', 'BCAVA', '', '1587', '100104725', '251102233', 'T1500128141841AQ1KV', 'https://tripay.co.id/checkout/T1500128141841AQ1KV', '1762308345', '2025-11-05', '1762394745', '', 'PAID', '127750', '1762308437', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (155, 'Tripay', '32098-251102298', 'QRIS2', '', '1655', '250522105402', '251102298', 'T1500128142433LFWHC', 'https://tripay.co.id/checkout/T1500128142433LFWHC', '1762309454', '2025-11-05', '1762311253', '', 'PAID', '126625', '1762309500', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (156, 'Tripay', '796859-251102743', 'BRIVA', '', '2113', '100105639', '251102743', 'T1500128142530AMPUB', 'https://tripay.co.id/checkout/T1500128142530AMPUB', '1762309652', '2025-11-05', '1762396045', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (157, 'Tripay', '319403-251101526', 'QRIS2', '', '780', '100103302', '251101526', 'T1500128142892SOF8B', 'https://tripay.co.id/checkout/T1500128142892SOF8B', '1762310381', '2025-11-05', '1762312181', '', 'PAID', '126625', '1762310440', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (158, 'Tripay', '93771-251101474', 'INDOMARET', '', '717', '100103197', '251101474', 'T1500128143152TVBMW', 'https://tripay.co.id/checkout/T1500128143152TVBMW', '1762310974', '2025-11-05', '1762397374', '', 'PAID', '126750', '1762311014', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (159, 'Tripay', '414557-251102436', 'BRIVA', '', '1800', '100105065', '251102436', 'T1500128143241MI6CQ', 'https://tripay.co.id/checkout/T1500128143241MI6CQ', '1762311150', '2025-11-05', '1762397543', '', 'PAID', '127125', '1762311983', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (160, 'Tripay', '847747-251101761', 'DANA', '', '1063', '241226130604', '251101761', 'T150012814438048BPM', 'https://tripay.co.id/checkout/T150012814438048BPM', '1762313397', '2025-11-05', '1762316876', '', 'PAID', '126875', '1762313434', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (161, 'Tripay', '617207-251101873', 'DANA', '', '1189', '250121130848', '251101873', 'T1500128144556VFU3H', 'https://tripay.co.id/checkout/T1500128144556VFU3H', '1762313720', '2025-11-05', '1762317199', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (162, 'Tripay', '650471-251102608', 'QRIS2', '', '1978', '100105424', '251102608', 'T1500128145651RC729', 'https://tripay.co.id/checkout/T1500128145651RC729', '1762315919', '2025-11-05', '1762319519', '', 'PAID', '126625', '1762315982', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (163, 'Tripay', '158181-251101284', 'BCAVA', '', '467', '231219090468', '251101284', 'T1500128145746YYB9I', 'https://tripay.co.id/checkout/T1500128145746YYB9I', '1762316094', '2025-11-05', '1762402494', '', 'PAID', '128106', '1762316133', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (164, 'Tripay', '541596-251102340', 'BCAVA', '', '1699', '100104873', '251102340', 'T1500128145820O4Y91', 'https://tripay.co.id/checkout/T1500128145820O4Y91', '1762316245', '2025-11-05', '1762402645', '', 'PAID', '127750', '1762316524', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (165, 'Tripay', '107641-251102003', 'BCAVA', '', '1335', '250227103606', '251102003', 'T1500128147371I7PZO', 'https://tripay.co.id/checkout/T1500128147371I7PZO', '1762318910', '2025-11-05', '1762405309', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (166, 'Tripay', '914272-251102787', 'ALFAMART', '', '2157', '100105722', '251102787', 'T1500128147382ZMS4X', 'https://tripay.co.id/checkout/T1500128147382ZMS4X', '1762318941', '2025-11-05', '1762405221', '', 'UNPAID', '72750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (167, 'Tripay', '401813-251102003', 'BCAVA', '', '1335', '250227103606', '251102003', 'T150012814761850FGV', 'https://tripay.co.id/checkout/T150012814761850FGV', '1762319361', '2025-11-05', '1762405761', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (168, 'Tripay', '426673-251102150', 'INDOMARET', '', '1496', '100104525', '251102150', 'T1500128147807TQ0F1', 'https://tripay.co.id/checkout/T1500128147807TQ0F1', '1762319685', '2025-11-05', '1762406085', '', 'UNPAID', '127341', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (169, 'Tripay', '535520-251102779', 'DANA', '', '2149', '100105710', '251102779', 'T15001281478210QW4P', 'https://tripay.co.id/checkout/T15001281478210QW4P', '1762319713', '2025-11-05', '1762323192', '', 'PAID', '85260', '1762319769', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (170, 'Tripay', '567750-251101836', 'BRIVA', '', '1147', '250118135408', '251101836', 'T1500128147914NFAXY', 'https://tripay.co.id/checkout/T1500128147914NFAXY', '1762319865', '2025-11-05', '1762406258', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (171, 'Tripay', '417970-251101836', 'BRIVA', '', '1147', '250118135408', '251101836', 'T1500128147967Y1XAF', 'https://tripay.co.id/checkout/T1500128147967Y1XAF', '1762319936', '2025-11-05', '1762406335', '', 'PAID', '127125', '1762320042', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (172, 'Tripay', '783107-251102271', 'ALFAMART', '', '1625', '100104794', '251102271', 'T15001281487821OA5J', 'https://tripay.co.id/checkout/T15001281487821OA5J', '1762321237', '2025-11-05', '1762407516', '', 'PAID', '126750', '1762321301', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (173, 'Tripay', '996989-251102780', 'BRIVA', '', '2150', '100105712', '251102780', 'T1500128148876HZHFH', 'https://tripay.co.id/checkout/T1500128148876HZHFH', '1762321439', '2025-11-05', '1762407832', '', 'UNPAID', '86125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (174, 'Tripay', '750163-251102780', 'DANA', '', '2150', '100105712', '251102780', 'T15001281489010DJF5', 'https://tripay.co.id/checkout/T15001281489010DJF5', '1762321492', '2025-11-05', '1762324971', '', 'UNPAID', '85260', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (175, 'Tripay', '452494-251102780', 'BRIVA', '', '2150', '100105712', '251102780', 'T1500128148939TBS8W', 'https://tripay.co.id/checkout/T1500128148939TBS8W', '1762321658', '2025-11-05', '1762408058', '', 'UNPAID', '86125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (176, 'Tripay', '495144-251102780', 'BRIVA', '', '2150', '100105712', '251102780', 'T15001281489850GFSZ', 'https://tripay.co.id/checkout/T15001281489850GFSZ', '1762321730', '2025-11-05', '1762408130', '', 'PAID', '86125', '1762321821', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (177, 'Tripay', '809244-251102286', 'QRIS2', '', '1640', '100104818', '251102286', 'T1500128149328NKFJZ', 'https://tripay.co.id/checkout/T1500128149328NKFJZ', '1762322326', '2025-11-05', '1762324126', '', 'PAID', '126625', '1762322459', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (178, 'Tripay', '174001-251102545', 'BCAVA', '', '1913', '100105296', '251102545', 'T1500128149529M9LTP', 'https://tripay.co.id/checkout/T1500128149529M9LTP', '1762322667', '2025-11-05', '1762409067', '', 'PAID', '127750', '1762322785', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (179, 'Tripay', '942509-251102217', 'MANDIRIVA', '', '1567', '100104652', '251102217', 'T1500128149973KP113', 'https://tripay.co.id/checkout/T1500128149973KP113', '1762323370', '2025-11-05', '1762409769', '', 'UNPAID', '127427', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (180, 'Tripay', '202887-251102217', 'MANDIRIVA', '', '1567', '100104652', '251102217', 'T1500128150038K0KE5', 'https://tripay.co.id/checkout/T1500128150038K0KE5', '1762323484', '2025-11-05', '1762409884', '', 'PAID', '127427', '1762323572', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (181, 'Tripay', '632956-251101247', 'DANA', '', '407', '231120142633', '251101247', 'T1500128151294HZGMG', 'https://tripay.co.id/checkout/T1500128151294HZGMG', '1762325521', '2025-11-05', '1762329001', '', 'PAID', '127342', '1762325573', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (182, 'Tripay', '807176-251102313', 'DANA', '', '1670', '250524142421', '251102313', 'T1500128151422DHXTD', 'https://tripay.co.id/checkout/T1500128151422DHXTD', '1762325756', '2025-11-05', '1762329235', '', 'PAID', '126875', '1762325787', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (183, 'Tripay', '545513-251102527', 'ALFAMART', '', '1894', '100105256', '251102527', 'T1500128151481ARFM3', 'https://tripay.co.id/checkout/T1500128151481ARFM3', '1762325851', '2025-11-05', '1762412131', '', 'PAID', '126750', '1762326065', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (184, 'Tripay', '560858-251101585', 'QRIS2', '', '849', '100103461', '251101585', 'T15001281517724E9IH', 'https://tripay.co.id/checkout/T15001281517724E9IH', '1762326396', '2025-11-05', '1762328195', '', 'PAID', '126625', '1762326432', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (185, 'Tripay', '346314-251101892', 'OVO', '', '1209', '100104060', '251101892', 'T1500128151957K252V', 'https://tripay.co.id/checkout/T1500128151957K252V', '1762326756', '2025-11-05', '1762413156', '', 'PAID', '126875', '1762327054', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (186, 'Tripay', '407996-251102641', 'DANA', '', '2011', '100105492', '251102641', 'T1500128152335TKX3V', 'https://tripay.co.id/checkout/T1500128152335TKX3V', '1762327483', '2025-11-05', '1762330962', '', 'PAID', '126875', '1762327511', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (187, 'Tripay', '305095-251102473', 'QRIS2', '', '1839', '100105145', '251102473', 'T1500128153201QLRLI', 'https://tripay.co.id/checkout/T1500128153201QLRLI', '1762329052', '2025-11-05', '1762330851', '', 'PAID', '126625', '1762329072', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (188, 'Tripay', '358983-251004600', 'DANA', '', '1547', '100104614', '251004600', 'T1500128153300KNIYH', 'https://tripay.co.id/checkout/T1500128153300KNIYH', '1762329233', '2025-11-05', '1762332712', '', 'UNPAID', '127852', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (189, 'Tripay', '889856-251004600', 'DANA', '', '1547', '100104614', '251004600', 'T1500128153402IBC3Z', 'https://tripay.co.id/checkout/T1500128153402IBC3Z', '1762329441', '2025-11-05', '1762332920', '', 'PAID', '127852', '1762329491', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (190, 'Tripay', '519831-251101873', 'DANA', '', '1189', '250121130848', '251101873', 'T1500128153664QFTIJ', 'https://tripay.co.id/checkout/T1500128153664QFTIJ', '1762329973', '2025-11-05', '1762333452', '', 'PAID', '126875', '1762330014', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (191, 'Tripay', '283849-251101327', 'MANDIRIVA', '', '527', '240326122337', '251101327', 'T1500128153773TRMNO', 'https://tripay.co.id/checkout/T1500128153773TRMNO', '1762330224', '2025-11-05', '1762416623', '', 'UNPAID', '127714', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (192, 'Tripay', '60188-251101327', 'QRIS2', '', '527', '240326122337', '251101327', 'T1500128153827LLUCB', 'https://tripay.co.id/checkout/T1500128153827LLUCB', '1762330342', '2025-11-05', '1762332142', '', 'PAID', '127219', '1762330382', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (193, 'Tripay', '237384-251102193', 'BRIVA', '', '1542', '100104606', '251102193', 'T1500128154060CANZY', 'https://tripay.co.id/checkout/T1500128154060CANZY', '1762330739', '2025-11-05', '1762417138', '', 'PAID', '127283', '1762330960', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (194, 'Tripay', '703828-251102431', 'INDOMARET', '', '1794', '100105056', '251102431', 'T15001281542581ZHID', 'https://tripay.co.id/checkout/T15001281542581ZHID', '1762331145', '2025-11-05', '1762417545', '', 'PAID', '126750', '1762331599', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (195, 'Tripay', '205141-251102062', 'BCAVA', '', '1401', '100104368', '251102062', 'T1500128155244CXWS0', 'https://tripay.co.id/checkout/T1500128155244CXWS0', '1762333118', '2025-11-05', '1762419518', '', 'PAID', '127935', '1762333204', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (196, 'Tripay', '112973-251102662', 'MANDIRIVA', '', '2032', '100105533', '251102662', 'T15001281552529M094', 'https://tripay.co.id/checkout/T15001281552529M094', '1762333139', '2025-11-05', '1762419538', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (197, 'Tripay', '694291-251102332', 'ALFAMART', '', '1690', '100104847', '251102332', 'T1500128155432JAYYH', 'https://tripay.co.id/checkout/T1500128155432JAYYH', '1762333445', '2025-11-05', '1762419725', '', 'PAID', '126750', '1762333527', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (198, 'Tripay', '225118-251101934', 'DANA', '', '1254', '250215084042', '251101934', 'T1500128156020S5X9P', 'https://tripay.co.id/checkout/T1500128156020S5X9P', '1762334530', '2025-11-05', '1762338009', '', 'PAID', '126875', '1762337531', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (199, 'Tripay', '255234-251102239', 'MANDIRIVA', '', '1593', '100104736', '251102239', 'T1500128156195TNQUI', 'https://tripay.co.id/checkout/T1500128156195TNQUI', '1762334867', '2025-11-05', '1762421258', '', 'PAID', '127125', '1762334998', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (200, 'Tripay', '484546-251101254', 'BCAVA', '', '420', '231212143444', '251101254', 'T1500128156384VN4OY', 'https://tripay.co.id/checkout/T1500128156384VN4OY', '1762335152', '2025-11-05', '1762421551', '', 'PAID', '128345', '1762335286', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (201, 'Tripay', '836158-251102204', 'SHOPEEPAY', '', '1553', '100104621', '251102204', 'T15001281564025LZB8', 'https://tripay.co.id/checkout/T15001281564025LZB8', '1762335180', '2025-11-05', '1762338659', '', 'PAID', '129345', '1762335249', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (202, 'Tripay', '989020-251102787', 'ALFAMART', '', '2157', '100105722', '251102787', 'T1500128156716XPKZX', 'https://tripay.co.id/checkout/T1500128156716XPKZX', '1762335706', '2025-11-05', '1762421986', '', 'PAID', '72750', '1762335798', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (203, 'Tripay', '724615-251102238', 'MANDIRIVA', '', '1592', '100104734', '251102238', 'T1500128156942RIEXS', 'https://tripay.co.id/checkout/T1500128156942RIEXS', '1762336117', '2025-11-05', '1762422509', '', 'PAID', '127125', '1762336241', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (204, 'Tripay', '924969-251102541', 'DANA', '', '1909', '100105284', '251102541', 'T1500128159210XXNJU', 'https://tripay.co.id/checkout/T1500128159210XXNJU', '1762339797', '2025-11-05', '1762343276', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (205, 'Tripay', '276175-251102541', 'QRIS2', '', '1909', '100105284', '251102541', 'T1500128159390AUJTL', 'https://tripay.co.id/checkout/T1500128159390AUJTL', '1762340088', '2025-11-05', '1762341884', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (206, 'Tripay', '550530-251101548', 'ALFAMART', '', '805', '100103360', '251101548', 'T15001281596663UENG', 'https://tripay.co.id/checkout/T15001281596663UENG', '1762340505', '2025-11-05', '1762426784', '', 'PAID', '126750', '1762340590', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (207, 'Tripay', '7944-251102550', 'DANA', '', '1918', '100105311', '251102550', 'T1500128159826272BG', 'https://tripay.co.id/checkout/T1500128159826272BG', '1762340737', '2025-11-05', '1762344216', '', 'PAID', '126875', '1762340762', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (208, 'Tripay', '852937-251102402', 'BRIVA', '', '1765', '100104994', '251102402', 'T1500128159942JLH4R', 'https://tripay.co.id/checkout/T1500128159942JLH4R', '1762340893', '2025-11-05', '1762427293', '', 'PAID', '127125', '1762341723', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (209, 'Tripay', '981119-251101976', 'BRIVA', '', '1301', '250226085335', '251101976', 'T1500128159993ZM4H9', 'https://tripay.co.id/checkout/T1500128159993ZM4H9', '1762340982', '2025-11-05', '1762427374', '', 'PAID', '127125', '1762341724', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (210, 'Tripay', '940176-251102541', 'DANA', '', '1909', '100105284', '251102541', 'T1500128160093BICYI', 'https://tripay.co.id/checkout/T1500128160093BICYI', '1762341159', '2025-11-05', '1762344638', '', 'PAID', '126875', '1762341196', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (211, 'Tripay', '553778-251102540', 'MANDIRIVA', '', '1908', '100105282', '251102540', 'T1500128160262VEHHW', 'https://tripay.co.id/checkout/T1500128160262VEHHW', '1762341424', '2025-11-05', '1762427823', '', 'PAID', '127125', '1762342178', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (212, 'Tripay', '59492-251101965', 'DANA', '', '1288', '250225152213', '251101965', 'T1500128160452CN8ZJ', 'https://tripay.co.id/checkout/T1500128160452CN8ZJ', '1762341777', '2025-11-05', '1762345256', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (213, 'Tripay', '110465-251102187', 'DANA', '', '1536', '100104598', '251102187', 'T1500128160586RZ0W6', 'https://tripay.co.id/checkout/T1500128160586RZ0W6', '1762341993', '2025-11-05', '1762345471', '', 'PAID', '127353', '1762342029', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (214, 'Tripay', '257088-251101965', 'DANA', '', '1288', '250225152213', '251101965', 'T150012816078498G3D', 'https://tripay.co.id/checkout/T150012816078498G3D', '1762342340', '2025-11-05', '1762345820', '', 'PAID', '126875', '1762342375', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (215, 'Tripay', '923372-251101530', 'DANA', '', '787', '100103315', '251101530', 'T1500128161419YDS23', 'https://tripay.co.id/checkout/T1500128161419YDS23', '1762343196', '2025-11-05', '1762346675', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (216, 'Tripay', '907629-251101530', 'DANA', '', '787', '100103315', '251101530', 'T15001281615202ES2H', 'https://tripay.co.id/checkout/T15001281615202ES2H', '1762343311', '2025-11-05', '1762346790', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (217, 'Tripay', '133353-251101653', 'ALFAMART', '', '927', '241115092012', '251101653', 'T1500128162748KPENZ', 'https://tripay.co.id/checkout/T1500128162748KPENZ', '1762344988', '2025-11-05', '1762431268', '', 'PAID', '126750', '1762345083', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (218, 'Tripay', '835063-251101489', 'DANA', '', '734', '100103233', '251101489', 'T1500128162767VKA1G', 'https://tripay.co.id/checkout/T1500128162767VKA1G', '1762345012', '2025-11-05', '1762348491', '', 'PAID', '126875', '1762345087', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (219, 'Tripay', '764231-251102716', 'INDOMARET', '', '2086', '100105591', '251102716', 'T1500128163899EMRM5', 'https://tripay.co.id/checkout/T1500128163899EMRM5', '1762346776', '2025-11-05', '1762433175', '', 'PAID', '126750', '1762347496', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (220, 'Tripay', '25648-251102674', 'ALFAMIDI', '', '2044', '100105549', '251102674', 'T150012816443137CTA', 'https://tripay.co.id/checkout/T150012816443137CTA', '1762347739', '2025-11-05', '1762434018', '', 'PAID', '126750', '1762347843', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (221, 'Tripay', '810271-251101990', 'BRIVA', '', '1316', '250226150150', '251101990', 'T1500128164459T1JDU', 'https://tripay.co.id/checkout/T1500128164459T1JDU', '1762347783', '2025-11-05', '1762434175', '', 'PAID', '127125', '1762348293', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (222, 'Tripay', '872177-251101242', 'BRIVA', '', '399', '231020102467', '251101242', 'T15001281645360DOSZ', 'https://tripay.co.id/checkout/T15001281645360DOSZ', '1762347917', '2025-11-05', '1762434317', '', 'PAID', '128081', '1762348518', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (223, 'Tripay', '658450-251102134', 'INDOMARET', '', '1476', '250411142207', '251102134', 'T1500128164626Z5FU8', 'https://tripay.co.id/checkout/T1500128164626Z5FU8', '1762348069', '2025-11-05', '1762434469', '', 'PAID', '127483', '1762348115', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (224, 'Tripay', '399546-251101242', 'BRIVA', '', '399', '231020102467', '251101242', 'T15001281646312TIC0', 'https://tripay.co.id/checkout/T15001281646312TIC0', '1762348075', '2025-11-05', '1762434474', '', 'UNPAID', '128081', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (225, 'Tripay', '74314-251101804', 'BCAVA', '', '1110', '250116145053', '251101804', 'T1500128164757NV0SK', 'https://tripay.co.id/checkout/T1500128164757NV0SK', '1762348258', '2025-11-05', '1762434658', '', 'PAID', '127750', '1762348772', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (226, 'Tripay', '594174-251101476', 'SHOPEEPAY', '', '720', '100103204', '251101476', 'T1500128165832NXR7Q', 'https://tripay.co.id/checkout/T1500128165832NXR7Q', '1762350177', '2025-11-05', '1762353656', '', 'PAID', '128750', '1762350230', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (227, 'Tripay', '432322-251102345', 'BNIVA', '', '1704', '100104880', '251102345', 'T15001281682471S1UL', 'https://tripay.co.id/checkout/T15001281682471S1UL', '1762356443', '2025-11-05', '1762442723', '', 'PAID', '129250', '1762356604', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (228, 'Tripay', '333174-251102072', 'BCAVA', '', '1411', '100104393', '251102072', 'T1500128168411JDR0D', 'https://tripay.co.id/checkout/T1500128168411JDR0D', '1762357076', '2025-11-05', '1762443476', '', 'PAID', '128692', '1762357139', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (229, 'Tripay', '547824-251102422', 'SHOPEEPAY', '', '1785', '100105038', '251102422', 'T1500128168557MZRKO', 'https://tripay.co.id/checkout/T1500128168557MZRKO', '1762357590', '2025-11-05', '1762361069', '', 'PAID', '128750', '1762357645', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (230, 'Tripay', '164541-251102390', 'QRIS2', '', '1751', '100104962', '251102390', 'T1500128168824CALVG', 'https://tripay.co.id/checkout/T1500128168824CALVG', '1762358636', '2025-11-05', '1762360435', '', 'PAID', '126625', '1762358704', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (231, 'Tripay', '702798-251102688', 'SHOPEEPAY', '', '2058', '10010579', '251102688', 'T1500128168874HPJED', 'https://tripay.co.id/checkout/T1500128168874HPJED', '1762358892', '2025-11-05', '1762362371', '', 'PAID', '128750', '1762358929', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (232, 'Tripay', '853142-251102454', 'BCAVA', '', '1818', '100105100', '251102454', 'T1500128169046MGH7K', 'https://tripay.co.id/checkout/T1500128169046MGH7K', '1762359545', '2025-11-05', '1762445945', '', 'PAID', '127750', '1762359613', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (233, 'Tripay', '131812-251102276', 'SHOPEEPAY', '', '1630', '100104802', '251102276', 'T1500128169349QQZZN', 'https://tripay.co.id/checkout/T1500128169349QQZZN', '1762361229', '2025-11-05', '1762364709', '', 'PAID', '128750', '1762361286', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (234, 'Tripay', '326849-251102432', 'DANA', '', '1795', '100105057', '251102432', 'T1500128169507KTA0W', 'https://tripay.co.id/checkout/T1500128169507KTA0W', '1762361949', '2025-11-05', '1762365428', '', 'PAID', '126875', '1762362055', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (235, 'Tripay', '205989-251102566', 'MANDIRIVA', '', '1934', '100105346', '251102566', 'T1500128170308GEFEJ', 'https://tripay.co.id/checkout/T1500128170308GEFEJ', '1762366235', '2025-11-06', '1762452635', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (236, 'Tripay', '463985-251101773', 'BNIVA', '', '1075', '100103849', '251101773', 'T1500128170891OTUK9', 'https://tripay.co.id/checkout/T1500128170891OTUK9', '1762372677', '2025-11-06', '1762458950', '', 'UNPAID', '119250', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (237, 'Tripay', '395830-251101773', 'BNIVA', '', '1075', '100103849', '251101773', 'T1500128170895BVCWN', 'https://tripay.co.id/checkout/T1500128170895BVCWN', '1762372733', '2025-11-06', '1762459013', '', 'UNPAID', '119250', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (238, 'Tripay', '653255-251101773', 'BNIVA', '', '1075', '100103849', '251101773', 'T1500128170904C4PLV', 'https://tripay.co.id/checkout/T1500128170904C4PLV', '1762372863', '2025-11-06', '1762459143', '', 'UNPAID', '119250', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (239, 'Tripay', '110060-251101773', 'BNIVA', '', '1075', '100103849', '251101773', 'T1500128170921MODUX', 'https://tripay.co.id/checkout/T1500128170921MODUX', '1762373083', '2025-11-06', '1762459363', '', 'PAID', '119250', '1762373173', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (240, 'Tripay', '511461-251102378', 'DANA', '', '1739', '100104943', '251102378', 'T15001281711973SBOX', 'https://tripay.co.id/checkout/T15001281711973SBOX', '1762377332', '2025-11-06', '1762380811', '', 'PAID', '126875', '1762377362', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (241, 'Tripay', '860040-251102594', 'INDOMARET', '', '1963', '100105398', '251102594', 'T1500128171628PPC1T', 'https://tripay.co.id/checkout/T1500128171628PPC1T', '1762380480', '2025-11-06', '1762466879', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (242, 'Tripay', '105171-251101616', 'INDOMARET', '', '882', '100103522', '251101616', 'T1500128171782NNHZT', 'https://tripay.co.id/checkout/T1500128171782NNHZT', '1762381047', '2025-11-06', '1762467447', '', 'PAID', '126750', '1762381828', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (243, 'Tripay', '973117-251102220', 'SHOPEEPAY', '', '1572', '250426101650', '251102220', 'T1500128172059VZMXX', 'https://tripay.co.id/checkout/T1500128172059VZMXX', '1762382257', '2025-11-06', '1762385736', '', 'PAID', '129023', '1762382286', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (244, 'Tripay', '330964-251102676', 'SHOPEEPAY', '', '2046', '100105553', '251102676', 'T1500128172088FOM3T', 'https://tripay.co.id/checkout/T1500128172088FOM3T', '1762382330', '2025-11-06', '1762385809', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (245, 'Tripay', '460090-251102676', 'QRIS2', '', '2046', '100105553', '251102676', 'T1500128172098KZEYR', 'https://tripay.co.id/checkout/T1500128172098KZEYR', '1762382351', '2025-11-06', '1762384150', '', 'PAID', '126625', '1762382386', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (246, 'Tripay', '494765-251102171', 'BCAVA', '', '1520', '100104568', '251102171', 'T1500128172974HBZWE', 'https://tripay.co.id/checkout/T1500128172974HBZWE', '1762385638', '2025-11-06', '1762472037', '', 'UNPAID', '128664', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (247, 'Tripay', '97815-251102171', 'BSIVA', '', '1520', '100104568', '251102171', 'T1500128173014QDZMG', 'https://tripay.co.id/checkout/T1500128173014QDZMG', '1762385758', '2025-11-06', '1762396432', '', 'UNPAID', '128039', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (248, 'Tripay', '919757-251102171', 'BSIVA', '', '1520', '100104568', '251102171', 'T1500128173038HDTML', 'https://tripay.co.id/checkout/T1500128173038HDTML', '1762385811', '2025-11-06', '1762396490', '', 'UNPAID', '128039', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (249, 'Tripay', '104142-251102171', 'QRIS2', '', '1520', '100104568', '251102171', 'T1500128173091TICM1', 'https://tripay.co.id/checkout/T1500128173091TICM1', '1762385943', '2025-11-06', '1762387743', '', 'PAID', '127546', '1762386025', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (250, 'Tripay', '340061-251101400', 'INDOMARET', '', '625', '240608143794', '251101400', 'T1500128173272XULWL', 'https://tripay.co.id/checkout/T1500128173272XULWL', '1762386483', '2025-11-06', '1762472883', '', 'PAID', '126782', '1762387415', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (251, 'Tripay', '113891-251102359', 'QRIS2', '', '1719', '250613133707', '251102359', 'T1500128173429ZKUZG', 'https://tripay.co.id/checkout/T1500128173429ZKUZG', '1762386847', '2025-11-06', '1762388646', '', 'PAID', '126625', '1762386868', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (252, 'Tripay', '58812-251101651', 'INDOMARET', '', '925', '241115090936', '251101651', 'T1500128174053I9ZA8', 'https://tripay.co.id/checkout/T1500128174053I9ZA8', '1762388442', '2025-11-06', '1762474841', '', 'PAID', '126750', '1762399376', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (253, 'Tripay', '658521-251101954', 'BRIVA', '', '1276', '250215140537', '251101954', 'T1500128174262UIC5H', 'https://tripay.co.id/checkout/T1500128174262UIC5H', '1762389007', '2025-11-06', '1762475398', '', 'PAID', '127125', '1762389113', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (254, 'Tripay', '891943-251102564', 'ALFAMART', '', '1932', '100105342', '251102564', 'T1500128174263OUPPB', 'https://tripay.co.id/checkout/T1500128174263OUPPB', '1762389010', '2025-11-06', '1762475289', '', 'PAID', '126750', '1762389070', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (255, 'Tripay', '324313-251102321', 'BRIVA', '', '1678', '250527100942', '251102321', 'T1500128174940G1FZF', 'https://tripay.co.id/checkout/T1500128174940G1FZF', '1762390689', '2025-11-06', '1762477089', '', 'PAID', '127125', '1762390810', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (256, 'Tripay', '817015-251102354', 'BCAVA', '', '1714', '100104899', '251102354', 'T1500128175176BSV31', 'https://tripay.co.id/checkout/T1500128175176BSV31', '1762391195', '2025-11-06', '1762477595', '', 'PAID', '127750', '1762391329', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (257, 'Tripay', '456203-251102150', 'ALFAMART', '', '1496', '100104525', '251102150', 'T1500128175309EK1TH', 'https://tripay.co.id/checkout/T1500128175309EK1TH', '1762391422', '2025-11-06', '1762477701', '', 'PAID', '127341', '1762391773', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (258, 'Tripay', '472736-251102133', 'MANDIRIVA', '', '1475', '250411141511', '251102133', 'T1500128175366BKEAC', 'https://tripay.co.id/checkout/T1500128175366BKEAC', '1762391526', '2025-11-06', '1762477915', '', 'PAID', '127570', '1762391692', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (259, 'Tripay', '681522-251101369', 'MANDIRIVA', '', '590', '240608143742', '251101369', 'T1500128175832ZORJN', 'https://tripay.co.id/checkout/T1500128175832ZORJN', '1762392527', '2025-11-06', '1762478920', '', 'PAID', '127428', '1762392663', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (260, 'Tripay', '926965-251102571', 'BNIVA', '', '1939', '100105357', '251102571', 'T1500128176341UGFGM', 'https://tripay.co.id/checkout/T1500128176341UGFGM', '1762393624', '2025-11-06', '1762479904', '', 'PAID', '129250', '1762393844', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (261, 'Tripay', '399336-251102692', 'BRIVA', '', '2062', '10010586', '251102692', 'T15001281763737LBJM', 'https://tripay.co.id/checkout/T15001281763737LBJM', '1762393687', '2025-11-06', '1762480087', '', 'PAID', '127125', '1762393764', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (262, 'Tripay', '985430-251102408', 'DANA', '', '1771', '100105008', '251102408', 'T1500128176492CRTVA', 'https://tripay.co.id/checkout/T1500128176492CRTVA', '1762393907', '2025-11-06', '1762397386', '', 'PAID', '126875', '1762394016', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (263, 'Tripay', '940732-251101942', 'QRIS2', '', '1264', '250215101241', '251101942', 'T1500128176566PMOFS', 'https://tripay.co.id/checkout/T1500128176566PMOFS', '1762394065', '2025-11-06', '1762395865', '', 'PAID', '126625', '1762394162', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (264, 'Tripay', '479367-251102465', 'BCAVA', '', '1831', '100105126', '251102465', 'T1500128177127CLNW2', 'https://tripay.co.id/checkout/T1500128177127CLNW2', '1762395213', '2025-11-06', '1762481597', '', 'PAID', '127750', '1762395397', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (265, 'Tripay', '690390-251101530', 'DANA', '', '787', '100103315', '251101530', 'T1500128177292DOHYB', 'https://tripay.co.id/checkout/T1500128177292DOHYB', '1762395548', '2025-11-06', '1762399027', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (266, 'Tripay', '420085-251102498', 'DANA', '', '1864', '100105199', '251102498', 'T1500128177828JOQRQ', 'https://tripay.co.id/checkout/T1500128177828JOQRQ', '1762396628', '2025-11-06', '1762400108', '', 'PAID', '126875', '1762396672', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (267, 'Tripay', '422285-251101843', 'BCAVA', '', '1156', '250118151104', '251101843', 'T1500128178372PHUCN', 'https://tripay.co.id/checkout/T1500128178372PHUCN', '1762397762', '2025-11-06', '1762484161', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (268, 'Tripay', '86021-251101073', 'BRIVA', '', '120', '220825142017', '251101073', 'T1500128178407SSIPD', 'https://tripay.co.id/checkout/T1500128178407SSIPD', '1762397815', '2025-11-06', '1762484215', '', 'PAID', '127376', '1762397865', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (269, 'Tripay', '81196-251101843', 'BCAVA', '', '1156', '250118151104', '251101843', 'T1500128178429UNLBW', 'https://tripay.co.id/checkout/T1500128178429UNLBW', '1762397860', '2025-11-06', '1762484258', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (270, 'Tripay', '866429-251102686', 'BNIVA', '', '2056', '10010576', '251102686', 'T1500128178895ZT505', 'https://tripay.co.id/checkout/T1500128178895ZT505', '1762398795', '2025-11-06', '1762485075', '', 'PAID', '129250', '1762398994', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (271, 'Tripay', '147328-251102672', 'BSIVA', '', '2042', '100105547', '251102672', 'T1500128178920RC5SU', 'https://tripay.co.id/checkout/T1500128178920RC5SU', '1762398851', '2025-11-06', '1762409525', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (272, 'Tripay', '312548-251102672', 'BSIVA', '', '2042', '100105547', '251102672', 'T15001281789695H00S', 'https://tripay.co.id/checkout/T15001281789695H00S', '1762398934', '2025-11-06', '1762409614', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (273, 'Tripay', '323622-251102672', 'BSIVA', '', '2042', '100105547', '251102672', 'T1500128179102F8EX0', 'https://tripay.co.id/checkout/T1500128179102F8EX0', '1762399179', '2025-11-06', '1762409859', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (274, 'Tripay', '327388-251102672', 'BSIVA', '', '2042', '100105547', '251102672', 'T15001281791637QZOL', 'https://tripay.co.id/checkout/T15001281791637QZOL', '1762399279', '2025-11-06', '1762409959', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (275, 'Tripay', '709779-251102098', 'BRIVA', '', '1438', '100104447', '251102098', 'T1500128179331GRAMR', 'https://tripay.co.id/checkout/T1500128179331GRAMR', '1762399596', '2025-11-06', '1762485990', '', 'PAID', '127161', '1762399756', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (276, 'Tripay', '137855-251102124', 'BCAVA', '', '1465', '100104507', '251102124', 'T1500128179392T7KOZ', 'https://tripay.co.id/checkout/T1500128179392T7KOZ', '1762399710', '2025-11-06', '1762486109', '', 'PAID', '127913', '1762399770', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (277, 'Tripay', '385157-251102087', 'SHOPEEPAY', '', '1427', '100104417', '251102087', 'T1500128180098LNSHG', 'https://tripay.co.id/checkout/T1500128180098LNSHG', '1762401200', '2025-11-06', '1762404680', '', 'PAID', '129401', '1762401314', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (278, 'Tripay', '587496-251102099', 'QRIS2', '', '1439', '100104450', '251102099', 'T1500128180369RFMSZ', 'https://tripay.co.id/checkout/T1500128180369RFMSZ', '1762401863', '2025-11-06', '1762405463', '', 'PAID', '127407', '1762402085', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (279, 'Tripay', '69553-251102693', 'SHOPEEPAY', '', '2063', '10010589', '251102693', 'T1500128181596PWGGO', 'https://tripay.co.id/checkout/T1500128181596PWGGO', '1762404743', '2025-11-06', '1762408223', '', 'PAID', '128750', '1762405039', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (280, 'Tripay', '704383-251101815', 'MANDIRIVA', '', '1123', '250117080538', '251101815', 'T1500128181624J4ELS', 'https://tripay.co.id/checkout/T1500128181624J4ELS', '1762404796', '2025-11-06', '1762491189', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (281, 'Tripay', '851692-251101815', 'MANDIRIVA', '', '1123', '250117080538', '251101815', 'T1500128181669WG4UL', 'https://tripay.co.id/checkout/T1500128181669WG4UL', '1762404860', '2025-11-06', '1762491260', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (282, 'Tripay', '208022-251101815', 'MANDIRIVA', '', '1123', '250117080538', '251101815', 'T15001281817326MVA5', 'https://tripay.co.id/checkout/T15001281817326MVA5', '1762405038', '2025-11-06', '1762491438', '', 'PAID', '127125', '1762405590', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (283, 'Tripay', '827549-251102231', 'BRIVA', '', '1585', '100104721', '251102231', 'T1500128181755XPCLW', 'https://tripay.co.id/checkout/T1500128181755XPCLW', '1762405078', '2025-11-06', '1762491478', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (284, 'Tripay', '416998-251102231', 'BRIVA', '', '1585', '100104721', '251102231', 'T1500128181781YWOPU', 'https://tripay.co.id/checkout/T1500128181781YWOPU', '1762405139', '2025-11-06', '1762491539', '', 'PAID', '127125', '1762405412', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (285, 'Tripay', '657554-251102679', 'DANA', '', '2049', '10010561', '251102679', 'T1500128185193GDQGC', 'https://tripay.co.id/checkout/T1500128185193GDQGC', '1762411850', '2025-11-06', '1762415329', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (286, 'Tripay', '56689-251102367', 'DANA', '', '1727', '100104919', '251102367', 'T1500128185871IXLN6', 'https://tripay.co.id/checkout/T1500128185871IXLN6', '1762413325', '2025-11-06', '1762416804', '', 'PAID', '126875', '1762413503', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (287, 'Tripay', '128815-251102538', 'MANDIRIVA', '', '1906', '100105280', '251102538', 'T1500128186039GSZAW', 'https://tripay.co.id/checkout/T1500128186039GSZAW', '1762413641', '2025-11-06', '1762500041', '', 'PAID', '127125', '1762414343', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (288, 'Tripay', '75610-251101971', 'BCAVA', '', '1295', '250225155638', '251101971', 'T1500128186789BK8AM', 'https://tripay.co.id/checkout/T1500128186789BK8AM', '1762415563', '2025-11-06', '1762501963', '', 'PAID', '127750', '1762415760', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (289, 'Tripay', '737379-251102504', 'MANDIRIVA', '', '1870', '100105208', '251102504', 'T1500128188479DYSR9', 'https://tripay.co.id/checkout/T1500128188479DYSR9', '1762419378', '2025-11-06', '1762505778', '', 'PAID', '127125', '1762419570', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (290, 'Tripay', '908511-251102769', 'INDOMARET', '', '2139', '100105690', '251102769', 'T1500128189454EGHNK', 'https://tripay.co.id/checkout/T1500128189454EGHNK', '1762421560', '2025-11-06', '1762507960', '', 'PAID', '93750', '1762422962', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (291, 'Tripay', '659046-251102775', 'INDOMARET', '', '2145', '100105703', '251102775', 'T1500128189521CRC3N', 'https://tripay.co.id/checkout/T1500128189521CRC3N', '1762421683', '2025-11-06', '1762508083', '', 'UNPAID', '89750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (292, 'Tripay', '637114-251102775', 'INDOMARET', '', '2145', '100105703', '251102775', 'T150012818956117X2V', 'https://tripay.co.id/checkout/T150012818956117X2V', '1762421760', '2025-11-06', '1762508160', '', 'PAID', '89750', '1762422900', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (293, 'Tripay', '49832-251101530', 'INDOMARET', '', '787', '100103315', '251101530', 'T1500128189781I1GJF', 'https://tripay.co.id/checkout/T1500128189781I1GJF', '1762422223', '2025-11-06', '1762508623', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (294, 'Tripay', '607114-251101530', 'INDOMARET', '', '787', '100103315', '251101530', 'T1500128189816TZDEJ', 'https://tripay.co.id/checkout/T1500128189816TZDEJ', '1762422302', '2025-11-06', '1762508702', '', 'PAID', '126750', '1762422432', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (295, 'Tripay', '800222-251102468', 'DANA', '', '1834', '100105135', '251102468', 'T1500128190272KU4G7', 'https://tripay.co.id/checkout/T1500128190272KU4G7', '1762423179', '2025-11-06', '1762426658', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (296, 'Tripay', '103684-251102468', 'DANA', '', '1834', '100105135', '251102468', 'T1500128190300BGGMH', 'https://tripay.co.id/checkout/T1500128190300BGGMH', '1762423254', '2025-11-06', '1762426733', '', 'PAID', '126875', '1762423406', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (297, 'Tripay', '837079-251101514', 'BRIVA', '', '766', '100103281', '251101514', 'T15001281906807RICY', 'https://tripay.co.id/checkout/T15001281906807RICY', '1762424152', '2025-11-06', '1762510552', '', 'PAID', '127125', '1762424210', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (298, 'Tripay', '540693-251102594', 'INDOMARET', '', '1963', '100105398', '251102594', 'T1500128191188GG2BA', 'https://tripay.co.id/checkout/T1500128191188GG2BA', '1762425146', '2025-11-06', '1762511545', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (299, 'Tripay', '195440-251102594', 'INDOMARET', '', '1963', '100105398', '251102594', 'T15001281912330YJQE', 'https://tripay.co.id/checkout/T15001281912330YJQE', '1762425228', '2025-11-06', '1762511628', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (300, 'Tripay', '595295-251102030', 'INDOMARET', '', '1366', '100104311', '251102030', 'T1500128191248PRAPN', 'https://tripay.co.id/checkout/T1500128191248PRAPN', '1762425252', '2025-11-06', '1762511652', '', 'UNPAID', '127310', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (301, 'Tripay', '479567-251102030', 'INDOMARET', '', '1366', '100104311', '251102030', 'T1500128191303FO0BK', 'https://tripay.co.id/checkout/T1500128191303FO0BK', '1762425335', '2025-11-06', '1762511734', '', 'UNPAID', '127310', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (302, 'Tripay', '744966-251102079', 'BRIVA', '', '1418', '100104404', '251102079', 'T1500128191429DEPIV', 'https://tripay.co.id/checkout/T1500128191429DEPIV', '1762425590', '2025-11-06', '1762511982', '', 'PAID', '127961', '1762425691', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (303, 'Tripay', '641136-251101682', 'ALFAMART', '', '962', '100103636', '251101682', 'T1500128191840ZB37M', 'https://tripay.co.id/checkout/T1500128191840ZB37M', '1762426406', '2025-11-06', '1762512686', '', 'PAID', '126750', '1762427391', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (304, 'Tripay', '828569-251102464', 'SHOPEEPAY', '', '1830', '100105125', '251102464', 'T1500128191865U9CJK', 'https://tripay.co.id/checkout/T1500128191865U9CJK', '1762426450', '2025-11-06', '1762429928', '', 'PAID', '128750', '1762426657', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (305, 'Tripay', '290654-251101361', 'QRIS2', '', '580', '240608143712', '251101361', 'T1500128191914UAOTY', 'https://tripay.co.id/checkout/T1500128191914UAOTY', '1762426526', '2025-11-06', '1762428326', '', 'UNPAID', '126811', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (306, 'Tripay', '204495-251101361', 'DANA', '', '580', '240608143712', '251101361', 'T1500128191916CXTFG', 'https://tripay.co.id/checkout/T1500128191916CXTFG', '1762426528', '2025-11-06', '1762430007', '', 'UNPAID', '127062', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (307, 'Tripay', '407706-251101361', 'DANA', '', '580', '240608143712', '251101361', 'T150012819197265OIQ', 'https://tripay.co.id/checkout/T150012819197265OIQ', '1762426614', '2025-11-06', '1762430093', '', 'PAID', '127062', '1762426659', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (308, 'Tripay', '111096-251101992', 'DANA', '', '1319', '250226151033', '251101992', 'T1500128192021E89JW', 'https://tripay.co.id/checkout/T1500128192021E89JW', '1762426698', '2025-11-06', '1762430177', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (309, 'Tripay', '290831-251101992', 'BCAVA', '', '1319', '250226151033', '251101992', 'T1500128192083KVV3W', 'https://tripay.co.id/checkout/T1500128192083KVV3W', '1762426801', '2025-11-06', '1762513201', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (310, 'Tripay', '423599-251101992', 'BCAVA', '', '1319', '250226151033', '251101992', 'T1500128192093HEU2X', 'https://tripay.co.id/checkout/T1500128192093HEU2X', '1762426818', '2025-11-06', '1762513217', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (311, 'Tripay', '161294-251101992', 'BCAVA', '', '1319', '250226151033', '251101992', 'T15001281923580KMND', 'https://tripay.co.id/checkout/T15001281923580KMND', '1762427301', '2025-11-06', '1762513701', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (312, 'Tripay', '811498-251101992', 'BCAVA', '', '1319', '250226151033', '251101992', 'T1500128192389C8J9N', 'https://tripay.co.id/checkout/T1500128192389C8J9N', '1762427365', '2025-11-06', '1762513765', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (313, 'Tripay', '387515-251101992', 'BCAVA', '', '1319', '250226151033', '251101992', 'T1500128192445EANNP', 'https://tripay.co.id/checkout/T1500128192445EANNP', '1762427475', '2025-11-06', '1762513875', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (314, 'Tripay', '433929-251101992', 'BCAVA', '', '1319', '250226151033', '251101992', 'T1500128192584RVRZW', 'https://tripay.co.id/checkout/T1500128192584RVRZW', '1762427722', '2025-11-06', '1762514121', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (315, 'Tripay', '514009-251101992', 'BCAVA', '', '1319', '250226151033', '251101992', 'T1500128192627PPOCB', 'https://tripay.co.id/checkout/T1500128192627PPOCB', '1762427805', '2025-11-06', '1762514205', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (316, 'Tripay', '74109-251102611', 'QRIS2', '', '1981', '100105434', '251102611', 'T1500128192626X6K88', 'https://tripay.co.id/checkout/T1500128192626X6K88', '1762427805', '2025-11-06', '1762429605', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (317, 'Tripay', '901874-251101992', 'BCAVA', '', '1319', '250226151033', '251101992', 'T1500128192686ZDHIC', 'https://tripay.co.id/checkout/T1500128192686ZDHIC', '1762427933', '2025-11-06', '1762514333', '', 'PAID', '127750', '1762428028', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (318, 'Tripay', '381953-251102611', 'MANDIRIVA', '', '1981', '100105434', '251102611', 'T1500128192825OCSIP', 'https://tripay.co.id/checkout/T1500128192825OCSIP', '1762428166', '2025-11-06', '1762514557', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (319, 'Tripay', '620781-251102030', 'INDOMARET', '', '1366', '100104311', '251102030', 'T15001281930022DHZM', 'https://tripay.co.id/checkout/T15001281930022DHZM', '1762428484', '2025-11-06', '1762514883', '', 'PAID', '127310', '1762436035', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (320, 'Tripay', '134031-251102214', 'INDOMARET', '', '1564', '100104648', '251102214', 'T1500128193090RM4FA', 'https://tripay.co.id/checkout/T1500128193090RM4FA', '1762428699', '2025-11-06', '1762515099', '', 'UNPAID', '126845', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (321, 'Tripay', '148515-251102214', 'INDOMARET', '', '1564', '100104648', '251102214', 'T1500128193120RPG89', 'https://tripay.co.id/checkout/T1500128193120RPG89', '1762428772', '2025-11-06', '1762515172', '', 'UNPAID', '126845', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (322, 'Tripay', '129284-251102433', 'INDOMARET', '', '1796', '100105058', '251102433', 'T1500128193367R583R', 'https://tripay.co.id/checkout/T1500128193367R583R', '1762429311', '2025-11-06', '1762515710', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (323, 'Tripay', '652001-251102433', 'INDOMARET', '', '1796', '100105058', '251102433', 'T1500128193401YJAPC', 'https://tripay.co.id/checkout/T1500128193401YJAPC', '1762429371', '2025-11-06', '1762515771', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (324, 'Tripay', '598198-251102433', 'INDOMARET', '', '1796', '100105058', '251102433', 'T1500128193854KEMPM', 'https://tripay.co.id/checkout/T1500128193854KEMPM', '1762430175', '2025-11-06', '1762516574', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (325, 'Tripay', '153436-251101835', 'QRIS2', '', '1146', '250118135119', '251101835', 'T1500128193864ZEITE', 'https://tripay.co.id/checkout/T1500128193864ZEITE', '1762430188', '2025-11-06', '1762431987', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (326, 'Tripay', '244553-251102433', 'INDOMARET', '', '1796', '100105058', '251102433', 'T1500128193890BCKQV', 'https://tripay.co.id/checkout/T1500128193890BCKQV', '1762430254', '2025-11-06', '1762516654', '', 'PAID', '126750', '1762433429', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (327, 'Tripay', '495479-251101835', 'QRIS2', '', '1146', '250118135119', '251101835', 'T1500128193901QIOUH', 'https://tripay.co.id/checkout/T1500128193901QIOUH', '1762430277', '2025-11-06', '1762432076', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (328, 'Tripay', '880774-251102594', 'ALFAMART', '', '1963', '100105398', '251102594', 'T1500128194150HSVZC', 'https://tripay.co.id/checkout/T1500128194150HSVZC', '1762430753', '2025-11-06', '1762517033', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (329, 'Tripay', '767736-251102594', 'ALFAMART', '', '1963', '100105398', '251102594', 'T1500128194215PGWRU', 'https://tripay.co.id/checkout/T1500128194215PGWRU', '1762430874', '2025-11-06', '1762517154', '', 'PAID', '126750', '1762431489', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (330, 'Tripay', '878384-251102026', 'DANA', '', '1362', '100104458', '251102026', 'T1500128194399WWYXS', 'https://tripay.co.id/checkout/T1500128194399WWYXS', '1762431272', '2025-11-06', '1762434751', '', 'UNPAID', '127725', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (331, 'Tripay', '432578-251102026', 'DANA', '', '1362', '100104458', '251102026', 'T1500128194432ZCTXT', 'https://tripay.co.id/checkout/T1500128194432ZCTXT', '1762431362', '2025-11-06', '1762434842', '', 'PAID', '127725', '1762431454', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (332, 'Tripay', '555677-251102717', 'BCAVA', '', '2087', '100105593', '251102717', 'T1500128194667PFCKU', 'https://tripay.co.id/checkout/T1500128194667PFCKU', '1762431863', '2025-11-06', '1762518262', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (333, 'Tripay', '505065-251102717', 'BCAVA', '', '2087', '100105593', '251102717', 'T1500128194715F9DHO', 'https://tripay.co.id/checkout/T1500128194715F9DHO', '1762431940', '2025-11-06', '1762518340', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (334, 'Tripay', '466455-251102214', 'INDOMARET', '', '1564', '100104648', '251102214', 'T1500128195008RCERR', 'https://tripay.co.id/checkout/T1500128195008RCERR', '1762432584', '2025-11-06', '1762518984', '', 'UNPAID', '126845', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (335, 'Tripay', '728702-251102214', 'INDOMARET', '', '1564', '100104648', '251102214', 'T15001281950573KF4U', 'https://tripay.co.id/checkout/T15001281950573KF4U', '1762432661', '2025-11-06', '1762519060', '', 'UNPAID', '126845', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (336, 'Tripay', '714691-251102214', 'INDOMARET', '', '1564', '100104648', '251102214', 'T1500128195095CHYTJ', 'https://tripay.co.id/checkout/T1500128195095CHYTJ', '1762432738', '2025-11-06', '1762519137', '', 'PAID', '126845', '1762433481', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (337, 'Tripay', '198144-251102444', 'ALFAMART', '', '1808', '100105075', '251102444', 'T15001281952555H3YD', 'https://tripay.co.id/checkout/T15001281952555H3YD', '1762433014', '2025-11-06', '1762519293', '', 'PAID', '126750', '1762433128', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (338, 'Tripay', '512432-251102433', 'INDOMARET', '', '1796', '100105058', '251102433', 'T1500128195317I1FCB', 'https://tripay.co.id/checkout/T1500128195317I1FCB', '1762433174', '2025-11-06', '1762519573', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (339, 'Tripay', '776929-251101809', 'SHOPEEPAY', '', '1116', '250116160748', '251101809', 'T1500128195598MIUF7', 'https://tripay.co.id/checkout/T1500128195598MIUF7', '1762433815', '2025-11-06', '1762437295', '', 'PAID', '128750', '1762434056', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (340, 'Tripay', '435349-251102628', 'DANA', '', '1998', '100105461', '251102628', 'T1500128195973YMT5N', 'https://tripay.co.id/checkout/T1500128195973YMT5N', '1762434474', '2025-11-06', '1762437954', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (341, 'Tripay', '393542-251102628', 'DANA', '', '1998', '100105461', '251102628', 'T1500128196035JZPMC', 'https://tripay.co.id/checkout/T1500128196035JZPMC', '1762434569', '2025-11-06', '1762438048', '', 'PAID', '126875', '1762434639', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (342, 'Tripay', '348065-251101835', 'QRIS2', '', '1146', '250118135119', '251101835', 'T1500128196589SJ3R8', 'https://tripay.co.id/checkout/T1500128196589SJ3R8', '1762435635', '2025-11-06', '1762437434', '', 'PAID', '126625', '1762435681', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (343, 'Tripay', '855705-251101658', 'INDOMARET', '', '933', '100103578', '251101658', 'T1500128196600SC86C', 'https://tripay.co.id/checkout/T1500128196600SC86C', '1762435651', '2025-11-06', '1762522051', '', 'PAID', '126750', '1762435765', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (344, 'Tripay', '194556-251102000', 'BNIVA', '', '1331', '250227094539', '251102000', 'T1500128198415EVPZO', 'https://tripay.co.id/checkout/T1500128198415EVPZO', '1762439523', '2025-11-06', '1762525803', '', 'UNPAID', '129250', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (345, 'Tripay', '875609-251102000', 'BNIVA', '', '1331', '250227094539', '251102000', 'T1500128198427JCCVI', 'https://tripay.co.id/checkout/T1500128198427JCCVI', '1762439541', '2025-11-06', '1762525821', '', 'UNPAID', '129250', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (346, 'Tripay', '148437-251102000', 'BNIVA', '', '1331', '250227094539', '251102000', 'T1500128198447LGIOW', 'https://tripay.co.id/checkout/T1500128198447LGIOW', '1762439578', '2025-11-06', '1762525857', '', 'UNPAID', '129250', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (347, 'Tripay', '658569-251102000', 'BNIVA', '', '1331', '250227094539', '251102000', 'T1500128198463HK5KO', 'https://tripay.co.id/checkout/T1500128198463HK5KO', '1762439605', '2025-11-06', '1762525885', '', 'UNPAID', '129250', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (348, 'Tripay', '659361-251102000', 'BNIVA', '', '1331', '250227094539', '251102000', 'T1500128198508HUMZ7', 'https://tripay.co.id/checkout/T1500128198508HUMZ7', '1762439729', '2025-11-06', '1762526009', '', 'UNPAID', '129250', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (349, 'Tripay', '7789-251102387', 'SHOPEEPAY', '', '1748', '100104958', '251102387', 'T15001282003626ACFT', 'https://tripay.co.id/checkout/T15001282003626ACFT', '1762447822', '2025-11-06', '1762451301', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (350, 'Tripay', '597810-251102147', 'BCAVA', '', '1493', '100104517', '251102147', 'T15001282017899WKS8', 'https://tripay.co.id/checkout/T15001282017899WKS8', '1762466056', '2025-11-07', '1762552455', '', 'PAID', '127900', '1762466154', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (351, 'Tripay', '364288-251102000', 'BNIVA', '', '1331', '250227094539', '251102000', 'T1500128202023BAVZV', 'https://tripay.co.id/checkout/T1500128202023BAVZV', '1762467707', '2025-11-07', '1762553987', '', 'PAID', '129250', '1762467829', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (352, 'Tripay', '435762-251102441', 'INDOMARET', '', '1805', '100105071', '251102441', 'T1500128203325RGH67', 'https://tripay.co.id/checkout/T1500128203325RGH67', '1762474090', '2025-11-07', '1762560489', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (353, 'Tripay', '598087-251102441', 'INDOMARET', '', '1805', '100105071', '251102441', 'T1500128203339OYICO', 'https://tripay.co.id/checkout/T1500128203339OYICO', '1762474171', '2025-11-07', '1762560570', '', 'PAID', '126750', '1762474340', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (354, 'Tripay', '132149-251101014', 'QRIS2', '', '19', '220822001638', '251101014', 'T15001282037315GGST', 'https://tripay.co.id/checkout/T15001282037315GGST', '1762475614', '2025-11-07', '1762479214', '', 'UNPAID', '126957', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (355, 'Tripay', '339665-251101014', 'QRIS2', '', '19', '220822001638', '251101014', 'T1500128203750Y2VAN', 'https://tripay.co.id/checkout/T1500128203750Y2VAN', '1762475700', '2025-11-07', '1762479300', '', 'UNPAID', '126957', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (356, 'Tripay', '368743-251101860', 'MANDIRIVA', '', '1174', '250121091009', '251101860', 'T1500128203908JITI5', 'https://tripay.co.id/checkout/T1500128203908JITI5', '1762476253', '2025-11-07', '1762562645', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (357, 'Tripay', '344765-251101356', 'SHOPEEPAY', '', '571', '240608143692', '251101356', 'T1500128204385RJQ9N', 'https://tripay.co.id/checkout/T1500128204385RJQ9N', '1762477704', '2025-11-07', '1762481184', '', 'PAID', '129251', '1762477737', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (358, 'Tripay', '163868-251102160', 'MANDIRIVA', '', '1508', '100104544', '251102160', 'T15001282059781QS47', 'https://tripay.co.id/checkout/T15001282059781QS47', '1762482052', '2025-11-07', '1762568445', '', 'UNPAID', '128021', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (359, 'Tripay', '269020-251102160', 'MANDIRIVA', '', '1508', '100104544', '251102160', 'T1500128206008YWZHZ', 'https://tripay.co.id/checkout/T1500128206008YWZHZ', '1762482119', '2025-11-07', '1762568519', '', 'PAID', '128021', '1762482237', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (360, 'Tripay', '30738-251102711', 'MANDIRIVA', '', '2081', '100105578', '251102711', 'T1500128207287CP8N6', 'https://tripay.co.id/checkout/T1500128207287CP8N6', '1762485276', '2025-11-07', '1762571668', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (361, 'Tripay', '649582-251102711', 'MANDIRIVA', '', '2081', '100105578', '251102711', 'T1500128207305HTXLO', 'https://tripay.co.id/checkout/T1500128207305HTXLO', '1762485310', '2025-11-07', '1762571709', '', 'PAID', '127125', '1762485468', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (362, 'Tripay', '753075-251102523', 'BCAVA', '', '1890', '100105244', '251102523', 'T1500128207471U9TZK', 'https://tripay.co.id/checkout/T1500128207471U9TZK', '1762485771', '2025-11-07', '1762572171', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (363, 'Tripay', '393103-251102523', 'BCAVA', '', '1890', '100105244', '251102523', 'T1500128207509M4GE6', 'https://tripay.co.id/checkout/T1500128207509M4GE6', '1762485873', '2025-11-07', '1762572273', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (364, 'Tripay', '830265-251102181', 'BCAVA', '', '1530', '100104587', '251102181', 'T1500128209924T05OK', 'https://tripay.co.id/checkout/T1500128209924T05OK', '1762491801', '2025-11-07', '1762578201', '', 'PAID', '127878', '1762492255', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (365, 'Tripay', '746195-251102278', 'BRIVA', '', '1632', '100104804', '251102278', 'T1500128210184HE7R0', 'https://tripay.co.id/checkout/T1500128210184HE7R0', '1762492322', '2025-11-07', '1762578722', '', 'PAID', '127125', '1762492457', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (366, 'Tripay', '484693-251101169', 'DANA', '', '297', '230327135560', '251101169', 'T1500128210909DUHHU', 'https://tripay.co.id/checkout/T1500128210909DUHHU', '1762493783', '2025-11-07', '1762497262', '', 'PAID', '126941', '1762493796', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (367, 'Tripay', '429965-251102827', 'QRIS2', '', '2198', '121000001', '251102827', 'T15001282110245GDU1', 'https://tripay.co.id/checkout/T15001282110245GDU1', '1762494033', '2025-11-07', '1762495833', '', 'PAID', '25925', '1762494082', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (368, 'Tripay', '200273-251101915', 'SHOPEEPAY', '', '1234', '250214100721', '251101915', 'T1500128211099KNZ5I', 'https://tripay.co.id/checkout/T1500128211099KNZ5I', '1762494171', '2025-11-07', '1762497648', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (369, 'Tripay', '721064-251101915', 'QRIS', '', '1234', '250214100721', '251101915', 'T1500128211128DJQQA', 'https://tripay.co.id/checkout/T1500128211128DJQQA', '1762494241', '2025-11-07', '1762496041', '', 'PAID', '125812', '1762494332', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (370, 'Tripay', '654948-251102516', 'INDOMARET', '', '1883', '100105231', '251102516', 'T1500128212371CZGWW', 'https://tripay.co.id/checkout/T1500128212371CZGWW', '1762496655', '2025-11-07', '1762583055', '', 'PAID', '126750', '1762497136', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (371, 'Tripay', '92540-251101713', 'ALFAMART', '', '1002', '241213085228', '251101713', 'T1500128215875AXWDI', 'https://tripay.co.id/checkout/T1500128215875AXWDI', '1762504586', '2025-11-07', '1762590866', '', 'PAID', '126750', '1762505087', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (372, 'Tripay', '751783-251101534', 'INDOMARET', '', '791', '100103328', '251101534', 'T1500128216216PGVPP', 'https://tripay.co.id/checkout/T1500128216216PGVPP', '1762505270', '2025-11-07', '1762591669', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (373, 'Tripay', '32837-251101534', 'INDOMARET', '', '791', '100103328', '251101534', 'T1500128216452PECWN', 'https://tripay.co.id/checkout/T1500128216452PECWN', '1762505773', '2025-11-07', '1762592173', '', 'PAID', '126750', '1762505824', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (374, 'Tripay', '720424-251102175', 'BRIVA', '', '1524', '100104573', '251102175', 'T1500128217373TBALY', 'https://tripay.co.id/checkout/T1500128217373TBALY', '1762507682', '2025-11-07', '1762594081', '', 'PAID', '127681', '1762507784', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (375, 'Tripay', '440756-251102782', 'BCAVA', '', '2152', '100105714', '251102782', 'T1500128217908B38MZ', 'https://tripay.co.id/checkout/T1500128217908B38MZ', '1762508866', '2025-11-07', '1762595266', '', 'PAID', '82750', '1762508972', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (376, 'Tripay', '979619-251101573', 'QRIS2', '', '835', '100103437', '251101573', 'T1500128217935HXIPC', 'https://tripay.co.id/checkout/T1500128217935HXIPC', '1762508914', '2025-11-07', '1762510713', '', 'PAID', '126625', '1762508966', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (377, 'Tripay', '339523-251102552', 'ALFAMART', '', '1920', '100105316', '251102552', 'T15001282186577VNIT', 'https://tripay.co.id/checkout/T15001282186577VNIT', '1762510357', '2025-11-07', '1762596637', '', 'PAID', '126750', '1762510463', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (378, 'Tripay', '637427-251101322', 'DANA', '', '522', '240326122312', '251101322', 'T1500128227505KGWYY', 'https://tripay.co.id/checkout/T1500128227505KGWYY', '1762527678', '2025-11-07', '1762531157', '', 'PAID', '127876', '1762527718', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (379, 'Tripay', '343025-251102010', 'QRIS2', '', '1344', '250228073718', '251102010', 'T15001282279367XDN9', 'https://tripay.co.id/checkout/T15001282279367XDN9', '1762529185', '2025-11-07', '1762530984', '', 'PAID', '126625', '1762529241', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (380, 'Tripay', '91547-251101837', 'DANA', '', '1149', '250118140653', '251101837', 'T15001282291365BGD4', 'https://tripay.co.id/checkout/T15001282291365BGD4', '1762534579', '2025-11-07', '1762538058', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (381, 'Tripay', '903524-251102312', 'DANA', '', '1669', '250524142058', '251102312', 'T1500128230994BBSZT', 'https://tripay.co.id/checkout/T1500128230994BBSZT', '1762554825', '2025-11-08', '1762558304', '', 'PAID', '126875', '1762554889', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (382, 'Tripay', '719084-251101837', 'DANA', '', '1149', '250118140653', '251101837', 'T1500128231847ONCSN', 'https://tripay.co.id/checkout/T1500128231847ONCSN', '1762559246', '2025-11-08', '1762562725', '', 'PAID', '126875', '1762559266', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (383, 'Tripay', '725648-251102210', 'BCAVA', '', '1559', '100104633', '251102210', 'T1500128232322S6TN5', 'https://tripay.co.id/checkout/T1500128232322S6TN5', '1762561034', '2025-11-08', '1762647434', '', 'PAID', '128585', '1762561279', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (384, 'Tripay', '411776-251101190', 'BCAVA', '', '324', '230617123737', '251101190', 'T1500128232750VLPH9', 'https://tripay.co.id/checkout/T1500128232750VLPH9', '1762562592', '2025-11-08', '1762648991', '', 'PAID', '128706', '1762562675', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (385, 'Tripay', '225095-251101029', 'BNIVA', '', '42', '220823101240', '251101029', 'T1500128232844X6OF0', 'https://tripay.co.id/checkout/T1500128232844X6OF0', '1762562934', '2025-11-08', '1762649213', '', 'UNPAID', '129754', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (386, 'Tripay', '87869-251101029', 'BRIVA', '', '42', '220823101240', '251101029', 'T1500128232852HYN6Y', 'https://tripay.co.id/checkout/T1500128232852HYN6Y', '1762562956', '2025-11-08', '1762649356', '', 'PAID', '127629', '1762563003', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (387, 'Tripay', '625034-251101434', 'QRIS2', '', '667', '100103114', '251101434', 'T1500128233460UHUUT', 'https://tripay.co.id/checkout/T1500128233460UHUUT', '1762564732', '2025-11-08', '1762568332', '', 'PAID', '126625', '1762564768', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (388, 'Tripay', '754547-251102761', 'BNIVA', '', '2131', '100105677', '251102761', 'T1500128233607SX7QA', 'https://tripay.co.id/checkout/T1500128233607SX7QA', '1762565159', '2025-11-08', '1762651432', '', 'PAID', '100250', '1762565229', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (389, 'Tripay', '931651-251102765', 'MANDIRIVA', '', '2135', '100105685', '251102765', 'T1500128233625O07JM', 'https://tripay.co.id/checkout/T1500128233625O07JM', '1762565207', '2025-11-08', '1762651607', '', 'PAID', '94125', '1762565319', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (390, 'Tripay', '769244-251102795', 'BRIVA', '', '2165', '100105743', '251102795', 'T1500128233691QMTRI', 'https://tripay.co.id/checkout/T1500128233691QMTRI', '1762565409', '2025-11-08', '1762651809', '', 'PAID', '65125', '1762565458', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (391, 'Tripay', '326266-251102789', 'BRIVA', '', '2159', '100105724', '251102789', 'T1500128233717MQXMH', 'https://tripay.co.id/checkout/T1500128233717MQXMH', '1762565467', '2025-11-08', '1762651867', '', 'UNPAID', '73125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (392, 'Tripay', '154300-251102789', 'BRIVA', '', '2159', '100105724', '251102789', 'T1500128233735JYG5R', 'https://tripay.co.id/checkout/T1500128233735JYG5R', '1762565508', '2025-11-08', '1762651907', '', 'PAID', '73125', '1762565570', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (393, 'Tripay', '448832-251101365', 'SHOPEEPAY', '', '586', '240608143722', '251101365', 'T1500128233854PVF7X', 'https://tripay.co.id/checkout/T1500128233854PVF7X', '1762565828', '2025-11-08', '1762569308', '', 'PAID', '128757', '1762566025', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (394, 'Tripay', '473941-251102661', 'DANA', '', '2031', '100105531', '251102661', 'T1500128233885BHG1D', 'https://tripay.co.id/checkout/T1500128233885BHG1D', '1762565885', '2025-11-08', '1762569364', '', 'PAID', '126875', '1762565923', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (395, 'Tripay', '525751-251101667', 'DANA', '', '945', '100103601', '251101667', 'T1500128233906AMV4Y', 'https://tripay.co.id/checkout/T1500128233906AMV4Y', '1762565937', '2025-11-08', '1762569415', '', 'PAID', '126875', '1762565987', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (396, 'Tripay', '182644-251102804', 'INDOMARET', '', '2174', '100105757', '251102804', 'T1500128233919PZO7J', 'https://tripay.co.id/checkout/T1500128233919PZO7J', '1762565979', '2025-11-08', '1762652379', '', 'PAID', '51750', '1762592044', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (397, 'Tripay', '116827-251102663', 'INDOMARET', '', '2033', '100105535', '251102663', 'T1500128233945QCBRG', 'https://tripay.co.id/checkout/T1500128233945QCBRG', '1762566072', '2025-11-08', '1762652471', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (398, 'Tripay', '66885-251102668', 'BRIVA', '', '2038', '100105541', '251102668', 'T1500128234054ZAVAM', 'https://tripay.co.id/checkout/T1500128234054ZAVAM', '1762566376', '2025-11-08', '1762652769', '', 'PAID', '127125', '1762566462', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (399, 'Tripay', '19337-251102675', 'BRIVA', '', '2045', '100105552', '251102675', 'T1500128234071ZNINS', 'https://tripay.co.id/checkout/T1500128234071ZNINS', '1762566443', '2025-11-08', '1762652843', '', 'PAID', '127125', '1762566495', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (400, 'Tripay', '263992-251102588', 'MANDIRIVA', '', '1957', '100105387', '251102588', 'T1500128234091ANGHX', 'https://tripay.co.id/checkout/T1500128234091ANGHX', '1762566504', '2025-11-08', '1762652904', '', 'PAID', '127125', '1762566576', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (401, 'Tripay', '505796-251102606', 'BCAVA', '', '1976', '100105421', '251102606', 'T15001282342247STUF', 'https://tripay.co.id/checkout/T15001282342247STUF', '1762566876', '2025-11-08', '1762653276', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (402, 'Tripay', '452442-251102654', 'BCAVA', '', '2024', '100105519', '251102654', 'T15001282342921CUZ8', 'https://tripay.co.id/checkout/T15001282342921CUZ8', '1762567050', '2025-11-08', '1762653450', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (403, 'Tripay', '879031-251102813', 'BRIVA', '', '2183', '100105772', '251102813', 'T1500128234301RBWB5', 'https://tripay.co.id/checkout/T1500128234301RBWB5', '1762567075', '2025-11-08', '1762653468', '', 'PAID', '44125', '1762567179', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (404, 'Tripay', '827766-251102701', 'ALFAMART', '', '2071', '100105560', '251102701', 'T1500128234350V8X84', 'https://tripay.co.id/checkout/T1500128234350V8X84', '1762567185', '2025-11-08', '1762653465', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (405, 'Tripay', '709527-251101233', 'ALFAMART', '', '386', '230630156075', '251101233', 'T1500128234436PUCYQ', 'https://tripay.co.id/checkout/T1500128234436PUCYQ', '1762567455', '2025-11-08', '1762653735', '', 'PAID', '126865', '1762596106', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (406, 'Tripay', '74317-251102575', 'MANDIRIVA', '', '1943', '100105364', '251102575', 'T1500128234438JZCGH', 'https://tripay.co.id/checkout/T1500128234438JZCGH', '1762567456', '2025-11-08', '1762653856', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (407, 'Tripay', '628234-251102528', 'INDOMARET', '', '1895', '100105257', '251102528', 'T1500128234439QG5C2', 'https://tripay.co.id/checkout/T1500128234439QG5C2', '1762567456', '2025-11-08', '1762653856', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (408, 'Tripay', '168010-251102415', 'BCAVA', '', '1778', '100105025', '251102415', 'T1500128234462JMTWF', 'https://tripay.co.id/checkout/T1500128234462JMTWF', '1762567519', '2025-11-08', '1762653919', '', 'PAID', '127750', '1762567588', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (409, 'Tripay', '392162-251102579', 'QRIS2', '', '1947', '100105371', '251102579', 'T1500128234491PDPAS', 'https://tripay.co.id/checkout/T1500128234491PDPAS', '1762567623', '2025-11-08', '1762571223', '', 'PAID', '126625', '1762567688', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (410, 'Tripay', '918477-251102822', 'BCAVA', '', '2192', '100105786', '251102822', 'T1500128234501G249N', 'https://tripay.co.id/checkout/T1500128234501G249N', '1762567638', '2025-11-08', '1762654038', '', 'PAID', '32750', '1762567716', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (411, 'Tripay', '377016-251102575', 'MANDIRIVA', '', '1943', '100105364', '251102575', 'T1500128234537SKVMK', 'https://tripay.co.id/checkout/T1500128234537SKVMK', '1762567714', '2025-11-08', '1762654107', '', 'PAID', '127125', '1762567769', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (412, 'Tripay', '875845-251102531', 'SHOPEEPAY', '', '1898', '100105263', '251102531', 'T1500128234550NRN73', 'https://tripay.co.id/checkout/T1500128234550NRN73', '1762567741', '2025-11-08', '1762571220', '', 'PAID', '128750', '1762567826', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (413, 'Tripay', '473414-251102430', 'SHOPEEPAY', '', '1793', '100105055', '251102430', 'T1500128234573Z53BE', 'https://tripay.co.id/checkout/T1500128234573Z53BE', '1762567820', '2025-11-08', '1762571299', '', 'PAID', '128750', '1762567844', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (414, 'Tripay', '400748-251102666', 'BCAVA', '', '2036', '100105538', '251102666', 'T1500128234619OEFQP', 'https://tripay.co.id/checkout/T1500128234619OEFQP', '1762567914', '2025-11-08', '1762654314', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (415, 'Tripay', '654969-251102567', 'BRIVA', '', '1935', '100105348', '251102567', 'T15001282346232XNLJ', 'https://tripay.co.id/checkout/T15001282346232XNLJ', '1762567935', '2025-11-08', '1762654335', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (416, 'Tripay', '592914-251102580', 'BCAVA', '', '1948', '100105373', '251102580', 'T1500128234666JDWEU', 'https://tripay.co.id/checkout/T1500128234666JDWEU', '1762568059', '2025-11-08', '1762654459', '', 'PAID', '127750', '1762568133', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (417, 'Tripay', '904869-251102365', 'DANA', '', '1725', '100104917', '251102365', 'T1500128234681FSFVV', 'https://tripay.co.id/checkout/T1500128234681FSFVV', '1762568103', '2025-11-08', '1762571582', '', 'PAID', '126875', '1762568191', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (418, 'Tripay', '892521-251102347', 'BRIVA', '', '1706', '100104883', '251102347', 'T1500128234691NXVEF', 'https://tripay.co.id/checkout/T1500128234691NXVEF', '1762568124', '2025-11-08', '1762654523', '', 'PAID', '127125', '1762568276', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (419, 'Tripay', '553722-251101301', 'BRIVA', '', '487', '231219090602', '251101301', 'T1500128234702E9DFU', 'https://tripay.co.id/checkout/T1500128234702E9DFU', '1762568151', '2025-11-08', '1762654551', '', 'PAID', '127305', '1762568190', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (420, 'Tripay', '581607-251102479', 'BRIVA', '', '1845', '100105158', '251102479', 'T1500128234704CUW8R', 'https://tripay.co.id/checkout/T1500128234704CUW8R', '1762568157', '2025-11-08', '1762654557', '', 'PAID', '127125', '1762568211', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (421, 'Tripay', '644260-251102370', 'BRIVA', '', '1731', '100104930', '251102370', 'T1500128234742A4ZKD', 'https://tripay.co.id/checkout/T1500128234742A4ZKD', '1762568253', '2025-11-08', '1762654652', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (422, 'Tripay', '620010-251102518', 'INDOMARET', '', '1885', '100105236', '251102518', 'T15001282347658P5GP', 'https://tripay.co.id/checkout/T15001282347658P5GP', '1762568309', '2025-11-08', '1762654708', '', 'PAID', '126750', '1762593418', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (423, 'Tripay', '589102-251102475', 'DANA', '', '1841', '100105147', '251102475', 'T1500128234804POHNO', 'https://tripay.co.id/checkout/T1500128234804POHNO', '1762568396', '2025-11-08', '1762571875', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (424, 'Tripay', '752401-251102481', 'MANDIRIVA', '', '1847', '100105160', '251102481', 'T1500128234835PYO11', 'https://tripay.co.id/checkout/T1500128234835PYO11', '1762568484', '2025-11-08', '1762654878', '', 'PAID', '127125', '1762568536', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (425, 'Tripay', '536003-251102490', 'SHOPEEPAY', '', '1856', '100105182', '251102490', 'T1500128234859QBJAJ', 'https://tripay.co.id/checkout/T1500128234859QBJAJ', '1762568560', '2025-11-08', '1762572040', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (426, 'Tripay', '523595-251102490', 'SHOPEEPAY', '', '1856', '100105182', '251102490', 'T1500128234861KCZ8H', 'https://tripay.co.id/checkout/T1500128234861KCZ8H', '1762568564', '2025-11-08', '1762572044', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (427, 'Tripay', '810383-251102490', 'SHOPEEPAY', '', '1856', '100105182', '251102490', 'T1500128234867FIQF2', 'https://tripay.co.id/checkout/T1500128234867FIQF2', '1762568570', '2025-11-08', '1762572050', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (428, 'Tripay', '234893-251102475', 'DANA', '', '1841', '100105147', '251102475', 'T1500128234874NLHSD', 'https://tripay.co.id/checkout/T1500128234874NLHSD', '1762568587', '2025-11-08', '1762572066', '', 'PAID', '126875', '1762568611', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (429, 'Tripay', '673915-251102427', 'QRIS2', '', '1790', '100105046', '251102427', 'T1500128234904AJAMC', 'https://tripay.co.id/checkout/T1500128234904AJAMC', '1762568647', '2025-11-08', '1762570447', '', 'PAID', '126625', '1762568692', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (430, 'Tripay', '626631-251102567', 'BCAVA', '', '1935', '100105348', '251102567', 'T1500128234906V4YAU', 'https://tripay.co.id/checkout/T1500128234906V4YAU', '1762568656', '2025-11-08', '1762655056', '', 'PAID', '127750', '1762568723', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (431, 'Tripay', '397133-251102463', 'BCAVA', '', '1829', '100105124', '251102463', 'T1500128234913AOYV1', 'https://tripay.co.id/checkout/T1500128234913AOYV1', '1762568666', '2025-11-08', '1762655066', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (432, 'Tripay', '955398-251102463', 'BCAVA', '', '1829', '100105124', '251102463', 'T15001282349315HCOY', 'https://tripay.co.id/checkout/T15001282349315HCOY', '1762568701', '2025-11-08', '1762655100', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (433, 'Tripay', '661053-251102680', 'BCAVA', '', '2050', '10010564', '251102680', 'T1500128235009JDAPC', 'https://tripay.co.id/checkout/T1500128235009JDAPC', '1762568940', '2025-11-08', '1762655340', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (434, 'Tripay', '954645-251102463', 'BCAVA', '', '1829', '100105124', '251102463', 'T15001282350292TZZB', 'https://tripay.co.id/checkout/T15001282350292TZZB', '1762568982', '2025-11-08', '1762655382', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (435, 'Tripay', '716469-251102294', 'QRIS2', '', '1649', '250517103610', '251102294', 'T1500128235031OPH5R', 'https://tripay.co.id/checkout/T1500128235031OPH5R', '1762568990', '2025-11-08', '1762570789', '', 'PAID', '126625', '1762569108', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (436, 'Tripay', '3698-251102680', 'QRIS2', '', '2050', '10010564', '251102680', 'T1500128235036OYCTQ', 'https://tripay.co.id/checkout/T1500128235036OYCTQ', '1762568997', '2025-11-08', '1762570797', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (437, 'Tripay', '752522-251102810', 'INDOMARET', '', '2180', '100105769', '251102810', 'T1500128235040OYUMX', 'https://tripay.co.id/checkout/T1500128235040OYUMX', '1762569004', '2025-11-08', '1762655404', '', 'UNPAID', '43750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (438, 'Tripay', '237802-251102680', 'QRIS2', '', '2050', '10010564', '251102680', 'T1500128235055EU3ZJ', 'https://tripay.co.id/checkout/T1500128235055EU3ZJ', '1762569049', '2025-11-08', '1762570848', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (439, 'Tripay', '191328-251102463', 'BRIVA', '', '1829', '100105124', '251102463', 'T1500128235100EOGFD', 'https://tripay.co.id/checkout/T1500128235100EOGFD', '1762569146', '2025-11-08', '1762655539', '', 'PAID', '127125', '1762569234', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (440, 'Tripay', '125684-251102800', 'DANA', '', '2170', '100105751', '251102800', 'T1500128235119CWQ2Z', 'https://tripay.co.id/checkout/T1500128235119CWQ2Z', '1762569175', '2025-11-08', '1762572655', '', 'PAID', '55825', '1762569219', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (441, 'Tripay', '903009-251102387', 'BRIVA', '', '1748', '100104958', '251102387', 'T1500128235125WF5SY', 'https://tripay.co.id/checkout/T1500128235125WF5SY', '1762569190', '2025-11-08', '1762655590', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (442, 'Tripay', '601612-251102646', 'QRIS2', '', '2016', '100105503', '251102646', 'T1500128235136JSJM2', 'https://tripay.co.id/checkout/T1500128235136JSJM2', '1762569219', '2025-11-08', '1762571018', '', 'PAID', '126625', '1762569282', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (443, 'Tripay', '667375-251102489', 'QRIS2', '', '1855', '100105180', '251102489', 'T1500128235251JBPLP', 'https://tripay.co.id/checkout/T1500128235251JBPLP', '1762569482', '2025-11-08', '1762571282', '', 'PAID', '126625', '1762569534', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (444, 'Tripay', '261071-251102482', 'BNIVA', '', '1848', '100105163', '251102482', 'T1500128235320AA8NG', 'https://tripay.co.id/checkout/T1500128235320AA8NG', '1762569612', '2025-11-08', '1762655891', '', 'PAID', '129250', '1762569685', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (445, 'Tripay', '708141-251102654', 'BCAVA', '', '2024', '100105519', '251102654', 'T1500128235356SPCWW', 'https://tripay.co.id/checkout/T1500128235356SPCWW', '1762569685', '2025-11-08', '1762656085', '', 'PAID', '127750', '1762569767', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (446, 'Tripay', '501617-251102654', 'BCAVA', '', '2024', '100105519', '251102654', 'T1500128235376RDQMD', 'https://tripay.co.id/checkout/T1500128235376RDQMD', '1762569739', '2025-11-08', '1762656139', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (447, 'Tripay', '857280-251102425', 'INDOMARET', '', '1788', '100105042', '251102425', 'T15001282353901OSFF', 'https://tripay.co.id/checkout/T15001282353901OSFF', '1762569772', '2025-11-08', '1762656172', '', 'PAID', '126750', '1762569949', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (448, 'Tripay', '17703-251102377', 'BRIVA', '', '1738', '100104942', '251102377', 'T150012823539671MJX', 'https://tripay.co.id/checkout/T150012823539671MJX', '1762569794', '2025-11-08', '1762656187', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (449, 'Tripay', '962569-251102205', 'DANA', '', '1554', '100104622', '251102205', 'T1500128235400BBOJ8', 'https://tripay.co.id/checkout/T1500128235400BBOJ8', '1762569806', '2025-11-08', '1762573285', '', 'PAID', '127654', '1762569831', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (450, 'Tripay', '583190-251102138', 'BCAVA', '', '1480', '250411143150', '251102138', 'T1500128235427R6EC0', 'https://tripay.co.id/checkout/T1500128235427R6EC0', '1762569854', '2025-11-08', '1762656254', '', 'PAID', '128329', '1762584889', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (451, 'Tripay', '170092-251102303', 'BRIVA', '', '1660', '250522111251', '251102303', 'T1500128235456IKTSW', 'https://tripay.co.id/checkout/T1500128235456IKTSW', '1762569918', '2025-11-08', '1762656318', '', 'PAID', '127125', '1762570677', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (452, 'Tripay', '327637-251102145', 'BRIVA', '', '1487', '250411145009', '251102145', 'T1500128235463TUFKH', 'https://tripay.co.id/checkout/T1500128235463TUFKH', '1762569942', '2025-11-08', '1762656342', '', 'PAID', '127990', '1762570016', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (453, 'Tripay', '2784-251102404', 'QRIS2', '', '1767', '100104997', '251102404', 'T1500128235471KWQB2', 'https://tripay.co.id/checkout/T1500128235471KWQB2', '1762569968', '2025-11-08', '1762571767', '', 'PAID', '126625', '1762570026', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (454, 'Tripay', '962357-251102035', 'BRIVA', '', '1371', '100104319', '251102035', 'T1500128235526YA6CB', 'https://tripay.co.id/checkout/T1500128235526YA6CB', '1762570119', '2025-11-08', '1762656519', '', 'PAID', '128061', '1762570172', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (455, 'Tripay', '961919-251102507', 'ALFAMART', '', '1873', '100105212', '251102507', 'T1500128235553KNTXO', 'https://tripay.co.id/checkout/T1500128235553KNTXO', '1762570158', '2025-11-08', '1762656438', '', 'PAID', '126750', '1762571705', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (456, 'Tripay', '694365-251102366', 'BRIVA', '', '1726', '100104918', '251102366', 'T1500128235624NUDJS', 'https://tripay.co.id/checkout/T1500128235624NUDJS', '1762570354', '2025-11-08', '1762656754', '', 'PAID', '127125', '1762570549', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (457, 'Tripay', '282099-251102064', 'BCAVA', '', '1403', '100104378', '251102064', 'T1500128235647APOXH', 'https://tripay.co.id/checkout/T1500128235647APOXH', '1762570410', '2025-11-08', '1762656809', '', 'PAID', '128044', '1762570497', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (458, 'Tripay', '887825-251102826', 'BCAVA', '', '2197', '161200001', '251102826', 'T15001282356481YX3S', 'https://tripay.co.id/checkout/T15001282356481YX3S', '1762570410', '2025-11-08', '1762656810', '', 'UNPAID', '27750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (459, 'Tripay', '560904-251102474', 'ALFAMART', '', '1840', '100105146', '251102474', 'T1500128235662VN1FP', 'https://tripay.co.id/checkout/T1500128235662VN1FP', '1762570451', '2025-11-08', '1762656731', '', 'PAID', '126750', '1762570492', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (460, 'Tripay', '778585-251102802', 'MANDIRIVA', '', '2172', '100105754', '251102802', 'T1500128235695SANNV', 'https://tripay.co.id/checkout/T1500128235695SANNV', '1762570537', '2025-11-08', '1762656930', '', 'PAID', '57125', '1762570692', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (461, 'Tripay', '111348-251102680', 'QRIS2', '', '2050', '10010564', '251102680', 'T1500128235761NGKKN', 'https://tripay.co.id/checkout/T1500128235761NGKKN', '1762570747', '2025-11-08', '1762572547', '', 'PAID', '126625', '1762570833', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (462, 'Tripay', '95418-251102309', 'BCAVA', '', '1666', '250524140124', '251102309', 'T15001282357972NTCO', 'https://tripay.co.id/checkout/T15001282357972NTCO', '1762570853', '2025-11-08', '1762657252', '', 'PAID', '127750', '1762571783', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (463, 'Tripay', '952762-251102387', 'BRIVA', '', '1748', '100104958', '251102387', 'T1500128235813H7TNJ', 'https://tripay.co.id/checkout/T1500128235813H7TNJ', '1762570911', '2025-11-08', '1762657311', '', 'PAID', '127125', '1762570974', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (464, 'Tripay', '89835-251102267', 'DANA', '', '1621', '100104785', '251102267', 'T15001282358639UWAT', 'https://tripay.co.id/checkout/T15001282358639UWAT', '1762571056', '2025-11-08', '1762574534', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (465, 'Tripay', '967344-251102810', 'DANA', '', '2180', '100105769', '251102810', 'T1500128235928UFLUI', 'https://tripay.co.id/checkout/T1500128235928UFLUI', '1762571220', '2025-11-08', '1762574699', '', 'PAID', '42630', '1762571317', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (466, 'Tripay', '326424-251102751', 'SHOPEEPAY', '', '2121', '100105652', '251102751', 'T1500128235930YPVHR', 'https://tripay.co.id/checkout/T1500128235930YPVHR', '1762571239', '2025-11-08', '1762574719', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (467, 'Tripay', '157478-251102025', 'INDOMARET', '', '1361', '100104307', '251102025', 'T1500128235953QJYSV', 'https://tripay.co.id/checkout/T1500128235953QJYSV', '1762571292', '2025-11-08', '1762657692', '', 'PAID', '126834', '1762575649', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (468, 'Tripay', '584517-251102022', 'BRIVA', '', '1358', '100104303', '251102022', 'T15001282359716DS3Z', 'https://tripay.co.id/checkout/T15001282359716DS3Z', '1762571331', '2025-11-08', '1762657724', '', 'PAID', '127523', '1762587136', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (469, 'Tripay', '63601-251102334', 'BRIVA', '', '1693', '100104851', '251102334', 'T1500128236004YHPTI', 'https://tripay.co.id/checkout/T1500128236004YHPTI', '1762571402', '2025-11-08', '1762657802', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (470, 'Tripay', '816923-251102285', 'BRIVA', '', '1639', '100104816', '251102285', 'T1500128236015KNVUB', 'https://tripay.co.id/checkout/T1500128236015KNVUB', '1762571437', '2025-11-08', '1762657836', '', 'PAID', '127125', '1762571556', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (471, 'Tripay', '785136-251102334', 'BRIVA', '', '1693', '100104851', '251102334', 'T15001282360313RAR6', 'https://tripay.co.id/checkout/T15001282360313RAR6', '1762571480', '2025-11-08', '1762657880', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (472, 'Tripay', '148690-251102334', 'BRIVA', '', '1693', '100104851', '251102334', 'T1500128236045CPROL', 'https://tripay.co.id/checkout/T1500128236045CPROL', '1762571504', '2025-11-08', '1762657904', '', 'PAID', '127125', '1762571580', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (473, 'Tripay', '386935-251102826', 'BCAVA', '', '2197', '161200001', '251102826', 'T1500128236102ZNH68', 'https://tripay.co.id/checkout/T1500128236102ZNH68', '1762571636', '2025-11-08', '1762658036', '', 'UNPAID', '27750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (474, 'Tripay', '307593-251102405', 'DANA', '', '1768', '100105000', '251102405', 'T1500128236135T7TD9', 'https://tripay.co.id/checkout/T1500128236135T7TD9', '1762571699', '2025-11-08', '1762575179', '', 'PAID', '126875', '1762571720', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (475, 'Tripay', '914827-251101449', 'BCAVA', '', '687', '100103151', '251101449', 'T1500128236191VIKME', 'https://tripay.co.id/checkout/T1500128236191VIKME', '1762571838', '2025-11-08', '1762658238', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (476, 'Tripay', '992502-251101449', 'BCAVA', '', '687', '100103151', '251101449', 'T15001282362115TZ4B', 'https://tripay.co.id/checkout/T15001282362115TZ4B', '1762571924', '2025-11-08', '1762658324', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (477, 'Tripay', '663967-251101449', 'QRIS2', '', '687', '100103151', '251101449', 'T1500128236229ERLHK', 'https://tripay.co.id/checkout/T1500128236229ERLHK', '1762571985', '2025-11-08', '1762573784', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (478, 'Tripay', '74695-251101449', 'QRIS2', '', '687', '100103151', '251101449', 'T1500128236238GIKHF', 'https://tripay.co.id/checkout/T1500128236238GIKHF', '1762572005', '2025-11-08', '1762573804', '', 'PAID', '126625', '1762572036', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (479, 'Tripay', '745311-251102490', 'SHOPEEPAY', '', '1856', '100105182', '251102490', 'T15001282364828EIL0', 'https://tripay.co.id/checkout/T15001282364828EIL0', '1762572587', '2025-11-08', '1762576066', '', 'PAID', '128750', '1762572701', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (480, 'Tripay', '559992-251102443', 'QRIS2', '', '1807', '100105074', '251102443', 'T1500128236583WKNPT', 'https://tripay.co.id/checkout/T1500128236583WKNPT', '1762572809', '2025-11-08', '1762574609', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (481, 'Tripay', '649808-251102597', 'BCAVA', '', '1967', '100105407', '251102597', 'T1500128236608OJU0F', 'https://tripay.co.id/checkout/T1500128236608OJU0F', '1762572896', '2025-11-08', '1762659296', '', 'PAID', '127750', '1762573037', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (482, 'Tripay', '480248-251102348', 'DANA', '', '1707', '100104884', '251102348', 'T15001282366117KBNV', 'https://tripay.co.id/checkout/T15001282366117KBNV', '1762572900', '2025-11-08', '1762576379', '', 'PAID', '126875', '1762573052', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (483, 'Tripay', '545847-251102267', 'DANA', '', '1621', '100104785', '251102267', 'T1500128236763DPWPE', 'https://tripay.co.id/checkout/T1500128236763DPWPE', '1762573323', '2025-11-08', '1762576802', '', 'PAID', '126875', '1762573380', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (484, 'Tripay', '263749-251102663', 'INDOMARET', '', '2033', '100105535', '251102663', 'T1500128236873P6NNF', 'https://tripay.co.id/checkout/T1500128236873P6NNF', '1762573612', '2025-11-08', '1762660011', '', 'PAID', '126750', '1762573670', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (485, 'Tripay', '944622-251102622', 'QRIS', '', '1992', '100105450', '251102622', 'T150012823689253VKL', 'https://tripay.co.id/checkout/T150012823689253VKL', '1762573650', '2025-11-08', '1762575449', '', 'PAID', '125812', '1762573669', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (486, 'Tripay', '459203-251102618', 'ALFAMART', '', '1988', '100105446', '251102618', 'T1500128237024DKZVP', 'https://tripay.co.id/checkout/T1500128237024DKZVP', '1762573985', '2025-11-08', '1762660264', '', 'PAID', '126750', '1762574166', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (487, 'Tripay', '655250-251102826', 'BCAVA', '', '2197', '161200001', '251102826', 'T1500128237045D3SRY', 'https://tripay.co.id/checkout/T1500128237045D3SRY', '1762574057', '2025-11-08', '1762660457', '', 'UNPAID', '27750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (488, 'Tripay', '344762-251102751', 'QRIS', '', '2121', '100105652', '251102751', 'T1500128237088UJB1J', 'https://tripay.co.id/checkout/T1500128237088UJB1J', '1762574235', '2025-11-08', '1762576034', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (489, 'Tripay', '577898-251102751', 'QRIS2', '', '2121', '100105652', '251102751', 'T1500128237111K5LV0', 'https://tripay.co.id/checkout/T1500128237111K5LV0', '1762574293', '2025-11-08', '1762576092', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (490, 'Tripay', '704139-251102751', 'QRIS', '', '2121', '100105652', '251102751', 'T1500128237145YK4TE', 'https://tripay.co.id/checkout/T1500128237145YK4TE', '1762574378', '2025-11-08', '1762576178', '', 'PAID', '125812', '1762574466', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (491, 'Tripay', '643535-251102403', 'BRIVA', '', '1766', '100104995', '251102403', 'T1500128237167QRKIW', 'https://tripay.co.id/checkout/T1500128237167QRKIW', '1762574424', '2025-11-08', '1762660817', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (492, 'Tripay', '204227-251102361', 'BRIVA', '', '1721', '100104908', '251102361', 'T15001282372787RB61', 'https://tripay.co.id/checkout/T15001282372787RB61', '1762574704', '2025-11-08', '1762661104', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (493, 'Tripay', '830150-251102719', 'BCAVA', '', '2089', '100105598', '251102719', 'T1500128237420QDXXX', 'https://tripay.co.id/checkout/T1500128237420QDXXX', '1762575125', '2025-11-08', '1762661525', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (494, 'Tripay', '47166-251102798', 'ALFAMART', '', '2168', '100105749', '251102798', 'T1500128237439AI31V', 'https://tripay.co.id/checkout/T1500128237439AI31V', '1762575182', '2025-11-08', '1762661462', '', 'PAID', '56750', '1762575414', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (495, 'Tripay', '576598-251102719', 'DANA', '', '2089', '100105598', '251102719', 'T1500128237464OR8FE', 'https://tripay.co.id/checkout/T1500128237464OR8FE', '1762575258', '2025-11-08', '1762578737', '', 'PAID', '126875', '1762575362', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (496, 'Tripay', '659329-251102569', 'BRIVA', '', '1937', '100105353', '251102569', 'T1500128237490PHZHP', 'https://tripay.co.id/checkout/T1500128237490PHZHP', '1762575330', '2025-11-08', '1762661723', '', 'PAID', '127125', '1762575368', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (497, 'Tripay', '441783-251102749', 'QRIS2', '', '2119', '100105650', '251102749', 'T1500128237530FFCHX', 'https://tripay.co.id/checkout/T1500128237530FFCHX', '1762575421', '2025-11-08', '1762577221', '', 'PAID', '126625', '1762575535', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (498, 'Tripay', '875446-251102539', 'BCAVA', '', '1907', '100105281', '251102539', 'T1500128237561XMGMO', 'https://tripay.co.id/checkout/T1500128237561XMGMO', '1762575495', '2025-11-08', '1762661895', '', 'PAID', '127750', '1762575569', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (499, 'Tripay', '490516-251101697', 'INDOMARET', '', '982', '100103687', '251101697', 'T1500128237622PNVCW', 'https://tripay.co.id/checkout/T1500128237622PNVCW', '1762575695', '2025-11-08', '1762662095', '', 'PAID', '126750', '1762580521', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (500, 'Tripay', '828724-251102509', 'DANA', '', '1876', '100105219', '251102509', 'T15001282376734KCZM', 'https://tripay.co.id/checkout/T15001282376734KCZM', '1762575861', '2025-11-08', '1762579340', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (501, 'Tripay', '947449-251102773', 'BCAVA', '', '2143', '100105700', '251102773', 'T15001282377276KMKK', 'https://tripay.co.id/checkout/T15001282377276KMKK', '1762575983', '2025-11-08', '1762662382', '', 'PAID', '127750', '1762576140', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (502, 'Tripay', '584007-251102208', 'BNIVA', '', '1557', '100104629', '251102208', 'T1500128238232R9VZX', 'https://tripay.co.id/checkout/T1500128238232R9VZX', '1762577428', '2025-11-08', '1762663702', '', 'PAID', '129834', '1762577480', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (503, 'Tripay', '414699-251102602', 'BNIVA', '', '1972', '100105414', '251102602', 'T1500128238533AAFU9', 'https://tripay.co.id/checkout/T1500128238533AAFU9', '1762578305', '2025-11-08', '1762664577', '', 'PAID', '129250', '1762578513', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (504, 'Tripay', '14228-251102041', 'ALFAMART', '', '1379', '100104337', '251102041', 'T1500128238946DG9PV', 'https://tripay.co.id/checkout/T1500128238946DG9PV', '1762579273', '2025-11-08', '1762665553', '', 'UNPAID', '127148', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (505, 'Tripay', '234982-251102041', 'ALFAMART', '', '1379', '100104337', '251102041', 'T1500128238970WJFWG', 'https://tripay.co.id/checkout/T1500128238970WJFWG', '1762579345', '2025-11-08', '1762665624', '', 'PAID', '127148', '1762579421', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (506, 'Tripay', '475505-251102509', 'DANA', '', '1876', '100105219', '251102509', 'T1500128239020W27ZR', 'https://tripay.co.id/checkout/T1500128239020W27ZR', '1762579516', '2025-11-08', '1762582995', '', 'PAID', '126875', '1762579547', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (507, 'Tripay', '267376-251102371', 'SHOPEEPAY', '', '1732', '100104933', '251102371', 'T1500128239049WP7BA', 'https://tripay.co.id/checkout/T1500128239049WP7BA', '1762579587', '2025-11-08', '1762583066', '', 'PAID', '128750', '1762579673', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (508, 'Tripay', '623669-251102488', 'BRIVA', '', '1854', '100105176', '251102488', 'T1500128239132AB4HI', 'https://tripay.co.id/checkout/T1500128239132AB4HI', '1762579806', '2025-11-08', '1762666198', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (509, 'Tripay', '845054-251102488', 'BRIVA', '', '1854', '100105176', '251102488', 'T1500128239198EAVRF', 'https://tripay.co.id/checkout/T1500128239198EAVRF', '1762579995', '2025-11-08', '1762666394', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (510, 'Tripay', '52346-251102817', 'ALFAMART', '', '2187', '100105776', '251102817', 'T1500128239252RNHNX', 'https://tripay.co.id/checkout/T1500128239252RNHNX', '1762580138', '2025-11-08', '1762666418', '', 'PAID', '39750', '1762580175', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (511, 'Tripay', '149731-251102388', 'MANDIRIVA', '', '1749', '100104960', '251102388', 'T15001282392586NBEF', 'https://tripay.co.id/checkout/T15001282392586NBEF', '1762580143', '2025-11-08', '1762666543', '', 'PAID', '127125', '1762580257', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (512, 'Tripay', '305781-251102472', 'SHOPEEPAY', '', '1838', '100105144', '251102472', 'T15001282392735VKSC', 'https://tripay.co.id/checkout/T15001282392735VKSC', '1762580186', '2025-11-08', '1762583665', '', 'PAID', '128750', '1762580280', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (513, 'Tripay', '929129-251102763', 'BNIVA', '', '2133', '100105681', '251102763', 'T1500128239302SRGVW', 'https://tripay.co.id/checkout/T1500128239302SRGVW', '1762580293', '2025-11-08', '1762666573', '', 'UNPAID', '96250', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (514, 'Tripay', '245796-251102763', 'BNIVA', '', '2133', '100105681', '251102763', 'T1500128239314CL8LX', 'https://tripay.co.id/checkout/T1500128239314CL8LX', '1762580337', '2025-11-08', '1762666616', '', 'PAID', '96250', '1762580480', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (515, 'Tripay', '374869-251102370', 'BRIVA', '', '1731', '100104930', '251102370', 'T1500128239884GXQQK', 'https://tripay.co.id/checkout/T1500128239884GXQQK', '1762581962', '2025-11-08', '1762668354', '', 'PAID', '127125', '1762582145', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (516, 'Tripay', '233038-251102377', 'ALFAMART', '', '1738', '100104942', '251102377', 'T1500128239892COY63', 'https://tripay.co.id/checkout/T1500128239892COY63', '1762581987', '2025-11-08', '1762668266', '', 'PAID', '126750', '1762582415', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (517, 'Tripay', '575873-251102258', 'BRIVA', '', '1612', '100104770', '251102258', 'T1500128240564K7MJB', 'https://tripay.co.id/checkout/T1500128240564K7MJB', '1762583832', '2025-11-08', '1762670224', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (518, 'Tripay', '504909-251102258', 'BRIVA', '', '1612', '100104770', '251102258', 'T1500128240566ZASCS', 'https://tripay.co.id/checkout/T1500128240566ZASCS', '1762583833', '2025-11-08', '1762670233', '', 'PAID', '127125', '1762583921', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (519, 'Tripay', '644574-251102330', 'QRIS2', '', '1688', '1001048', '251102330', 'T1500128240643H2VGF', 'https://tripay.co.id/checkout/T1500128240643H2VGF', '1762584041', '2025-11-08', '1762585840', '', 'PAID', '126625', '1762584067', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (520, 'Tripay', '393805-251102658', 'QRIS2', '', '2028', '100105526', '251102658', 'T1500128240761BAGIZ', 'https://tripay.co.id/checkout/T1500128240761BAGIZ', '1762584337', '2025-11-08', '1762587937', '', 'PAID', '126625', '1762584371', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (521, 'Tripay', '742766-251102701', 'INDOMARET', '', '2071', '100105560', '251102701', 'T1500128240789UYCV5', 'https://tripay.co.id/checkout/T1500128240789UYCV5', '1762584433', '2025-11-08', '1762670833', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (522, 'Tripay', '921927-251102488', 'BRIVA', '', '1854', '100105176', '251102488', 'T15001282408066DKKY', 'https://tripay.co.id/checkout/T15001282408066DKKY', '1762584467', '2025-11-08', '1762670860', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (523, 'Tripay', '862379-251102701', 'ALFAMART', '', '2071', '100105560', '251102701', 'T1500128240809OGW48', 'https://tripay.co.id/checkout/T1500128240809OGW48', '1762584472', '2025-11-08', '1762670752', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (524, 'Tripay', '911431-251102733', 'DANA', '', '2103', '100105623', '251102733', 'T150012824088324OPS', 'https://tripay.co.id/checkout/T150012824088324OPS', '1762584765', '2025-11-08', '1762588243', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (525, 'Tripay', '12180-251102375', 'ALFAMART', '', '1736', '100104938', '251102375', 'T15001282410027XSRN', 'https://tripay.co.id/checkout/T15001282410027XSRN', '1762585180', '2025-11-08', '1762671460', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (526, 'Tripay', '256561-251101418', 'BRIVA', '', '645', '240608143840', '251101418', 'T1500128241057S7F3H', 'https://tripay.co.id/checkout/T1500128241057S7F3H', '1762585367', '2025-11-08', '1762671760', '', 'UNPAID', '127588', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (527, 'Tripay', '893347-251101418', 'BRIVA', '', '645', '240608143840', '251101418', 'T1500128241080CMLJF', 'https://tripay.co.id/checkout/T1500128241080CMLJF', '1762585424', '2025-11-08', '1762671824', '', 'PAID', '127588', '1762585534', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (528, 'Tripay', '999056-251102397', 'BNIVA', '', '1758', '100104982', '251102397', 'T1500128241083PXUE5', 'https://tripay.co.id/checkout/T1500128241083PXUE5', '1762585431', '2025-11-08', '1762671710', '', 'UNPAID', '129250', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (529, 'Tripay', '487472-251102397', 'BNIVA', '', '1758', '100104982', '251102397', 'T1500128241116XNMOS', 'https://tripay.co.id/checkout/T1500128241116XNMOS', '1762585523', '2025-11-08', '1762671803', '', 'PAID', '129250', '1762585619', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (530, 'Tripay', '644611-251102375', 'INDOMARET', '', '1736', '100104938', '251102375', 'T1500128241176QK2ZK', 'https://tripay.co.id/checkout/T1500128241176QK2ZK', '1762585640', '2025-11-08', '1762672040', '', 'PAID', '126750', '1762585815', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (531, 'Tripay', '975141-251102685', 'BNIVA', '', '2055', '10010575', '251102685', 'T15001282413287PBCO', 'https://tripay.co.id/checkout/T15001282413287PBCO', '1762586058', '2025-11-08', '1762672330', '', 'PAID', '129250', '1762586158', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (532, 'Tripay', '504219-251102480', 'QRIS2', '', '1846', '100105159', '251102480', 'T1500128242219A7UQK', 'https://tripay.co.id/checkout/T1500128242219A7UQK', '1762588227', '2025-11-08', '1762590027', '', 'PAID', '126625', '1762588651', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (533, 'Tripay', '52496-251102804', 'ALFAMART', '', '2174', '100105757', '251102804', 'T1500128242449DPQFV', 'https://tripay.co.id/checkout/T1500128242449DPQFV', '1762588811', '2025-11-08', '1762675091', '', 'UNPAID', '51750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (534, 'Tripay', '141107-251102102', 'DANA', '', '1443', '100104463', '251102102', 'T1500128242466VETLT', 'https://tripay.co.id/checkout/T1500128242466VETLT', '1762588849', '2025-11-08', '1762592328', '', 'UNPAID', '126914', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (535, 'Tripay', '279287-251102403', 'BRIVA', '', '1766', '100104995', '251102403', 'T1500128243085MVJHS', 'https://tripay.co.id/checkout/T1500128243085MVJHS', '1762590259', '2025-11-08', '1762676652', '', 'PAID', '127125', '1762590604', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (536, 'Tripay', '269606-251102826', 'BCAVA', '', '2197', '161200001', '251102826', 'T1500128243258TNOAE', 'https://tripay.co.id/checkout/T1500128243258TNOAE', '1762590669', '2025-11-08', '1762677069', '', 'UNPAID', '27750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (537, 'Tripay', '97603-251101347', 'BRIVA', '', '556', '240608143658', '251101347', 'T1500128243806DP5PZ', 'https://tripay.co.id/checkout/T1500128243806DP5PZ', '1762592242', '2025-11-08', '1762678635', '', 'PAID', '127885', '1762592449', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (538, 'Tripay', '700766-251102024', 'BNIVA', '', '1360', '100104305', '251102024', 'T1500128243838FZCVX', 'https://tripay.co.id/checkout/T1500128243838FZCVX', '1762592357', '2025-11-08', '1762678637', '', 'PAID', '129940', '1762596229', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (539, 'Tripay', '108978-251102583', 'BSIVA', '', '1951', '100105380', '251102583', 'T1500128244097OLSJ2', 'https://tripay.co.id/checkout/T1500128244097OLSJ2', '1762593042', '2025-11-08', '1762603722', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (540, 'Tripay', '185929-251102089', 'DANA', '', '1429', '100104419', '251102089', 'T1500128244487YTKQ7', 'https://tripay.co.id/checkout/T1500128244487YTKQ7', '1762594132', '2025-11-08', '1762597612', '', 'UNPAID', '127515', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (541, 'Tripay', '643566-251102820', 'DANA', '', '2190', '100105784', '251102820', 'T1500128244722SR4OT', 'https://tripay.co.id/checkout/T1500128244722SR4OT', '1762594740', '2025-11-08', '1762598218', '', 'UNPAID', '34510', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (542, 'Tripay', '783174-251102820', 'DANA', '', '2190', '100105784', '251102820', 'T1500128244744I1GAL', 'https://tripay.co.id/checkout/T1500128244744I1GAL', '1762594800', '2025-11-08', '1762598278', '', 'UNPAID', '34510', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (543, 'Tripay', '32724-251102701', 'DANA', '', '2071', '100105560', '251102701', 'T1500128244770OWQQ0', 'https://tripay.co.id/checkout/T1500128244770OWQQ0', '1762594853', '2025-11-08', '1762598331', '', 'PAID', '126875', '1762595011', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (544, 'Tripay', '529984-251102820', 'INDOMARET', '', '2190', '100105784', '251102820', 'T1500128244787YXGSJ', 'https://tripay.co.id/checkout/T1500128244787YXGSJ', '1762594907', '2025-11-08', '1762681306', '', 'UNPAID', '35750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (545, 'Tripay', '625153-251102820', 'INDOMARET', '', '2190', '100105784', '251102820', 'T1500128244818BUH4L', 'https://tripay.co.id/checkout/T1500128244818BUH4L', '1762594978', '2025-11-08', '1762681378', '', 'UNPAID', '35750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (546, 'Tripay', '916813-251102820', 'DANA', '', '2190', '100105784', '251102820', 'T1500128244849SUXAK', 'https://tripay.co.id/checkout/T1500128244849SUXAK', '1762595027', '2025-11-08', '1762598505', '', 'UNPAID', '34510', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (547, 'Tripay', '214142-251101998', 'BSIVA', '', '1329', '250227082634', '251101998', 'T1500128244858NFLFL', 'https://tripay.co.id/checkout/T1500128244858NFLFL', '1762595053', '2025-11-08', '1762605726', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (548, 'Tripay', '425318-251102820', 'DANA', '', '2190', '100105784', '251102820', 'T1500128244877T1LPL', 'https://tripay.co.id/checkout/T1500128244877T1LPL', '1762595097', '2025-11-08', '1762598576', '', 'UNPAID', '34510', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (549, 'Tripay', '290726-251101998', 'BSIVA', '', '1329', '250227082634', '251101998', 'T1500128244912N8YSF', 'https://tripay.co.id/checkout/T1500128244912N8YSF', '1762595184', '2025-11-08', '1762605864', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (550, 'Tripay', '642295-251101998', 'QRIS2', '', '1329', '250227082634', '251101998', 'T1500128244930D6NZM', 'https://tripay.co.id/checkout/T1500128244930D6NZM', '1762595215', '2025-11-08', '1762597014', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (551, 'Tripay', '397064-251101998', 'QRIS2', '', '1329', '250227082634', '251101998', 'T1500128244962VIYWO', 'https://tripay.co.id/checkout/T1500128244962VIYWO', '1762595302', '2025-11-08', '1762597102', '', 'PAID', '126625', '1762595394', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (552, 'Tripay', '498904-251102089', 'DANA', '', '1429', '100104419', '251102089', 'T1500128245146EUQKE', 'https://tripay.co.id/checkout/T1500128245146EUQKE', '1762595583', '2025-11-08', '1762599062', '', 'UNPAID', '127515', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (553, 'Tripay', '198237-251102089', 'DANA', '', '1429', '100104419', '251102089', 'T1500128245189WN6FQ', 'https://tripay.co.id/checkout/T1500128245189WN6FQ', '1762595681', '2025-11-08', '1762599160', '', 'UNPAID', '127515', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (554, 'Tripay', '320766-251102089', 'DANA', '', '1429', '100104419', '251102089', 'T15001282452428BYJF', 'https://tripay.co.id/checkout/T15001282452428BYJF', '1762595798', '2025-11-08', '1762599277', '', 'UNPAID', '127515', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (555, 'Tripay', '555574-251102820', 'INDOMARET', '', '2190', '100105784', '251102820', 'T1500128245329LZK04', 'https://tripay.co.id/checkout/T1500128245329LZK04', '1762596013', '2025-11-08', '1762682412', '', 'PAID', '35750', '1762596155', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (556, 'Tripay', '845441-251102733', 'DANA', '', '2103', '100105623', '251102733', 'T15001282454162O5BM', 'https://tripay.co.id/checkout/T15001282454162O5BM', '1762596250', '2025-11-08', '1762599729', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (557, 'Tripay', '572142-251102733', 'QRIS2', '', '2103', '100105623', '251102733', 'T1500128245458AZMQD', 'https://tripay.co.id/checkout/T1500128245458AZMQD', '1762596348', '2025-11-08', '1762598148', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (558, 'Tripay', '775462-251102477', 'DANA', '', '1843', '100105151', '251102477', 'T1500128245485PVXME', 'https://tripay.co.id/checkout/T1500128245485PVXME', '1762596414', '2025-11-08', '1762599892', '', 'PAID', '126875', '1762596448', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (559, 'Tripay', '422891-251102089', 'DANA', '', '1429', '100104419', '251102089', 'T150012824553932FUT', 'https://tripay.co.id/checkout/T150012824553932FUT', '1762596544', '2025-11-08', '1762600022', '', 'PAID', '127515', '1762596577', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (560, 'Tripay', '383652-251102764', 'INDOMARET', '', '2134', '100105684', '251102764', 'T15001282455792NBHN', 'https://tripay.co.id/checkout/T15001282455792NBHN', '1762596639', '2025-11-08', '1762683039', '', 'UNPAID', '93750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (561, 'Tripay', '548192-251102764', 'INDOMARET', '', '2134', '100105684', '251102764', 'T1500128245612GZVR2', 'https://tripay.co.id/checkout/T1500128245612GZVR2', '1762596746', '2025-11-08', '1762683146', '', 'PAID', '93750', '1762600550', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (562, 'Tripay', '718745-251102459', 'QRIS2', '', '1823', '100105109', '251102459', 'T1500128245954LZLG0', 'https://tripay.co.id/checkout/T1500128245954LZLG0', '1762597535', '2025-11-08', '1762599335', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (563, 'Tripay', '412517-251102459', 'QRIS2', '', '1823', '100105109', '251102459', 'T1500128245990U2VWM', 'https://tripay.co.id/checkout/T1500128245990U2VWM', '1762597620', '2025-11-08', '1762601220', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (564, 'Tripay', '249685-251102459', 'QRIS2', '', '1823', '100105109', '251102459', 'T1500128246023LZ4VB', 'https://tripay.co.id/checkout/T1500128246023LZ4VB', '1762597677', '2025-11-08', '1762601277', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (565, 'Tripay', '478024-251102466', 'INDOMARET', '', '1832', '100105132', '251102466', 'T15001282461875OZQN', 'https://tripay.co.id/checkout/T15001282461875OZQN', '1762598087', '2025-11-08', '1762684487', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (566, 'Tripay', '277730-251102466', 'INDOMARET', '', '1832', '100105132', '251102466', 'T1500128246214A7O58', 'https://tripay.co.id/checkout/T1500128246214A7O58', '1762598160', '2025-11-08', '1762684559', '', 'PAID', '126750', '1762598585', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (567, 'Tripay', '918323-251102669', 'ALFAMART', '', '2039', '100105542', '251102669', 'T1500128246481UN4QP', 'https://tripay.co.id/checkout/T1500128246481UN4QP', '1762598754', '2025-11-08', '1762685034', '', 'PAID', '126750', '1762599107', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (568, 'Tripay', '850915-251102605', 'QRIS2', '', '1975', '100105419', '251102605', 'T1500128246773NWOGH', 'https://tripay.co.id/checkout/T1500128246773NWOGH', '1762599355', '2025-11-08', '1762601154', '', 'PAID', '126625', '1762599400', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (569, 'Tripay', '545918-251102500', 'BRIVA', '', '1866', '100105202', '251102500', 'T1500128246894B9D8Y', 'https://tripay.co.id/checkout/T1500128246894B9D8Y', '1762599642', '2025-11-08', '1762686040', '', 'PAID', '127125', '1762599718', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (570, 'Tripay', '182872-251102104', 'QRIS2', '', '1445', '100104470', '251102104', 'T1500128247066MY0WJ', 'https://tripay.co.id/checkout/T1500128247066MY0WJ', '1762600103', '2025-11-08', '1762601903', '', 'PAID', '126895', '1762600159', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (571, 'Tripay', '722190-251102503', 'QRIS2', '', '1869', '100105207', '251102503', 'T1500128247256ETT3Z', 'https://tripay.co.id/checkout/T1500128247256ETT3Z', '1762600554', '2025-11-08', '1762604154', '', 'PAID', '126625', '1762600591', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (572, 'Tripay', '238733-251102638', 'DANA', '', '2008', '100105487', '251102638', 'T1500128247345VZRWS', 'https://tripay.co.id/checkout/T1500128247345VZRWS', '1762600734', '2025-11-08', '1762604211', '', 'PAID', '126875', '1762600760', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (573, 'Tripay', '663038-251102095', 'QRIS2', '', '1435', '100104444', '251102095', 'T1500128247348T5YZP', 'https://tripay.co.id/checkout/T1500128247348T5YZP', '1762600735', '2025-11-08', '1762602535', '', 'PAID', '127476', '1762600810', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (574, 'Tripay', '434223-251102794', 'BCAVA', '', '2164', '100105741', '251102794', 'T1500128247378WAMLZ', 'https://tripay.co.id/checkout/T1500128247378WAMLZ', '1762600805', '2025-11-08', '1762687205', '', 'UNPAID', '65750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (575, 'Tripay', '97593-251102180', 'DANA', '', '1529', '100104585', '251102180', 'T1500128247558MKCHN', 'https://tripay.co.id/checkout/T1500128247558MKCHN', '1762601164', '2025-11-08', '1762604642', '', 'PAID', '126898', '1762601203', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (576, 'Tripay', '23473-251102811', 'INDOMARET', '', '2181', '100105791', '251102811', 'T1500128247564JD3NL', 'https://tripay.co.id/checkout/T1500128247564JD3NL', '1762601179', '2025-11-08', '1762687579', '', 'UNPAID', '31750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (577, 'Tripay', '338352-251102811', 'INDOMARET', '', '2181', '100105791', '251102811', 'T1500128247578OLAC4', 'https://tripay.co.id/checkout/T1500128247578OLAC4', '1762601217', '2025-11-08', '1762687616', '', 'UNPAID', '31750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (578, 'Tripay', '679087-251102331', 'ALFAMART', '', '1689', '100104846', '251102331', 'T1500128248131NOLPE', 'https://tripay.co.id/checkout/T1500128248131NOLPE', '1762602355', '2025-11-08', '1762688635', '', 'PAID', '126750', '1762602472', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (579, 'Tripay', '741888-251102655', 'BRIVA', '', '2025', '100105523', '251102655', 'T1500128248158RDOJ5', 'https://tripay.co.id/checkout/T1500128248158RDOJ5', '1762602396', '2025-11-08', '1762688789', '', 'PAID', '127125', '1762602628', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (580, 'Tripay', '696281-251102074', 'DANA', '', '1413', '100104396', '251102074', 'T1500128248536LVE9E', 'https://tripay.co.id/checkout/T1500128248536LVE9E', '1762603070', '2025-11-08', '1762606549', '', 'UNPAID', '127424', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (581, 'Tripay', '796980-251102236', 'INDOMARET', '', '1590', '100104731', '251102236', 'T1500128248733XRXHU', 'https://tripay.co.id/checkout/T1500128248733XRXHU', '1762603425', '2025-11-08', '1762689825', '', 'PAID', '126750', '1762604137', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (582, 'Tripay', '659393-251101380', 'BRIVA', '', '601', '240608143759', '251101380', 'T1500128248802PN6QY', 'https://tripay.co.id/checkout/T1500128248802PN6QY', '1762603563', '2025-11-08', '1762689963', '', 'PAID', '127342', '1762603679', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (583, 'Tripay', '336611-251102557', 'QRIS2', '', '1925', '100105327', '251102557', 'T15001282489667CH8W', 'https://tripay.co.id/checkout/T15001282489667CH8W', '1762603845', '2025-11-08', '1762605645', '', 'PAID', '126625', '1762603897', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (584, 'Tripay', '783815-251102600', 'ALFAMART', '', '1970', '100105410', '251102600', 'T1500128249254FXU0N', 'https://tripay.co.id/checkout/T1500128249254FXU0N', '1762604406', '2025-11-08', '1762690686', '', 'PAID', '126750', '1762604991', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (585, 'Tripay', '654498-251102559', 'BRIVA', '', '1927', '100105333', '251102559', 'T1500128249417SNJFG', 'https://tripay.co.id/checkout/T1500128249417SNJFG', '1762604713', '2025-11-08', '1762691112', '', 'PAID', '127125', '1762604838', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (586, 'Tripay', '674218-251101349', 'INDOMARET', '', '559', '240608143669', '251101349', 'T1500128249441HALO8', 'https://tripay.co.id/checkout/T1500128249441HALO8', '1762604776', '2025-11-08', '1762691176', '', 'PAID', '127276', '1762604825', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (587, 'Tripay', '861254-251102395', 'BCAVA', '', '1756', '100104975', '251102395', 'T1500128249567JEKCW', 'https://tripay.co.id/checkout/T1500128249567JEKCW', '1762605059', '2025-11-08', '1762691459', '', 'PAID', '127750', '1762605114', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (588, 'Tripay', '361048-251102819', 'ALFAMART', '', '2189', '100105781', '251102819', 'T15001282501629Z6PG', 'https://tripay.co.id/checkout/T15001282501629Z6PG', '1762606223', '2025-11-08', '1762692503', '', 'PAID', '35750', '1762606333', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (589, 'Tripay', '296944-251102587', 'INDOMARET', '', '1956', '100105386', '251102587', 'T1500128251885NU1JT', 'https://tripay.co.id/checkout/T1500128251885NU1JT', '1762610553', '2025-11-08', '1762696952', '', 'PAID', '126750', '1762610590', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (590, 'Tripay', '702224-251101407', 'BRIVA', '', '632', '240608143814', '251101407', 'T1500128251967U7ULD', 'https://tripay.co.id/checkout/T1500128251967U7ULD', '1762610794', '2025-11-08', '1762697187', '', 'UNPAID', '127904', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (591, 'Tripay', '633641-251101407', 'DANA', '', '632', '240608143814', '251101407', 'T1500128252070OMMLH', 'https://tripay.co.id/checkout/T1500128252070OMMLH', '1762611101', '2025-11-08', '1762614578', '', 'UNPAID', '127666', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (592, 'Tripay', '37442-251102724', 'DANA', '', '2094', '100105608', '251102724', 'T1500128252364QO9EC', 'https://tripay.co.id/checkout/T1500128252364QO9EC', '1762611853', '2025-11-08', '1762615330', '', 'PAID', '126875', '1762611919', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (593, 'Tripay', '486460-251102443', 'QRIS2', '', '1807', '100105074', '251102443', 'T1500128252401QGFQP', 'https://tripay.co.id/checkout/T1500128252401QGFQP', '1762611984', '2025-11-08', '1762613784', '', 'PAID', '126625', '1762612024', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (594, 'Tripay', '221158-251102435', 'DANA', '', '1798', '250626105950', '251102435', 'T1500128254314KYETH', 'https://tripay.co.id/checkout/T1500128254314KYETH', '1762619787', '2025-11-08', '1762623265', '', 'PAID', '126875', '1762619816', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (595, 'Tripay', '152144-251102485', 'ALFAMART', '', '1851', '100105166', '251102485', 'T1500128256955YQ4KC', 'https://tripay.co.id/checkout/T1500128256955YQ4KC', '1762645404', '2025-11-09', '1762731684', '', 'PAID', '126750', '1762645442', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (596, 'Tripay', '963044-251102699', 'SHOPEEPAY', '', '2069', '100105558', '251102699', 'T1500128256988J9D38', 'https://tripay.co.id/checkout/T1500128256988J9D38', '1762645597', '2025-11-09', '1762649077', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (597, 'Tripay', '17342-251102699', 'DANA', '', '2069', '100105558', '251102699', 'T1500128257003TPVYP', 'https://tripay.co.id/checkout/T1500128257003TPVYP', '1762645641', '2025-11-09', '1762649120', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (598, 'Tripay', '300425-251102699', 'QRIS', '', '2069', '100105558', '251102699', 'T1500128257022DND7J', 'https://tripay.co.id/checkout/T1500128257022DND7J', '1762645737', '2025-11-09', '1762647537', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (599, 'Tripay', '265244-251102699', 'SHOPEEPAY', '', '2069', '100105558', '251102699', 'T1500128257046XPOCQ', 'https://tripay.co.id/checkout/T1500128257046XPOCQ', '1762645837', '2025-11-09', '1762649317', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (600, 'Tripay', '911726-251102699', 'QRIS2', '', '2069', '100105558', '251102699', 'T1500128257059AM9NC', 'https://tripay.co.id/checkout/T1500128257059AM9NC', '1762645871', '2025-11-09', '1762647671', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (601, 'Tripay', '346096-251102699', 'QRIS', '', '2069', '100105558', '251102699', 'T1500128257129RLU8F', 'https://tripay.co.id/checkout/T1500128257129RLU8F', '1762646183', '2025-11-09', '1762647982', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (602, 'Tripay', '969822-251102699', 'DANA', '', '2069', '100105558', '251102699', 'T1500128257134GHYCA', 'https://tripay.co.id/checkout/T1500128257134GHYCA', '1762646222', '2025-11-09', '1762649702', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (603, 'Tripay', '275434-251102699', 'INDOMARET', '', '2069', '100105558', '251102699', 'T1500128257695WGAZJ', 'https://tripay.co.id/checkout/T1500128257695WGAZJ', '1762648509', '2025-11-09', '1762734909', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (604, 'Tripay', '415434-251101420', 'BCAVA', '', '648', '240608143844', '251101420', 'T1500128257985I3BFN', 'https://tripay.co.id/checkout/T1500128257985I3BFN', '1762649394', '2025-11-09', '1762735793', '', 'UNPAID', '128743', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (605, 'Tripay', '891566-251101949', 'BRIVA', '', '1271', '250215134916', '251101949', 'T1500128258001O8QCW', 'https://tripay.co.id/checkout/T1500128258001O8QCW', '1762649437', '2025-11-09', '1762735830', '', 'PAID', '127125', '1762649499', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (606, 'Tripay', '116248-251101420', 'QRIS2', '', '648', '240608143844', '251101420', 'T1500128258036J5KCT', 'https://tripay.co.id/checkout/T1500128258036J5KCT', '1762649522', '2025-11-09', '1762651322', '', 'PAID', '127625', '1762649579', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (607, 'Tripay', '510276-251102635', 'BNIVA', '', '2005', '100105480', '251102635', 'T15001282585529S3W5', 'https://tripay.co.id/checkout/T15001282585529S3W5', '1762651320', '2025-11-09', '1762737593', '', 'PAID', '129250', '1762651396', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (608, 'Tripay', '363878-251102726', 'BRIVA', '', '2096', '100105615', '251102726', 'T1500128260543U1YUO', 'https://tripay.co.id/checkout/T1500128260543U1YUO', '1762656656', '2025-11-09', '1762743049', '', 'PAID', '127125', '1762656813', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (609, 'Tripay', '819421-251102781', 'BCAVA', '', '2151', '100105713', '251102781', 'T1500128260758MJVLZ', 'https://tripay.co.id/checkout/T1500128260758MJVLZ', '1762657197', '2025-11-09', '1762743596', '', 'PAID', '82750', '1762657268', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (610, 'Tripay', '646298-251102006', 'QRIS2', '', '1338', '250227110656', '251102006', 'T1500128260950D4WTU', 'https://tripay.co.id/checkout/T1500128260950D4WTU', '1762657643', '2025-11-09', '1762659443', '', 'PAID', '126625', '1762657690', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (611, 'Tripay', '480935-251101941', 'BNIVA', '', '1263', '250215100151', '251101941', 'T15001282611547FR7Y', 'https://tripay.co.id/checkout/T15001282611547FR7Y', '1762658063', '2025-11-09', '1762744343', '', 'PAID', '129250', '1762658113', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (612, 'Tripay', '866154-251101743', 'BRIVA', '', '1040', '241219074935', '251101743', 'T1500128261421GYBAV', 'https://tripay.co.id/checkout/T1500128261421GYBAV', '1762658774', '2025-11-09', '1762745167', '', 'PAID', '117125', '1762658855', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (613, 'Tripay', '514890-251101745', 'QRIS2', '', '1043', '241223085142', '251101745', 'T1500128261476M3ICV', 'https://tripay.co.id/checkout/T1500128261476M3ICV', '1762658943', '2025-11-09', '1762660743', '', 'PAID', '116555', '1762658978', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (614, 'Tripay', '984952-251101799', 'INDOMARET', '', '1104', '250116085647', '251101799', 'T1500128261490R8ZYF', 'https://tripay.co.id/checkout/T1500128261490R8ZYF', '1762659013', '2025-11-09', '1762745413', '', 'PAID', '126750', '1762674820', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (615, 'Tripay', '353025-251102811', 'INDOMARET', '', '2181', '100105791', '251102811', 'T150012826165221J8T', 'https://tripay.co.id/checkout/T150012826165221J8T', '1762659511', '2025-11-09', '1762745911', '', 'UNPAID', '31750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (616, 'Tripay', '955080-251101948', 'BCAVA', '', '1270', '250215113745', '251101948', 'T150012826174846CF6', 'https://tripay.co.id/checkout/T150012826174846CF6', '1762659798', '2025-11-09', '1762746197', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (617, 'Tripay', '433676-251102706', 'BCAVA', '', '2076', '100105570', '251102706', 'T1500128261911WRRTH', 'https://tripay.co.id/checkout/T1500128261911WRRTH', '1762660239', '2025-11-09', '1762746639', '', 'PAID', '127750', '1762660338', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (618, 'Tripay', '543498-251102666', 'BCAVA', '', '2036', '100105538', '251102666', 'T1500128261941FQOFB', 'https://tripay.co.id/checkout/T1500128261941FQOFB', '1762660303', '2025-11-09', '1762746703', '', 'PAID', '127750', '1762660388', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (619, 'Tripay', '708093-251101933', 'INDOMARET', '', '1253', '250215083753', '251101933', 'T1500128262015J60LL', 'https://tripay.co.id/checkout/T1500128262015J60LL', '1762660525', '2025-11-09', '1762746924', '', 'PAID', '126750', '1762660565', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (620, 'Tripay', '426372-251102486', 'SHOPEEPAY', '', '1852', '100105169', '251102486', 'T1500128262141SAZAP', 'https://tripay.co.id/checkout/T1500128262141SAZAP', '1762660903', '2025-11-09', '1762664383', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (621, 'Tripay', '143182-251102486', 'DANA', '', '1852', '100105169', '251102486', 'T15001282621585ZN3B', 'https://tripay.co.id/checkout/T15001282621585ZN3B', '1762660936', '2025-11-09', '1762664415', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (622, 'Tripay', '941923-251102486', 'OVO', '', '1852', '100105169', '251102486', 'T1500128262176TWMF7', 'https://tripay.co.id/checkout/T1500128262176TWMF7', '1762660965', '2025-11-09', '1762747365', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (623, 'Tripay', '81316-251102544', 'BCAVA', '', '1912', '100105294', '251102544', 'T1500128262228Z24KV', 'https://tripay.co.id/checkout/T1500128262228Z24KV', '1762661103', '2025-11-09', '1762747503', '', 'PAID', '127750', '1762661215', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (624, 'Tripay', '550367-251102486', 'DANA', '', '1852', '100105169', '251102486', 'T1500128262240LZRN7', 'https://tripay.co.id/checkout/T1500128262240LZRN7', '1762661127', '2025-11-09', '1762664606', '', 'PAID', '126875', '1762661148', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (625, 'Tripay', '228197-251102252', 'DANA', '', '1606', '100104762', '251102252', 'T1500128262352XBFJU', 'https://tripay.co.id/checkout/T1500128262352XBFJU', '1762661463', '2025-11-09', '1762664942', '', 'PAID', '126875', '1762661495', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (626, 'Tripay', '175193-251102116', 'QRIS2', '', '1457', '100104495', '251102116', 'T1500128262377SD06B', 'https://tripay.co.id/checkout/T1500128262377SD06B', '1762661546', '2025-11-09', '1762663346', '', 'UNPAID', '126788', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (627, 'Tripay', '129007-251102122', 'DANA', '', '1463', '100104505', '251102122', 'T1500128262430BCBA4', 'https://tripay.co.id/checkout/T1500128262430BCBA4', '1762661701', '2025-11-09', '1762665181', '', 'UNPAID', '127841', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (628, 'Tripay', '797070-251102289', 'BCAVA', '', '1643', '250515152315', '251102289', 'T1500128262484IPE1J', 'https://tripay.co.id/checkout/T1500128262484IPE1J', '1762662183', '2025-11-09', '1762748583', '', 'PAID', '127750', '1762662275', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (629, 'Tripay', '878427-251101946', 'BNIVA', '', '1268', '250215103457', '251101946', 'T15001282625013PZS0', 'https://tripay.co.id/checkout/T15001282625013PZS0', '1762662197', '2025-11-09', '1762748470', '', 'PAID', '129250', '1762662255', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (630, 'Tripay', '151733-251101958', 'MANDIRIVA', '', '1280', '250215142943', '251101958', 'T1500128262505D2HNV', 'https://tripay.co.id/checkout/T1500128262505D2HNV', '1762662199', '2025-11-09', '1762748599', '', 'PAID', '127125', '1762662361', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (631, 'Tripay', '52922-251102335', 'MANDIRIVA', '', '1694', '100104852', '251102335', 'T1500128262641T1ITJ', 'https://tripay.co.id/checkout/T1500128262641T1ITJ', '1762662432', '2025-11-09', '1762748832', '', 'PAID', '127125', '1762662554', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (632, 'Tripay', '960367-251102776', 'BCAVA', '', '2146', '100105704', '251102776', 'T1500128262882O3RUK', 'https://tripay.co.id/checkout/T1500128262882O3RUK', '1762663055', '2025-11-09', '1762749455', '', 'PAID', '86750', '1762663150', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (633, 'Tripay', '340774-251101754', 'BCAVA', '', '1056', '100103826', '251101754', 'T1500128262980TWZPJ', 'https://tripay.co.id/checkout/T1500128262980TWZPJ', '1762663335', '2025-11-09', '1762749735', '', 'PAID', '127750', '1762663473', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (634, 'Tripay', '922571-251101886', 'QRIS2', '', '1203', '100104045', '251101886', 'T15001282630108GEEY', 'https://tripay.co.id/checkout/T15001282630108GEEY', '1762663418', '2025-11-09', '1762667017', '', 'PAID', '126625', '1762663453', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (635, 'Tripay', '352807-251101628', 'BRIVA', '', '895', '100103547', '251101628', 'T1500128263248GC4O4', 'https://tripay.co.id/checkout/T1500128263248GC4O4', '1762664031', '2025-11-09', '1762750424', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (636, 'Tripay', '363915-251102277', 'ALFAMART', '', '1631', '100104803', '251102277', 'T1500128263252KLHII', 'https://tripay.co.id/checkout/T1500128263252KLHII', '1762664038', '2025-11-09', '1762750317', '', 'PAID', '126750', '1762664285', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (637, 'Tripay', '524119-251101767', 'QRIS2', '', '1069', '100103842', '251101767', 'T1500128263253R4GJP', 'https://tripay.co.id/checkout/T1500128263253R4GJP', '1762664040', '2025-11-09', '1762665840', '', 'PAID', '116555', '1762664065', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (638, 'Tripay', '305827-251101407', 'BRIVA', '', '632', '240608143814', '251101407', 'T1500128263301K6S1S', 'https://tripay.co.id/checkout/T1500128263301K6S1S', '1762664166', '2025-11-09', '1762750565', '', 'UNPAID', '127904', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (639, 'Tripay', '590323-251101579', 'INDOMARET', '', '841', '100103451', '251101579', 'T1500128263409ZXVUU', 'https://tripay.co.id/checkout/T1500128263409ZXVUU', '1762664462', '2025-11-09', '1762750862', '', 'PAID', '126750', '1762736521', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (640, 'Tripay', '195132-251101194', 'QRIS2', '', '332', '230617125127', '251101194', 'T1500128263685XAKUQ', 'https://tripay.co.id/checkout/T1500128263685XAKUQ', '1762664960', '2025-11-09', '1762666760', '', 'PAID', '126849', '1762665036', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (641, 'Tripay', '18567-251101760', 'DANA', '', '1062', '241226130025', '251101760', 'T1500128263867QBDTB', 'https://tripay.co.id/checkout/T1500128263867QBDTB', '1762665321', '2025-11-09', '1762668800', '', 'PAID', '126875', '1762665339', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (642, 'Tripay', '34805-251101634', 'DANA', '', '903', '241114142538', '251101634', 'T1500128263922VYT17', 'https://tripay.co.id/checkout/T1500128263922VYT17', '1762665435', '2025-11-09', '1762668914', '', 'PAID', '126875', '1762665457', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (643, 'Tripay', '448741-251102300', 'BRIVA', '', '1657', '250522110331', '251102300', 'T1500128263947IK65H', 'https://tripay.co.id/checkout/T1500128263947IK65H', '1762665523', '2025-11-09', '1762751922', '', 'PAID', '127125', '1762666024', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (644, 'Tripay', '613410-251101215', 'BCAVA', '', '362', '230630155891', '251101215', 'T1500128263959IPS34', 'https://tripay.co.id/checkout/T1500128263959IPS34', '1762665570', '2025-11-09', '1762751970', '', 'UNPAID', '128055', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (645, 'Tripay', '1113-251101145', 'MANDIRIVA', '', '244', '221201082308', '251101145', 'T1500128264142W7C8N', 'https://tripay.co.id/checkout/T1500128264142W7C8N', '1762666004', '2025-11-09', '1762752398', '', 'UNPAID', '127507', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (646, 'Tripay', '336922-251101145', 'QRIS2', '', '244', '221201082308', '251101145', 'T15001282642237Q2FG', 'https://tripay.co.id/checkout/T15001282642237Q2FG', '1762666161', '2025-11-09', '1762667961', '', 'PAID', '127010', '1762666199', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (647, 'Tripay', '439514-251102122', 'DANA', '', '1463', '100104505', '251102122', 'T1500128264308RX1VV', 'https://tripay.co.id/checkout/T1500128264308RX1VV', '1762666408', '2025-11-09', '1762669888', '', 'PAID', '127841', '1762666433', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (648, 'Tripay', '716388-251101215', 'DANA', '', '362', '230630155891', '251101215', 'T1500128264341DIX78', 'https://tripay.co.id/checkout/T1500128264341DIX78', '1762666519', '2025-11-09', '1762669998', '', 'PAID', '127185', '1762666704', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (649, 'Tripay', '557510-251101769', 'MANDIRIVA', '', '1071', '241226140257', '251101769', 'T1500128264532TIN72', 'https://tripay.co.id/checkout/T1500128264532TIN72', '1762667054', '2025-11-09', '1762753447', '', 'UNPAID', '117125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (650, 'Tripay', '424015-251102560', 'DANA', '', '1928', '100105334', '251102560', 'T1500128264749HIQVC', 'https://tripay.co.id/checkout/T1500128264749HIQVC', '1762667590', '2025-11-09', '1762671069', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (651, 'Tripay', '316659-251102350', 'BCAVA', '', '1709', '100104886', '251102350', 'T1500128264756MWUSI', 'https://tripay.co.id/checkout/T1500128264756MWUSI', '1762667626', '2025-11-09', '1762754025', '', 'PAID', '127750', '1762667707', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (652, 'Tripay', '34745-251101669', 'BNIVA', '', '949', '100103608', '251101669', 'T1500128264774CGKIM', 'https://tripay.co.id/checkout/T1500128264774CGKIM', '1762667661', '2025-11-09', '1762753934', '', 'PAID', '129250', '1762667716', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (653, 'Tripay', '54386-251102560', 'DANA', '', '1928', '100105334', '251102560', 'T1500128264799YCE1P', 'https://tripay.co.id/checkout/T1500128264799YCE1P', '1762667717', '2025-11-09', '1762671196', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (654, 'Tripay', '19734-251102396', 'QRIS2', '', '1757', '100104980', '251102396', 'T1500128265075XHDYW', 'https://tripay.co.id/checkout/T1500128265075XHDYW', '1762668632', '2025-11-09', '1762670431', '', 'PAID', '126625', '1762668691', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (655, 'Tripay', '46504-251101676', 'SHOPEEPAY', '', '956', '100103619', '251101676', 'T1500128265313HEH11', 'https://tripay.co.id/checkout/T1500128265313HEH11', '1762669175', '2025-11-09', '1762672655', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (656, 'Tripay', '320604-251101676', 'BRIVA', '', '956', '100103619', '251101676', 'T150012826533244VHC', 'https://tripay.co.id/checkout/T150012826533244VHC', '1762669228', '2025-11-09', '1762755620', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (657, 'Tripay', '284211-251101676', 'QRIS2', '', '956', '100103619', '251101676', 'T1500128265340UXRI5', 'https://tripay.co.id/checkout/T1500128265340UXRI5', '1762669254', '2025-11-09', '1762671053', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (658, 'Tripay', '285442-251101676', 'QRIS', '', '956', '100103619', '251101676', 'T1500128265357CQIVQ', 'https://tripay.co.id/checkout/T1500128265357CQIVQ', '1762669308', '2025-11-09', '1762671108', '', 'PAID', '125812', '1762669400', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (659, 'Tripay', '16460-251102560', 'DANA', '', '1928', '100105334', '251102560', 'T1500128265401DOZLV', 'https://tripay.co.id/checkout/T1500128265401DOZLV', '1762669456', '2025-11-09', '1762672935', '', 'PAID', '126875', '1762669592', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (660, 'Tripay', '311029-251102001', 'BNIVA', '', '1333', '250227100825', '251102001', 'T150012826546899RX3', 'https://tripay.co.id/checkout/T150012826546899RX3', '1762669647', '2025-11-09', '1762755926', '', 'UNPAID', '129250', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (661, 'Tripay', '999971-251102001', 'BNIVA', '', '1333', '250227100825', '251102001', 'T1500128265476WNEGR', 'https://tripay.co.id/checkout/T1500128265476WNEGR', '1762669685', '2025-11-09', '1762755965', '', 'PAID', '129250', '1762669750', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (662, 'Tripay', '290564-251101865', 'DANA', '', '1179', '250121093001', '251101865', 'T1500128265526T7RFD', 'https://tripay.co.id/checkout/T1500128265526T7RFD', '1762669810', '2025-11-09', '1762673289', '', 'PAID', '126875', '1762669828', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (663, 'Tripay', '950791-251102578', 'MANDIRIVA', '', '1946', '100105369', '251102578', 'T1500128265795MPGJ9', 'https://tripay.co.id/checkout/T1500128265795MPGJ9', '1762670793', '2025-11-09', '1762757185', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (664, 'Tripay', '678251-251102720', 'DANA', '', '2090', '100105602', '251102720', 'T1500128266277T0SAU', 'https://tripay.co.id/checkout/T1500128266277T0SAU', '1762672182', '2025-11-09', '1762675661', '', 'PAID', '126875', '1762672204', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (665, 'Tripay', '767188-251101198', 'QRIS2', '', '339', '230630155757', '251101198', 'T1500128266293DPBU7', 'https://tripay.co.id/checkout/T1500128266293DPBU7', '1762672234', '2025-11-09', '1762674034', '', 'PAID', '126841', '1762672283', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (666, 'Tripay', '279749-251101061', 'DANA', '', '94', '220825084420', '251101061', 'T1500128266342UOPUT', 'https://tripay.co.id/checkout/T1500128266342UOPUT', '1762672391', '2025-11-09', '1762675870', '', 'PAID', '127744', '1762672483', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (667, 'Tripay', '192004-251101450', 'ALFAMART', '', '688', '100103154', '251101450', 'T1500128266380FJMAL', 'https://tripay.co.id/checkout/T1500128266380FJMAL', '1762672495', '2025-11-09', '1762758775', '', 'PAID', '126750', '1762672811', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (668, 'Tripay', '916027-251101407', 'DANA', '', '632', '240608143814', '251101407', 'T1500128266891DZR7L', 'https://tripay.co.id/checkout/T1500128266891DZR7L', '1762674084', '2025-11-09', '1762677563', '', 'PAID', '127666', '1762674101', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (669, 'Tripay', '270473-251101996', 'BCAVA', '', '1327', '250227075654', '251101996', 'T1500128267981UOHFY', 'https://tripay.co.id/checkout/T1500128267981UOHFY', '1762676857', '2025-11-09', '1762763257', '', 'PAID', '127750', '1762676948', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (670, 'Tripay', '826960-251102015', 'DANA', '', '1350', '100104455', '251102015', 'T15001282683606HQRI', 'https://tripay.co.id/checkout/T15001282683606HQRI', '1762677702', '2025-11-09', '1762681182', '', 'PAID', '127669', '1762677907', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (671, 'Tripay', '915213-251101910', 'BNIVA', '', '1229', '250214080924', '251101910', 'T1500128268897A9QNL', 'https://tripay.co.id/checkout/T1500128268897A9QNL', '1762679016', '2025-11-09', '1762765296', '', 'PAID', '129250', '1762679072', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (672, 'Tripay', '897431-251102784', 'MANDIRIVA', '', '2154', '100105717', '251102784', 'T1500128269175RR6BS', 'https://tripay.co.id/checkout/T1500128269175RR6BS', '1762679697', '2025-11-09', '1762766090', '', 'UNPAID', '82125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (673, 'Tripay', '881600-251102784', 'MANDIRIVA', '', '2154', '100105717', '251102784', 'T1500128269226SUMYZ', 'https://tripay.co.id/checkout/T1500128269226SUMYZ', '1762679856', '2025-11-09', '1762766256', '', 'UNPAID', '82125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (674, 'Tripay', '871108-251102013', 'SHOPEEPAY', '', '1348', '100104285', '251102013', 'T1500128269266LT9JW', 'https://tripay.co.id/checkout/T1500128269266LT9JW', '1762679964', '2025-11-09', '1762683444', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (675, 'Tripay', '561514-251102013', 'SHOPEEPAY', '', '1348', '100104285', '251102013', 'T1500128269298CXEDG', 'https://tripay.co.id/checkout/T1500128269298CXEDG', '1762680053', '2025-11-09', '1762683533', '', 'PAID', '128750', '1762680092', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (676, 'Tripay', '941406-251102784', 'MANDIRIVA', '', '2154', '100105717', '251102784', 'T1500128269366WY03F', 'https://tripay.co.id/checkout/T1500128269366WY03F', '1762680212', '2025-11-09', '1762766611', '', 'UNPAID', '82125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (677, 'Tripay', '413971-251101833', 'INDOMARET', '', '1143', '250118133431', '251101833', 'T1500128269873PMM16', 'https://tripay.co.id/checkout/T1500128269873PMM16', '1762681341', '2025-11-09', '1762767740', '', 'PAID', '126750', '1762681768', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (678, 'Tripay', '246535-251101470', 'DANA', '', '713', '100103191', '251101470', 'T1500128270316HAL1B', 'https://tripay.co.id/checkout/T1500128270316HAL1B', '1762682299', '2025-11-09', '1762685779', '', 'PAID', '126875', '1762682353', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (679, 'Tripay', '698826-251101208', 'QRIS2', '', '353', '230630155833', '251101208', 'T1500128270338DZSSG', 'https://tripay.co.id/checkout/T1500128270338DZSSG', '1762682345', '2025-11-09', '1762684144', '', 'PAID', '127406', '1762682378', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (680, 'Tripay', '475184-251101970', 'SHOPEEPAY', '', '1294', '250225155415', '251101970', 'T1500128270474NFMOS', 'https://tripay.co.id/checkout/T1500128270474NFMOS', '1762682647', '2025-11-09', '1762686126', '', 'PAID', '128750', '1762682671', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (681, 'Tripay', '569784-251102320', 'DANA', '', '1677', '250527100657', '251102320', 'T1500128270631JZVQZ', 'https://tripay.co.id/checkout/T1500128270631JZVQZ', '1762682972', '2025-11-09', '1762686451', '', 'PAID', '126875', '1762683039', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (682, 'Tripay', '561008-251102212', 'ALFAMART', '', '1562', '100104640', '251102212', 'T1500128271622RVZ61', 'https://tripay.co.id/checkout/T1500128271622RVZ61', '1762684998', '2025-11-09', '1762771278', '', 'PAID', '127391', '1762685033', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (683, 'Tripay', '883013-251101948', 'BCAVA', '', '1270', '250215113745', '251101948', 'T1500128271818JELIS', 'https://tripay.co.id/checkout/T1500128271818JELIS', '1762685333', '2025-11-09', '1762771732', '', 'PAID', '127750', '1762685449', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (684, 'Tripay', '393153-251101207', 'BRIVA', '', '352', '230630155827', '251101207', 'T1500128271920ZSADH', 'https://tripay.co.id/checkout/T1500128271920ZSADH', '1762685541', '2025-11-09', '1762771941', '', 'PAID', '127282', '1762685601', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (685, 'Tripay', '791387-251102811', 'INDOMARET', '', '2181', '100105791', '251102811', 'T1500128272670Q7DBO', 'https://tripay.co.id/checkout/T1500128272670Q7DBO', '1762687045', '2025-11-09', '1762773440', '', 'PAID', '31750', '1762687316', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (686, 'Tripay', '980218-251101114', 'INDOMARET', '', '192', '220826114833', '251101114', 'T1500128273388NBRFW', 'https://tripay.co.id/checkout/T1500128273388NBRFW', '1762688302', '2025-11-09', '1762774702', '', 'PAID', '112553', '1762688334', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (687, 'Tripay', '75125-251101465', 'BNIVA', '', '706', '100103183', '251101465', 'T15001282738976IZEL', 'https://tripay.co.id/checkout/T15001282738976IZEL', '1762689181', '2025-11-09', '1762775454', '', 'PAID', '129250', '1762689239', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (688, 'Tripay', '146941-251102053', 'ALFAMART', '', '1391', '100104352', '251102053', 'T1500128273900OEJZ9', 'https://tripay.co.id/checkout/T1500128273900OEJZ9', '1762689185', '2025-11-09', '1762775465', '', 'PAID', '126977', '1762691155', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (689, 'Tripay', '156104-251102681', 'INDOMARET', '', '2051', '10010566', '251102681', 'T1500128274017OIHBN', 'https://tripay.co.id/checkout/T1500128274017OIHBN', '1762689425', '2025-11-09', '1762775825', '', 'PAID', '126750', '1762693917', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (690, 'Tripay', '376503-251101459', 'INDOMARET', '', '700', '100103173', '251101459', 'T1500128274688YKBH9', 'https://tripay.co.id/checkout/T1500128274688YKBH9', '1762690636', '2025-11-09', '1762777035', '', 'PAID', '126750', '1762690700', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (691, 'Tripay', '853372-251101727', 'ALFAMART', '', '1020', '241214091454', '251101727', 'T1500128275519OVBI5', 'https://tripay.co.id/checkout/T1500128275519OVBI5', '1762692210', '2025-11-09', '1762778490', '', 'PAID', '126750', '1762692263', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (692, 'Tripay', '305787-251102520', 'DANA', '', '1887', '100105240', '251102520', 'T1500128276373NGTJF', 'https://tripay.co.id/checkout/T1500128276373NGTJF', '1762693787', '2025-11-09', '1762697266', '', 'PAID', '126875', '1762693823', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (693, 'Tripay', '769366-251102790', 'BCAVA', '', '2160', '100105725', '251102790', 'T1500128277087PJIIZ', 'https://tripay.co.id/checkout/T1500128277087PJIIZ', '1762695208', '2025-11-09', '1762781608', '', 'PAID', '73750', '1762695419', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (694, 'Tripay', '497605-251102670', 'INDOMARET', '', '2040', '100105545', '251102670', 'T1500128277772RLAV4', 'https://tripay.co.id/checkout/T1500128277772RLAV4', '1762696804', '2025-11-09', '1762783203', '', 'PAID', '126750', '1762697503', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (695, 'Tripay', '468667-251102121', 'QRIS2', '', '1462', '100104503', '251102121', 'T1500128277899VPPLN', 'https://tripay.co.id/checkout/T1500128277899VPPLN', '1762697116', '2025-11-09', '1762698916', '', 'PAID', '126781', '1762697235', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (696, 'Tripay', '421425-251102411', 'ALFAMART', '', '1774', '100105016', '251102411', 'T1500128278720JID9Y', 'https://tripay.co.id/checkout/T1500128278720JID9Y', '1762699251', '2025-11-09', '1762785531', '', 'PAID', '126750', '1762699277', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (697, 'Tripay', '19129-251102421', 'BCAVA', '', '1784', '100105037', '251102421', 'T1500128282428NEX2H', 'https://tripay.co.id/checkout/T1500128282428NEX2H', '1762724467', '2025-11-10', '1762810866', '', 'PAID', '127750', '1762724603', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (698, 'Tripay', '318160-251102633', 'DANA', '', '2003', '100105472', '251102633', 'T1500128282546LPJGW', 'https://tripay.co.id/checkout/T1500128282546LPJGW', '1762725350', '2025-11-10', '1762728829', '', 'PAID', '126875', '1762725367', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (699, 'Tripay', '139352-251101227', 'QRIS2', '', '379', '230630156051', '251101227', 'T1500128284539X5CYS', 'https://tripay.co.id/checkout/T1500128284539X5CYS', '1762733814', '2025-11-10', '1762735614', '', 'PAID', '126811', '1762734036', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (700, 'Tripay', '342883-251101496', 'BRIVA', '', '745', '100103251', '251101496', 'T1500128284847BVVGJ', 'https://tripay.co.id/checkout/T1500128284847BVVGJ', '1762734659', '2025-11-10', '1762821059', '', 'PAID', '127125', '1762734744', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (701, 'Tripay', '779963-251101427', 'INDOMARET', '', '658', '100103092', '251101427', 'T1500128285245EHMLQ', 'https://tripay.co.id/checkout/T1500128285245EHMLQ', '1762735526', '2025-11-10', '1762821926', '', 'PAID', '126750', '1762737129', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (702, 'Tripay', '21985-251102247', 'DANA', '', '1601', '100104755', '251102247', 'T1500128285327HNKOR', 'https://tripay.co.id/checkout/T1500128285327HNKOR', '1762735753', '2025-11-10', '1762739232', '', 'PAID', '126875', '1762735811', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (703, 'Tripay', '273790-251102828', 'BCAVA', '', '2199', '191100001', '251102828', 'T1500128285964SCU7M', 'https://tripay.co.id/checkout/T1500128285964SCU7M', '1762737090', '2025-11-10', '1762823490', '', 'PAID', '32750', '1762739198', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (704, 'Tripay', '585489-251101001', 'BRIVA', '', '1', '220821222607', '251101001', 'T1500128286006PGBQQ', 'https://tripay.co.id/checkout/T1500128286006PGBQQ', '1762737162', '2025-11-10', '1762823554', '', 'PAID', '127267', '1762737269', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (705, 'Tripay', '961304-251102562', 'BCAVA', '', '1930', '100105336', '251102562', 'T1500128286181OI3BF', 'https://tripay.co.id/checkout/T1500128286181OI3BF', '1762737547', '2025-11-10', '1762823947', '', 'PAID', '127750', '1762737635', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (706, 'Tripay', '218378-251101336', 'INDOMARET', '', '541', '240517132224', '251101336', 'T1500128286533RJOWP', 'https://tripay.co.id/checkout/T1500128286533RJOWP', '1762738257', '2025-11-10', '1762824657', '', 'PAID', '126927', '1762739637', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (707, 'Tripay', '59056-251101238', 'BRIVA', '', '395', '231020102452', '251101238', 'T1500128286599VVB98', 'https://tripay.co.id/checkout/T1500128286599VVB98', '1762738402', '2025-11-10', '1762824801', '', 'PAID', '128063', '1762738464', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (708, 'Tripay', '107897-251102310', 'INDOMARET', '', '1667', '250524141105', '251102310', 'T1500128286794EDZ5E', 'https://tripay.co.id/checkout/T1500128286794EDZ5E', '1762738783', '2025-11-10', '1762825182', '', 'PAID', '126750', '1762738820', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (709, 'Tripay', '309470-251101533', 'INDOMARET', '', '790', '100103326', '251101533', 'T1500128287106OXUJY', 'https://tripay.co.id/checkout/T1500128287106OXUJY', '1762739053', '2025-11-10', '1762825453', '', 'PAID', '126750', '1762739832', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (710, 'Tripay', '379256-251102709', 'BRIVA', '', '2079', '100105573', '251102709', 'T1500128287190VORR0', 'https://tripay.co.id/checkout/T1500128287190VORR0', '1762739189', '2025-11-10', '1762825588', '', 'PAID', '127125', '1762739277', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (711, 'Tripay', '293976-251101673', 'INDOMARET', '', '953', '100103615', '251101673', 'T1500128287249MYNOX', 'https://tripay.co.id/checkout/T1500128287249MYNOX', '1762739268', '2025-11-10', '1762825668', '', 'PAID', '126750', '1762740872', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (712, 'Tripay', '383154-251101378', 'ALFAMART', '', '599', '240608143757', '251101378', 'T1500128287256JZCX4', 'https://tripay.co.id/checkout/T1500128287256JZCX4', '1762739274', '2025-11-10', '1762825554', '', 'PAID', '127460', '1762739622', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (713, 'Tripay', '3194-251101018', 'BRIVA', '', '27', '220822160653', '251101018', 'T150012828763074JH4', 'https://tripay.co.id/checkout/T150012828763074JH4', '1762739867', '2025-11-10', '1762826259', '', 'PAID', '127661', '1762739974', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (714, 'Tripay', '404678-251101245', 'SHOPEEPAY', '', '405', '231114143743', '251101245', 'T1500128288350KQMN9', 'https://tripay.co.id/checkout/T1500128288350KQMN9', '1762740498', '2025-11-10', '1762743977', '', 'UNPAID', '128916', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (715, 'Tripay', '486625-251101245', 'QRIS', '', '405', '231114143743', '251101245', 'T1500128288485TRVNP', 'https://tripay.co.id/checkout/T1500128288485TRVNP', '1762740746', '2025-11-10', '1762742546', '', 'PAID', '125974', '1762741127', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (716, 'Tripay', '761281-251102510', 'INDOMARET', '', '1877', '100105220', '251102510', 'T1500128288662OHKXR', 'https://tripay.co.id/checkout/T1500128288662OHKXR', '1762740958', '2025-11-10', '1762827358', '', 'PAID', '126750', '1762741185', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (717, 'Tripay', '213690-251101805', 'BRIVA', '', '1112', '250116151123', '251101805', 'T1500128289002KRVQA', 'https://tripay.co.id/checkout/T1500128289002KRVQA', '1762741515', '2025-11-10', '1762827914', '', 'PAID', '127125', '1762741689', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (718, 'Tripay', '552524-251101862', 'DANA', '', '1176', '250121091920', '251101862', 'T15001282896354LONZ', 'https://tripay.co.id/checkout/T15001282896354LONZ', '1762742601', '2025-11-10', '1762746080', '', 'PAID', '126875', '1762742662', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (719, 'Tripay', '927232-251102069', 'BRIVA', '', '1408', '100104390', '251102069', 'T1500128290487R0IPU', 'https://tripay.co.id/checkout/T1500128290487R0IPU', '1762743635', '2025-11-10', '1762830034', '', 'PAID', '127870', '1762743746', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (720, 'Tripay', '548355-251102116', 'QRIS2', '', '1457', '100104495', '251102116', 'T1500128291245PSFTH', 'https://tripay.co.id/checkout/T1500128291245PSFTH', '1762744953', '2025-11-10', '1762746752', '', 'PAID', '126788', '1762745003', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (721, 'Tripay', '151447-251102528', 'INDOMARET', '', '1895', '100105257', '251102528', 'T1500128291840T7ALH', 'https://tripay.co.id/checkout/T1500128291840T7ALH', '1762745929', '2025-11-10', '1762832329', '', 'PAID', '126750', '1762746059', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (722, 'Tripay', '60522-251101791', 'INDOMARET', '', '1095', '250114092623', '251101791', 'T1500128292555ZNLWJ', 'https://tripay.co.id/checkout/T1500128292555ZNLWJ', '1762747091', '2025-11-10', '1762833490', '', 'PAID', '126750', '1762747857', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (723, 'Tripay', '166765-251102143', 'DANA', '', '1485', '250411144656', '251102143', 'T1500128293042BS1HR', 'https://tripay.co.id/checkout/T1500128293042BS1HR', '1762747953', '2025-11-10', '1762751432', '', 'PAID', '127442', '1762748024', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (724, 'Tripay', '498736-251101221', 'BCAVA', '', '371', '230630155944', '251101221', 'T15001282931251KTDC', 'https://tripay.co.id/checkout/T15001282931251KTDC', '1762748103', '2025-11-10', '1762834502', '', 'UNPAID', '128153', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (725, 'Tripay', '435197-251101221', 'SHOPEEPAY', '', '371', '230630155944', '251101221', 'T150012829315921BKE', 'https://tripay.co.id/checkout/T150012829315921BKE', '1762748170', '2025-11-10', '1762751649', '', 'UNPAID', '129166', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (726, 'Tripay', '515037-251101221', 'BCAVA', '', '371', '230630155944', '251101221', 'T1500128293169ZTJCT', 'https://tripay.co.id/checkout/T1500128293169ZTJCT', '1762748185', '2025-11-10', '1762834584', '', 'PAID', '128153', '1762748228', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (727, 'Tripay', '658604-251101849', 'BCAVA', '', '1163', '250120074907', '251101849', 'T15001282943797ZLTC', 'https://tripay.co.id/checkout/T15001282943797ZLTC', '1762749981', '2025-11-10', '1762836380', '', 'PAID', '127750', '1762769989', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (728, 'Tripay', '884651-251101214', 'BNIVA', '', '360', '230630155869', '251101214', 'T1500128295152HIDRK', 'https://tripay.co.id/checkout/T1500128295152HIDRK', '1762751397', '2025-11-10', '1762837669', '', 'UNPAID', '129850', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (729, 'Tripay', '236794-251101214', 'QRIS2', '', '360', '230630155869', '251101214', 'T15001282951762TRNL', 'https://tripay.co.id/checkout/T15001282951762TRNL', '1762751427', '2025-11-10', '1762753227', '', 'PAID', '127230', '1762751468', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (730, 'Tripay', '519232-251102103', 'INDOMARET', '', '1444', '100104468', '251102103', 'T15001282958266E96U', 'https://tripay.co.id/checkout/T15001282958266E96U', '1762752698', '2025-11-10', '1762839098', '', 'PAID', '126957', '1762754032', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (731, 'Tripay', '768880-251102225', 'MANDIRIVA', '', '1578', '100104711', '251102225', 'T150012829610521U6B', 'https://tripay.co.id/checkout/T150012829610521U6B', '1762753230', '2025-11-10', '1762839626', '', 'PAID', '127125', '1762753360', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (732, 'Tripay', '753237-251102368', 'DANA', '', '1728', '100104920', '251102368', 'T15001282961635NW64', 'https://tripay.co.id/checkout/T15001282961635NW64', '1762753353', '2025-11-10', '1762756832', '', 'PAID', '126875', '1762753421', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (733, 'Tripay', '128806-251102609', 'BCAVA', '', '1979', '100105427', '251102609', 'T1500128297552PTHF4', 'https://tripay.co.id/checkout/T1500128297552PTHF4', '1762756145', '2025-11-10', '1762842545', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (734, 'Tripay', '669946-251102532', 'SHOPEEPAY', '', '1899', '100105264', '251102532', 'T1500128298044BEXC2', 'https://tripay.co.id/checkout/T1500128298044BEXC2', '1762757056', '2025-11-10', '1762760536', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (735, 'Tripay', '614008-251102532', 'SHOPEEPAY', '', '1899', '100105264', '251102532', 'T1500128298199ER9NP', 'https://tripay.co.id/checkout/T1500128298199ER9NP', '1762757394', '2025-11-10', '1762760873', '', 'UNPAID', '128750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (736, 'Tripay', '821680-251102609', 'BCAVA', '', '1979', '100105427', '251102609', 'T1500128298662UFKYN', 'https://tripay.co.id/checkout/T1500128298662UFKYN', '1762758355', '2025-11-10', '1762844755', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (737, 'Tripay', '660256-251101753', 'BCAVA', '', '1055', '100103824', '251101753', 'T1500128298975FNX9P', 'https://tripay.co.id/checkout/T1500128298975FNX9P', '1762759001', '2025-11-10', '1762845401', '', 'PAID', '127750', '1762759136', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (738, 'Tripay', '248454-251101930', 'BSIVA', '', '1250', '250215081602', '251101930', 'T1500128299019SI5WI', 'https://tripay.co.id/checkout/T1500128299019SI5WI', '1762759103', '2025-11-10', '1762769776', '', 'PAID', '127125', '1762759149', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (739, 'Tripay', '992645-251101940', 'BRIVA', '', '1262', '250215093329', '251101940', 'T1500128301610IRPOT', 'https://tripay.co.id/checkout/T1500128301610IRPOT', '1762764293', '2025-11-10', '1762850686', '', 'PAID', '127125', '1762764340', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (740, 'Tripay', '393095-251102266', 'BRIVA', '', '1620', '100104784', '251102266', 'T1500128302167X2VMQ', 'https://tripay.co.id/checkout/T1500128302167X2VMQ', '1762765242', '2025-11-10', '1762851642', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (741, 'Tripay', '254648-251101105', 'BRIVA', '', '179', '220826111956', '251101105', 'T15001283038402107O', 'https://tripay.co.id/checkout/T15001283038402107O', '1762768106', '2025-11-10', '1762854499', '', 'PAID', '112396', '1762768209', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (742, 'Tripay', '423721-251101882', 'BRIVA', '', '1199', '100104040', '251101882', 'T1500128304867TTDUO', 'https://tripay.co.id/checkout/T1500128304867TTDUO', '1762769532', '2025-11-10', '1762855932', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (743, 'Tripay', '820049-251101191', 'BRIVA', '', '326', '230617124720', '251101191', 'T1500128305300H2ZVS', 'https://tripay.co.id/checkout/T1500128305300H2ZVS', '1762770175', '2025-11-10', '1762856568', '', 'PAID', '127483', '1762770229', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (744, 'Tripay', '34511-251102499', 'INDOMARET', '', '1865', '100105200', '251102499', 'T1500128305421YKBAR', 'https://tripay.co.id/checkout/T1500128305421YKBAR', '1762770339', '2025-11-10', '1762856738', '', 'PAID', '126750', '1762770504', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (745, 'Tripay', '800356-251102609', 'BRIVA', '', '1979', '100105427', '251102609', 'T1500128305965OYEIX', 'https://tripay.co.id/checkout/T1500128305965OYEIX', '1762771004', '2025-11-10', '1762857396', '', 'PAID', '127125', '1762771234', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (746, 'Tripay', '544124-251101969', 'BNIVA', '', '1293', '250225155131', '251101969', 'T1500128306712ASOCZ', 'https://tripay.co.id/checkout/T1500128306712ASOCZ', '1762772034', '2025-11-10', '1762858305', '', 'UNPAID', '129250', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (747, 'Tripay', '384883-251102762', 'ALFAMART', '', '2132', '100105678', '251102762', 'T1500128308595PUXLX', 'https://tripay.co.id/checkout/T1500128308595PUXLX', '1762774237', '2025-11-10', '1762860516', '', 'PAID', '98750', '1762774299', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (748, 'Tripay', '490057-251102604', 'MANDIRIVA', '', '1974', '100105416', '251102604', 'T15001283094424MRHS', 'https://tripay.co.id/checkout/T15001283094424MRHS', '1762775109', '2025-11-10', '1762861500', '', 'PAID', '127125', '1762775811', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (749, 'Tripay', '219203-251102809', 'DANA', '', '2179', '100105767', '251102809', 'T1500128310240YCI0N', 'https://tripay.co.id/checkout/T1500128310240YCI0N', '1762775939', '2025-11-10', '1762779418', '', 'PAID', '42630', '1762776253', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (750, 'Tripay', '395007-251102048', 'DANA', '', '1386', '100104346', '251102048', 'T1500128310522LPWXD', 'https://tripay.co.id/checkout/T1500128310522LPWXD', '1762776228', '2025-11-10', '1762779707', '', 'PAID', '127583', '1762776265', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (751, 'Tripay', '887463-251102478', 'BCAVA', '', '1844', '100105154', '251102478', 'T1500128311189FD9IK', 'https://tripay.co.id/checkout/T1500128311189FD9IK', '1762777019', '2025-11-10', '1762863418', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (752, 'Tripay', '440287-251101051', 'ALFAMART', '', '81', '220824100107', '251101051', 'T1500128311229R1LBK', 'https://tripay.co.id/checkout/T1500128311229R1LBK', '1762777065', '2025-11-10', '1762863345', '', 'PAID', '112017', '1762777097', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (753, 'Tripay', '569478-251102478', 'ALFAMART', '', '1844', '100105154', '251102478', 'T1500128311310KHPFH', 'https://tripay.co.id/checkout/T1500128311310KHPFH', '1762777163', '2025-11-10', '1762863443', '', 'PAID', '126750', '1762777433', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (754, 'Tripay', '793103-251101969', 'MANDIRIVA', '', '1293', '250225155131', '251101969', 'T1500128311423PI2R9', 'https://tripay.co.id/checkout/T1500128311423PI2R9', '1762777317', '2025-11-10', '1762863710', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (755, 'Tripay', '784294-251102799', 'QRIS2', '', '2169', '100105750', '251102799', 'T1500128311555GPZQE', 'https://tripay.co.id/checkout/T1500128311555GPZQE', '1762777433', '2025-11-10', '1762779233', '', 'UNPAID', '56135', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (756, 'Tripay', '197791-251102799', 'QRIS2', '', '2169', '100105750', '251102799', 'T1500128311590FHE87', 'https://tripay.co.id/checkout/T1500128311590FHE87', '1762777478', '2025-11-10', '1762779278', '', 'PAID', '56135', '1762777528', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (757, 'Tripay', '352708-251102671', 'DANA', '', '2041', '100105546', '251102671', 'T1500128311897KIZHN', 'https://tripay.co.id/checkout/T1500128311897KIZHN', '1762777886', '2025-11-10', '1762781365', '', 'PAID', '126875', '1762777942', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (758, 'Tripay', '365738-251101527', 'DANA', '', '781', '100103304', '251101527', 'T1500128313659TQRM5', 'https://tripay.co.id/checkout/T1500128313659TQRM5', '1762780057', '2025-11-10', '1762783536', '', 'PAID', '126875', '1762780179', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (759, 'Tripay', '755405-251102629', 'BNIVA', '', '1999', '100105462', '251102629', 'T1500128314290TPA8P', 'https://tripay.co.id/checkout/T1500128314290TPA8P', '1762780818', '2025-11-10', '1762867090', '', 'PAID', '129250', '1762781064', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (760, 'Tripay', '820856-251101291', 'QRIS2', '', '476', '231219090521', '251101291', 'T15001283152046OP4O', 'https://tripay.co.id/checkout/T15001283152046OP4O', '1762782019', '2025-11-10', '1762783819', '', 'UNPAID', '127425', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (761, 'Tripay', '388198-251101291', 'QRIS2', '', '476', '231219090521', '251101291', 'T15001283155004DRYI', 'https://tripay.co.id/checkout/T15001283155004DRYI', '1762782432', '2025-11-10', '1762784231', '', 'UNPAID', '127425', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (762, 'Tripay', '112763-251101520', 'DANA', '', '773', '100103292', '251101520', 'T1500128316635XOOJL', 'https://tripay.co.id/checkout/T1500128316635XOOJL', '1762784109', '2025-11-10', '1762787588', '', 'PAID', '126875', '1762785138', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (763, 'Tripay', '544838-251101223', 'QRIS2', '', '374', '230630155966', '251101223', 'T1500128324840SWCYS', 'https://tripay.co.id/checkout/T1500128324840SWCYS', '1762820719', '2025-11-11', '1762822519', '', 'PAID', '127060', '1762820763', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (764, 'Tripay', '321119-251111001', 'DANA', '', '2207', '100105667', '251111001', 'T1500128326301PLXT7', 'https://tripay.co.id/checkout/T1500128326301PLXT7', '1762823825', '2025-11-11', '1762827304', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (765, 'Tripay', '254272-251101614', 'ALFAMART', '', '880', '100103520', '251101614', 'T15001283278398DCRK', 'https://tripay.co.id/checkout/T15001283278398DCRK', '1762827055', '2025-11-11', '1762913335', '', 'PAID', '126750', '1762827097', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (766, 'Tripay', '577626-251101123', 'QRIS2', '', '204', '220825221733', '251101123', 'T1500128327863KOFU2', 'https://tripay.co.id/checkout/T1500128327863KOFU2', '1762827094', '2025-11-11', '1762828893', '', 'PAID', '112165', '1762827111', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (767, 'Tripay', '442202-251101342', 'DANA', '', '550', '240608143627', '251101342', 'T1500128329320TJSV1', 'https://tripay.co.id/checkout/T1500128329320TJSV1', '1762830204', '2025-11-11', '1762833683', '', 'PAID', '127761', '1762830268', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (768, 'Tripay', '697366-251102642', 'INDOMARET', '', '2012', '100105495', '251102642', 'T15001283340081OO1Y', 'https://tripay.co.id/checkout/T15001283340081OO1Y', '1762840932', '2025-11-11', '1762927332', '', 'PAID', '126750', '1762842214', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (769, 'Tripay', '653129-251111003', 'DANA', '', '997', '241212141714', '251111003', 'T15001283345774VZGF', 'https://tripay.co.id/checkout/T15001283345774VZGF', '1762842026', '2025-11-11', '1762845505', '', 'PAID', '72065', '1762842056', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (770, 'Tripay', '577747-251101674', 'INDOMARET', '', '954', '100103616', '251101674', 'T15001283347474CX77', 'https://tripay.co.id/checkout/T15001283347474CX77', '1762842402', '2025-11-11', '1762928801', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (771, 'Tripay', '566860-251101674', 'INDOMARET', '', '954', '100103616', '251101674', 'T1500128334817MRBJ1', 'https://tripay.co.id/checkout/T1500128334817MRBJ1', '1762842557', '2025-11-11', '1762928956', '', 'PAID', '126750', '1762843319', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (772, 'Tripay', '425605-251102339', 'DANA', '', '1698', '100104872', '251102339', 'T1500128335271C6JOR', 'https://tripay.co.id/checkout/T1500128335271C6JOR', '1762843650', '2025-11-11', '1762847129', '', 'PAID', '126875', '1762843698', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (773, 'Tripay', '502106-251101037', 'SHOPEEPAY', '', '53', '220823114916', '251101037', 'T1500128337362VPX0H', 'https://tripay.co.id/checkout/T1500128337362VPX0H', '1762848969', '2025-11-11', '1762852449', '', 'PAID', '129070', '1762849001', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (774, 'Tripay', '543437-251101331', 'BRIVA', '', '532', '240326122362', '251101331', 'T1500128338022L23BF', 'https://tripay.co.id/checkout/T1500128338022L23BF', '1762850554', '2025-11-11', '1762936945', '', 'PAID', '127650', '1762850636', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (775, 'Tripay', '878870-251101153', 'BRIVA', '', '260', '221229141064', '251101153', 'T1500128339530CZK0E', 'https://tripay.co.id/checkout/T1500128339530CZK0E', '1762854148', '2025-11-11', '1762940548', '', 'PAID', '122984', '1762854264', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (776, 'Tripay', '28793-251101871', 'ALFAMART', '', '1187', '250121105941', '251101871', 'T1500128340185Z4PIW', 'https://tripay.co.id/checkout/T1500128340185Z4PIW', '1762855612', '2025-11-11', '1762941892', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (777, 'Tripay', '105643-251102169', 'DANA', '', '1518', '100104565', '251102169', 'T1500128343110SABRG', 'https://tripay.co.id/checkout/T1500128343110SABRG', '1762860061', '2025-11-11', '1762863540', '', 'PAID', '127797', '1762860090', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (778, 'Tripay', '165749-251102505', 'ALFAMART', '', '1871', '100105209', '251102505', 'T150012834344859NWG', 'https://tripay.co.id/checkout/T150012834344859NWG', '1762860670', '2025-11-11', '1762946950', '', 'PAID', '126750', '1762860866', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (779, 'Tripay', '80022-251102270', 'INDOMARET', '', '1624', '100104793', '251102270', 'T1500128344598R4NCV', 'https://tripay.co.id/checkout/T1500128344598R4NCV', '1762862543', '2025-11-11', '1762948942', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (780, 'Tripay', '46027-251101694', 'QRIS2', '', '978', '100103677', '251101694', 'T1500128345688VB5LG', 'https://tripay.co.id/checkout/T1500128345688VB5LG', '1762864030', '2025-11-11', '1762950310', '', 'PAID', '126625', '1762864092', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (781, 'Tripay', '433065-251102270', 'DANA', '', '1624', '100104793', '251102270', 'T1500128345726KXNIW', 'https://tripay.co.id/checkout/T1500128345726KXNIW', '1762864088', '2025-11-11', '1762867568', '', 'PAID', '126875', '1762864113', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (782, 'Tripay', '197790-251111001', 'DANA', '', '2207', '100105667', '251111001', 'T1500128345817NEI2G', 'https://tripay.co.id/checkout/T1500128345817NEI2G', '1762864216', '2025-11-11', '1762867695', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (783, 'Tripay', '559449-251111001', 'DANA', '', '2207', '100105667', '251111001', 'T1500128345916WDTM0', 'https://tripay.co.id/checkout/T1500128345916WDTM0', '1762864365', '2025-11-11', '1762867844', '', 'PAID', '126875', '1762864435', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (784, 'Tripay', '529910-251102699', 'ALFAMART', '', '2069', '100105558', '251102699', 'T1500128345992XX3LN', 'https://tripay.co.id/checkout/T1500128345992XX3LN', '1762864458', '2025-11-11', '1762950738', '', 'PAID', '126750', '1762864615', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (785, 'Tripay', '4720-251101032', 'BRIVA', '', '45', '220822205044', '251101032', 'T1500128347460MAEP3', 'https://tripay.co.id/checkout/T1500128347460MAEP3', '1762867261', '2025-11-11', '1762953654', '', 'UNPAID', '127396', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (786, 'Tripay', '315878-251101032', 'BRIVA', '', '45', '220822205044', '251101032', 'T1500128347468TBY7Y', 'https://tripay.co.id/checkout/T1500128347468TBY7Y', '1762867276', '2025-11-11', '1762953676', '', 'PAID', '127396', '1762867388', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (787, 'Tripay', '615055-251101027', 'ALFAMART', '', '40', '220823091923', '251101027', 'T1500128347621ISI12', 'https://tripay.co.id/checkout/T1500128347621ISI12', '1762867679', '2025-11-11', '1762953959', '', 'PAID', '127219', '1762867795', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (788, 'Tripay', '942515-251101895', 'BCAVA', '', '1212', '100104068', '251101895', 'T1500128349649XXAPN', 'https://tripay.co.id/checkout/T1500128349649XXAPN', '1762873388', '2025-11-11', '1762959787', '', 'PAID', '127750', '1762873561', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (789, 'Tripay', '327248-251112001', 'INDOMARET', '', '622', '240608143787', '251112001', 'T1500128355927I4SJW', 'https://tripay.co.id/checkout/T1500128355927I4SJW', '1762912646', '2025-11-12', '1762999046', '', 'UNPAID', '127068', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (790, 'Tripay', '819530-251101871', 'ALFAMART', '', '1187', '250121105941', '251101871', 'T1500128356103KGYCM', 'https://tripay.co.id/checkout/T1500128356103KGYCM', '1762913119', '2025-11-12', '1762999398', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (791, 'Tripay', '929464-251102414', 'ALFAMART', '', '1777', '100105022', '251102414', 'T1500128360259HXQQ5', 'https://tripay.co.id/checkout/T1500128360259HXQQ5', '1762924559', '2025-11-12', '1763010839', '', 'PAID', '126750', '1762924651', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (792, 'Tripay', '202169-251102199', 'BNIVA', '', '1548', '100104615', '251102199', 'T1500128360301CSEKS', 'https://tripay.co.id/checkout/T1500128360301CSEKS', '1762924653', '2025-11-12', '1763010925', '', 'PAID', '130039', '1762924731', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (793, 'Tripay', '755013-251112001', 'INDOMARET', '', '622', '240608143787', '251112001', 'T1500128360758N6UBT', 'https://tripay.co.id/checkout/T1500128360758N6UBT', '1762925910', '2025-11-12', '1763012310', '', 'PAID', '127068', '1762961548', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (794, 'Tripay', '461749-251102114', 'DANA', '', '1455', '100104491', '251102114', 'T1500128361303VRUQP', 'https://tripay.co.id/checkout/T1500128361303VRUQP', '1762927573', '2025-11-12', '1762931052', '', 'PAID', '127821', '1762927606', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (795, 'Tripay', '630458-251101161', 'QRIS2', '', '274', '221229141126', '251101161', 'T1500128366804F1AYT', 'https://tripay.co.id/checkout/T1500128366804F1AYT', '1762942517', '2025-11-12', '1762944316', '', 'PAID', '126748', '1762942548', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (796, 'Tripay', '611130-251102139', 'BCAVA', '', '1481', '250411143539', '251102139', 'T1500128367914ZTJPD', 'https://tripay.co.id/checkout/T1500128367914ZTJPD', '1762945132', '2025-11-12', '1763031532', '', 'PAID', '128388', '1762945326', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (797, 'Tripay', '68470-251102266', 'BRIVA', '', '1620', '100104784', '251102266', 'T1500128370070GQJJH', 'https://tripay.co.id/checkout/T1500128370070GQJJH', '1762949673', '2025-11-12', '1763036066', '', 'PAID', '127125', '1762949843', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (798, 'Tripay', '867450-251102360', 'DANA', '', '1720', '100104906', '251102360', 'T1500128380794GXDEM', 'https://tripay.co.id/checkout/T1500128380794GXDEM', '1763002770', '2025-11-13', '1763006250', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (799, 'Tripay', '472689-251102360', 'DANA', '', '1720', '100104906', '251102360', 'T15001283909378SZMZ', 'https://tripay.co.id/checkout/T15001283909378SZMZ', '1763034271', '2025-11-13', '1763037750', '', 'PAID', '126875', '1763034310', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (800, 'Tripay', '532780-251102700', 'DANA', '', '2070', '100105559', '251102700', 'T1500128393960WHWHZ', 'https://tripay.co.id/checkout/T1500128393960WHWHZ', '1763041214', '2025-11-13', '1763044693', '', 'PAID', '126875', '1763041252', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (801, 'Tripay', '584788-251101563', 'QRIS2', '', '822', '100103406', '251101563', 'T1500128394496CALMY', 'https://tripay.co.id/checkout/T1500128394496CALMY', '1763042722', '2025-11-13', '1763044522', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (802, 'Tripay', '7680-251101563', 'QRIS2', '', '822', '100103406', '251101563', 'T1500128394498BORDT', 'https://tripay.co.id/checkout/T1500128394498BORDT', '1763042723', '2025-11-13', '1763044523', '', 'PAID', '126625', '1763042868', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (803, 'Tripay', '941585-251101543', 'ALFAMART', '', '800', '100103352', '251101543', 'T1500128401088CXCIV', 'https://tripay.co.id/checkout/T1500128401088CXCIV', '1763083382', '2025-11-14', '1763169662', '', 'PAID', '126750', '1763085461', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (804, 'Tripay', '783772-251101206', 'BNIVA', '', '350', '230630155824', '251101206', 'T1500128413664DHU57', 'https://tripay.co.id/checkout/T1500128413664DHU57', '1763118703', '2025-11-14', '1763204975', '', 'PAID', '130058', '1763118767', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (805, 'Tripay', '604555-251101272', 'QRIS2', '', '442', '231219090322', '251101272', 'T1500128414806K72XY', 'https://tripay.co.id/checkout/T1500128414806K72XY', '1763121300', '2025-11-14', '1763123099', '', 'PAID', '127505', '1763121330', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (806, 'Tripay', '381309-251102525', 'DANA', '', '1892', '100105252', '251102525', 'T1500128417032JGLD6', 'https://tripay.co.id/checkout/T1500128417032JGLD6', '1763125108', '2025-11-14', '1763128587', '', 'PAID', '126875', '1763125154', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (807, 'Tripay', '586976-251101291', 'QRIS2', '', '476', '231219090521', '251101291', 'T15001284200021OTT8', 'https://tripay.co.id/checkout/T15001284200021OTT8', '1763131937', '2025-11-14', '1763133737', '', 'UNPAID', '127425', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (808, 'Tripay', '703381-251101291', 'BCAVA', '', '476', '231219090521', '251101291', 'T1500128421705N4LTT', 'https://tripay.co.id/checkout/T1500128421705N4LTT', '1763138283', '2025-11-14', '1763224682', '', 'UNPAID', '128544', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (809, 'Tripay', '15214-251101291', 'DANA', '', '476', '231219090521', '251101291', 'T1500128421761KXYYA', 'https://tripay.co.id/checkout/T1500128421761KXYYA', '1763138640', '2025-11-14', '1763142118', '', 'UNPAID', '127681', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (810, 'Tripay', '211361-251101291', 'QRIS', '', '476', '231219090521', '251101291', 'T1500128421763ZG6NS', 'https://tripay.co.id/checkout/T1500128421763ZG6NS', '1763138652', '2025-11-14', '1763140451', '', 'UNPAID', '126609', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (811, 'Tripay', '343410-251101291', 'BRIVA', '', '476', '231219090521', '251101291', 'T1500128421767FT4UG', 'https://tripay.co.id/checkout/T1500128421767FT4UG', '1763138678', '2025-11-14', '1763225071', '', 'UNPAID', '127919', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (812, 'Tripay', '349750-251101291', 'QRIS', '', '476', '231219090521', '251101291', 'T1500128421774NCVDW', 'https://tripay.co.id/checkout/T1500128421774NCVDW', '1763138698', '2025-11-14', '1763140497', '', 'PAID', '126609', '1763138727', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (813, 'Tripay', '188499-251101893', 'SHOPEEPAY', '', '1210', '100104065', '251101893', 'T1500128434816FUOVJ', 'https://tripay.co.id/checkout/T1500128434816FUOVJ', '1763188961', '2025-11-15', '1763192441', '', 'PAID', '128750', '1763188993', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (814, 'Tripay', '893872-251101155', 'INDOMARET', '', '264', '221229141075', '251101155', 'T1500128441654PGMND', 'https://tripay.co.id/checkout/T1500128441654PGMND', '1763205486', '2025-11-15', '1763291886', '', 'PAID', '127159', '1763205770', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (815, 'Tripay', '715124-251101597', 'INDOMARET', '', '862', '100103491', '251101597', 'T15001284427182ICZY', 'https://tripay.co.id/checkout/T15001284427182ICZY', '1763207149', '2025-11-15', '1763293548', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (816, 'Tripay', '627943-251101612', 'BCAVA', '', '878', '100103517', '251101612', 'T1500128442775YNRIC', 'https://tripay.co.id/checkout/T1500128442775YNRIC', '1763207200', '2025-11-15', '1763293600', '', 'PAID', '127750', '1763207238', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (817, 'Tripay', '61875-251101299', 'BRIVA', '', '485', '231219090590', '251101299', 'T1500128450821A8WPD', 'https://tripay.co.id/checkout/T1500128450821A8WPD', '1763229476', '2025-11-16', '1763315869', '', 'PAID', '127919', '1763229553', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (818, 'Tripay', '761534-251101464', 'BCAVA', '', '705', '100103181', '251101464', 'T1500128456069L0AMD', 'https://tripay.co.id/checkout/T1500128456069L0AMD', '1763260747', '2025-11-16', '1763347147', '', 'PAID', '127750', '1763260823', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (819, 'Tripay', '720239-251101140', 'INDOMARET', '', '238', '221128125033', '251101140', 'T1500128462366EGG3R', 'https://tripay.co.id/checkout/T1500128462366EGG3R', '1763278996', '2025-11-16', '1763365395', '', 'PAID', '126792', '1763280150', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (820, 'Tripay', '361026-251101707', 'DANA', '', '995', '241212140143', '251101707', 'T15001284773872HNLO', 'https://tripay.co.id/checkout/T15001284773872HNLO', '1763345303', '2025-11-17', '1763348781', '', 'PAID', '126875', '1763345321', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (821, 'Tripay', '331779-251102018', 'QRIS2', '', '1354', '100104299', '251102018', 'T1500128481278IBZVC', 'https://tripay.co.id/checkout/T1500128481278IBZVC', '1763357146', '2025-11-17', '1763443426', '', 'PAID', '126721', '1763357274', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (822, 'Tripay', '563214-251101030', 'BRIVA', '', '43', '220823102731', '251101030', 'T1500128482245FYFCI', 'https://tripay.co.id/checkout/T1500128482245FYFCI', '1763360436', '2025-11-17', '1763446828', '', 'PAID', '22316', '1763360548', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (823, 'Tripay', '175011-251102349', 'QRIS2', '', '1708', '100104885', '251102349', 'T1500128497817B00EQ', 'https://tripay.co.id/checkout/T1500128497817B00EQ', '1763432979', '2025-11-18', '1763519259', '', 'UNPAID', '126625', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (824, 'Tripay', '207387-251102349', 'BSIVA', '', '1708', '100104885', '251102349', 'T1500128497849IBIQY', 'https://tripay.co.id/checkout/T1500128497849IBIQY', '1763433103', '2025-11-18', '1763443776', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (825, 'Tripay', '327045-251102349', 'QRIS2', '', '1708', '100104885', '251102349', 'T1500128497912RLDVF', 'https://tripay.co.id/checkout/T1500128497912RLDVF', '1763433294', '2025-11-18', '1763519574', '', 'PAID', '126625', '1763433453', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (826, 'Tripay', '776130-251101805', 'INDOMARET', '', '898', '10010583', '251101805', 'T465022823900705QNX', 'https://tripay.co.id/checkout/T465022823900705QNX', '1762579473', '2025-11-08', '1762580493', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (827, 'Tripay', '90843-251101805', 'INDOMARET', '', '898', '10010583', '251101805', 'T46502282391405USY2', 'https://tripay.co.id/checkout/T46502282391405USY2', '1762579820', '2025-11-08', '1762580840', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (828, 'Tripay', '185618-251101095', 'BCAVA', '', '121', '231219090593', '251101095', 'T4650228239397K87Q6', 'https://tripay.co.id/checkout/T4650228239397K87Q6', '1762580599', '2025-11-08', '1762581619', '', 'UNPAID', '128054', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (829, 'Tripay', '361691-251101711', 'BCAVA', '', '801', '100105225', '251101711', 'T4650228239577XEBO9', 'https://tripay.co.id/checkout/T4650228239577XEBO9', '1762581040', '2025-11-08', '1762582060', '', 'PAID', '127750', '1762581137', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (830, 'Tripay', '553781-251101755', 'BCAVA', '', '848', '100105396', '251101755', 'T46502282403792568V', 'https://tripay.co.id/checkout/T46502282403792568V', '1762583248', '2025-11-08', '1762584268', '', 'PAID', '127750', '1762583403', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (831, 'Tripay', '183266-251101702', 'BCAVA', '', '791', '100105191', '251101702', 'T4650228240447SJW0H', 'https://tripay.co.id/checkout/T4650228240447SJW0H', '1762583488', '2025-11-08', '1762584508', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (832, 'Tripay', '549025-251101702', 'BCAVA', '', '791', '100105191', '251101702', 'T4650228240473A8OIB', 'https://tripay.co.id/checkout/T4650228240473A8OIB', '1762583551', '2025-11-08', '1762584571', '', 'PAID', '127750', '1762583627', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (833, 'Tripay', '439210-251101805', 'INDOMARET', '', '898', '10010583', '251101805', 'T4650228240688HNSTW', 'https://tripay.co.id/checkout/T4650228240688HNSTW', '1762584150', '2025-11-08', '1764521999', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (834, 'Tripay', '251366-251101869', 'BCAVA', '', '962', '100105745', '251101869', 'T4650228240927KCLBA', 'https://tripay.co.id/checkout/T4650228240927KCLBA', '1762584902', '2025-11-08', '1762585922', '', 'PAID', '57750', '1762584959', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (835, 'Tripay', '179351-251101831', 'QRIS2', '', '924', '100105618', '251101831', 'T4650228241012IDELG', 'https://tripay.co.id/checkout/T4650228241012IDELG', '1762585224', '2025-11-08', '1762585939', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (836, 'Tripay', '583905-251101816', 'SHOPEEPAY', '', '909', '100105576', '251101816', 'T4650228241159EVNPB', 'https://tripay.co.id/checkout/T4650228241159EVNPB', '1762585608', '2025-11-08', '1762586628', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (837, 'Tripay', '631303-251101816', 'SHOPEEPAY', '', '909', '100105576', '251101816', 'T4650228241199ZGL9L', 'https://tripay.co.id/checkout/T4650228241199ZGL9L', '1762585714', '2025-11-08', '1762586733', '', 'PAID', '126875', '1762585730', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (838, 'Tripay', '834900-251101534', 'QRIS2', '', '614', '100104742', '251101534', 'T4650228241263JDOLW', 'https://tripay.co.id/checkout/T4650228241263JDOLW', '1762585889', '2025-11-08', '1762586609', '', 'PAID', '125812', '1762585985', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (839, 'Tripay', '422937-251101143', 'INDOMARET', '', '176', '240517132255', '251101143', 'T4650228242036L276Q', 'https://tripay.co.id/checkout/T4650228242036L276Q', '1762587775', '2025-11-08', '1762588795', '', 'PAID', '122425', '1762587808', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (840, 'Tripay', '338358-251101456', 'INDOMARET', '', '530', '250325084850', '251101456', 'T4650228242364TAMBH', 'https://tripay.co.id/checkout/T4650228242364TAMBH', '1762588600', '2025-11-08', '1762589620', '', 'PAID', '126907', '1762589343', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (841, 'Tripay', '896381-251101604', 'MANDIRIVA', '', '689', '100104914', '251101604', 'T4650228245658SRNL1', 'https://tripay.co.id/checkout/T4650228245658SRNL1', '1762596855', '2025-11-08', '1762600568', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (842, 'Tripay', '600446-251101604', 'MANDIRIVA', '', '689', '100104914', '251101604', 'T46502282456971YS3D', 'https://tripay.co.id/checkout/T46502282456971YS3D', '1762596936', '2025-11-08', '1762600656', '', 'PAID', '167125', '1762597182', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (843, 'Tripay', '49750-251101170', 'QRIS2', '', '208', '100103215', '251101170', 'T4650228245948LQCTW', 'https://tripay.co.id/checkout/T4650228245948LQCTW', '1762597523', '2025-11-08', '1762598243', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (844, 'Tripay', '382925-251101170', 'QRIS2', '', '208', '100103215', '251101170', 'T46502282459812YUDH', 'https://tripay.co.id/checkout/T46502282459812YUDH', '1762597603', '2025-11-08', '1762598323', '', 'PAID', '125812', '1762597653', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (845, 'Tripay', '615787-251101032', 'BRIVA', '', '43', '230630155790', '251101032', 'T4650228246693P81MC', 'https://tripay.co.id/checkout/T4650228246693P81MC', '1762599211', '2025-11-08', '1762602925', '', 'UNPAID', '127469', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (846, 'Tripay', '720777-251101032', 'QRIS2', '', '43', '230630155790', '251101032', 'T4650228246722VA417', 'https://tripay.co.id/checkout/T4650228246722VA417', '1762599256', '2025-11-08', '1762599975', '', 'PAID', '126158', '1762599296', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (847, 'Tripay', '396115-251101838', 'INDOMARET', '', '931', '100105649', '251101838', 'T4650228247349PIEQ9', 'https://tripay.co.id/checkout/T4650228247349PIEQ9', '1762600737', '2025-11-08', '1762601757', '', 'PAID', '126750', '1762601480', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (848, 'Tripay', '341228-251101805', 'INDOMARET', '', '898', '10010583', '251101805', 'T46502282478415RS7G', 'https://tripay.co.id/checkout/T46502282478415RS7G', '1762601783', '2025-11-08', '1762602803', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (849, 'Tripay', '378113-251101607', 'BNIVA', '', '692', '100104921', '251101607', 'T4650228248491YEM9E', 'https://tripay.co.id/checkout/T4650228248491YEM9E', '1762603008', '2025-11-08', '1762604021', '', 'PAID', '127125', '1762603045', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (850, 'Tripay', '384407-251101828', 'BCAVA', '', '921', '100105609', '251101828', 'T4650228248715WFG13', 'https://tripay.co.id/checkout/T4650228248715WFG13', '1762603387', '2025-11-08', '1762604406', '', 'PAID', '127750', '1762603472', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (851, 'Tripay', '783532-251101646', 'QRIS2', '', '733', '100105023', '251101646', 'T4650228249380BDAZK', 'https://tripay.co.id/checkout/T4650228249380BDAZK', '1762604657', '2025-11-08', '1762605377', '', 'PAID', '42522', '1762604780', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (852, 'Tripay', '881240-251101576', 'BRIVA', '', '658', '250527105202', '251101576', 'T4650228250043XWALW', 'https://tripay.co.id/checkout/T4650228250043XWALW', '1762605981', '2025-11-08', '1762609694', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (853, 'Tripay', '524159-251101150', 'INDOMARET', '', '184', '240608143661', '251101150', 'T4650228250136PLGJY', 'https://tripay.co.id/checkout/T4650228250136PLGJY', '1762606177', '2025-11-08', '1762607197', '', 'UNPAID', '122673', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (854, 'Tripay', '659345-251101343', 'ALFAMART', '', '406', '250118141837', '251101343', 'T4650228250208PKKH1', 'https://tripay.co.id/checkout/T4650228250208PKKH1', '1762606320', '2025-11-08', '1762610039', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (855, 'Tripay', '37682-251101389', 'DANA', '', '457', '250226140921', '251101389', 'T4650228250379IJUHL', 'https://tripay.co.id/checkout/T4650228250379IJUHL', '1762606685', '2025-11-08', '1762607703', '', 'PAID', '126875', '1762606765', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (856, 'Tripay', '949376-251101343', 'ALFAMART', '', '406', '250118141837', '251101343', 'T465022825039515YCK', 'https://tripay.co.id/checkout/T465022825039515YCK', '1762606707', '2025-11-08', '1762610427', '', 'PAID', '126750', '1762606771', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (857, 'Tripay', '142158-251101722', 'DANA', '', '813', '100105274', '251101722', 'T46502282507634YDTR', 'https://tripay.co.id/checkout/T46502282507634YDTR', '1762607555', '2025-11-08', '1762608573', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (858, 'Tripay', '162788-251101722', 'DANA', '', '813', '100105274', '251101722', 'T4650228250793JDJIT', 'https://tripay.co.id/checkout/T4650228250793JDJIT', '1762607635', '2025-11-08', '1762608654', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (859, 'Tripay', '946802-251101722', 'DANA', '', '813', '100105274', '251101722', 'T4650228251991MFIG8', 'https://tripay.co.id/checkout/T4650228251991MFIG8', '1762610886', '2025-11-08', '1762611904', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (860, 'Tripay', '101542-251101722', 'SHOPEEPAY', '', '813', '100105274', '251101722', 'T4650228252030U07EX', 'https://tripay.co.id/checkout/T4650228252030U07EX', '1762610994', '2025-11-08', '1762612013', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (861, 'Tripay', '386893-251101722', 'QRIS2', '', '813', '100105274', '251101722', 'T4650228252107R7F0C', 'https://tripay.co.id/checkout/T4650228252107R7F0C', '1762611190', '2025-11-08', '1762611909', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (862, 'Tripay', '593886-251101722', 'QRIS2', '', '813', '100105274', '251101722', 'T4650228252137X7T7O', 'https://tripay.co.id/checkout/T4650228252137X7T7O', '1762611263', '2025-11-08', '1762611982', '', 'PAID', '125812', '1762611298', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (863, 'Tripay', '166890-251101145', 'QRIS2', '', '179', '240608143638', '251101145', 'T4650228256327PWSFY', 'https://tripay.co.id/checkout/T4650228256327PWSFY', '1762641234', '2025-11-09', '1762641953', '', 'PAID', '166049', '1762641267', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (864, 'Tripay', '875116-251101341', 'INDOMARET', '', '404', '250118140302', '251101341', 'T4650228257389YVXK9', 'https://tripay.co.id/checkout/T4650228257389YVXK9', '1762647320', '2025-11-09', '1762648340', '', 'PAID', '126750', '1762647829', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (865, 'Tripay', '90818-251101011', 'INDOMARET', '', '11', '220827092343', '251101011', 'T4650228257755KB2M1', 'https://tripay.co.id/checkout/T4650228257755KB2M1', '1762648679', '2025-11-09', '1762649699', '', 'PAID', '127199', '1762649366', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (866, 'Tripay', '108157-251101511', 'BCAVA', '', '590', '100104645', '251101511', 'T4650228258149SX03U', 'https://tripay.co.id/checkout/T4650228258149SX03U', '1762649984', '2025-11-09', '1762651004', '', 'PAID', '128578', '1762650054', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (867, 'Tripay', '570327-251101185', 'INDOMARET', '', '224', '100103342', '251101185', 'T4650228258723CQATY', 'https://tripay.co.id/checkout/T4650228258723CQATY', '1762651824', '2025-11-09', '1762652844', '', 'PAID', '126750', '1762652796', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (868, 'Tripay', '879671-251101557', 'BRIVA', '', '639', '250520141044', '251101557', 'T4650228259565DGFQZ', 'https://tripay.co.id/checkout/T4650228259565DGFQZ', '1762654082', '2025-11-09', '1762657795', '', 'PAID', '127125', '1762654112', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (869, 'Tripay', '285995-251101742', 'DANA', '', '835', '100105350', '251101742', 'T4650228261503MKODL', 'https://tripay.co.id/checkout/T4650228261503MKODL', '1762659052', '2025-11-09', '1762660071', '', 'PAID', '126875', '1762659564', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (870, 'Tripay', '926626-251101837', 'INDOMARET', '', '930', '100105648', '251101837', 'T4650228261524GLIEB', 'https://tripay.co.id/checkout/T4650228261524GLIEB', '1762659095', '2025-11-09', '1762660115', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (871, 'Tripay', '381438-251101865', 'BRIVA', '', '958', '100105736', '251101865', 'T4650228261532ND4Z4', 'https://tripay.co.id/checkout/T4650228261532ND4Z4', '1762659122', '2025-11-09', '1762662842', '', 'PAID', '65125', '1762659194', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (872, 'Tripay', '921701-251101240', 'INDOMARET', '', '294', '241115140548', '251101240', 'T4650228261825CZAFO', 'https://tripay.co.id/checkout/T4650228261825CZAFO', '1762659993', '2025-11-09', '1762661013', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (873, 'Tripay', '772731-251101240', 'INDOMARET', '', '294', '241115140548', '251101240', 'T4650228261879NKYRZ', 'https://tripay.co.id/checkout/T4650228261879NKYRZ', '1762660132', '2025-11-09', '1762661152', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (874, 'Tripay', '723621-251101837', 'INDOMARET', '', '930', '100105648', '251101837', 'T4650228261892LXRZD', 'https://tripay.co.id/checkout/T4650228261892LXRZD', '1762660184', '2025-11-09', '1762661204', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (875, 'Tripay', '344704-251101240', 'INDOMARET', '', '294', '241115140548', '251101240', 'T4650228262987ECNXW', 'https://tripay.co.id/checkout/T4650228262987ECNXW', '1762663351', '2025-11-09', '1762664371', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (876, 'Tripay', '801451-251101240', 'ALFAMART', '', '294', '241115140548', '251101240', 'T4650228263015RC2EA', 'https://tripay.co.id/checkout/T4650228263015RC2EA', '1762663429', '2025-11-09', '1762667148', '', 'PAID', '126750', '1762663740', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (877, 'Tripay', '887554-251101836', 'ALFAMART', '', '929', '100105647', '251101836', 'T4650228265056KZHER', 'https://tripay.co.id/checkout/T4650228265056KZHER', '1762668571', '2025-11-09', '1762672290', '', 'PAID', '126750', '1762668687', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (878, 'Tripay', '293306-251101575', 'DANA', '', '657', '100104839', '251101575', 'T4650228268726KODN8', 'https://tripay.co.id/checkout/T4650228268726KODN8', '1762678568', '2025-11-09', '1762679587', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (879, 'Tripay', '165289-251101575', 'DANA', '', '657', '100104839', '251101575', 'T4650228268771SPQA9', 'https://tripay.co.id/checkout/T4650228268771SPQA9', '1762678679', '2025-11-09', '1762679698', '', 'PAID', '126875', '1762678803', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (880, 'Tripay', '572619-251101551', 'DANA', '', '632', '250516093318', '251101551', 'T4650228269616I4BJP', 'https://tripay.co.id/checkout/T4650228269616I4BJP', '1762680806', '2025-11-09', '1762681825', '', 'PAID', '126875', '1762680843', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (881, 'Tripay', '362474-251101405', 'QRIS2', '', '474', '250227121738', '251101405', 'T4650228269994T5K7M', 'https://tripay.co.id/checkout/T4650228269994T5K7M', '1762681574', '2025-11-09', '1762682294', '', 'PAID', '125812', '1762681752', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (882, 'Tripay', '97238-251101164', 'INDOMARET', '', '199', '100103118', '251101164', 'T4650228270104OAIRA', 'https://tripay.co.id/checkout/T4650228270104OAIRA', '1762681835', '2025-11-09', '1762682855', '', 'PAID', '126750', '1762681897', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (883, 'Tripay', '131275-251101684', 'DANA', '', '772', '100105141', '251101684', 'T46502282712045CV1C', 'https://tripay.co.id/checkout/T46502282712045CV1C', '1762684195', '2025-11-09', '1762685214', '', 'PAID', '126875', '1762684245', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (884, 'Tripay', '315095-251101831', 'QRIS2', '', '924', '100105618', '251101831', 'T46502282718425CPKT', 'https://tripay.co.id/checkout/T46502282718425CPKT', '1762685374', '2025-11-09', '1762686094', '', 'PAID', '125812', '1762685451', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (885, 'Tripay', '165782-251101492', 'ALFAMART', '', '568', '100104588', '251101492', 'T46502282726106WY3U', 'https://tripay.co.id/checkout/T46502282726106WY3U', '1762686936', '2025-11-09', '1762690656', '', 'UNPAID', '127444', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (886, 'Tripay', '306166-251101294', 'INDOMARET', '', '355', '100103819', '251101294', 'T4650228274299JQIP7', 'https://tripay.co.id/checkout/T4650228274299JQIP7', '1762689977', '2025-11-09', '1762690996', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (887, 'Tripay', '285312-251101732', 'ALFAMART', '', '824', '100105309', '251101732', 'T4650228274395OGEF8', 'https://tripay.co.id/checkout/T4650228274395OGEF8', '1762690150', '2025-11-09', '1762693870', '', 'PAID', '126750', '1762690260', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (888, 'Tripay', '150473-251101461', 'ALFAMART', '', '535', '100104484', '251101461', 'T4650228274445IMEOB', 'https://tripay.co.id/checkout/T4650228274445IMEOB', '1762690234', '2025-11-09', '1762693954', '', 'PAID', '126877', '1762690295', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (889, 'Tripay', '651853-251101588', 'INDOMARET', '', '671', '100104882', '251101588', 'T46502282771510HAIS', 'https://tripay.co.id/checkout/T46502282771510HAIS', '1762695350', '2025-11-09', '1762696370', '', 'PAID', '126750', '1762695500', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (890, 'Tripay', '652696-251101294', 'INDOMARET', '', '355', '100103819', '251101294', 'T4650228277450GWPZ3', 'https://tripay.co.id/checkout/T4650228277450GWPZ3', '1762696054', '2025-11-09', '1762697074', '', 'PAID', '126750', '1762696142', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (891, 'Tripay', '868901-251101620', 'BNIVA', '', '705', '100104952', '251101620', 'T4650228277711UKRDY', 'https://tripay.co.id/checkout/T4650228277711UKRDY', '1762696658', '2025-11-09', '1762697671', '', 'PAID', '127125', '1762696707', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (892, 'Tripay', '185696-251101492', 'ALFAMART', '', '568', '100104588', '251101492', 'T4650228278608ZGMNZ', 'https://tripay.co.id/checkout/T4650228278608ZGMNZ', '1762698912', '2025-11-09', '1762702632', '', 'PAID', '127444', '1762698971', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (893, 'Tripay', '368024-251101657', 'QRIS2', '', '744', '100105054', '251101657', 'T4650228279158XUXZL', 'https://tripay.co.id/checkout/T4650228279158XUXZL', '1762700577', '2025-11-09', '1762701297', '', 'PAID', '125812', '1762700623', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (894, 'Tripay', '397327-251101623', 'DANA', '', '708', '100104966', '251101623', 'T4650228279466BG4TC', 'https://tripay.co.id/checkout/T4650228279466BG4TC', '1762701528', '2025-11-09', '1762702546', '', 'PAID', '126875', '1762701548', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (895, 'Tripay', '996797-251101400', 'QRIS2', '', '468', '250227085047', '251101400', 'T4650228281186GXCJ5', 'https://tripay.co.id/checkout/T4650228281186GXCJ5', '1762709201', '2025-11-10', '1762709921', '', 'PAID', '125812', '1762709259', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (896, 'Tripay', '337912-251101837', 'QRIS2', '', '930', '100105648', '251101837', 'T4650228284351VGWJR', 'https://tripay.co.id/checkout/T4650228284351VGWJR', '1762733284', '2025-11-10', '1762734003', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (897, 'Tripay', '43171-251101837', 'INDOMARET', '', '930', '100105648', '251101837', 'T4650228284609ISCY6', 'https://tripay.co.id/checkout/T4650228284609ISCY6', '1762734064', '2025-11-10', '1762735084', '', 'PAID', '126750', '1762734114', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (898, 'Tripay', '182159-251101708', 'INDOMARET', '', '798', '100105216', '251101708', 'T4650228285397MLABG', 'https://tripay.co.id/checkout/T4650228285397MLABG', '1762735941', '2025-11-10', '1762736961', '', 'PAID', '126750', '1762736500', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (899, 'Tripay', '810004-251101840', 'BCAVA', '', '933', '100105661', '251101840', 'T4650228286158ERZHF', 'https://tripay.co.id/checkout/T4650228286158ERZHF', '1762737488', '2025-11-10', '1762738507', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (900, 'Tripay', '118462-251101840', 'QRIS2', '', '933', '100105661', '251101840', 'T46502282861708MSA9', 'https://tripay.co.id/checkout/T46502282861708MSA9', '1762737517', '2025-11-10', '1762738236', '', 'PAID', '125812', '1762737873', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (901, 'Tripay', '410051-251101823', 'BCAVA', '', '916', '100105587', '251101823', 'T4650228286243KVTCY', 'https://tripay.co.id/checkout/T4650228286243KVTCY', '1762737657', '2025-11-10', '1762738677', '', 'PAID', '127750', '1762738444', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (902, 'Tripay', '206600-251101152', 'MANDIRIVA', '', '186', '240608143682', '251101152', 'T4650228286870JKNFB', 'https://tripay.co.id/checkout/T4650228286870JKNFB', '1762738910', '2025-11-10', '1762742630', '', 'PAID', '127417', '1762739039', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (903, 'Tripay', '676258-251101698', 'INDOMARET', '', '787', '100105179', '251101698', 'T46502282875304CD3Q', 'https://tripay.co.id/checkout/T46502282875304CD3Q', '1762739694', '2025-11-10', '1762740713', '', 'PAID', '126750', '1762739754', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (904, 'Tripay', '327082-251101600', 'INDOMARET', '', '684', '250613112333', '251101600', 'T46502282877577OHIS', 'https://tripay.co.id/checkout/T46502282877577OHIS', '1762739983', '2025-11-10', '1762741003', '', 'PAID', '126750', '1762740083', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (905, 'Tripay', '33124-251101862', 'INDOMARET', '', '955', '100105733', '251101862', 'T4650228288335TUCFL', 'https://tripay.co.id/checkout/T4650228288335TUCFL', '1762740459', '2025-11-10', '1762741479', '', 'PAID', '68750', '1762740513', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (906, 'Tripay', '182556-251101089', 'DANA', '', '113', '231219090544', '251101089', 'T4650228288390YSDEI', 'https://tripay.co.id/checkout/T4650228288390YSDEI', '1762740587', '2025-11-10', '1762741607', '', 'UNPAID', '127531', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (907, 'Tripay', '997394-251101585', 'BCAVA', '', '668', '100104861', '251101585', 'T4650228288548OANR5', 'https://tripay.co.id/checkout/T4650228288548OANR5', '1762740802', '2025-11-10', '1762741822', '', 'PAID', '127750', '1762740957', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (908, 'Tripay', '170706-251101672', 'ALFAMART', '', '759', '100105099', '251101672', 'T4650228288738XHCKR', 'https://tripay.co.id/checkout/T4650228288738XHCKR', '1762741079', '2025-11-10', '1762744798', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (909, 'Tripay', '62473-251101672', 'ALFAMART', '', '759', '100105099', '251101672', 'T4650228288773XTPF9', 'https://tripay.co.id/checkout/T4650228288773XTPF9', '1762741147', '2025-11-10', '1762744867', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (910, 'Tripay', '895386-251101672', 'QRIS2', '', '759', '100105099', '251101672', 'T4650228288877ZHP5L', 'https://tripay.co.id/checkout/T4650228288877ZHP5L', '1762741291', '2025-11-10', '1762742011', '', 'PAID', '125812', '1762741361', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (911, 'Tripay', '470547-251101089', 'DANA', '', '113', '231219090544', '251101089', 'T46502282890847X9XP', 'https://tripay.co.id/checkout/T46502282890847X9XP', '1762741619', '2025-11-10', '1762742638', '', 'UNPAID', '127531', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (912, 'Tripay', '125231-251101089', 'BCAVA', '', '113', '231219090544', '251101089', 'T4650228289387UQKPC', 'https://tripay.co.id/checkout/T4650228289387UQKPC', '1762742130', '2025-11-10', '1762743150', '', 'UNPAID', '128396', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (913, 'Tripay', '700702-251101819', 'BCAVA', '', '912', '100105581', '251101819', 'T4650228289475J5TOI', 'https://tripay.co.id/checkout/T4650228289475J5TOI', '1762742311', '2025-11-10', '1762743332', '', 'PAID', '167750', '1762742369', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (914, 'Tripay', '316754-251101089', 'DANA', '', '113', '231219090544', '251101089', 'T4650228289526MPP8U', 'https://tripay.co.id/checkout/T4650228289526MPP8U', '1762742401', '2025-11-10', '1762743421', '', 'PAID', '127531', '1762742845', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (915, 'Tripay', '111140-251101089', 'DANA', '', '113', '231219090544', '251101089', 'T4650228289585TN5KE', 'https://tripay.co.id/checkout/T4650228289585TN5KE', '1762742538', '2025-11-10', '1762743557', '', 'UNPAID', '127531', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (916, 'Tripay', '221385-251101070', 'QRIS2', '', '91', '231219090379', '251101070', 'T4650228289694SR9CE', 'https://tripay.co.id/checkout/T4650228289694SR9CE', '1762742630', '2025-11-10', '1762743349', '', 'PAID', '166227', '1762742681', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (917, 'Tripay', '908435-251101810', 'SHOPEEPAY', '', '903', '10010598', '251101810', 'T4650228290549DBMSW', 'https://tripay.co.id/checkout/T4650228290549DBMSW', '1762743739', '2025-11-10', '1762744759', '', 'PAID', '126875', '1762743788', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (918, 'Tripay', '805284-251101196', 'INDOMARET', '', '238', '100103386', '251101196', 'T46502282906376WSFL', 'https://tripay.co.id/checkout/T46502282906376WSFL', '1762743891', '2025-11-10', '1762744911', '', 'PAID', '126750', '1762744330', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (919, 'Tripay', '778423-251101204', 'INDOMARET', '', '248', '100103429', '251101204', 'T4650228290650ERPYG', 'https://tripay.co.id/checkout/T4650228290650ERPYG', '1762743914', '2025-11-10', '1762744934', '', 'PAID', '126750', '1762744422', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (920, 'Tripay', '761483-251101833', 'INDOMARET', '', '926', '100105631', '251101833', 'T4650228290767B5Z0P', 'https://tripay.co.id/checkout/T4650228290767B5Z0P', '1762744126', '2025-11-10', '1762745145', '', 'PAID', '126750', '1762744647', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (921, 'Tripay', '675075-251101266', 'QRIS2', '', '324', '241213084225', '251101266', 'T4650228291432BTHCY', 'https://tripay.co.id/checkout/T4650228291432BTHCY', '1762745276', '2025-11-10', '1762745996', '', 'PAID', '125812', '1762745333', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (922, 'Tripay', '420492-251101427', 'INDOMARET', '', '500', '100104370', '251101427', 'T4650228291519RNDJM', 'https://tripay.co.id/checkout/T4650228291519RNDJM', '1762745417', '2025-11-10', '1762746437', '', 'PAID', '127383', '1762745929', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (923, 'Tripay', '38278-251101348', 'BCAVA', '', '413', '250120074004', '251101348', 'T46502282916762SNWH', 'https://tripay.co.id/checkout/T46502282916762SNWH', '1762745672', '2025-11-10', '1762746692', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (924, 'Tripay', '398118-251101348', 'BCAVA', '', '413', '250120074004', '251101348', 'T4650228291773KHCSP', 'https://tripay.co.id/checkout/T4650228291773KHCSP', '1762745841', '2025-11-10', '1762746861', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (925, 'Tripay', '275894-251101689', 'QRIS2', '', '778', '100105157', '251101689', 'T4650228291920USM0A', 'https://tripay.co.id/checkout/T4650228291920USM0A', '1762746073', '2025-11-10', '1762746792', '', 'PAID', '125812', '1762746137', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (926, 'Tripay', '808018-251101348', 'BCAVA', '', '413', '250120074004', '251101348', 'T4650228291968ZGBN9', 'https://tripay.co.id/checkout/T4650228291968ZGBN9', '1762746151', '2025-11-10', '1762747171', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (927, 'Tripay', '31260-251101753', 'QRIS2', '', '846', '100105392', '251101753', 'T4650228292631E6SSK', 'https://tripay.co.id/checkout/T4650228292631E6SSK', '1762747263', '2025-11-10', '1762747968', '', 'PAID', '125812', '1762747407', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (928, 'Tripay', '490286-251101193', 'INDOMARET', '', '234', '100103379', '251101193', 'T4650228293289WBP5U', 'https://tripay.co.id/checkout/T4650228293289WBP5U', '1762748413', '2025-11-10', '1762749432', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (929, 'Tripay', '291056-251101193', 'INDOMARET', '', '234', '100103379', '251101193', 'T4650228293840USWDY', 'https://tripay.co.id/checkout/T4650228293840USWDY', '1762749293', '2025-11-10', '1762750312', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (930, 'Tripay', '187284-251101798', 'INDOMARET', '', '891', '10010565', '251101798', 'T465022829437379KWT', 'https://tripay.co.id/checkout/T465022829437379KWT', '1762749976', '2025-11-10', '1762750995', '', 'PAID', '166750', '1762750111', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (931, 'Tripay', '239156-251101237', 'QRIS2', '', '291', '100103584', '251101237', 'T4650228294874BUR7S', 'https://tripay.co.id/checkout/T4650228294874BUR7S', '1762750931', '2025-11-10', '1762751650', '', 'PAID', '165952', '1762750960', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (932, 'Tripay', '690734-251101284', 'MANDIRIVA', '', '344', '241216104448', '251101284', 'T4650228295288NNHWH', 'https://tripay.co.id/checkout/T4650228295288NNHWH', '1762751646', '2025-11-10', '1762755366', '', 'PAID', '127125', '1762751886', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (933, 'Tripay', '194629-251101621', 'INDOMARET', '', '706', '100104957', '251101621', 'T4650228295477EDKFD', 'https://tripay.co.id/checkout/T4650228295477EDKFD', '1762752136', '2025-11-10', '1762753156', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (934, 'Tripay', '372434-251101281', 'ALFAMART', '', '340', '241214102933', '251101281', 'T4650228295971X8LRD', 'https://tripay.co.id/checkout/T4650228295971X8LRD', '1762752991', '2025-11-10', '1762756711', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (935, 'Tripay', '494880-251101807', 'MANDIRIVA', '', '900', '10010590', '251101807', 'T4650228296220Z42QF', 'https://tripay.co.id/checkout/T4650228296220Z42QF', '1762753473', '2025-11-10', '1762757193', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (936, 'Tripay', '144331-251101807', 'MANDIRIVA', '', '900', '10010590', '251101807', 'T46502282964789EZOL', 'https://tripay.co.id/checkout/T46502282964789EZOL', '1762753985', '2025-11-10', '1762757698', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (937, 'Tripay', '367655-251101344', 'QRIS2', '', '407', '250118142131', '251101344', 'T46502282965243GIR1', 'https://tripay.co.id/checkout/T46502282965243GIR1', '1762754071', '2025-11-10', '1762754791', '', 'PAID', '125812', '1762754093', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (938, 'Tripay', '907779-251101621', 'INDOMARET', '', '706', '100104957', '251101621', 'T4650228296709MOK0D', 'https://tripay.co.id/checkout/T4650228296709MOK0D', '1762754440', '2025-11-10', '1762755460', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (939, 'Tripay', '602630-251101621', 'ALFAMART', '', '706', '100104957', '251101621', 'T4650228296713CDCC6', 'https://tripay.co.id/checkout/T4650228296713CDCC6', '1762754451', '2025-11-10', '1762758171', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (940, 'Tripay', '425977-251101621', 'INDOMARET', '', '706', '100104957', '251101621', 'T4650228296939JQZGS', 'https://tripay.co.id/checkout/T4650228296939JQZGS', '1762754905', '2025-11-10', '1762755925', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (941, 'Tripay', '253019-251101621', 'ALFAMART', '', '706', '100104957', '251101621', 'T4650228296951BG0FX', 'https://tripay.co.id/checkout/T4650228296951BG0FX', '1762754927', '2025-11-10', '1762758647', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (942, 'Tripay', '338542-251101621', 'INDOMARET', '', '706', '100104957', '251101621', 'T4650228297016CD2CM', 'https://tripay.co.id/checkout/T4650228297016CD2CM', '1762755056', '2025-11-10', '1762756076', '', 'PAID', '126750', '1762755371', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (943, 'Tripay', '416553-251101621', 'ALFAMART', '', '706', '100104957', '251101621', 'T4650228297029ZEZNM', 'https://tripay.co.id/checkout/T4650228297029ZEZNM', '1762755077', '2025-11-10', '1762758796', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (944, 'Tripay', '848019-251101621', 'INDOMARET', '', '706', '100104957', '251101621', 'T4650228297157T16LC', 'https://tripay.co.id/checkout/T4650228297157T16LC', '1762755345', '2025-11-10', '1762756365', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (945, 'Tripay', '847170-251101807', 'MANDIRIVA', '', '900', '10010590', '251101807', 'T4650228297397L7U4I', 'https://tripay.co.id/checkout/T4650228297397L7U4I', '1762755838', '2025-11-10', '1762759550', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (946, 'Tripay', '89375-251101042', 'BCAVA', '', '57', '230630156026', '251101042', 'T4650228297450R1JZ7', 'https://tripay.co.id/checkout/T4650228297450R1JZ7', '1762755932', '2025-11-10', '1762756951', '', 'PAID', '168212', '1762755967', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (947, 'Tripay', '527870-251101193', 'INDOMARET', '', '234', '100103379', '251101193', 'T4650228299098RV1ZS', 'https://tripay.co.id/checkout/T4650228299098RV1ZS', '1762759283', '2025-11-10', '1762760302', '', 'PAID', '126750', '1762759341', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (948, 'Tripay', '595867-251101827', 'SHOPEEPAY', '', '920', '100105606', '251101827', 'T4650228300258JPKQ2', 'https://tripay.co.id/checkout/T4650228300258JPKQ2', '1762761647', '2025-11-10', '1762762666', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (949, 'Tripay', '629133-251101827', 'SHOPEEPAY', '', '920', '100105606', '251101827', 'T4650228300479KNKJ5', 'https://tripay.co.id/checkout/T4650228300479KNKJ5', '1762762139', '2025-11-10', '1762763159', '', 'PAID', '126875', '1762762260', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (950, 'Tripay', '482196-251101616', 'BRIVA', '', '701', '100104941', '251101616', 'T4650228302010CIKC7', 'https://tripay.co.id/checkout/T4650228302010CIKC7', '1762765001', '2025-11-10', '1762768714', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (951, 'Tripay', '96379-251101616', 'BRIVA', '', '701', '100104941', '251101616', 'T4650228302071BS3UL', 'https://tripay.co.id/checkout/T4650228302071BS3UL', '1762765107', '2025-11-10', '1762768827', '', 'PAID', '127125', '1762765191', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (952, 'Tripay', '991344-251101277', 'QRIS2', '', '336', '241214091628', '251101277', 'T4650228304072TRJN1', 'https://tripay.co.id/checkout/T4650228304072TRJN1', '1762768429', '2025-11-10', '1762769149', '', 'PAID', '125812', '1762768709', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (953, 'Tripay', '962640-251101807', 'QRIS2', '', '900', '10010590', '251101807', 'T4650228304127EZAPP', 'https://tripay.co.id/checkout/T4650228304127EZAPP', '1762768528', '2025-11-10', '1762769247', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (954, 'Tripay', '964741-251101807', 'MANDIRIVA', '', '900', '10010590', '251101807', 'T4650228304693NORQH', 'https://tripay.co.id/checkout/T4650228304693NORQH', '1762769314', '2025-11-10', '1762773034', '', 'PAID', '127125', '1762769449', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (955, 'Tripay', '579468-251101537', 'DANA', '', '617', '100104751', '251101537', 'T465022830547174O62', 'https://tripay.co.id/checkout/T465022830547174O62', '1762770401', '2025-11-10', '1762771420', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (956, 'Tripay', '78724-251101537', 'DANA', '', '617', '100104751', '251101537', 'T4650228305473RCEEF', 'https://tripay.co.id/checkout/T4650228305473RCEEF', '1762770403', '2025-11-10', '1762771423', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (957, 'Tripay', '913843-251101537', 'DANA', '', '617', '100104751', '251101537', 'T46502283054772Y02O', 'https://tripay.co.id/checkout/T46502283054772Y02O', '1762770407', '2025-11-10', '1762771426', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (958, 'Tripay', '899080-251101537', 'DANA', '', '617', '100104751', '251101537', 'T4650228305479DAKBN', 'https://tripay.co.id/checkout/T4650228305479DAKBN', '1762770409', '2025-11-10', '1762771428', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (959, 'Tripay', '713447-251101537', 'DANA', '', '617', '100104751', '251101537', 'T4650228305485XJWLJ', 'https://tripay.co.id/checkout/T4650228305485XJWLJ', '1762770411', '2025-11-10', '1762771431', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (960, 'Tripay', '701071-251101537', 'DANA', '', '617', '100104751', '251101537', 'T4650228305487DKBP7', 'https://tripay.co.id/checkout/T4650228305487DKBP7', '1762770413', '2025-11-10', '1762771432', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (961, 'Tripay', '163089-251101537', 'DANA', '', '617', '100104751', '251101537', 'T4650228305490YRWKJ', 'https://tripay.co.id/checkout/T4650228305490YRWKJ', '1762770415', '2025-11-10', '1762771434', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (962, 'Tripay', '7092-251101537', 'DANA', '', '617', '100104751', '251101537', 'T4650228305496FC6SC', 'https://tripay.co.id/checkout/T4650228305496FC6SC', '1762770417', '2025-11-10', '1762771436', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (963, 'Tripay', '714626-251101537', 'DANA', '', '617', '100104751', '251101537', 'T4650228305608NGI7J', 'https://tripay.co.id/checkout/T4650228305608NGI7J', '1762770538', '2025-11-10', '1762771557', '', 'PAID', '126875', '1762770587', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (964, 'Tripay', '155234-251101220', 'INDOMARET', '', '270', '100103548', '251101220', 'T4650228305698HWMAQ', 'https://tripay.co.id/checkout/T4650228305698HWMAQ', '1762770654', '2025-11-10', '1762771674', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (965, 'Tripay', '2864-251101394', 'QRIS2', '', '462', '250226160803', '251101394', 'T4650228306104FKSTZ', 'https://tripay.co.id/checkout/T4650228306104FKSTZ', '1762771206', '2025-11-10', '1762771925', '', 'PAID', '125812', '1762771301', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (966, 'Tripay', '289328-251101241', 'BCAVA', '', '295', '100103606', '251101241', 'T4650228306157HFIJP', 'https://tripay.co.id/checkout/T4650228306157HFIJP', '1762771284', '2025-11-10', '1762772304', '', 'PAID', '127750', '1762771824', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (967, 'Tripay', '364468-251101878', 'INDOMARET', '', '971', '100105782', '251101878', 'T4650228310134RUFQZ', 'https://tripay.co.id/checkout/T4650228310134RUFQZ', '1762775816', '2025-11-10', '1762776836', '', 'UNPAID', '35750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (968, 'Tripay', '251788-251101067', 'QRIS2', '', '88', '231219090297', '251101067', 'T4650228311465DJGL3', 'https://tripay.co.id/checkout/T4650228311465DJGL3', '1762777366', '2025-11-10', '1762778085', '', 'PAID', '121081', '1762777402', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (969, 'Tripay', '51568-251101559', 'ALFAMART', '', '641', '250522105618', '251101559', 'T4650228311981K7RTA', 'https://tripay.co.id/checkout/T4650228311981K7RTA', '1762777997', '2025-11-10', '1762781717', '', 'PAID', '126750', '1762778213', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (970, 'Tripay', '478933-251101694', 'INDOMARET', '', '783', '100105172', '251101694', 'T4650228312971NUJVX', 'https://tripay.co.id/checkout/T4650228312971NUJVX', '1762779205', '2025-11-10', '1762780225', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (971, 'Tripay', '7149-251101878', 'INDOMARET', '', '971', '100105782', '251101878', 'T4650228313118MHGCY', 'https://tripay.co.id/checkout/T4650228313118MHGCY', '1762779388', '2025-11-10', '1762780408', '', 'PAID', '35750', '1762779641', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (972, 'Tripay', '576582-251101535', 'DANA', '', '615', '100104746', '251101535', 'T4650228313122KUPDK', 'https://tripay.co.id/checkout/T4650228313122KUPDK', '1762779392', '2025-11-10', '1762780411', '', 'PAID', '126875', '1762779463', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (973, 'Tripay', '79973-251101192', 'BCAVA', '', '232', '100103377', '251101192', 'T465022831321135YJ4', 'https://tripay.co.id/checkout/T465022831321135YJ4', '1762779499', '2025-11-10', '1762780518', '', 'PAID', '127750', '1762780564', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (974, 'Tripay', '481007-251101383', 'INDOMARET', '', '451', '250225153657', '251101383', 'T4650228314582PBRZL', 'https://tripay.co.id/checkout/T4650228314582PBRZL', '1762781170', '2025-11-10', '1762782189', '', 'PAID', '126750', '1762781233', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (975, 'Tripay', '445375-251101202', 'INDOMARET', '', '245', '100103415', '251101202', 'T4650228314987LU57Z', 'https://tripay.co.id/checkout/T4650228314987LU57Z', '1762781734', '2025-11-10', '1762782754', '', 'PAID', '126750', '1762781859', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (976, 'Tripay', '186181-251101720', 'INDOMARET', '', '811', '100105270', '251101720', 'T4650228314994FABBE', 'https://tripay.co.id/checkout/T4650228314994FABBE', '1762781741', '2025-11-10', '1762782760', '', 'PAID', '126750', '1762781781', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (977, 'Tripay', '950909-251101631', 'QRIS2', '', '716', '100104978', '251101631', 'T4650228318182EYTE2', 'https://tripay.co.id/checkout/T4650228318182EYTE2', '1762787212', '2025-11-10', '1762787932', '', 'PAID', '125812', '1762787248', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (978, 'Tripay', '375923-251101220', 'INDOMARET', '', '270', '100103548', '251101220', 'T4650228323247FYGYF', 'https://tripay.co.id/checkout/T4650228323247FYGYF', '1762816353', '2025-11-11', '1762817373', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (979, 'Tripay', '790578-251101677', 'SHOPEEPAY', '', '764', '100105116', '251101677', 'T4650228323320JHAZ4', 'https://tripay.co.id/checkout/T4650228323320JHAZ4', '1762816586', '2025-11-11', '1762817606', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (980, 'Tripay', '341028-251101677', 'SHOPEEPAY', '', '764', '100105116', '251101677', 'T4650228323359IDXDR', 'https://tripay.co.id/checkout/T4650228323359IDXDR', '1762816725', '2025-11-11', '1762817745', '', 'PAID', '126875', '1762816754', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (981, 'Tripay', '683303-251101592', 'BCAVA', '', '675', '100104893', '251101592', 'T4650228324200FMPTN', 'https://tripay.co.id/checkout/T4650228324200FMPTN', '1762819221', '2025-11-11', '1762820241', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (982, 'Tripay', '604094-251101220', 'INDOMARET', '', '270', '100103548', '251101220', 'T4650228324393LV5DV', 'https://tripay.co.id/checkout/T4650228324393LV5DV', '1762819716', '2025-11-11', '1762820735', '', 'PAID', '126750', '1762820013', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (983, 'Tripay', '833450-251101756', 'ALFAMART', '', '849', '100105400', '251101756', 'T46502283286109ZQEJ', 'https://tripay.co.id/checkout/T46502283286109ZQEJ', '1762828753', '2025-11-11', '1762832473', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (984, 'Tripay', '3493-251101756', 'INDOMARET', '', '849', '100105400', '251101756', 'T465022832862133YP5', 'https://tripay.co.id/checkout/T465022832862133YP5', '1762828775', '2025-11-11', '1762829796', '', 'PAID', '126750', '1762828977', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (985, 'Tripay', '400575-251101796', 'INDOMARET', '', '889', '10010560', '251101796', 'T4650228328773NQKAP', 'https://tripay.co.id/checkout/T4650228328773NQKAP', '1762829063', '2025-11-11', '1762830082', '', 'PAID', '126750', '1762829156', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (986, 'Tripay', '587611-251101632', 'ALFAMART', '', '717', '100104981', '251101632', 'T46502283292985FBFG', 'https://tripay.co.id/checkout/T46502283292985FBFG', '1762830148', '2025-11-11', '1762833868', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (987, 'Tripay', '211903-251101632', 'ALFAMART', '', '717', '100104981', '251101632', 'T4650228329402TNSAF', 'https://tripay.co.id/checkout/T4650228329402TNSAF', '1762830378', '2025-11-11', '1762834098', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (988, 'Tripay', '492226-251101474', 'ALFAMART', '', '548', '100104529', '251101474', 'T4650228329567POLNL', 'https://tripay.co.id/checkout/T4650228329567POLNL', '1762830762', '2025-11-11', '1762834482', '', 'UNPAID', '127483', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (989, 'Tripay', '848751-251101632', 'ALFAMART', '', '717', '100104981', '251101632', 'T4650228330411JEMQS', 'https://tripay.co.id/checkout/T4650228330411JEMQS', '1762832705', '2025-11-11', '1762836425', '', 'PAID', '126750', '1762833283', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (990, 'Tripay', '692395-251101438', 'BRIVA', '', '512', '100104402', '251101438', 'T4650228331286PKKTI', 'https://tripay.co.id/checkout/T4650228331286PKKTI', '1762834667', '2025-11-11', '1762838379', '', 'PAID', '127632', '1762834746', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (991, 'Tripay', '843564-251101349', 'DANA', '', '414', '250120074618', '251101349', 'T4650228331597DHM9C', 'https://tripay.co.id/checkout/T4650228331597DHM9C', '1762835336', '2025-11-11', '1762836355', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (992, 'Tripay', '142698-251101615', 'INDOMARET', '', '700', '100104940', '251101615', 'T4650228332678BMJEL', 'https://tripay.co.id/checkout/T4650228332678BMJEL', '1762837751', '2025-11-11', '1762838771', '', 'PAID', '126750', '1762838241', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (993, 'Tripay', '103994-251101593', 'QRIS2', '', '676', '100104894', '251101593', 'T4650228333290QDUIX', 'https://tripay.co.id/checkout/T4650228333290QDUIX', '1762839216', '2025-11-11', '1762839936', '', 'PAID', '125812', '1762839269', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (994, 'Tripay', '552810-251101055', 'INDOMARET', '', '74', '231120143907', '251101055', 'T4650228334592KWATC', 'https://tripay.co.id/checkout/T4650228334592KWATC', '1762842056', '2025-11-11', '1762843075', '', 'PAID', '126788', '1762842380', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (995, 'Tripay', '554822-251101408', 'ALFAMART', '', '478', '100104291', '251101408', 'T4650228340289PZLOG', 'https://tripay.co.id/checkout/T4650228340289PZLOG', '1762855852', '2025-11-11', '1762859571', '', 'PAID', '126750', '1762855881', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (996, 'Tripay', '545167-251101543', 'ALFAMART', '', '623', '100104782', '251101543', 'T4650228341447JBS7Y', 'https://tripay.co.id/checkout/T4650228341447JBS7Y', '1762857903', '2025-11-11', '1762861623', '', 'PAID', '126750', '1762858510', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (997, 'Tripay', '68511-251101049', 'INDOMARET', '', '65', '231020102438', '251101049', 'T4650228345756BGM4E', 'https://tripay.co.id/checkout/T4650228345756BGM4E', '1762864130', '2025-11-11', '1762865149', '', 'UNPAID', '207487', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (998, 'Tripay', '139627-251101049', 'INDOMARET', '', '65', '231020102438', '251101049', 'T4650228346488ZIAFX', 'https://tripay.co.id/checkout/T4650228346488ZIAFX', '1762865377', '2025-11-11', '1762866396', '', 'UNPAID', '207487', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (999, 'Tripay', '65117-251101049', 'INDOMARET', '', '65', '231020102438', '251101049', 'T4650228347105BBOIM', 'https://tripay.co.id/checkout/T4650228347105BBOIM', '1762866534', '2025-11-11', '1762867554', '', 'PAID', '207487', '1762866924', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1000, 'Tripay', '259075-251101306', 'INDOMARET', '', '367', '100103852', '251101306', 'T4650228352807WID2K', 'https://tripay.co.id/checkout/T4650228352807WID2K', '1762901015', '2025-11-12', '1762902035', '', 'UNPAID', '116750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1001, 'Tripay', '881154-251101306', 'INDOMARET', '', '367', '100103852', '251101306', 'T4650228352825YM9GZ', 'https://tripay.co.id/checkout/T4650228352825YM9GZ', '1762901122', '2025-11-12', '1762902142', '', 'UNPAID', '116750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1002, 'Tripay', '481805-251101306', 'INDOMARET', '', '367', '100103852', '251101306', 'T46502283528491C0NN', 'https://tripay.co.id/checkout/T46502283528491C0NN', '1762901299', '2025-11-12', '1762902319', '', 'UNPAID', '116750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1003, 'Tripay', '217425-251101686', 'DANA', '', '774', '100105152', '251101686', 'T4650228353376QOXKI', 'https://tripay.co.id/checkout/T4650228353376QOXKI', '1762904111', '2025-11-12', '1762905130', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1004, 'Tripay', '54281-251101306', 'INDOMARET', '', '367', '100103852', '251101306', 'T4650228353739POHRZ', 'https://tripay.co.id/checkout/T4650228353739POHRZ', '1762905716', '2025-11-12', '1762906736', '', 'UNPAID', '116750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1005, 'Tripay', '133250-251101686', 'DANA', '', '774', '100105152', '251101686', 'T4650228355909AYRXO', 'https://tripay.co.id/checkout/T4650228355909AYRXO', '1762912592', '2025-11-12', '1762913611', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1006, 'Tripay', '36521-251101686', 'DANA', '', '774', '100105152', '251101686', 'T4650228356673VQKF1', 'https://tripay.co.id/checkout/T4650228356673VQKF1', '1762914793', '2025-11-12', '1762915813', '', 'PAID', '126875', '1762914951', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1007, 'Tripay', '931444-251003465', 'DANA', '', '266', '100103526', '251003465', 'T4650228357310CSTJY', 'https://tripay.co.id/checkout/T4650228357310CSTJY', '1762916595', '2025-11-12', '1762917614', '', 'PAID', '126875', '1762916632', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1008, 'Tripay', '282907-251101507', 'INDOMARET', '', '585', '100104638', '251101507', 'T4650228357602XLSOU', 'https://tripay.co.id/checkout/T4650228357602XLSOU', '1762917344', '2025-11-12', '1762918364', '', 'PAID', '126779', '1762917774', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1009, 'Tripay', '13359-251101282', 'INDOMARET', '', '341', '241214103134', '251101282', 'T4650228365642SLDMQ', 'https://tripay.co.id/checkout/T4650228365642SLDMQ', '1762939437', '2025-11-12', '1762940456', '', 'PAID', '126750', '1762939510', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1010, 'Tripay', '635063-251101065', 'BCAVA', '', '85', '231219090242', '251101065', 'T4650228368834D4ABU', 'https://tripay.co.id/checkout/T4650228368834D4ABU', '1762947124', '2025-11-12', '1762948144', '', 'PAID', '208414', '1762947197', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1011, 'Tripay', '614287-251101496', 'BRIVA', '', '572', '100104597', '251101496', 'T4650228378530KZJP4', 'https://tripay.co.id/checkout/T4650228378530KZJP4', '1762995054', '2025-11-13', '1762998768', '', 'UNPAID', '127587', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1012, 'Tripay', '262977-251101496', 'BRIVA', '', '572', '100104597', '251101496', 'T4650228378560E7OKS', 'https://tripay.co.id/checkout/T4650228378560E7OKS', '1762995228', '2025-11-13', '1762998948', '', 'UNPAID', '127587', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1013, 'Tripay', '522407-251101349', 'BCAVA', '', '414', '250120074618', '251101349', 'T4650228382632GCWGF', 'https://tripay.co.id/checkout/T4650228382632GCWGF', '1763008440', '2025-11-13', '1763009460', '', 'PAID', '127750', '1763008505', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1014, 'Tripay', '185308-251101693', 'BRIVA', '', '782', '100105170', '251101693', 'T4650228390970S1WZA', 'https://tripay.co.id/checkout/T4650228390970S1WZA', '1763034343', '2025-11-13', '1763038056', '', 'PAID', '127125', '1763034448', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1015, 'Tripay', '296925-251101496', 'BRIVA', '', '572', '100104597', '251101496', 'T4650228393734B9LPX', 'https://tripay.co.id/checkout/T4650228393734B9LPX', '1763040606', '2025-11-13', '1763044319', '', 'PAID', '127587', '1763040735', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1016, 'Tripay', '541316-251101737', 'ALFAMART', '', '830', '100105332', '251101737', 'T4650228416827EUNLS', 'https://tripay.co.id/checkout/T4650228416827EUNLS', '1763124855', '2025-11-14', '1763128575', '', 'PAID', '126750', '1763124951', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1017, 'Tripay', '176251-251101622', 'ALFAMART', '', '707', '100104959', '251101622', 'T4650228418471N33XV', 'https://tripay.co.id/checkout/T4650228418471N33XV', '1763127955', '2025-11-14', '1763131675', '', 'PAID', '126750', '1763129768', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1018, 'Tripay', '127331-251101478', 'MANDIRIVA', '', '553', '102030407', '251101478', 'T4650228432615V104D', 'https://tripay.co.id/checkout/T4650228432615V104D', '1763183456', '2025-11-15', '1763187169', '', 'PAID', '90043', '1763184649', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1019, 'Tripay', '940159-251101153', 'BCAVA', '', '187', '240608143684', '251101153', 'T46502284623956NWYN', 'https://tripay.co.id/checkout/T46502284623956NWYN', '1763279105', '2025-11-16', '1763280125', '', 'UNPAID', '128324', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1020, 'Tripay', '954657-251101370', 'MANDIRIVA', '', '437', '250213081350', '251101370', 'T46502284865557CT24', 'https://tripay.co.id/checkout/T46502284865557CT24', '1763375413', '2025-11-17', '1763379125', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1021, 'Tripay', '689658-251101370', 'MANDIRIVA', '', '437', '250213081350', '251101370', 'T4650228486763WVPAR', 'https://tripay.co.id/checkout/T4650228486763WVPAR', '1763376090', '2025-11-17', '1763379802', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1022, 'Tripay', '914265-251101525', 'ALFAMART', '', '604', '250509103810', '251101525', 'T46502284965521CIZA', 'https://tripay.co.id/checkout/T46502284965521CIZA', '1763427982', '2025-11-18', '1763431702', '', 'PAID', '126750', '1763428413', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1023, 'Tripay', '510971-251101173', 'QRIS2', '', '211', '100103231', '251101173', 'T46502284982028QMQ1', 'https://tripay.co.id/checkout/T46502284982028QMQ1', '1763434403', '2025-11-18', '1763435123', '', 'PAID', '206092', '1763434484', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1024, 'Tripay', '571531-251124001', 'INDOMARET', '', '5593', '101011757', '251124001', 'T1500128632857D05TR', 'https://tripay.co.id/checkout/T1500128632857D05TR', '1763963026', '2025-11-24', '1763964046', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1025, 'Tripay', '293759-251124001', 'ALFAMART', '', '5593', '101011757', '251124001', 'T1500128632915NIWWB', 'https://tripay.co.id/checkout/T1500128632915NIWWB', '1763963272', '2025-11-24', '1763966992', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1026, 'Tripay', '880620-251124001', 'INDOMARET', '', '5593', '101011757', '251124001', 'T1500128633101CS9BB', 'https://tripay.co.id/checkout/T1500128633101CS9BB', '1763964038', '2025-11-24', '1763965057', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1027, 'Tripay', '747753-251124001', 'INDOMARET', '', '5593', '101011757', '251124001', 'T1500128633188H7YMK', 'https://tripay.co.id/checkout/T1500128633188H7YMK', '1763964306', '2025-11-24', '1763965325', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1028, 'Tripay', '548081-251124001', 'INDOMARET', '', '5593', '101011757', '251124001', 'T1500128633254YGEVG', 'https://tripay.co.id/checkout/T1500128633254YGEVG', '1763964573', '2025-11-24', '1763965592', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1029, 'Tripay', '48621-251124001', 'INDOMARET', '', '5593', '101011757', '251124001', 'T1500128652046IPBE5', 'https://tripay.co.id/checkout/T1500128652046IPBE5', '1764039927', '2025-11-25', '1764040947', '', 'UNPAID', '126750', '', '');


