#
# TABLE STRUCTURE FOR: customer
#

DROP TABLE IF EXISTS `customer`;

CREATE TABLE `customer` (
  `customer_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `no_services` varchar(128) NOT NULL,
  `email` varchar(128) NOT NULL,
  `register_date` varchar(50) NOT NULL,
  `due_date` int(11) NOT NULL,
  `address` text NOT NULL,
  `no_wa` varchar(128) NOT NULL,
  `c_status` varchar(128) NOT NULL,
  `ppn` int(11) NOT NULL,
  `no_ktp` varchar(128) NOT NULL,
  `ktp` text NOT NULL,
  `created` int(11) NOT NULL,
  `mode_user` varchar(50) NOT NULL,
  `user_mikrotik` varchar(128) NOT NULL,
  `mitra` int(11) NOT NULL,
  `coverage` int(11) NOT NULL,
  `auto_isolir` int(11) NOT NULL,
  `type_id` varchar(50) NOT NULL,
  `router` int(11) NOT NULL,
  `codeunique` int(11) NOT NULL,
  `phonecode` int(11) NOT NULL,
  `latitude` text NOT NULL,
  `longitude` text NOT NULL,
  `user_profile` varchar(50) NOT NULL,
  `action` int(11) NOT NULL,
  `type_payment` int(11) NOT NULL,
  `max_due_isolir` int(11) NOT NULL,
  `olt` int(11) NOT NULL,
  `connection` int(11) NOT NULL,
  `cust_amount` int(11) NOT NULL,
  `mac_address` varchar(50) NOT NULL,
  `level` int(11) NOT NULL,
  `cust_description` text NOT NULL,
  `type_ip` int(11) NOT NULL,
  `id_odc` int(11) NOT NULL,
  `id_odp` int(11) NOT NULL,
  `no_port_odp` int(11) NOT NULL,
  `month_due_date` int(11) NOT NULL,
  `serial_number` text NOT NULL,
  `pass_mikrotik` text NOT NULL,
  `slot` int(11) NOT NULL,
  `port` int(11) NOT NULL,
  `onu_index` int(11) NOT NULL,
  `onu_type` text NOT NULL,
  `vlan` int(11) NOT NULL,
  `send_bill` int(11) NOT NULL,
  `no_va` text NOT NULL,
  `up_onu` text NOT NULL,
  `down_onu` text NOT NULL,
  `customer_mitra` int(11) NOT NULL,
  `createby` int(11) NOT NULL,
  `uuid` text NOT NULL,
  `nomorcodeuniq` int(11) NOT NULL,
  `mediaconnection` int(11) NOT NULL,
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `uniq_no_services` (`no_services`)
) ENGINE=InnoDB AUTO_INCREMENT=5745 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (1, 'Siti Aliyah', '101010001', 'aliyah@pasuruannet.com', '22-08-01', 5, 'Dsn. Balun, Ds. Gading', '081231840538', 'Aktif', 0, '0', '', 1661146061, 'PPPOE', 'balun_aliyah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 83, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (2, 'Heru Joko Prasetyo', '101010002', 'herujokoprasetyo@pasuruannet.com', '21-12-31', 5, 'Dsn Banyubiru Kidul Ds Sumber Rejo', '085606929692', 'Aktif', 0, '3514190000000000', '', 1661146726, 'PPPOE', 'banyubiru_heru', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 454, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (3, 'Cholili', '101010003', 'cholil@pasuruannet.com', '21-01-15', 5, 'Dsn. Balun, Ds. Gading', '085231738791', 'Aktif', 0, '0', '', 1661147276, 'PPPOE', 'balun_cholil', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 231, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (4, 'Khoirotul Khasanah', '101010004', 'khoirotulkhasanah@pasuruannet.com', '22-08-10', 5, 'Dsn. Banyubiru Kidul, Ds. Sumberejo', '081229734030', 'Aktif', 0, '3514090000000000', '', 1661147280, 'PPPOE', 'banyubirukidul_khoirotul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 368, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (5, 'Inayatul Izah', '101010005', 'innayatul@pasuruannet.com', '22-08-01', 5, 'Dsn. Balun, Ds. Gading', '081334200406', 'Aktif', 0, '0', '', 1661147507, 'PPPOE', 'balun_innayatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 536, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (6, 'Khudori', '101010006', 'khudori@pasuruannet.com', '22-02-26', 5, 'Dsn. Banyubiru kidul, Ds. Sumberrejo', '081558990493', 'Aktif', 0, '3514190000000000', '', 1661147626, 'PPPOE', 'banyubirulor_khudori', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 374, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (7, 'Kiki Mariyatul Qibtiyah', '101010007', 'kiki@pasuruannet.com', '22-08-01', 5, 'Dsn. Balun, Ds. Gading', '082144749882', 'Non-Aktif', 0, '0', '', 1661147723, 'PPPOE', 'balun_kiki', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 386, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (8, 'Wagito', '101040001', 'wagito@pasuruannet.com', '22-07-12', 5, 'Dsn. Mbaran, Ds. Karangkliwon', '083857724731', 'Aktif', 0, '3514201209730010', '', 1661147868, 'PPPOE', 'baran_wagito', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 448, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (9, 'Darmawan', '101020001', 'darmawan@pasuruannet.com', '21-08-20', 5, 'Dsn. Brambang, Ds, Brambang', '085335280434', 'Aktif', 0, '3514182003710010', '', 1661148116, 'PPPOE', 'brambang_darmawan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 239, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (10, 'Francisca Dian Iriyanti', '101010008', 'francisca@pasuruannet.com', '20-12-17', 5, 'Dsn. Bandaran KIdul, Ds.Bandaran', '085737628684', 'Non-Aktif', 0, '3514200000000000', '', 1661148230, 'PPPOE', 'bandaran_francisca', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 424, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (11, 'Mohammad Samak', '101010009', 'samak@pasuruannet.com', '22-08-01', 5, 'Dsn. Balun, Ds. Gading', '083841771262', 'Non-Aktif', 0, '3514190000000000', '', 1661148341, 'PPPOE', 'balun_samak', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 1040, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (12, 'Sinta Nuriah', '101010010', 'sinta@pasuruannet.com', '22-08-01', 5, 'Dsn. Balun, Ds. Gading', '081221115025', 'Aktif', 0, '0', '', 1661148591, 'PPPOE', 'balun_sinta', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 108, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (13, 'Miftakhul Jannah', '101010011', 'miftakhul@pasuruannet.com', '20-12-04', 5, 'Dsn. Gambiran Indah, Ds. Bandaran', '082245958378', 'Non-Aktif', 0, '3514190000000000', '', 1661148885, 'PPPOE', 'bandaran_jannah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 854, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (14, 'Sugiono', '101010012', 'sugiono@pasuruannet.com', '22-04-17', 5, 'Dsn. Brintik Kidul, Ds. Penataan', '081332701328', 'Aktif', 0, '3514190000000000', '', 1661149259, 'PPPOE', 'brintikkidul_sugiono', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 794, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (15, 'Mutrofin', '101020002', 'mutrofin@pasuruannet.com', '21-08-23', 5, 'Dsn. Brambang Barat, Ds. Brambang', '082245738560', 'Aktif', 0, '0', '', 1661149752, 'PPPOE', 'brambang_mutrofin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1025, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (16, 'Ansori', '101010013', 'ansori@pasuruannet.com', '22-08-10', 5, 'Dsn. Brintik Lor, Ds. Menyarik', '082341227708', 'Aktif', 0, '3514190000000000', '', 1661149992, 'PPPOE', 'brintiklor_ansori', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 186, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (17, 'Muhammad Ansori', '101040002', 'muhammadansori@pasuruannet.com', '22-05-16', 5, 'Dsn. Buntalan, Ds. Kedawung Wetan', '081553355428', 'Aktif', 0, '3514202505950010', '', 1661150921, 'PPPOE', 'buntalan_ansori', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1245, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (18, 'Munif', '101010014', 'moh.munip@pasuruannet.com', '22-03-04', 5, 'Dsn. Brintik kidul, Ds. Penata\'an', '085804326600', 'Non-Aktif', 0, '3514190000000000', '', 1661151831, 'PPPOE', 'brintikkidul_munif', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 871, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (19, 'Sunik Maisaro', '101040003', 'sunikmaisaroh@pasuruannet.com', '21-10-30', 5, 'Dsn. Buntalan, Ds. Kedawung Wetan', '085859828965', 'Aktif', 0, '3514204412890000', '', 1661152708, 'PPPOE', 'buntalan_sunik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 806, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (20, 'Sumantri', '101010015', 'sumantri@pasuruannet.com', '20-12-23', 5, 'Dsn. Talang Kulon, Ds. Bandaran', '085755414785', 'Non-Aktif', 0, '3514190000000000', '', 1661154145, 'PPPOE', 'bandaran_sumantri', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 800, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (21, 'Rosidi', '101010016', 'rosidi@pasuruannet.com', '22-06-13', 5, 'Dsn. Cukurguling, Ds. Cukurguling', '083117318246', 'Non-Aktif', 0, '3514040000000000', '', 1661155529, 'PPPOE', 'cukurguling_rosidi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 270, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (22, 'Ach. Baihaqi', '101010017', 'achbaihaqi@pasuruannet.com', '22-04-04', 5, 'Dsn. Curahmalang Ds. Karangtengah', '0881027830174', 'Aktif', 0, '3514190000000000', '', 1661155652, 'PPPOE', 'curahmalang_baihaqi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 49, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (23, 'Mukhammad Hidayatulloh (Kantor)', '101040004', 'mukhammadhidayatulloh@pasuruannet.com', '22-04-18', 5, 'Dsn. Curahwulu Ds. Karanglo', '082245679878', 'Non-Aktif', 0, '3514081207940010', '', 1661156929, 'PPPOE', 'curahwulu_hidayatulloh1', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 1023, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (24, 'Mutolep', '101020003', 'mutholib@pasuruannet.com', '22-08-01', 5, 'Dsn. Gayam, Ds. Gayam (Keboncandi)', '081252328319', 'Aktif', 0, '0', '', 1661157618, 'PPPOE', 'gayam_mutholib', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 788, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (25, 'Uyun Nur Rohmah', '101020004', 'uyun@pasuruannet.com', '22-08-01', 5, 'Dsn. Gayam, Ds. Gayam', '083899338226', 'Aktif', 0, '3514185506900000', '', 1661158116, 'PPPOE', 'gayam_uyun', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 506, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (26, 'Saikhu', '101010018', 'saikhu@pasuruannet.com', '22-08-01', 5, 'Dsn. Gading, Ds. Gading', '081292735299', 'Non-Aktif', 0, '0', '', 1661158371, 'PPPOE', 'gading_saikhu', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 156, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (27, 'Nikmatul Jannah', '101020005', 'nikmatuljannah@pasuruannet.com', '21-09-16', 5, 'Dsn. Grogol, Ds. Grogol', '085282795552', 'Aktif', 0, '3514185508890010', '', 1661159318, 'PPPOE', 'grogol_nikmatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 952, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (28, 'Nita dian puspita', '101010019', 'nitadianpuspita@psuruannet.com', '21-11-29', 5, 'Dsn. Gendol, Ds. Prodo', '085712349190', 'Aktif', 0, '3514200000000000', '', 1661159465, 'PPPOE', 'gendol_nita', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 954, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (29, 'Mentik Sumarmi', '101020006', 'mentik@pasuruannet.com', '22-04-05', 5, 'Dsn. Gondangwetan, Ds. Gondangwetan', '081542332001', 'Aktif', 0, '3514184703710000', '', 1661160565, 'PPPOE', 'gondangwetan_mentik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 843, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (30, 'Andiyono (BALDES JELADRI)', '101010020', 'andiyono@pasuruannet.com', '22-08-01', 5, 'Dsn. Watugede Ds. Jeladri', '085859592678', 'Non-Aktif', 0, '3514190000000000', '', 1661215514, 'PPPOE', 'jeladri_baldes', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 0, 22297, '', 0, '', 0, 2, 1, 171, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (31, 'Achmad Baihaqi', '101020007', 'achmadbaihaqi@pasuruannet.com', '22-08-05', 5, 'Dsn. Brambang, Ds. Brambang', '082228668551', 'Aktif', 0, '3514182503850000', '', 1661216379, 'PPPOE', 'jagan_baihaqi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 95, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (32, 'Hidayatul Adzimah', '101020008', 'hidayatuladzimah@pasuruannet.com', '22-01-31', 5, 'Dsn. Jajar Lor, Ds. Gondang Wetan ', '081327138540', 'Non-Aktif', 0, '3514186104940000', '', 1661218581, 'PPPOE', 'jajar_adzimah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 460, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (33, 'Misrikah', '101020009', 'misrikah@pasuruannet.com', '22-03-07', 5, 'Dsn. Jagan, Ds. Tambakrejo', '082131317884', 'Aktif', 0, '3514054212810000', '', 1661218757, 'PPPOE', 'jagan_misrikah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 861, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (34, 'Khoiril Bariyah', '101020010', 'khoirilbariyah@pasuruannet.com', '21-03-05', 5, 'Dsn. Kalimalang, Ds. Kalirejo', '082333889231', 'Aktif', 0, '3514186609950000', '', 1661221205, 'PPPOE', 'kalimalang_khoiril', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 489, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (35, 'Akhadi', '101040005', 'akhadi@pasuruannet.com', '22-08-01', 5, 'Dsn. Pande, Ds. Kambinganrejo', '082336076193', 'Aktif', 0, '0', '', 1661221381, 'PPPOE', 'kambinganrejo_akhadi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 61, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (36, 'Akhmadi', '101040006', 'akhmadii@pasuruannet.com', '22-08-01', 5, 'Dsn. Krajan Ds. Kambinganrejo', '081333394099', 'Aktif', 0, '3514802506780000', '', 1661221493, 'PPPOE', 'kambinganrejo_akhmadi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 147, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (37, 'Muhammad Mukhlis', '101010021', 'mukhlis@pasuruannet.com', '21-02-23', 5, 'Dsn. Mendalan Ds. Mendalan', '085785639527', 'Aktif', 0, '3514190000000000', '', 1661221963, 'PPPOE', 'kalongan_mukhlis', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 840, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (38, 'Subaida', '101020011', 'subaida@pasuruannet.com', '21-03-05', 5, 'Dsn. Kalimalang, Ds. Kalirejo', '085859005279', 'Non-Aktif', 0, '3514185204830010', '', 1661222171, 'PPPOE', 'kalimalang_subaidah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 712, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (39, 'Ita Lestari', '101040007', 'ita@pasuruannet.com', '22-08-01', 5, 'Dsn. Krajan Ds.Kambinganrejo', '085608816333', 'Aktif', 0, '3514204203960000', '', 1661222910, 'PPPOE', 'kambinganrejo_ita', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 568, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (40, 'Akhmad Baidlowi', '101010022', 'baidowi@pasuruannet.com', '22-07-02', 5, 'Dsn. Jungalang, Ds. Winonganlor', '081259074622', 'Aktif', 0, '3514190000000000', '', 1661223007, 'PPPOE', 'jungalang_baidowi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 100, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (41, 'Siti Julaiha', '101040008', 'sitijulaiha@pasuruannet.com', '21-08-02', 5, 'Dsn. Krajan Ds. Kambinganrejo', '082331451877', 'Aktif', 0, '3514206011970000', '', 1661224317, 'PPPOE', 'kambingan_julaikha', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 68, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (42, 'Lailia Rahmawati', '101040009', 'lailiarahmawati@pasuruannet.com', '21-10-05', 5, 'Dsn. Krajan, Ds. Kambinganrejo', '081554327054', 'Aktif', 0, '3575034610870000', '', 1661224501, 'PPPOE', 'kambingan_lailia', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 295, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (43, 'Yanwar Andrianto', '101040010', 'yanwarandrianto@pasuruannet.com', '21-07-23', 5, 'Dsn. Kambingan Timur, Ds. Kambinganrejo', '085791272525', 'Aktif', 0, '3514201901910000', '', 1661225384, 'PPPOE', 'kambingan_yanwar', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 361, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (44, 'Zainul', '101010023', 'zainulkandung@pasuruannet.com', '21-08-21', 5, 'Dsn. Pandean, Ds. Kandung', '085235997968', 'Aktif', 0, '3514190000000000', '', 1661225571, 'PPPOE', 'kandung_zainul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 285, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (45, 'Wahyu Laksono Putro', '101040011', 'wahyu@pasuruannet.com', '22-08-01', 5, 'Dsn. Krajan Ds. Kambinganrejo', '082331363811', 'Aktif', 0, '3514202509470000', '', 1661226765, 'PPPOE', 'kambinganrejo_wahyu', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 413, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (46, 'Sumarni', '101040012', 'sumarni@pasuruannet.com', '22-04-14', 5, 'Dsn. Karangasem Ds. karangkliwon', '083848864835', 'Aktif', 0, '3514204303810000', '', 1661226866, 'PPPOE', 'karangkliwon_sumarni', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 737, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (47, 'Atem', '101040013', 'atem@pasuruannet.com', '22-08-01', 5, 'Dsn. Curh Wulu, ds. Karanglo', '085755467938', 'Aktif', 0, '3514203006760000', '', 1661228032, 'PPPOE', 'karangtangkis_atim', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 220, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (48, 'Agus Eko Purnawianto', '101010024', 'aguskarangmojo@pasuruannet.com', '21-04-16', 5, 'Dsn. Karang Mojo, Ds. Karang Tengah', '085790444363', 'Aktif', 0, '3514190000000000', '', 1661228463, 'PPPOE', 'karangtengah_agusrumah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 86, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (49, 'H.A. Juki', '101040014', 'h.a.juki@pasuruannet.com', '21-08-21', 5, 'Dsn. Baran, Ds. Karangkliwon', '081333274994', 'Non-Aktif', 0, '3514200807730000', '', 1661228742, 'PPPOE', 'karangmakam_juki', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 501, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (50, 'Amin', '101020012', 'aamin@pasuruannet.com', '22-08-01', 5, 'Dsn. Keboncandi, Ds. Keboncandi', '0853833627890', 'Non-Aktif', 0, '3514180409640000', '', 1661228768, 'PPPOE', 'keboncandi_amin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (51, 'Moch. Zakaria', '101010025', 'zakariya@pasuruannet.com', '21-06-04', 5, 'Dsn. Karangmojo, Ds. Karang Tengah', '085755399074', 'Aktif', 0, '3514190000000000', '', 1661229658, 'PPPOE', 'karangmojo_zakariyya', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 868, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (52, 'BALDES KEBONREJO', '101040015', 'supandi@pasuruannet.com', '22-08-23', 5, 'Dsn. Kloto\'an, Ds. Kebonrejo', '085708543441', 'Non-Aktif', 0, '0', '', 1661230212, 'PPPOE', 'kebonrejo_balaidesa', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 0, 0, 1, 0, 1, 22297, '', 0, '', 0, 2, 1, 807, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (53, 'Indah Permatasari', '101020013', 'indahpermatasari@pasuruanet.com', '21-12-27', 5, 'Dsn. Kebonsawo, Ds. Keboncandi', '085791172648', 'Aktif', 0, '3515156805940000', '', 1661230285, 'PPPOE', 'kebonsawo_indah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 5, 0, 0, 125000, '', 0, '', 0, 2, 1, 571, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (54, 'Akhmad Jailani', '101020014', 'akhmadjailani@pasuruannet.com', '21-02-27', 5, 'Dsn. Kebonsawo, Ds. Kebon Candi', '082232109282', 'Aktif', 0, '3514180406820010', '', 1661231186, 'PPPOE', 'kebonsawo_jaelani', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 114, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (55, 'Slamet Ngadiono', '101020015', 'ngadiono@pasuruannet.com', '22-08-01', 5, 'Keboncandi', '081556657338', 'Non-Aktif', 0, '3514190411840000', '', 1661231589, 'PPPOE', 'keboncandi_ngadiono', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 604, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (56, 'Baldes Karangtengah', '101010026', 'agusekobaldes@pasuruannet.com', '21-11-19', 5, 'Dsn. Karangtengah, Ds. Karangtengah', '085755805000', 'Non-Aktif', 0, '3514190000000000', '', 1661233667, 'PPPOE', 'karangtengah_baldes', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 22297, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (57, 'Ryan Amrizal', '101040016', 'ryanamrizal@pasuruannet.com', '22-08-12', 5, 'Dsn. Kebonrejo, Ds. Kebunrejo', '082249233834', 'Non-Aktif', 0, '3514230403920000', '', 1661233702, 'PPPOE', '', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 195, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (58, 'Siti Salma', '101040017', 'sitisalma@pasuruannet.com', '22-08-23', 5, 'Dsn. Kebonrejo, Ds. Kebonrejo', '085704390084', 'Non-Aktif', 0, '0', '', 1661233990, 'PPPOE', 'kebonrejo_salma', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 600, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (59, 'Mulyati', '101040018', 'mulyati@pasuruannet.com', '22-08-23', 5, 'Dsn. Menangas, Ds. Menangas', '085804408011', 'Aktif', 0, '0', '', 1661234160, 'PPPOE', 'kebonrejo_mulyati', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 769, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (60, 'M. Samsul Huda', '101040019', 'samsulhuda@pasuruannet.com', '21-07-29', 5, 'Dsn. Kebonrejo, Ds. Kebonrejo', '082245611176', 'Aktif', 0, '3514201802910000', '', 1661234328, 'PPPOE', 'kebonrejo_samsul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 686, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (61, 'Ahmad Yani', '101010027', 'yani@pasuruannet.com', '22-08-01', 5, 'Dsn. Krajan, Ds. Kedungrejo', '088226042553', 'Aktif', 0, '3514190000000000', '', 1661234622, 'PPPOE', 'kedungbanger_yani', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 75, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (62, 'Rohayu', '101040020', 'rohayu@pasuruannet.com', '22-08-23', 5, 'Dsn. Kloto\'an, Ds. Kebonrejo', '085755467935', 'Aktif', 0, '0', '', 1661234666, 'PPPOE', 'kebonrejo_rohayu', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 182, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (63, 'Taufiq', '101040021', 'taufiq@pasuruannet.com', '22-08-23', 5, 'Dsn. Kebonrejo, Ds. Kebonrejo', '081334119582', 'Aktif', 0, '0', '', 1661234780, 'PPPOE', 'kebonrejo_tofik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 677, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (64, 'Umilatul Arofah', '101010028', 'umilatularofah@pasuruannet.com', '22-02-23', 5, 'Dsn. Karangtengah, Ds. Karangtengah', '085607362799', 'Non-Aktif', 0, '3514190000000000', '', 1661238564, 'PPPOE', 'karangtengah_umilatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 549, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (65, 'Ana', '101010029', 'ana@pasuruannet.com', '22-07-31', 5, 'Dsn.Kedungwaru lor, Ds.Kedungwaru', '081231985811', 'Aktif', 0, '0', '', 1661238752, 'PPPOE', 'kedungwaru_anna', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 163, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (66, 'Yulhiyah', '101010030', 'yulhiyah@pasuruannet.com', '21-02-16', 5, 'Dsn. Karangtengah, Ds. Karangtengah', '085607698994', 'Aktif', 0, '3514200000000000', '', 1661239244, 'PPPOE', 'karangtengah_yulhiyah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 348, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (67, 'Rosidi', '101020016', 'rosidiiii@pasuruannet.com', '22-01-26', 5, 'Dsn. Ngemplak Ds. Kersikan', '082232246454', 'Aktif', 0, '3514181203780000', '', 1661240206, 'PPPOE', 'kersikan_rosidi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 267, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (68, 'Hariyanto', '101030001', 'hidayateknik@pasuruannet.com', '22-07-07', 5, 'CV Hidayah Teknik (Rejoso)', '081288862429', 'Non-Aktif', 0, '3514204065820010', '', 1661240273, 'PPPOE', 'kemantren_hidayateknik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 444, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (69, 'Alviyah', '101010031', 'alviyah@pasuruannet.com', '22-08-15', 5, 'Dsn. Kemong, Ds. Lebak', '082231188943', 'Non-Aktif', 0, '3514190000000000', '', 1661240711, 'PPPOE', 'kemong_alviyah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 114, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (70, 'Rosdak', '101010032', 'rosdakk@pasuruannet.com', '22-07-31', 5, 'Dsn. Sidepan, Ds. Kedungwaru Kidul', '081936232339', 'Non-Aktif', 0, '3515130000000000', '', 1661241893, 'PPPOE', 'kedungwaru_rosdak', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 273, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (71, 'Karti', '101020017', 'karti@pasuruannet.com', '22-07-07', 5, 'Dsn. Klodangan, Ds. Wonojati', '085648065124', 'Aktif', 0, '3514185405710000', '', 1661243356, 'PPPOE', 'klodangan_karti', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 478, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (72, 'Abdul Wahab', '101020018', 'abdulwahab@pasuruannet.com', '21-09-04', 5, 'Dsn. Kiringan, Ds. Wonojati', '085173008300', 'Aktif', 0, '3513040506780000', '', 1661245167, 'PPPOE', 'kiringan_wahab', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 42, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (73, 'Brahim', '101010033', 'brahim@pasuruannet.com', '22-08-01', 5, 'Dsn. Kluwes, Ds. Menyarik', '085335301282', 'Non-Aktif', 0, '0', '', 1661304488, 'PPPOE', 'kluwes_brahim', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 208, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (74, 'Ainun Fitria', '101010034', 'rochmatul@pasuruannet.com', '22-08-01', 5, 'Dsn. Kluwes, Ds. Menyarik', '082331524653', 'Non-Aktif', 0, '3514190000000000', '', 1661304790, 'PPPOE', 'kluwes_rochmatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 179, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (75, 'Moh. Rozikin', '101010035', 'rozikin@pasuruannet.com', '22-08-12', 5, 'Dsn. Mulyorejo Lor, Ds. Umbulan', '082223469176', 'Aktif', 0, '3514190000000000', '', 1661305883, 'PPPOE', 'kruyo_rozikin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1038, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (76, 'Arini Hidayati', '101020019', 'arinihidayati@pasuruannet.com', '21-06-22', 5, 'Dsn. Lajuk, Ds. Lajuk', '08813361590', 'Aktif', 0, '3514187010940000', '', 1661307183, 'PPPOE', 'lajuk_arini', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 172, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (77, 'Jumar Arquisola', '101020020', 'jumararquisola@pasuruannet.com', '21-10-05', 5, 'Dsn. Lajuk, Ds. Lajuk', '081555461555', 'Non-Aktif', 0, '3514180503970000', '', 1661307797, 'PPPOE', 'lajuk_jumar', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 471, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (78, 'Nur Jazilah', '101020021', 'jazilah@pasuruannet.com', '22-08-01', 5, 'Dsn. Mantingan, Ds. Tenggilisrejo', '083846826539', 'Non-Aktif', 0, '3514186703980000', '', 1661309887, 'PPPOE', 'mantingan_jazilah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 972, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (79, 'Muhajir', '101020022', 'muhajir@pasuruannet.com', '21-06-23', 5, 'Dsn. Lajuk, Ds. Lajuk', '083194797492', 'Aktif', 0, '0', '', 1661310194, 'PPPOE', 'lajuk_muhajir', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 1248, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (80, 'Shodiq/ Lailiah', '101020023', 'sodik@pasuruannet.com', '22-08-01', 5, 'Dsn. Mantingan, Ds. Tenggilis Rejo', '085604045203', 'Aktif', 0, '0', '', 1661311635, 'PPPOE', 'mantingan_sodik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 122, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (81, 'Tiamah', '101020024', 'tiamah@pasuruannet.com', '22-08-01', 5, 'Dsn. Mantingan, Ds. Tenggilis Rejo', '085791831002', 'Aktif', 0, '0', '', 1661311737, 'PPPOE', 'mantingan_tiamah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 663, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (82, 'Rifan Mukhammad N', '101020025', 'rifanmukhammadn@pasuruannet.com', '21-04-17', 5, 'Dsn. Lodo, Ds. Kalirejo', '083856824551', 'Non-Aktif', 0, '3514182011030000', '', 1661312017, 'PPPOE', 'lodo_rifan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 357, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (83, 'Weni Indarti', '101020026', 'weniindarti@pasuruannet.com', '22-06-04', 5, 'Dsn Lodo Ds.Kalirejo', '0', 'Aktif', 0, '3514235501830000', '', 1661312096, 'PPPOE', 'lodo_weni', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 415, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (84, 'Sochib', '101010036', 'irfanalbab@pasuruannet.com', '21-02-20', 5, 'Dsn. Lebak, Ds. Lebak', '082142080973', 'Aktif', 0, '3514190000000000', '', 1661314122, 'PPPOE', 'lebak_sochib', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 640, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (85, 'Hilyatu Nadhiro', '101020027', 'hilyatunadhiro@paasuruannet.com', '20-12-15', 5, 'Dsn. Masangan, Ds. Tenggilis Rejo', '081232567004', 'Aktif', 0, '3514185706940000', '', 1661318339, 'PPPOE', 'masangan_hilyatu', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 510, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (86, 'Rohmatulloh', '101020028', 'rohmatulloh@pasuruannet.com', '22-02-19', 5, 'Dsn. Masangan, Ds. Tenggilis Rejo', '082123119200', 'Aktif', 0, '3514180404020000', '', 1661319463, 'PPPOE', 'masangan_rohmatulloh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 191, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (87, 'M. Ngadianto', '101040022', 'ngadianto@pasuruannet.com', '22-08-01', 5, 'Dsn. Menangas, Ds. Menangas', '081932684939', 'Aktif', 0, '3514202502730000', '', 1661327597, 'PPPOE', 'menangas_ngadianto', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 671, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (88, 'Fadlul Ridho', '101040023', 'ridho@pasuruannet.com', '22-08-01', 5, 'Dsn.Menangas Wetan Ds.Kebonrejo', '085232566964', 'Aktif', 0, '3514202502980000', '', 1661328197, 'PPPOE', 'menangas_ridho', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 330, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (89, 'M. Sofiyulloh', '101010037', 'sofiyulloh@pasuruannet.com', '21-04-15', 5, 'Dsn. Lebak, Ds. Lebak', '085748614200', 'Aktif', 0, '0', '', 1661329759, 'PPPOE', 'lebak_sofiyulloh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 692, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (90, 'Bakhar', '101010038', 'bakhar@pasuruannet.com', '22-08-01', 5, 'Dsn. Mendalan, Ds. Mendalan', '085233315647', 'Non-Aktif', 0, '0', '', 1661389370, 'PPPOE', 'mendalan_bakhar', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (91, 'Diana Rudyana', '101010039', 'diana@pasuruannet.com', '22-08-01', 5, 'Dsn. Bica\'an Ds. Mendalan', '082112037433', 'Non-Aktif', 0, '3275020000000000', '', 1661390459, 'PPPOE', 'mendalan_diana', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 261, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (92, 'Ach. Rafi', '101010040', 'achrafi@pasuruannet.com', '21-07-03', 5, 'Dsn. Menyarik, Ds. Menyarik (Brintik Lor)', '085859261503', 'Aktif', 0, '3514190000000000', '', 1661391999, 'PPPOE', 'brintiklor_rafi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 17, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (93, 'Huda', '101010041', 'hudaa@pasuruannet.com', '22-08-01', 5, 'Dsn. Mendalan, Ds. Mendalan', '081336704900', 'Non-Aktif', 0, '0', '', 1661392083, 'PPPOE', 'mendalan_huda', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 5, 0, 1, 225000, '', 0, '', 0, 2, 1, 514, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (94, 'Mas Khanin', '101010042', 'khanin@pasuruannet.com', '22-08-01', 5, 'Dsn. Mendalan Ds. Mendalan', '081936936259', 'Aktif', 0, '3514190000000000', '', 1661392272, 'PPPOE', 'mendalan_khanin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 823, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (95, 'Khasan Basri', '101020029', 'khasanbasri@pasuruannet.com', '21-03-09', 5, 'Dsn. Ngepreng, Ds. Wonosari', '085856634916', 'Non-Aktif', 0, '3514181202900000', '', 1661393160, 'PPPOE', 'ngepreng_khasan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 483, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (96, 'Masadi', '101010043', 'masadi@pasuruannet.com', '22-08-01', 5, 'Dsn mendalan Ds. mendalan', '082247236985', 'Non-Aktif', 0, '3514190000000000', '', 1661393664, 'PPPOE', 'mendalan_masadi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 825, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (97, 'Naning Oktafiyah', '101010044', 'naningoktafiyah@pasuruannet.com', '21-04-20', 5, 'Dsn. Pandansari, Ds. Pandanrejo', '085259107715', 'Non-Aktif', 0, '0', '', 1661394345, 'PPPOE', 'ngebras_naning', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 940, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (98, 'Nurul Lailiyah', '101010045', 'nurullailiyah@pasuruannet.com', '22-08-25', 5, 'Dsn. Kletek, Ds. Mendalan', '0', 'Aktif', 0, '0', '', 1661394684, 'PPPOE', 'nurullailiyah_mendalan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 999, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (99, 'Toyib ghojali', '101020030', 'toyibghojali@pasuruannet.com', '22-08-25', 5, 'Dsn. Ngebras, Ds. Ngebras', '082331343966', 'Aktif', 0, '0', '', 1661394779, 'PPPOE', 'ngebras_toyib', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 650, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (100, 'Asriya Ainul', '101010046', 'asriya@pasuruannet.com', '22-08-05', 5, 'Dsn. Kruyo, Ds. Umbulan', '085748496940', 'Non-Aktif', 0, '3514190000000000', '', 1661395892, 'PPPOE', 'minggir_asriya', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 151, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (101, 'Akhmad Afandi', '101030002', 'akhmadafandi@pasuruannet.com', '21-06-07', 5, 'Dsn. Pandanrejo, Ds. Pandanrejo', '081259089707', 'Non-Aktif', 0, '3514231101840000', '', 1661396312, 'PPPOE', 'pandanrejo_afandi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 60, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (102, 'M Rois Nasrudin', '101030003', 'roisnasrudin@pasuruannet.com', '22-03-11', 5, 'Dsn. Pandan Ds. Kebonrejo', '081231574179', 'Aktif', 0, '3514201604970000', '', 1661396715, 'PPPOE', 'pandan_rois', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 601, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (103, 'Siti Romlah', '101030004', 'sitiromlah@pasuruannet.com', '22-05-10', 5, 'Dsn. Pandan , Ds. Kebonrejo', '082139910556', 'Aktif', 0, '3514204908690000', '', 1661396854, 'PPPOE', 'pandan_romlah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 595, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (104, 'Siti Jamila', '101030005', 'sitijamilah@pasuruannet.com', '22-04-06', 5, 'Dsn. Pandansari, Ds. Pandan Rejo', '083132684944', 'Non-Aktif', 0, '3514235103730000', '', 1661397555, 'PPPOE', 'pandansari_jamilah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 70, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (105, 'Akhmad Makhbubillah', '101010047', 'makhbubillah@pasuruannet.com', '21-09-11', 5, 'Dsn. Minggir, Ds. Minggir', '085730348716', 'Non-Aktif', 0, '3514190000000000', '', 1661397608, 'PPPOE', 'minggir_mahbubillah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 120, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (106, 'Minatu Zahro', '101010048', 'zahro@pasuruannet.com', '22-08-01', 5, 'Dsn. Mendalan Ds. Mendalan', '085334190570', 'Aktif', 0, '3514190000000000', '', 1661397667, 'PPPOE', 'mendalan_zahro', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 858, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (107, 'Moh. Muslikh', '101010049', 'mokhmuslikh@pasuruannet.com', '21-09-14', 5, 'Dsn. Minggir, Ds. Minggir', '085730829535', 'Aktif', 0, '3514190000000000', '', 1661398045, 'PPPOE', 'minggir_muslikh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 1047, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (108, 'Muhammad Mujib', '101020031', 'muhammadmujib@pasuruannet.co', '22-01-14', 5, 'Dsn. Macan Putih, Ds. Pekangkungan ', '082245510071', 'Aktif', 0, '3514222908880000', '', 1661398269, 'PPPOE', 'pekangkungan_mujib', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 838, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (109, 'Sulaiman', '101010050', 'sulaimann@pasuruannet.com', '22-08-25', 5, 'Dsn. Pandean, Ds. Winongan Kidul', '085731191545', 'Non-Aktif', 0, '0', '', 1661398446, 'PPPOE', 'pandean_sulaiman', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 729, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (110, 'Abd. Rokhim', '101010051', 'abdrokhim@pasuruannet.com', '22-07-07', 5, 'Dsn. minggir, Ds. Minggir', '085755705865', 'Non-Aktif', 0, '3514190000000000', '', 1661399357, 'PPPOE', 'minggir_rokhim', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (111, 'M. Munib Umar', '101020032', 'munibumar@pasuruannet.com', '21-03-06', 5, 'Dsn. Pateguhan, Ds. Pateguhan', '081232308008', 'Aktif', 0, '3514182008710000', '', 1661399591, 'PPPOE', 'pateguhan_munib', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 665, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (112, 'Selamet', '101010052', 'selamat@pasuruannet.com', '21-11-13', 5, 'Dsn. Minggir, Ds. Minggir', '085730929150', 'Non-Aktif', 0, '3514190000000000', '', 1661399851, 'PPPOE', 'minggir_slamet', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 129, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (113, 'Sholehudin', '101020033', 'solehudin@pasuruannet.com', '22-07-16', 5, 'Dsn. Pateguhan, Ds. Pateguhan', '083873079771', 'Aktif', 0, '3514180505840000', '', 1661400302, 'PPPOE', 'pateguhan_sholehudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 119, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (114, 'Zainul Alim', '101010053', 'zainulalimminggir@pasuruannet.com', '21-05-31', 5, 'Dsn. Getahlor, Ds. Minggir', '085785854860', 'Non-Aktif', 0, '3514190000000000', '', 1661400343, 'PPPOE', 'minggir_zainul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 284, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (115, 'Shon Haji', '101020034', 'shonhaji@pasuruannet.com', '22-04-09', 5, 'Dsn. Sarirejo Ds. Pateguhan', '085859944006', 'Non-Aktif', 0, '3514181812820000', '', 1661400691, 'PPPOE', 'pateguhan_sonhaji', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 117, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (116, 'Muzayin', '101020035', 'muzayin@pasuruannet.com', '21-03-13', 5, 'Dsn. Plalangan, Ds. Wonojati', '0', 'Aktif', 0, '3514182308820000', '', 1661403331, 'PPPOE', 'plalangan_muzayin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1028, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (117, 'Saiful', '101010054', 'saiful@pasuruannet.com', '22-08-19', 5, 'Dsn. Putat, Ds. Penataan', '085855295092', 'Non-Aktif', 0, '3514190000000000', '', 1661411296, 'PPPOE', 'putat_saiful', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (118, 'Eko Wijang Purnomo', '101020036', 'ekowijangpurnomo@pasuruannet.com', '21-12-22', 5, 'Dsn. Sidodadi, Ds. Puncangro (Ranggeh)', '083833141986', 'Aktif', 0, '3517020705860000', '', 1661412124, 'PPPOE', 'ranggeh_eko', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 312, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (119, 'Abdul Ghofur', '101040024', 'abdulghofur@pasuruannet.com', '21-10-25', 5, 'Dsn. Rebalas, Ds. Rebalas', '085852778977', 'Non-Aktif', 0, '3514200506820000', '', 1661412245, 'PPPOE', 'rebalas_ghofur', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 29, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (120, 'Mujiono', '101040025', 'mujiono@pasuruannet.com', '21-10-11', 5, 'Dsn. Randukerto. Ds. Rebalas', '085707109974', 'Non-Aktif', 0, '3514200610740000', '', 1661412387, 'PPPOE', 'rebalas_mujiono', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 1011, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (121, 'Ali Muntaha', '101020037', 'alimuntaha@pasuruannet.com', '22-01-28', 5, 'Dsn. Rojo Gunting, Ds. Kalirejo', '085853249185', 'Aktif', 0, '3514180210930000', '', 1661414313, 'PPPOE', 'rojogunting_muntaha', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 140, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (122, 'Nur Kholifah', '101010055', 'nurkholidfahprodo@pasuruane5t.com', '21-09-11', 5, 'Dsn. Prodo, Ds. Prodo', '08563053882', 'Aktif', 0, '3514200000000000', '', 1661414463, 'PPPOE', 'prodo_kholifah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 975, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (123, 'Syarifuddin', '101020038', 'syarifuddin@pasuruannet.com', '21-03-15', 5, 'Dsn. Rojogunting, Ds. Kalirejo', '082332171331', 'Non-Aktif', 0, '3514183011900000', '', 1661414826, 'PPPOE', 'rojogunting_syarifuddin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 818, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (124, 'Sucipto', '101010056', 'sucipto@pasuruiannet.com', '21-12-22', 5, 'Dsn. Ledok, Ds. Prodo', '081334335999', 'Aktif', 0, '3514190000000000', '', 1661415108, 'PPPOE', 'prodo_sucipto', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 721, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (125, 'Sahrul Basori', '101010057', 'sahrulbasori@pasuruannet.com', '22-07-31', 5, 'Dsn. Prodo, Ds. Prodo', '083834302849', 'Aktif', 0, '3514190000000000', '', 1661415221, 'PPPOE', 'prodo_sahrul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 186, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (126, 'Alfiatul Jannah', '101020039', 'alfiatul@pasuruannet.com', '21-12-14', 5, 'Dsn. Krajan, Ds. Sekarputih', '085746310877', 'Non-Aktif', 0, '3514184201960000', '', 1661416290, 'PPPOE', 'sekarputih_alfiatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 147, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (127, 'Aminatuz Zuhro', '101020040', 'aminatuz@pasuruannet.com', '22-08-05', 5, 'Dsn. Bendo, Ds. Sekarputih', '085859340970', 'Non-Aktif', 0, '3514185111880000', '', 1661416422, 'PPPOE', 'sekarputih_aminatuz', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 161, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (128, 'Novy Rosianti', '101020041', 'novyrosianti@pasuruannet.com', '21-01-07', 5, 'Dsn. Kebonsawo, Ds. Tenggilis', '082232721855', 'Aktif', 0, '3514186202960000', '', 1661416435, 'PPPOE', 'sawo_novi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 958, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (129, 'Mufidatul Islamiya', '101030006', 'mufidatul@pasuruannet.com', '21-02-09', 5, 'Dsn. Sadengrejo, Ds. Sadengrejo', '083119065630', 'Aktif', 0, '3514235006820010', '', 1661416633, 'PPPOE', 'sadeng_mufidatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 846, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (130, 'Lailatul Hikmah', '101010058', 'lailayulhikmah@pasuruannet.com', '22-04-30', 5, 'Dsn. Seloliman, Ds. Sruwi', '082229948913', 'Aktif', 0, '3575010000000000', '', 1661416848, 'PPPOE', 'seloliman_lailatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 394, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (131, 'M. Khisom', '101020042', 'khisomsekarputih@pasuruannet.com', '21-01-16', 5, 'Dsn. Sekarputih, Ds. Sekarputih', '085745996934', 'Aktif', 0, '3514182402930000', '', 1661417579, 'PPPOE', 'sekarputih_khisom', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 655, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (132, 'Nur Kholis', '101020043', 'nurkholissekarputih@pasuruannet.com', '22-06-24', 5, 'Dsn. Triwung, Ds. Sekar Putih', '082257003448', 'Non-Aktif', 0, '3514182809780000', '', 1661417885, 'PPPOE', 'sekarputih_kholis', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 978, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (133, 'Subaida', '101020044', 'subaidasekarputih@pasuruannet.com', '21-09-11', 5, 'Dsn. Sekarputih, Ds. Sekarputih', '088989070469', 'Non-Aktif', 0, '3514184808880000', '', 1661418402, 'PPPOE', 'sekarputih_subaidah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 713, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (134, 'Sukriyah', '101020045', 'sukriyah@pasuruannet.com', '21-10-23', 5, 'Dsn. Bendo, Ds. Sekarputih', '083825450381', 'Non-Aktif', 0, '3514184206880000', '', 1661418634, 'PPPOE', 'sekarputih_sukriyah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 726, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (135, 'Ana Yasmi', '101030007', 'anayasmi@pasuruannet.com', '21-05-06', 5, 'Dsn. Sadengrejo, Ds. Sadengrejo', '083899771992', 'Non-Aktif', 0, '3514204611820000', '', 1661418751, 'PPPOE', 'sadeng_yasmi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 165, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (136, 'Soleh', '101020046', 'solehsekarputih@pasuruannet.com', '22-02-25', 5, 'Dsn. Trewung, Ds. Sekarputih', '081374737855', 'Non-Aktif', 0, '3514162112850000', '', 1661418845, 'PPPOE', 'sekarputih_soleh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 623, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (137, 'Zainul Arifin', '101030008', 'zainularifin@pasuruannet.com', '21-02-13', 5, 'Dsn. Sadengrejo, Ds. Sadengrejo', '082334435102', 'Aktif', 0, '3514233005800000', '', 1661418968, 'PPPOE', 'sadeng_zainul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 302, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (138, 'Solikhin', '101010059', 'solihin@pasuruannet.com', '22-08-01', 5, 'Dsn. Serambi, Ds. Winongan Kidul', '081358507759', 'Aktif', 0, '3514190000000000', '', 1661477776, 'PPPOE', 'serambi_solihin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 630, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (139, 'Muslikhin', '101020047', 'muslikhin@pasuruannet.com', '21-01-26', 5, 'Dsn. Wonosalam, Ds. Wonosalam', '081259074293', 'Aktif', 0, '3514180812680000', '', 1661479024, 'PPPOE', 'wonosalam_muslikhin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 783, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (140, 'Mariyam', '101020048', 'mariyammm@pasuruannet.com', '20-11-16', 5, 'Dsn. Wonosalam Timur, Ds. Wonosari', '085859322966', 'Aktif', 0, '3514187001650000', '', 1661479415, 'PPPOE', 'wonosalam_mariyam', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 820, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (141, 'Badrudin', '101010060', 'badrudin@pasuruannet.com', '21-03-29', 5, 'Dsn.Wulu, Ds. Mendalan', '081217953979', 'Aktif', 0, '3514190000000000', '', 1661479906, 'PPPOE', 'wulu_badruddin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 202, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (142, 'Ririn Ulfi Dianasari', '101010061', 'ririnulfidianasari@pasuruannet.com', '21-03-24', 5, 'Dsn. Wulu Ds. Mendalan', '085806696588', 'Aktif', 0, '0', '', 1661480458, 'PPPOE', 'wulu_ririn', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 334, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (143, 'Karimatul Arofah', '101030009', 'karimatularafah@pasuruannet.com', '22-02-10', 5, 'Dsn. Kedungbendo, Ds. Rejoso lor (tunjungan)', '08155554788', 'Aktif', 0, '3514195805960000', '', 1661480676, 'PPPOE', 'tunjungan_karimatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 477, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (144, 'Didik Sulaiman', '101020049', 'didiksulaiman@pasuruannet.com', '22-08-26', 5, 'Dsn. Wonosalam, Ds. Wonosalam', '087853523589', 'Non-Aktif', 0, '0', '', 1661480758, 'PPPOE', 'wonosalam_didik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 279, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (145, 'Rohma/Fikri', '101010062', 'romafikri@pasuruannet.com', '20-08-12', 5, 'Dsn. Tunjungan, Ds. Mendalan', '0', 'Aktif', 0, '0', '', 1661480801, 'PPPOE', 'tunjungan_fikri', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 183, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (146, 'Sri Anik', '101020050', 'srianik@pasuruannet.com', '21-12-30', 5, 'Dsn. Wonosalam Timur, Ds. Wonosari', '083834358569', 'Aktif', 0, '3514184204770000', '', 1661481015, 'PPPOE', 'wonosalam_anik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 636, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (147, 'Anwar', '101030010', 'anwar@pasuruannet.com', '22-08-01', 5, 'Dsn. suklan, Ds. Pandanrejo', '08383583295', 'Non-Aktif', 0, '0', '', 1661481292, 'PPPOE', 'suklan_anwar', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 183, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (148, 'Nur Kholis', '101010063', 'nurkholis@pasuruannet.com', '22-04-15', 5, 'Dsn. Gading Ds. Winongan(wonojati)', '082230400065', 'Non-Aktif', 0, '3514190000000000', '', 1661481590, 'PPPOE', 'wonojati_nurkholis', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 977, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (149, 'Ernawati Andayani', '101030011', 'ernawati@pasuruannet.com', '22-08-01', 5, 'Dsn. Suklan, Ds. Pandanrejo', '081233121208', 'Aktif', 0, '3514235312700000', '', 1661481614, 'PPPOE', 'suklan_ernawati', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 323, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (150, 'Fikri Mustofa', '101030012', 'fikrimustofa@pasuruannet.com', '21-06-29', 5, 'Dsn. Bendo, Ds. Winongan Kidul', '085766453900', 'Aktif', 0, '3514190208010000', '', 1661481859, 'PPPOE', 'winongan_fikri', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 411, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (151, 'Ali Imron Rosyadi', '101030013', 'imroon@pasuruannet.com', '22-08-01', 5, 'Dsn. Pandannsari, Ds. Pandanrejo', '085236068837', 'Non-Aktif', 0, '3514230606800000', '', 1661481933, 'PPPOE', 'suklan_imron', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 141, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (152, 'Junaidi', '101020051', 'junaidiii@pasuruannet.com', '20-12-21', 5, 'Dsn. Wonojati, Ds. Wonojati', '082180989700', 'Aktif', 0, '3514180101810020', '', 1661482339, 'PPPOE', 'wonojati_junaidi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 472, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (153, 'Deby Firmansyah', '101020052', 'debyfirmansyah@pasuruannet.com', '22-03-28', 5, 'Dsn. Wonojati, Ds. Gondangwetan', '085604116802', 'Non-Aktif', 0, '3514182810010000', '', 1661482771, 'PPPOE', 'wonojati_deby', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 240, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (154, 'Nasor', '101030014', 'nasor@pasuruannet.com', '22-08-01', 5, 'Dsn. Suklan, Ds. Pandanrejo', '085212740593', 'Non-Aktif', 0, '3514230312780000', '', 1661482854, 'PPPOE', 'suklan_nasor', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 943, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (155, 'Ngadi', '101030015', 'ngadi@pasuruannet.com', '22-08-01', 5, 'Dsn. Suklan, Ds. Pandanrejo', '081931880911', 'Aktif', 0, '0', '', 1661482937, 'PPPOE', 'suklan_ngadi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 945, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (156, 'M. Baidowi', '101020053', 'baidowiiiiiii@pasuruannet.com', '20-12-07', 5, 'Dsn. Wonojati, Ds. Wonojati', '085655838544', 'Non-Aktif', 0, '3514182005830000', '', 1661482970, 'PPPOE', 'wonojati_baidowi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 612, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (157, 'Yatimah', '101010064', 'yatimah@pasuruannet.com', '22-03-29', 5, 'Dsn. Werakas, Ds. Penataan', '082199649172', 'Aktif', 0, '3514200000000000', '', 1661482993, 'PPPOE', 'werakas_yatimah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 406, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (158, 'Solimah', '101010065', 'solimah@pasuruannet.com', '22-08-01', 5, 'Dsn. Suklan, Ds. Pandanrejo', '085233179980', 'Aktif', 0, '3514240000000000', '', 1661483404, 'PPPOE', 'suklan_solimah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 6, 0, 0, 125000, '', 0, '', 0, 2, 1, 634, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (159, 'Abdulloh', '101010066', 'abbdulloh@pasuruannet.com', '20-12-19', 5, 'Dsn. Panci\'an, Ds. Winongan Lor', '082245197996', 'Non-Aktif', 0, '3514190000000000', '', 1661484064, 'PPPOE', 'winonganlor_abdulloh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 53, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (160, 'Ana Sofia', '101020054', 'anasofia@pasuruannet.com', '20-11-12', 5, 'Dsn. Wonosari, Ds. Wonosari', '0895628101674', 'Non-Aktif', 0, '0', '', 1661484227, 'PPPOE', 'wonosari_anasofia', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (161, 'Syaifudin Zuhri', '101010067', 'zzuhri@pasuruannet.com', '22-08-01', 5, 'Dsn. Suklan, Ds. Pandanrejo', '085235260111', 'Aktif', 0, '0', '', 1661484264, 'PPPOE', 'suklan_zuhri', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 273, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (162, 'M. Aly Mukhdor', '101020055', 'aliy@pasuruannet.com', '22-08-01', 5, 'tenggilis', '082232381471', 'Non-Aktif', 0, '3514182308860000', '', 1661484399, 'PPPOE', '', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 608, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (163, 'Anis Naslikha', '101020056', 'anisnaslikha@PASURUANNET.COM', '22-11-25', 5, 'Dsn. Kili, Ds. Wonosari', '085855885119', 'Aktif', 0, '3514165706930010', '', 1661484430, 'PPPOE', 'wonosari_anisa', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 183, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (164, 'Sulistiana', '101010068', 'sulistiana@pasuruannet.com', '22-08-13', 5, 'Dsn. Seloliman, Ds. Sruwi', '085807106663', 'Aktif', 0, '3514190000000000', '', 1661484626, 'PPPOE', 'sruwi_sulistiana', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 733, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (165, 'Farida', '101020057', 'farida@pasuruannet.com', '22-08-01', 5, 'Dsn Tenggilis, Ds. Tenggilis', '085733379078', 'Aktif', 0, '0', '', 1661484921, 'PPPOE', 'tenggilis_farida', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 0, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 348, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (166, 'Muhammad Zainul Farid', '101010069', 'muhammadzainlfahid@pasuruannt.com', '20-12-22', 5, 'Dsn. Junggalang, Ds. Winongan Lor', '082335373322', 'Aktif', 0, '3514190000000000', '', 1661485073, 'PPPOE', 'winonganlor_fahid', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 17, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (167, 'Supriatin', '101070001', 'supriatin@pasuruannet.com', '22-08-17', 5, 'Dsn. Sidogiri, Ds. Sidogiri', '0895324507984', 'Non-Aktif', 0, '3514164203650010', '', 1661486877, 'PPPOE', 'sidogiri_supriatin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 749, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (168, 'H. Abd. Rochman M.', '101020058', 'rochman@pasuruannet.com', '22-07-12', 5, 'Dsn. Tampung, Ds. Kalirejo', '081230680859', 'Non-Aktif', 0, '3514181005820000', '', 1661486947, 'PPPOE', 'tampung_rokhman', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 457, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (169, 'Rois', '101010070', 'rois@pasuruannet.com', '20-09-14', 5, 'Dsn. Tokwiro, Ds. Winongan Lor', '082264053041', 'Aktif', 0, '0', '', 1661487051, 'PPPOE', 'toxwiro_rois', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 275, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (170, 'Mochamad Ulfi Sulthon', '101020059', 'ulfi@pasuruannet.com', '22-08-01', 5, 'Tenggilis ', '083343391653', 'Non-Aktif', 0, '3514011608010000', '', 1661487073, 'PPPOE', 'tenggilis_ulfi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 1048, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (171, 'Yahya', '101020060', 'yahyaa@pasuruannet.com', '22-08-01', 5, 'Dsn. Tenggilis, Ds. Tenggilisrejo', '085748496769', 'Non-Aktif', 0, '3514182103810000', '', 1661487152, 'PPPOE', 'tenggilis_yahya', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 364, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (172, 'Sofyan sauri', '101010071', 'sofyansauri@pasuruannet.com', '22-08-26', 5, 'Dsn. Jungalang. Ds. Winonganlor', '081233404648', 'Aktif', 0, '0', '', 1661487399, 'PPPOE', 'winonganlor_sofyan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 616, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (173, 'Ahmad Wageyanto', '101010072', 'wageyanto@pasuruannet.com', '21-03-02', 5, 'Dsn. Toxwiro, Ds. Winongan Lor', '083835516022', 'Non-Aktif', 0, '3514190000000000', '', 1661487534, 'PPPOE', 'toxwiro_wageyanto', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (174, 'Shobir', '101030016', 'sobir@pasuruannet.com', '22-08-01', 5, 'Dsn. Ketegan, Ds. Ketegan', '085100943322', 'Aktif', 0, '0', '', 1661487544, 'PPPOE', 'taunan_sobir', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 125, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (175, 'Muhammad Makhsun', '101020061', 'mukhammadmakhsun@pasuruannet.com', '21-02-23', 5, 'Dsn. Tampung, Ds. Kalirejo', '083129108826', 'Non-Aktif', 0, '3514180806820000', '', 1661487549, 'PPPOE', 'tampung_makhsun', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 834, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (176, 'Akhmad Sokhib', '101010073', 'akhmadsokhib@pasuruannet.com', '20-12-22', 5, 'Dsn. Bendo, Ds. Winongan Lor', '082337435553', 'Non-Aktif', 0, '3514190000000000', '', 1661487593, 'PPPOE', 'winonganlor_sokhib', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 137, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (177, 'Wahyudi', '101010074', 'wahyudii@pasuruannet.com', '20-12-26', 5, 'Dsn. Toxwiro, Ds. Winongan Lor', '082228813030', 'Aktif', 0, '3514190000000000', '', 1661487867, 'PPPOE', 'toxwiro_wahyudi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 433, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (178, 'Mukhammad Soleh', '101010075', 'mukhammadsoleeh@pasuruannet.com', '21-12-25', 5, 'Dsn. Bendo, Ds. Winongan Lor', '082257098375', 'Non-Aktif', 0, '3514190000000000', '', 1661487876, 'PPPOE', 'winonganlor_soleh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 756, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (179, 'Susanti', '101010076', 'susantii@pasuruannet.com', '20-12-19', 5, 'Dsn. Panci\'an, Ds. Winongan Lor', '082135046930', 'Aktif', 0, '3516120000000000', '', 1661488056, 'PPPOE', 'winonganlor_susanti', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 750, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (180, 'Yeny Puji Astutik', '101010077', 'yenypujiastutik@pasuruannet.com', '21-09-21', 5, 'Dsn. Toxwiro, Ds. Winongan Lor', '083833197689', 'Aktif', 0, '3514200000000000', '', 1661488088, 'PPPOE', 'toxwiro_yeni', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 356, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (181, 'Shon haji Abd. Wahid', '101020062', 'abdwahid@pasuruannet.com', '21-02-08', 5, 'Dsn. Wonosari, Ds. Wonosari', '085174080706', 'Aktif', 0, '0', '', 1661488569, 'PPPOE', 'wonosari_wahid', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 116, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (182, 'Muhammad Hasanudin', '101050001', 'hasanudin@pasuruannet.com', '22-08-09', 5, 'Dsn. Baba\'an, Ds. Tugurejo', '081331258394', 'Non-Aktif', 0, '3506252109860000', '', 1661488629, 'PPPOE', 'umbulan_hasanudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 1244, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (183, 'Sri Wahyuni', '101010078', 'sriwahyunii@pasuruannet.com', '20-12-22', 5, 'Dsn. Bendo, Ds. Winongan Lor', '085104676288', 'Aktif', 0, '3514190000000000', '', 1661488672, 'PPPOE', 'winonganlor_wahyuni', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 641, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (184, 'Santi Dewi Lestari', '101020063', 'santidewilestari@pasuruannet.com', '21-01-12', 5, 'Dsn. Rerate, Ds. Karangsentul', '083835132521', 'Aktif', 0, '3575016111960000', '', 1661488691, 'PPPOE', 'terate_santi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 135, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (185, 'Rifatul Zakiya', '101020064', 'rifiatulzakiya@pasuruannet.com', '22-07-25', 5, 'Dsn. Terate, Ds. Karang Sentul', '085732002804', 'Aktif', 0, '3514186910020000', '', 1661488816, 'PPPOE', 'terate_rifatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 351, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (186, 'Makiatul Madania', '101020065', 'makiatulmadania@pasuruannet.com', '21-08-03', 5, 'Dsn. Terate, Ds. Karangsentul', '08383527821', 'Non-Aktif', 0, '3514185003990000', '', 1661489060, 'PPPOE', 'terate_makiatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 740, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (187, 'Luluk Niswatin', '101020066', 'lulukniswatin@pasuruannet.com', '20-12-02', 5, 'Dsn. Kili, Ds. Wonosari', '081252646378', 'Aktif', 0, '3514185212890000', '', 1661489178, 'PPPOE', 'wonosari_luluk', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 582, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (188, 'Siti Juwariyah', '101020067', 'sitijuwariyah@pasuruannet.com', '21-01-27', 5, 'Dsn. Terate, Ds. Karangsentul', '083111022078', 'Aktif', 0, '3575035912800000', '', 1661489180, 'PPPOE', 'terate_juwariyah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 66, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (189, 'Lutfi Hasyim', '101020068', 'lutfihasyim@pasuruannet.com', '20-12-02', 5, 'Dsn. Kili, Ds. Wonosari', '085102661914', 'Non-Aktif', 0, '3514180106710010', '', 1661489353, 'PPPOE', 'wonosari_lutfi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 587, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (190, 'Jainal', '101020069', 'jainal@pasuruannet.com', '22-08-26', 5, 'Dsn. Terate, Ds. Karangsentul', '085859059472', 'Aktif', 0, '0', '', 1661489387, 'PPPOE', 'terate_jaenal', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 516, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (191, 'Hj. Juar Manis Lili Dewi', '101020070', 'juarmaniswonosari@pasuruannet.com', '20-11-09', 5, 'Dsn.Wonosari', '0895396132083', 'Aktif', 0, '3514181819870000', '', 1661489619, 'PPPOE', 'wonosari_dewi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 516, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (192, 'Solihin Abdi', '101010079', 'solihinabdi@pasuruannet.com', '22-06-26', 5, 'Dsn. Mulyorejo kidul, Ds. Umbulan', '082337838194', 'Aktif', 0, '3514190000000000', '', 1661489690, 'PPPOE', 'umbulan_solihin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (193, 'Ali Usman', '101040026', 'aliiiusman@pasuruannet.com', '21-08-11', 5, 'Dsn. Trewung, Ds. Trewung', '085850468588', 'Non-Aktif', 0, '3514170511840000', '', 1661489715, 'PPPOE', 'trewong_usman', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 2, 1, 123, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (194, 'Ikhwan', '101010080', 'ikhwansukun@pasuruannet.com', '22-08-26', 5, 'Dsn. Sukun, Ds. Mendalan', '085608177126', 'Aktif', 0, '0', '', 1661490022, 'PPPOE', 'sukun_ikhwan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 528, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (195, 'Iskhak', '101010081', 'iskhak@pasuruannet.com', '20-06-11', 5, 'Dsn. Sukun, Ds. Mendalan', '081333947195', 'Aktif', 0, '', '', 1661490144, 'PPPOE', 'sukun_iskhak', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 562, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (196, 'Rifatul Fitria', '101020071', 'rifatulfitria@pasuruannet.com', '20-12-02', 5, 'Dsn. Kili, Ds. Wonosari', '0895627067224', 'Non-Aktif', 0, '3514186306840000', '', 1661490284, 'PPPOE', 'wonosari_fitria', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 354, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (197, 'Siti Fatimah', '101020072', 'fatimahwonosari@pasuruannet.com', '20-11-28', 5, 'Dsn. Wonosari, Ds. Wonosari', '082334873851', 'Non-Aktif', 0, '3514215611880000', '', 1661490392, 'PPPOE', 'wonosari_fatimah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 120000, '', 0, '', 0, 2, 1, 74, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (198, 'Khilmatus Solikha / Khilyatu', '101010082', 'khilyatu@pasuruannet.com', '20-04-11', 5, 'Dsn. Sukun, Ds. Mendalan', '087856725152', 'Aktif', 0, '3514200000000000', '', 1661490473, 'PPPOE', 'sukun_nurhidayati', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 485, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (199, 'Sodikin', '101010083', 'sodikin@pasuruannet.com', '22-08-01', 5, 'Dsn. Sukun, Ds. Mendalan', '081907319887', 'Aktif', 0, '3514140000000000', '', 1661490567, 'PPPOE', 'sukun_saichon', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 608, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (200, 'Saifuddin', '101010084', 'saifuddin@pasuruannet.com', '22-08-01', 5, 'Dsn. Sukun, Ds. Mendalan', '081216532344', 'Aktif', 0, '3514190000000000', '', 1661490651, 'PPPOE', 'sukun_saifuddin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 166, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (201, 'Fatimah Zahro', '101010085', 'fatimahzzahro@pasuruannet.com', '22-08-01', 5, 'Dsn. Sukun, Ds. Mendalan', '0', 'Aktif', 0, '0', '', 1661491114, 'PPPOE', 'sukun_zahro', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 405, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (202, 'Sofiyah (pak khoiron)', '101020073', 'sofiawonosari@pasuruannet.com', '20-11-05', 5, 'Dsn. Wonosari, Ds. Womosari', '085732029342', 'Aktif', 0, '3514186304720000', '', 1661491145, 'PPPOE', 'wonosari_sofia', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 611, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (203, 'Mokhamad Slamet', '101020074', 'mokhamadslamet@pasuruannet.com', '20-12-21', 5, 'Dsn. Wonosari, Ds. Wonosari', '083830309245', 'Aktif', 0, '3514192606920000', '', 1661491410, 'PPPOE', 'wonosari_slamet', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 867, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (204, 'Sarofah', '101020075', 'sarofahwonosari@pasuruannet.com', '21-12-06', 5, 'Dsn. kili tengah, Ds. Wonosari', '0813955792406', 'Non-Aktif', 0, '3514074504800000', '', 1661491518, 'PPPOE', 'wonosari_sarofah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 131, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (205, 'Susanto', '101020076', 'susantowonosari@pasuruannet.com', '21-01-09', 5, 'Dsn. Wonosari, Desa Wonosari', '0895336391118', 'Aktif', 0, '0', '', 1661491630, 'PPPOE', 'wonosari_susanto', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 810, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (206, 'Miftahul Jannah', '101020077', 'miftahulwonosari@pasuruannet.com', '21-02-15', 5, 'Dsn. Kili tengah, Ds. Wonosari', '081330384206', 'Aktif', 0, '3514185604830000', '', 1661492003, 'PPPOE', 'wonosari_miftahul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 850, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (207, 'Muwafiki Maulana', '101020078', 'muwafikimaulana@pasuruannet.com', '20-01-14', 5, 'Dsn. Kili Barat, Ds. Wonosari', '081548447237', 'Non-Aktif', 0, '3514180211990000', '', 1661492348, 'PPPOE', 'wonosari_maulana', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 1026, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (208, 'Maimunah', '101020079', 'maimunawonosari@pasuruannet.com', '20-12-14', 5, 'Dsn. Kili Barat, Ds. Wonosari', '085804065943', 'Non-Aktif', 0, '3514184607550000', '', 1661492487, 'PPPOE', 'wonosari_maimunah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 738, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (209, 'Kanzul Fikri', '101020080', 'kanzulfikri@pasuruannet.com', '21-08-31', 5, 'Dsn. Kili Timur, Ds. Wonosari', '0895800445327', 'Non-Aktif', 0, '3514180202950000', '', 1661498957, 'PPPOE', 'wonosari_kanzul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 476, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (210, 'Fahrur Rosi', '101020081', 'fahrurrosad@pasuruannet.com', '20-11-27', 5, 'Dsn. Kili, Ds. Wonosari', '082330777571', 'Aktif', 0, '3514181903020000', '', 1661499372, 'PPPOE', 'wonosari_rosi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 338, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (211, 'Runi', '101020082', 'runi@pasuruannet.com', '21-01-04', 5, 'Dsn. Kili Tengah, Ds. Wonosari', '085790420951', 'Aktif', 1, '0', '', 1661499474, 'PPPOE', 'wonosari_runi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 200, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (212, 'Dewi Indarwati', '101010086', 'dewiindrawati@pasuruannet.com', '22-08-27', 5, 'Dsn. Gendol, Ds. Gendol', '081553895971', 'Non-Aktif', 0, '3514200000000000', '', 1661566913, 'PPPOE', 'gendol_dewi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 248, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (213, 'M. Saiful Atim', '101030017', 'saifulatim@pasuruannet.com', '22-08-27', 5, 'Dsn. Sadengrejo, Ds. Sadengrejo', '083856988745', 'Non-Aktif', 0, '3514181507890000', '', 1661567872, 'PPPOE', 'sadeng_atim', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 687, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (214, 'Putri Wahyuningsih', '101020083', 'putriwahyuningsih@pasuruannet.com', '22-08-25', 5, 'Dsn. Kebonrejo, Ds. Kebunrejo', '085855728216', 'Aktif', 0, '3514205209960000', '', 1661568785, 'PPPOE', 'kebonrejo_putri', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '30 Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 2, 1, 317, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (215, 'Suwandi', '101010087', 'suwandi@pasuruannet.com', '22-08-01', 5, 'Balun', '081252050524', 'Aktif', 0, '0', '', 1661572181, 'PPPOE', 'balun_suwandi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (216, 'Ismatul Faizah', '101040027', 'ismaa@pasuruannet.com', '22-08-01', 5, 'karangkliwon', '085730121698', 'Aktif', 0, '0', '', 1661661418, 'PPPOE', 'karangkliwon_isma', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 565, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (217, 'Gatut susiyanto, ST', '101010088', 'gatutsusiyanto@pasuruannet.com', '22-08-01', 5, 'Dsn. Kletek Lor, Ds. Mendalan', '081333780672', 'Aktif', 0, '3514190000000000', '', 1661827854, 'PPPOE', 'mendalan_gatot', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 1, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 29, 1, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (218, 'Akhmad Ali', '101020084', 'akhmadali@pasuruannet.com', '22-09-01', 5, 'Dsn. Mantingan, Ds. Tenggilisrejo', '085730828913', 'Aktif', 0, '3514182209810000', '', 1662167723, 'PPPOE', 'mantingan_ali', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 883, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (219, 'Toni Hermanto', '101020085', 'Moh.Diyanisyaifudin@pasuruannet.com', '22-09-07', 5, 'Bendo Sekarputih', '085816122913', 'Non-Aktif', 0, '3575011709840000', '', 1663553352, 'PPPOE', 'sekarputih_toni', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 892, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (220, 'Fajar (Wajak)', '101010089', 'fajarwajak@pasuruannet.com', '22-09-22', 5, 'Ketondo', '0', 'Non-Aktif', 0, '0', '', 1663812089, 'PPPOE', 'ketondo_wajak', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (221, 'Khasan bisri', '101010090', 'bisrirekesan@pasuruannet.com', '22-08-27', 5, 'Dsn. Rekesan, Ds. Sruwi', '082330437138', 'Aktif', 0, '0', '', 1664524643, 'PPPOE', 'rekesan_bisri', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 464, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (222, 'Ady Setyono / MI Wulu', '101010091', 'miwulu@pasuruannet.com', '22-10-03', 5, 'MI WULU', '08814983090', 'Non-Aktif', 0, '0', '', 1664864924, 'PPPOE', 'wulu_mi', 0, 1, 0, 'KTP', 1, 1, 0, '', '', '1,5M', 0, 0, 0, 0, 0, 0, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (223, 'Siti Maisaroh', '101010092', 'sitimaisarohhhh@pasuruannet.com', '22-10-11', 5, 'Dsn. Nyangkring, Ds. Menyarik', '085335599238', 'Aktif', 0, '3514200000000000', '', 1666404350, 'PPPOE', 'nyangkring_maisaroh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 926, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (224, 'Arix Anang Wahyudi', '101020086', 'arixanangwahyudi@pasuruannet.com', '22-10-01', 5, 'Dsn. Karanganyar (Ranggeh)', '085708369482', 'Non-Aktif', 0, '3514232908040000', '', 1666404499, 'PPPOE', 'ranggeh_arix', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 895, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (225, 'Sri Wulandari Agustina', '101020087', 'sriwulandariagustina@pasuruannet.com', '22-10-11', 5, 'Dsn. Karangasem, Ds. Tenggilis', '085731512990', 'Non-Aktif', 0, '3514186708950000', '', 1666404552, 'PPPOE', 'karangasem_wulandari', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 1051, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (226, 'Irham Hadi Purnama', '101020088', 'irhamhadipurnama@pasuruannet.com', '22-10-01', 5, 'Dsn. Ngepreng, Ds. Gondangwetan', '085257635006', 'Non-Aktif', 0, '3514182811880000', '', 1666404674, 'PPPOE', 'ngepreng_irham', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 896, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (227, 'Naning', '101010093', 'naning@pasuruannet.com', '22-10-04', 5, 'Dsn. banyubiru, Ds. Sumberejo', '082331624004', 'Aktif', 0, '3514050000000000', '', 1666404879, 'PPPOE', 'banyubiru_naning', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 897, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (228, 'Moh. Sahid', '101020089', 'moh.sahid@pasuruannet.com', '22-10-04', 5, 'Dsn. Kebonsawo, Ds. Keboncandi', '085732371878', 'Non-Aktif', 0, '3514181809850010', '', 1666405049, 'PPPOE', 'kebonsawo_sahid', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 898, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (229, 'Suwondo', '101130001', 'suwondo@pasuruannet.com', '22-10-04', 5, 'Aluran', '082338633813', 'Non-Aktif', 0, '0', '', 1666405496, 'PPPOE', 'aluran_suwondo1', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 922, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (230, 'Rani Agustina', '101020090', 'raniagustina@pasuruannet.com', '22-10-26', 5, 'Tenggilis', '085733325341', 'Non-Aktif', 0, '3514184406030000', '', 1667267348, 'PPPOE', 'tenggilis_rani', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 921, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (231, 'Inayatul Maula', '101020091', 'inayatulmaula@pasuruannet.com', '22-09-19', 5, 'Dsn. Klodangan, Ds. Wonojati', '083105253403', 'Non-Aktif', 0, '351418510576003', '', 1667615959, 'PPPOE', 'klodangan_NU', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 1057, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (232, 'Ajib', '101010094', 'ajib@pasuruannet.com', '22-10-27', 5, 'Prodo', '082133193414', 'Aktif', 0, '3514190000000000', '', 1669604991, 'PPPOE', 'prodo_ajib', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 511, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (233, 'Akhmad Erwin', '101030018', 'akhmaderwin@pasuruannet.com', '22-11-01', 5, 'Raket', '085718236514', 'Non-Aktif', 0, '3514230411980000', '', 1669615224, 'PPPOE', 'raket_erwin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 902, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (234, 'Nanang Efendi', '101010095', 'nanangefendi@pasuruannet.com', '22-11-02', 5, 'Menyarik', '085850367194', 'Non-Aktif', 0, '3514190000000000', '', 1669615827, 'PPPOE', 'menyarik_nanang', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 544, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (235, 'Mukhlis', '101010096', 'mukhliss@pasuruannet.com', '22-10-31', 5, 'Ngayon, Kandung', '081331177617', 'Aktif', 0, '3514190000000000', '', 1669618184, 'PPPOE', 'kandung_mukhlis', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1063, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (236, 'Akhmad Ischak', '101030019', 'akhmadischak@pasuruannet.com', '22-12-09', 5, 'Suklan', '081217749992', 'Aktif', 0, '3514232005800010', '', 1669854975, 'PPPOE', 'suklan_ischak', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1056, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (237, 'Tolha', '101010097', 'tolha@pasuruannet.com', '22-12-10', 5, 'Kasiman', '085749525762', 'Aktif', 0, '3514050000000000', '', 1669855722, 'PPPOE', 'kasiman_tolha', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 910, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (238, 'Sumarsini', '101010098', 'sumarsini@pasuruannet.com', '22-12-10', 5, 'Banyubiru', '082142678102', 'Aktif', 0, '3514200000000000', '', 1669856121, 'PPPOE', 'banyubiru_sumarsinih', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 912, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (239, 'Abdul Manaf', '101010099', 'manaf@pasuruannet.com', '22-11-26', 5, 'Prodo, Winongan', '085236719441', 'Aktif', 0, '3514190000000000', '', 1669856134, 'PPPOE', 'prodo_manaf', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1142, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (240, 'Akhmad Makhrus', '101020092', 'makhrus12@pasuruannet.com', '22-11-25', 5, 'Kebonsawo', '082330062688', 'Non-Aktif', 0, '3514183112700000', '', 1669856835, 'PPPOE', 'kebonsawo_makhrusrumah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 1138, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (241, 'Abd.Ghoni', '101010100', 'ghoni@pasuruannet.com', '22-11-14', 5, 'Umbulan', '085232778808', 'Aktif', 0, '3514190000000000', '', 1669857703, 'PPPOE', 'umbulan_ghoni', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 598, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (242, 'M.misbachudin', '101010101', 'misbachudin@pasuruannet.com', '22-11-22', 5, 'menyarik', '088235997280', 'Aktif', 0, '3514190000000000', '', 1669857871, 'PPPOE', 'menyarik_misbachudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (243, 'Khoirul Mustofa', '101010102', 'khoirulmustofa@pasuruannet.com', '22-11-20', 5, 'Ngayon', '08580880359', 'Aktif', 0, '3514190000000000', '', 1669858822, 'PPPOE', 'ngayon_mustofa', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1202, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (244, 'MI Nurul Huda Kletek', '101010103', 'mikletek@pasuruannet.com', '22-12-01', 5, 'Mi Nurul Huda Kletek Kidul', '082331376955', 'Aktif', 0, '0', '', 1669867300, 'PPPOE', 'mendalan_mi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 0, 135000, '', 0, '', 0, 2, 1, 1205, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (245, 'Mohammad Fahmi Romadhon', '101020093', 'FahmiRomadhon@pasuruannet.com', '22-12-03', 5, 'ATMA Cell Ranggeh', '085235666363', 'Aktif', 0, '3513180312980000', '', 1672124885, 'PPPOE', 'ranggeh_atmacell', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 377, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (246, 'Khofifah', '101020094', 'Khofifah@pasuruannet.com', '22-12-03', 5, 'Pateguhan', '081357473131', 'Aktif', 0, '3514186109950000', '', 1672125056, 'PPPOE', 'pateguhan_khofifah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 916, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (247, 'Dani Hidayat', '101040028', 'danihidayat@pasuruannet.com', '22-12-05', 5, 'Krajan, Rebalas', '081234750052', 'Aktif', 0, '3514201212030000', '', 1672193106, 'PPPOE', 'rebalas_dani', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 0, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1118, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (248, 'Ahmad Hasan Walinono', '101010104', 'hasanwalinono@pasuruannet.com', '22-12-28', 5, 'Dsn. Gambiran, Ds. Bandaran', '085791614225', 'Aktif', 0, '3514190000000000', '', 1672214248, 'PPPOE', 'gambiran_hasan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 14, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (249, 'Muhammad Faidzin', '101010105', 'faidzin@pasuruannet.com', '22-12-19', 5, 'Dsn. Curahmaalang, Ds. Karangtengah', '081217791409', 'Non-Aktif', 0, '3514190000000000', '', 1672278568, 'PPPOE', 'curahmalang_faizin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 1149, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (250, 'Fandi Akhmad', '101070002', 'fandi123@pasuruannet.com', '22-12-17', 5, 'Dsn. Sedodol Utara, Ds. Plinggisan', '0882009998877', 'Non-Aktif', 0, '3514162704050000', '', 1672278804, 'PPPOE', 'sedodol_fandi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 1121, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (251, 'Sinta Mauludiyah', '101010106', 'Sintamauludiyah@pasuruannet.com', '22-12-11', 5, 'Dsn.Kurek, Minggir, Kec.Winongan', '085780208864', 'Non-Aktif', 0, '3514200000000000', '', 1672279160, 'PPPOE', 'klodangan_sinta', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (252, 'Miftahul Ulum', '101010107', 'Miftahululum@pasuruannet.com', '22-12-12', 5, 'Dsn.Karangmojo, Ds. Karang Tengah, Kec. Winongan', '085815917255', 'Non-Aktif', 0, '3514190000000000', '', 1672279381, 'PPPOE', 'karangmojo_ulum', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 0, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 276, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (253, 'Tri Wahyuni', '101130002', 'triwahyuni@pasuruannet.com', '22-12-16', 5, 'Dsn. Watugilang, Ds. Cukurguling', '0', 'Non-Aktif', 0, '3514044105910000', '', 1672279702, 'PPPOE', 'cukurguling_tri', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 1115, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (254, 'Nur Kholis', '101010108', 'Nurkholisss@pasuruannet.com', '22-12-12', 5, 'Dsn. Sentono Timur, Ds. Jeladri, Kec. Winongan', '081336233422', 'Non-Aktif', 0, '3514190000000000', '', 1672280297, 'PPPOE', 'jeladri_kholis', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 1010, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (255, 'Yuliasari', '101020095', 'yuliasari@pasuruannet.com', '22-12-14', 5, 'Kampung Cempakaria, Ds. Pasrepan', '085707114342', 'Non-Aktif', 0, '3514194107940000', '', 1672298126, 'PPPOE', 'pasrepan_yulia', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (256, 'Rini Fitri Astuti', '101020096', 'rinifitriastuti@pasuruannet.com', '22-12-14', 5, 'Wonosalam, Wonosari, Kec. Gondangwetan`', '085608226457', 'Non-Aktif', 0, '3514185207830000', '', 1672298290, 'PPPOE', 'wonosalam_rini', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (257, 'Achmad Arief', '101020097', 'achmadarief@pasuruannet.com', '22-12-24', 5, 'Dsn. Karangasem, Ds. Tenggilis Rejo, Kec. Gondangwetan', '085755958380', 'Aktif', 0, '3514181206020000', '', 1672470462, 'PPPOE', 'tenggilis_arif', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 575, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (258, 'Mahmud Siuntung', '101010109', 'mahmudsiuntung@pasuruannet.com', '23-01-01', 5, 'Dsn. Mendalan, Ds. Mendalan', '083110842437', 'Aktif', 0, '0', '', 1672561512, 'PPPOE', 'mendalan_mahmud', 0, 1, 1, 'KTP', 1, 1, 62, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (259, 'Anne Pratiwi', '101010110', 'annepratiwi@pasuruan.com', '22-12-27', 5, 'Dsn.Gendol, Ds.Prodo, Kec.Winongan', '085804405050', 'Aktif', 0, '3514200000000000', '', 1674093702, 'PPPOE', 'gendol_anne', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 22, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (260, 'Dwi Tufi\'qurrohman', '101040029', 'dwitufi\'qurrohman@pasuruannet.com', '22-12-28', 5, 'KajarKuning, Ds.Kedawungwetan, Kec.Grati', '085792245561', 'Non-Aktif', 0, '3514201609000000', '', 1674095195, 'PPPOE', 'kajarkuning_dwi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 111, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (261, 'Akhmad Soleh Afandi', '101020098', 'akhmadsolehafandi@pasuruannet.com', '22-12-28', 5, 'Kiringan (Wonosari)', '085236122351', 'Non-Aktif', 0, '3514180203010000', '', 1674095403, 'PPPOE', 'wonosari_soleh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 152, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (262, 'Alwi', '101010111', 'alwi@pasuruannet.com', '22-12-29', 5, 'Dsn.Kebonsari, Desa Sruwi, Kec. Winongan', '085232147061', 'Aktif', 0, '3514190000000000', '', 1674095791, 'PPPOE', 'sruwi_alwi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 188, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (263, 'Nur Sugiarti', '101010112', 'nursugiarti@pasuruannet.com', '22-12-30', 5, 'Dsn.Bendo, Desa Winongan Lor, Kec. Winongan', '082254199009', 'Aktif', 0, '3514190000000000', '', 1674097813, 'PPPOE', 'bendo_sugiarti', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 654, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (264, 'Mohammad Khoiron', '101010113', 'mohammadkhoiron@pasuruannet.com', '23-01-07', 5, 'Dsn.Bandaran Kidul,Desa Bandaran,Kec.Winongan', '085314172178', 'Aktif', 0, '3514190000000000', '', 1674180902, 'PPPOE', 'bandaran_khoiron', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 188, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (265, 'Yuning Nurdwiyanti', '101010114', 'yuningnurdwiyanti@pasuruannet.com', '23-01-07', 5, 'Dsn.Banyubiru Kidul,Desa Sumberrejo,Kec Winongan', '085716107473', 'Non-Aktif', 0, '3514190000000000', '', 1674181253, 'PPPOE', 'banyubiru_yuning', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 111, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (266, 'Harto', '101010115', 'harto@pasuruannet.com', '23-01-07', 5, 'sentul, Toxwiro', '087873184274', 'Aktif', 0, '3527060000000000', '', 1674181621, 'PPPOE', 'sentul_harto', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 417, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (267, 'Nelly Agustina Ningsih', '101010116', 'nellyagustinaningsih@pasuruannet.com', '23-01-09', 5, 'Dsn.Talang Tengah,Desa Winongan Kidul,Kec.Winongan', '085706369395', 'Non-Aktif', 0, '3514200000000000', '', 1674181892, 'PPPOE', 'talang_melly', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 111, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (268, 'Akhmad Ardiansyah', '101010117', 'akhmadardiansyah@pasuruannet.com', '23-01-11', 5, 'Dsn. Karangmakam, Ds. Bandaran, Kec. Winongan', '085814646468', 'Non-Aktif', 0, '3514190000000000', '', 1674184611, 'PPPOE', 'gayam_ardiansyah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 1044, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (269, 'Sami\'an', '101070003', 'sami\'an@pasuruannet.com', '23-01-14', 5, 'Kramat, Ds. Dhompo, Kec. Kraton', '085235242058', 'Aktif', 0, '3514160601760000', '', 1674185612, 'PPPOE', 'dhomposidogiri_sami', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 1081, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (270, 'M. Hasan Bisri', '101010118', 'mhasanbasri@pasuruannet.com', '23-01-14', 5, 'Dsn. Kletek Kidul, Ds. Mendalan, Kec. Winongan', '081232036479', 'Aktif', 0, '3514190000000000', '', 1674185763, 'PPPOE', 'kletekkidul_hasan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1159, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (271, 'Sutiyaningsih', '101020099', 'sutiyaningsih@pasuruannet.com', '23-01-16', 5, 'Wonosari', '082232607933', 'Non-Aktif', 0, '3514195201820000', '', 1674186449, 'PPPOE', 'wonosari_sutiyaningsih', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '30Mbps', 1, 0, 1, 0, 1, 285000, '', 0, '', 0, 2, 1, 1200, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (272, 'Sukur', '101020100', 'sukur098@pasuruannet.com', '23-01-05', 5, 'Wonosalam', '085183093732', 'Aktif', 0, '0', '', 1674270415, 'PPPOE', 'wonosalam_sukur', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (273, 'Fajar Ulun Wiweka', '101020101', 'fajarulunwiweka@pasuruannet.com', '23-01-26', 5, 'Ranggeh Residence, Ranggeh, Gondang Wetan', '089699626783', 'Non-Aktif', 0, '3208090908050000', '', 1675154839, 'PPPOE', 'keboncandi_fajar', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 0, 185000, '', 0, '', 0, 2, 1, 111, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (274, 'Aminah Sulistia Ningrum', '101030020', 'aminasulistiai@pasuruannet.com', '23-02-18', 5, 'Dsn. Sadeng, Ds. Pandanrejo', '081213485687', 'Non-Aktif', 0, '9101015506920000', '', 1676713810, 'PPPOE', 'sadeng_aminah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (275, 'Mukhammad Nurudin', '101010119', 'mukhammadnurudin@pasuruannet.com', '23-01-27', 5, 'Dsn. Tegalpo, Ds. Jeladri, Kec. Winongan', '081246820329', 'Aktif', 0, '3514190000000000', '', 1677035842, 'PPPOE', 'jeladri_nurudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 152, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (276, 'Mukhammad Agus Ijazi', '101010120', 'mukhammadagusijazi@pasuruannet.com', '23-01-28', 5, 'Dsn. Karangtengah, Ds. Karangtengah, Kec. Winongan', '085732929715', 'Non-Aktif', 0, '3514190000000000', '', 1677036149, 'PPPOE', 'karangtengah_ijazi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 317, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (277, 'Afandi', '101020102', 'afandi123@pasuruannet.com', '23-01-31', 5, 'Bendo, Ds. Sekarputih, Kec. Gondang wetan', '085790420012', 'Aktif', 0, '3514061107940000', '', 1677039108, 'PPPOE', 'bendo_afandi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 678, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (278, 'Feri Irawan', '101010121', 'feriirawan@pasuruannet.com', '23-02-06', 5, 'Dsn. Mulyorejo Kidul, Ds. Umbulan, Kec. Winongan', '082143119173', 'Aktif', 0, '3514190000000000', '', 1677042506, 'PPPOE', 'umbulan_feri', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1089, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (279, 'Mutamimah', '101020103', 'mutamimah@pasuruannet.com', '23-02-11', 5, 'Kalimalang, Kalirejo, Kec. Gondangwetan', '081554333354', 'Non-Aktif', 0, '3514184307750000', '', 1677044391, 'PPPOE', 'kalimalang_mutamimah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 1172, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (280, 'Mustofa', '101020104', 'mustofa123@pasuruannet.com', '23-02-15', 5, 'Krajan, Gondangwetan', '088217787742', 'Non-Aktif', 0, '3514180101850000', '', 1677117908, 'PPPOE', 'gondangwetan_mustofa', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 763, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (281, 'M. Ikhuwani', '101020105', 'mikhuwani@pasuruannet.com', '23-02-17', 5, 'Masangan, Tenggilis rejo, Gondangwetan', '085850180474', 'Non-Aktif', 0, '3514180512910000', '', 1677118337, 'PPPOE', 'masangan_ikhuwani', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 566, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (282, 'Sayyi', '101010122', 'sayyi@pasuruannet.com', '23-02-08', 5, 'watu gede jeladri', '085238951447', 'Aktif', 0, '0', '', 1677463933, 'PPPOE', 'jeladri_sayyi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1052, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (283, 'Kholifah', '101020106', 'kholifah1232@pasuruannet.com', '23-02-25', 5, 'Dsn terewung, desa sekarputih, kec. gondangwetan', '082232587721', 'Non-Aktif', 0, '3514186308800000', '', 1677547409, 'PPPOE', 'sekarputih_kholifah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 965, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (284, 'Lailatun nisfi', '101020107', 'lailatunnisfi@pasuruannet.com', '23-02-25', 5, 'Dsn. wonojati, Ds. Wonojati, Kec. Gondang Wetan', '082143901399', 'Aktif', 0, '3514185412970000', '', 1677547746, 'PPPOE', 'kiringan_lailatun', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 670, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (285, 'Saiful Arifin', '101010123', 'saifularifin123@pasuruannet.com', '23-02-25', 5, 'Dsn.curahmalang, desa karang tengah, kec.winongan', '085749055519', 'Non-Aktif', 0, '3514190000000000', '', 1677548450, 'PPPOE', 'curahmalang_saiful', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 528, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (286, 'Hadi', '101020108', 'hadi@pasuruannet.com', '23-03-05', 5, 'Wonosari', '0895337021633', 'Non-Aktif', 0, '0', '', 1678001041, 'PPPOE', 'wonosari_hadi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (287, 'Atun', '101040030', 'atun@pasuruannet.com', '23-02-27', 5, 'Ds. Kalipang, Kec. Grati', '083155752943', 'Non-Aktif', 0, '3514202808730000', '', 1679881369, 'PPPOE', 'kalipang_atun', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 606, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (288, 'Siti Fatimah / Dimas Indi Dwi Rahma', '101010124', 'miftahulhuda1234@pasuruannet.com', '23-02-27', 5, 'Dukuh Kidul', '085607757922', 'Aktif', 0, '3514140000000000', '', 1679892860, 'PPPOE', 'dukuhkidul_sitifatimah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 687, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (289, 'Dewi Urifa', '101010125', 'dewiurifa1@pasuruannet.com', '23-03-28', 5, 'Ds. Penataan, Kec. Winongan', '081330807232', 'Non-Aktif', 0, '3514200000000000', '', 1679893062, 'PPPOE', 'penataan_urifa', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 900, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (290, 'Fatkhur rozak', '101010126', 'fatkhurrozak@pasuruannet.com', '23-03-02', 5, 'Dsn, kurban, ds gading, kec. winongan', '085859786566', 'Non-Aktif', 0, '3514230000000000', '', 1679900101, 'PPPOE', 'kurban_fatkhur', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 996, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (291, 'Muhammad Sukron', '101020109', 'muhammadsukron@pasuruannet.com', '23-03-03', 5, 'Dsn.bendo,Ds Sekarputih,kec.gondang wetan', '085854830010', 'Non-Aktif', 0, '3514182208950000', '', 1679900832, 'PPPOE', 'sekarputih_sukron', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '40Mbps', 1, 0, 1, 0, 1, 335000, '', 0, '', 0, 2, 1, 496, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (292, 'Syamsul Huda', '101020110', 'syamsulhuda12@pasuruannet.com', '23-03-07', 5, 'Dsn.tampung,ds.kalirejo,kec.gondang wetan', '085606741947', 'Non-Aktif', 0, '3514180812920000', '', 1679905612, 'PPPOE', 'tampung_syamsul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 225000, '', 0, '', 0, 2, 1, 847, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (293, 'Asnawi', '101010127', 'asnawi123@pasuruannet.com', '23-03-10', 5, 'Karangtengah', '085746542205', 'Non-Aktif', 0, '3514190000000000', '', 1679908647, 'PPPOE', 'karangtengah_asnawi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'paket3-new', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 792, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (294, 'Lailatul alfaha', '101010128', 'lailatulalfaha@pasuruannet.com', '23-03-11', 5, 'Dsn.Krajan,Ds.Kedungrejo/kedungwaru,Kec,.winongan', '0881026972105', 'Aktif', 0, '3514960000000000', '', 1679908804, 'PPPOE', 'kedungrejo_alfaha', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1094, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (295, 'Feri Febrianto', '101040031', 'ferifebriantoo@pasuruannet.com', '23-03-13', 5, 'Dsn.Curahwulu,Ds.karanglo,Kec.Grati', '081335066684', 'Aktif', 0, '3514200802000000', '', 1679909274, 'PPPOE', 'curahwulu_feri', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 940, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (296, 'Hindun', '101010129', 'hindunn@pasuruannet.com', '23-03-20', 5, 'Dsn.Ngayon,Desa Kandung,Kec.Winongan', '085784277255', 'Aktif', 0, '3514200000000000', '', 1679967045, 'PPPOE', 'ngayon_hindun', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1210, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (297, 'Zumrotul Rodheya', '101010130', 'zumrotulrodheya@pasuruannet.com', '23-03-21', 5, 'Dsn.Ngayon,Desa Kandung,Kec.Winongan', '085755433065', 'Aktif', 0, '3514190000000000', '', 1679967348, 'PPPOE', 'ngayon_zumrotul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1145, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (298, 'Solikan', '101010131', 'solikan@pasuruannet.com', '23-04-06', 5, 'Dsn. Gambiran, Ds. Bandaran', '083862111115', 'Aktif', 0, '0', '', 1680772821, 'PPPOE', 'gambiran_solikan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 1082, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (299, 'Anisa', '101040032', 'anisaaa@pasuruannet.com', '23-03-31', 5, 'Dsn.Kebonrejo,Ds.kebonrejo,Kec.Grati', '085732607167', 'Aktif', 0, '3514207007850000', '', 1681198869, 'PPPOE', 'kebonrejo_anisa', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 501, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (300, 'Khoiruddin', '101010132', 'khoiruddinn@pasuruannet.com', '23-03-31', 5, 'Dsn.Krajan,Ds.Kedungrejo,Kec,.winongan', '082139917076', 'Non-Aktif', 0, '3514190000000000', '', 1681199053, 'PPPOE', 'kedungrejo_khoiruddin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 185000, '', 0, '', 0, 2, 1, 496, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (301, 'Supriyatno', '101010133', 'supriyatno@pasuruannet.com', '23-04-01', 5, 'Dsn.Wedar,Ds.Gading,Kec.Winongan', '081232258983', 'Non-Aktif', 0, '3514190000000000', '', 1681199626, 'PPPOE', 'wedar_supriyatno', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 1162, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (302, 'Moh. Isom Hadik', '101010134', 'mohisomhadik@pasuruannet.com', '23-04-08', 5, 'Dsn.Dukuh Kidul,Ds.Sumberejo,Kec.Winongan', '085234131413', 'Aktif', 0, '3514190000000000', '', 1681200809, 'PPPOE', 'dukuhkidul_isom', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1234, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (303, 'nadifah', '101010135', 'wardatussholichan@pasuruannet.com', '23-04-05', 5, 'Dsn.Kemong,Ds.Lebak,Kec.Winongan', '081325931199', 'Non-Aktif', 0, '3514200000000000', '', 1681201322, 'PPPOE', 'kemong_nadifa', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 1217, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (304, 'Abdul Farid', '101010136', 'abdulfarid1@pasuruannet.com', '23-04-04', 5, 'Dsn.Gading,Ds.Gading,Kec.Winongan', '083164053877', 'Aktif', 0, '3514190000000000', '', 1681201860, 'PPPOE', 'gading_farid', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1197, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (305, 'Dian Anggraeni', '101020111', 'diananggraeni@pasuruannet.com', '23-04-03', 5, 'Dsn.Kiringan,Ds.Wonojati,Kec.Gondangwetan', '081233207749', 'Aktif', 0, '3514186505850000', '', 1681202165, 'PPPOE', 'kiringan_anggraeni', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1134, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (306, 'Luli Mawar Wati', '101010137', 'lulimawarwati@pasuruannet.com', '23-04-13', 5, 'Dsn. Tegalpoh, Ds. Jeladri', '085706615837', 'Aktif', 0, '3514200000000000', '', 1681375912, 'PPPOE', 'jeladri_luli', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 443, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (307, 'Sakroni', '101040033', 'sakroni1@pasuruannet.com', '23-04-13', 5, 'Dsn. Sumbersuko, Ds. Plososari', '082245937967', 'Aktif', 0, '3514202501030010', '', 1682819093, 'PPPOE', 'plososari_roni', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 0, 110000, '', 0, '', 0, 2, 1, 1180, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (308, 'Manisa', '101040034', 'manisa@pasuruannet.com', '23-05-03', 5, 'Dsn. Kloto\'an, Ds. Kebonrejo', '083185241872', 'Non-Aktif', 0, '3514207006730010', '', 1683105969, 'PPPOE', 'klotokan_manisa', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 0, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 14, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (309, 'Tri Yudha Cahyo Nagara (PG)', '101040035', 'triyudhacahyo@pasuruannet.com', '23-05-16', 5, 'Dsn. PG Kedawung', '081217229158', 'Aktif', 0, '3514180309860000', '', 1684889075, 'PPPOE', 'kedawung_PG', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'paket150-mbps', 1, 0, 1, 0, 1, 385000, '', 0, '', 0, 2, 1, 764, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (310, 'M Riyan Fimansyah', '101020112', 'mriyanfirmansyah@pasuruannet.com', '23-05-04', 5, 'Dsn.Kiringan,Ds.Wonojati,Kec.Gondang Wetan', '083824045726', 'Aktif', 0, '3514182903020000', '', 1684890451, 'PPPOE', 'kiringan_riyan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 542, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (311, 'Amaliyah Mukmillah', '101010138', 'amaliyahmukmillah@pasuruannet.com', '23-05-04', 5, 'Dsn.Wulu,Ds.Mendalan,Kec.Winongan', '0822348112433', 'Aktif', 0, '3514190000000000', '', 1684890756, 'PPPOE', 'wulu_amaliyah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 428, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (312, 'Eliyah', '101020113', 'eliyah1@pasuruannet.com', '23-05-05', 5, 'Dsn. Wonosalam, Ds. Wonosari', '083185724719', 'Aktif', 0, '3514185505800010', '', 1684901034, 'PPPOE', 'wonosalam_eliyah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (313, 'Endang susiati', '101040036', 'endangsusiati@pasuruannet.com', '23-05-10', 5, 'Pondok candra C1 no 2', '083899338318', 'Non-Aktif', 0, '3514204510740000', '', 1685070641, 'PPPOE', 'pondokcandra_endang', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (314, 'Ismail Marzuki', '101010139', 'ismailmarzuki3@pasuruannet.com', '23-05-19', 5, 'Dsn. Minggir, Ds. Minggir', '085708622258', 'Aktif', 0, '3514190000000000', '', 1685084967, 'PPPOE', 'minggir_ismail', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 167, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (315, 'M. Nur Hadi', '101010140', 'm.nurhadi4@pasuruannet.com', '23-05-24', 5, 'Dsn. Kedungwaru kidul, Ds. Sidepan', '081392295638', 'Non-Aktif', 0, '3514190000000000', '', 1685152369, 'PPPOE', 'kedungwarukidul_nurhadi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 1229, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (316, 'Mohammad Arif', '101010141', 'mohammadarif@pasuruannet.com', '23-05-31', 5, 'Dsn. Margo Utomo, Ds. Prodo', '083836042725', 'Aktif', 0, '3514200000000000', '', 1685506564, 'PPPOE', 'margoutomo_arif', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 14, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (317, 'Sulaeman', '101010142', 'sulaeman006@pasuruannet.com', '23-06-02', 5, 'Ds. Wulu, Ds. Mendalan', '085784048102', 'Aktif', 0, '0', '', 1685702320, 'PPPOE', 'wulu_sulaeman', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 14, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (318, 'Nurkhayyi', '101020114', 'nurkhayyi@pasuruannet.com', '23-06-16', 5, 'Dsn.Tenggilisrejo,Ds.Tenggilisrejo ', '085790448010', 'Aktif', 0, '3514182105860000', '', 1686977857, 'PPPOE', 'tenggilis_nurkhayyi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1244, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (319, 'Karina Ilmiyah', '101010143', 'karinailmiyah@pasuruannet.com', '23-06-15', 5, 'Dsn.Gading,Ds.Gading', '081330084194', 'Aktif', 0, '3514200000000000', '', 1686978057, 'PPPOE', 'gading_karina', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1234, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (320, 'Muchammad Ali Ridho', '101020115', 'muchammadaliridho@pasuruannet.com', '23-06-10', 5, 'Dsn.Pekangkungan,Ds.Pekangkungan', '082245810654', 'Aktif', 0, '3514182601940000', '', 1686979538, 'PPPOE', 'pekangkungan_ridho', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1221, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (321, 'Moh. Rozak', '101010144', 'mohrozak@pasuruannet.com', '23-05-29', 5, 'Dsn. Tunjungan,Ds. Mendalan', '082230948939', 'Aktif', 0, '3514190000000000', '', 1686979945, 'PPPOE', 'tunjungan_rozak', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 625, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (322, 'Ifa Maulidyah', '101010145', 'ifamaulidyah2@pasuruannet.com', '23-06-09', 5, 'Dsn.Sukun Ds.Mendalan', '081937063630', 'Aktif', 0, '3514200000000000', '', 1686980420, 'PPPOE', 'sukun_ifa', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1195, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (323, 'Akhmad Khambali', '101030021', 'akhmadkhambalii@pasuruannet.com', '23-05-31', 5, 'Dsn. Ketegan.Ds.Ketegan', '082331842302', 'Non-Aktif', 0, '3514232711980000', '', 1686980560, 'PPPOE', 'ketegan_khambali', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 764, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (324, 'M. Rofik', '101040037', 'mrofikk@pasuruannet.com', '23-05-31', 5, 'Dsn. Kalipang, Ds. Grati', '082236122400', 'Aktif', 0, '3514202001870000', '', 1686980842, 'PPPOE', 'kalipang_rofik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 428, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (325, 'Dwi Heni Kartikasari', '101010146', 'dwihenikartikasari@pasuruannet.com', '23-05-31', 5, 'Dsn. Sukun, Ds. Mendalan', '081584932631', 'Non-Aktif', 0, '3514200000000000', '', 1686980959, 'PPPOE', 'sukun_heni', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 501, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (326, 'Alfan Tauviki', '101010147', 'alfantauviki@pasuriannet.com', '23-06-07', 5, 'Dsn.Nyangkring Ds.Menyarik', '083162958971', 'Aktif', 0, '3514190000000000', '', 1686981051, 'PPPOE', 'nyangkring_alfan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1191, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (327, 'Ely Hariana', '101020116', 'elyhariana@pasuruannet.com', '23-06-01', 5, 'Dsn. Buntalan, Ds. Kedawung Wetan', '085607139521', 'Non-Aktif', 0, '3514205201820000', '', 1687159183, 'PPPOE', 'buntalan_ely', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 14, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (328, 'Muhlason', '101020117', 'Muhlason@pasuruannet.com', '23-06-05', 5, 'Dsn. Plaosan,Ds.Brambang', '083857557073', 'Aktif', 0, '3514180908950010', '', 1687161473, 'PPPOE', 'plaosan_mukhlason', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 14, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (329, 'Jumakri', '101040038', 'jumakri@pasuruannet.com', '23-06-06', 5, 'Dsn.Krajan Ds.Kalipang', '082229447010', 'Non-Aktif', 0, '3514201402840000', '', 1687165120, 'PPPOE', 'kalipang_jumakri', 0, 1, 1, 'SIM', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 14, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (330, 'M. azhari', '101020118', 'm.azhari@pasuruan.net', '23-06-19', 5, 'BangilanBoncandi (plalangan)', '085732361298', 'Aktif', 0, '0', '', 1687494297, 'PPPOE', 'plalangan_azhari', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (331, 'Much. Marzuqi2', '101020119', 'much.marzuqi@pasuruannet.com', '23-06-21', 5, 'Dsn. Pateguhan, Ds Pateguhan', '0881036815885', 'Aktif', 0, '0', '', 1687494880, 'PPPOE', 'pateguhan_marzuqi2', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 358, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (332, 'Lilik Maulidah', '101040039', 'lilikmaulidah02@pasuruannet.com', '23-06-25', 5, 'Menangas', '082132920263', 'Non-Aktif', 0, '3514204405950000', '', 1688115455, 'PPPOE', 'menangas_lilik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 14, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (333, 'Yasin', '101040040', 'yasin@pasuruannet.com', '23-06-26', 5, 'Dsn. Buntalan, Ds. Kedawung wetan', '081259764394', 'Aktif', 0, '0', '', 1689066934, 'PPPOE', 'buntalan_yasin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 358, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (334, 'Nur Khofifah', '101010148', 'nurkhofifah@pasuruannet.com', '23-07-04', 5, 'kedungwaru ', '085707535490', 'Non-Aktif', 0, '0', '', 1689068010, 'PPPOE', 'kedungwarukidul_khofifah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 485, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (335, 'Abd. Aziz', '101030022', 'abdaziz1@pasuruannet.com', '23-07-05', 5, 'ngebras, pandansari', '083897494328', 'Aktif', 0, '0', '', 1689126665, 'PPPOE', 'pandansari_azis', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 485, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (336, 'Rossy', '101020120', 'rossy@pasuruannet.com', '23-06-30', 5, 'kiringan', '081330386990', 'Non-Aktif', 0, '0', '', 1689127061, 'PPPOE', 'kiringan_rossy', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 832, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (337, 'Suciati', '101040041', 'suciati@pasuruannet.com', '23-06-28', 5, 'Buntalan', '082232346724', 'Aktif', 0, '0', '', 1689130277, 'PPPOE', 'buntalan_suciati', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (338, 'Baharudin', '101010149', 'baharudin1@pasuruannet.com', '23-07-03', 5, 'Mendalan', '085233315647', 'Non-Aktif', 0, '0', '', 1689134422, 'PPPOE', 'mendalan_baharudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 716, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (339, 'Yulia Agustina', '101010150', 'yuliaagustina@pasuruannet.com', '23-07-11', 5, 'Dsn.Bendo Ds.Winongan Lor', '085731191473', 'Aktif', 0, '0', '', 1689317473, 'PPPOE', 'bendo_yulia', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1244, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (340, 'Siti Aisyah', '101040042', 'SitiAisyah2@pasuruannet.com', '23-07-12', 5, 'Dsn.Krajan Ds.Karang Kliwon', '085655209817', 'Aktif', 0, '0', '', 1689321561, 'PPPOE', 'karangkliwon_aisyah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 341, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (341, 'M. Khumaidi', '101010151', 'Khumaidi@pasuruannet.com', '23-07-13', 5, 'Dsn.junggalang Ds.winonganlor', '085731507972', 'Aktif', 0, '0', '', 1689653550, 'PPPOE', 'jungalang_khumaedi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1057, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (342, 'Syarif hidayatullah', '101010152', 'syarifhidayatulloh@pasuruannet.com', '23-07-21', 5, 'Dsn.mulyorejolor Ds.umbulan', '082139057202', 'Aktif', 0, '0', '', 1690257199, 'PPPOE', 'mulyorejolor_syarif', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 962, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (343, 'David Maulana', '101020121', 'davidmaulana@pasuruannet.com', '23-07-21', 5, 'Dsn.pateguhan Ds.pateguhan', '088231287560', 'Non-Aktif', 0, '0', '', 1690257740, 'PPPOE', 'pateguhan_david', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 0, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 566, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (344, 'M.Jazuli', '101010153', 'mjazuli@pasuruannet.com', '23-07-22', 5, 'Dsn.karangsono Ds.winonganlor', '085749555965', 'Aktif', 0, '0', '', 1690261128, 'PPPOE', 'karangsono_jazuli', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 716, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (345, 'Mukhibbin', '101010154', 'mukhibbin@pasuruannet.com', '23-07-25', 5, 'Dsn.Umbulan Ds.Umbulan', '085785821545', 'Aktif', 0, '0', '', 1690425087, 'PPPOE', 'umbulan_mukhibbin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 774, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (346, 'M. Muchib', '101010155', 'muchib@pasuruannet.com', '23-07-28', 5, 'Dsn.Curahmalang Ds.Karangtengah', '082335236068', 'Aktif', 0, '0', '', 1690518528, 'PPPOE', 'curahmalang_muchib', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1077, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (347, 'Wahyu Budi Wicaksono', '101010156', 'wahyubudiwicaksono@pasuruannet.com', '23-08-20', 5, 'Dsn.Mayangbang Ds.Bandaran', '08223481190', 'Non-Aktif', 0, '0', '', 1690852561, 'PPPOE', 'bandaran_wahyu2', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 428, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (348, 'Subkhan', '101010157', 'subkhan01@pasuruannet.com', '23-08-05', 5, 'kedungrejo, kedungbanger', '085236851307', 'Aktif', 0, '0', '', 1691200161, 'PPPOE', 'kedungbanger_subkhan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 14, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (349, 'Mustain/Alfiatus sofah', '101010158', 'mustain@pasuruannet.com', '23-07-28', 5, 'Dsn.Mulyorejo Kidul Ds.Umbulan', '085257146501', 'Non-Aktif', 0, '0', '', 1691728988, 'PPPOE', 'umbulan_mustain', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 284, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (350, 'M. Idris/Sugiono', '101010159', 'sugiono2@pasuruannet.com', '23-07-29', 5, 'Dsn.Umbulan Ds.Umbulan', '085706682913', 'Aktif', 0, '0', '', 1691729264, 'PPPOE', 'umbulan_sugiono', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 443, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (351, 'Mukhammad Nurul Huda', '101020122', 'mukhammadnurulhuda@pasuruannet.com', '23-07-29', 5, 'Dsn.Pateguhan Ds.Pateguhan', '085746761007', 'Aktif', 0, '0', '', 1691732308, 'PPPOE', 'pateguhan_huda', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 501, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (352, 'Faza Mutmainnatur Rokhma', '101040043', 'fazamutmainnaturrokhma@pasuruannet.com', '23-08-03', 5, 'Dsn.Menangas wetan Ds.Kebonrejo', '082139267092', 'Aktif', 0, '0', '', 1691741939, 'PPPOE', 'menangas_faza', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 436, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (353, 'Soleh', '101020123', 'soleh@pasuruannet.com', '23-08-05', 5, 'Dsn.Sekaran Ds.Wonojati', '082142673524', 'Aktif', 0, '0', '', 1691742962, 'PPPOE', 'sekaran_soleh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 335, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (354, 'Muzaki', '101010160', 'muzaki1@pasuruannet.com', '23-07-31', 5, 'Dsn.Brintik Lor Ds.Menyarik', '085757424522', 'Free', 0, '0', '', 1691890744, 'PPPOE', 'brintiklor_muzaki', 0, 1, 0, 'KTP', 1, 1, 0, '', '', '3M', 0, 0, 0, 0, 0, 120000, '', 0, '', 0, 2, 1, 14, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (355, 'Mukhamad Ikhwan', '101010161', 'mukhamadikhwan@pasuruannet.com', '23-08-01', 5, 'Dsn.Wedar Ds.Gading', '081334525805', 'Aktif', 0, '0', '', 1691912023, 'PPPOE', 'wedar_ikhwan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 134, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (356, 'Mukhammad Kholis', '101010162', 'mukhammadkholis@pasuruannet.com', '23-08-09', 5, 'Dsn.Putat Ds.Penataan', '083836041131', 'Aktif', 0, '0', '', 1691916086, 'PPPOE', 'putat_kholis', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 347, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (357, 'Lukman Hakim', '101010163', 'lukmanhakimm@pasuruannet.com', '23-08-07', 5, 'Dsn.Kalongan Ds.Mendalan', '085655553024', 'Aktif', 0, '0', '', 1692240090, 'PPPOE', 'kalongan_lukman', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 495, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (358, 'Moh.Khoiruman', '101020124', 'mohkhoiruman@pasuruannet.com', '23-08-19', 5, 'Dsn.Wonosalam Tengah Ds.Wonosari', '085106656819', 'Non-Aktif', 0, '0', '', 1692590674, 'PPPOE', 'wonosalam_khoiruman', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 0, 120000, '', 0, '', 0, 2, 1, 410, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (359, 'Nanik Sri Handayani', '101020125', 'naniksrihandayani@pasuruannet.com', '23-08-19', 5, 'Dsn.Kebonrejo Ds.Kebonrejo', '082257098882', 'Aktif', 0, '0', '', 1692591687, 'PPPOE', 'kebonrejo_nanik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 642, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (360, 'Suhartono', '101020126', 'suhartono@pasuruannet.com', '23-08-19', 5, 'Dsn.Murjati Ds.Lajuk', '0881080604422', 'Non-Aktif', 0, '0', '', 1692592287, 'PPPOE', 'murjati_suhartono', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 416, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (361, 'Lutfiyanti Andayani', '101010164', 'lutfiyantiandayani@pasuruannet.com', '23-08-23', 5, 'Dsn.Kurban Ds.Gading', '085645324780', 'Aktif', 0, '0', '', 1692926256, 'PPPOE', 'kurban_lutfianti', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 531, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (362, 'Rosita Firdiyanti', '101010165', 'rositafirdiyanti@pasuruannet.com', '23-08-23', 5, 'Dsn.Kletek Kidul Ds.Mendalan', '085731049330', 'Aktif', 0, '0', '', 1692926545, 'PPPOE', 'kletekkidul_rosita', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1057, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (363, 'Samsul Anam', '101020127', 'samsulanam@pasuruannet.com', '23-08-24', 5, 'Dsn.Wonosalam Timur Ds.Wonosari (Klodangan)', '085389988771', 'Non-Aktif', 0, '0', '', 1692926821, 'PPPOE', 'klodangan_anam', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 27, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (364, 'Tumina', '101010166', 'tumina01@pasuruannet.com', '23-09-06', 5, 'Dsn. Curahmalang', '083844134032', 'Non-Aktif', 0, '0', '', 1693970229, 'PPPOE', 'curahmalang_tuminah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (365, 'Bati Suciani', '101010167', 'batisuciani@pasuruannet.com', '23-08-29', 5, 'Dsn.Seloliman Ds.Winongan', '085730912843', 'Aktif', 0, '0', '', 1694836920, 'PPPOE', 'seloliman_suciati', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 151, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (366, 'Hanum Fardianah', '101010168', 'hanumfardianah@pasuruannet.com', '23-09-01', 5, 'Dsn.kandung Ds.Kandung', '085230728258', 'Aktif', 0, '0', '', 1694851572, 'PPPOE', 'kandung_hanum', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (367, 'Ananda Anisa Fitriani', '101020128', 'anandaanisafitriani@pasuruannet.com', '23-09-01', 5, 'Dsn.Sambisari Ds.Gayam', '081259731152', 'Aktif', 0, '0', '', 1694851814, 'PPPOE', 'sambisari_ananda', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (368, 'mokhammad Munir', '101030023', 'mokhammadmunir@pasuruannet.com', '23-09-02', 5, 'Dsn.Suklan Ds.Pandanrejo', '081936888627', 'Aktif', 0, '0', '', 1695008751, 'PPPOE', 'suklan_m.munir', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 244, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (369, 'Muhammad Sali', '101020129', 'muhammadsali@pasuruannet.com', '23-09-04', 5, 'Dsn.Bendo Ds.Sekarputih', '085790418895', 'Non-Aktif', 0, '0', '', 1695008863, 'PPPOE', 'sekarputih_sali', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 270, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (370, 'Abdulloh Lutfan', '101010169', 'abdullohlutfan@pasuruannet.com', '23-09-02', 5, 'Dsn.Kalongan Ds.Mendalan', '083132174990', 'Aktif', 0, '0', '', 1695195762, 'PPPOE', 'kalongan_lutfan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 453, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (371, 'Sugeng Riyadi', '101020130', 'sugengriyadi@pasuruannet.com', '23-09-02', 5, 'Dsn.Bendo Ds.Sekarputih', '081252012802', 'Aktif', 0, '0', '', 1695195862, 'PPPOE', 'sekarputih_sugeng', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 523, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (372, 'Ilmiatus Saidah', '101020131', 'ilmiatussaidah@pasuruannet.com', '23-09-11', 5, 'Dsn.Tenggilis Krajan Ds.Tenggilis Rejo', '085755469485', 'Aktif', 0, '0', '', 1695267846, 'PPPOE', 'tenggilis_ilmiatus', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 238, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (373, 'Sjamsoedin', '101010170', 'sjamsoedin@pasuruannet.com', '23-09-12', 5, 'Dsn.Lebak Ds.Lebak', '085331749582', 'Aktif', 0, '0', '', 1695272346, 'PPPOE', 'lebak_sjamsoedin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (374, 'Rifa Khisbiatul Khoiriyah', '101010171', 'maslikha@pasuruannet.com', '23-09-19', 5, 'Dsn. Kletek Kidul, Ds. Mendalan', '081547533605', 'Aktif', 0, '0', '', 1695352642, 'PPPOE', 'mendalan_rifa', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 284, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (375, 'Mohammad Faried Wildan', '101030024', 'mohammadfariedwildan@pasuruannet.com', '23-09-23', 5, 'Dsn.Gapuk Ds.Kawisrejo', '081331744874', 'Non-Aktif', 0, '0', '', 1695784406, 'PPPOE', 'gapuk_faried', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 460, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (376, 'Fatma Amy', '101020132', 'fatmaamy@pasuruannet.com', '23-10-04', 5, 'Dsn.Ploso Ds.Ploso (Bajangan)', '0882010410045', 'Aktif', 0, '0', '', 1697012969, 'PPPOE', 'bajangan_amy', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 80, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (377, 'Agus Hidayatulloh', '101070004', 'agushidayatulloh@pasuruannet.com', '23-10-07', 5, 'Dsn. Lodo Ds. Kalirejo', '085737928000', 'Aktif', 0, '0', '', 1697014642, 'PPPOE', 'lodo_agus', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 140, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (378, 'Abd Manaf', '101010172', 'abdmanaf@pasuruannet.com', '23-10-08', 5, 'Dsn . Kedungwaru Lor Ds. Sidepan', '081359530896', 'Aktif', 0, '0', '', 1697015082, 'PPPOE', 'kedungwaru_manaf', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (379, 'Siti Fatimah', '101010173', 'sitifatimah@pasuruannet.com', '23-10-09', 5, 'Dsn. Pandean Ds. Winongan Kidul', '081285264096', 'Non-Aktif', 0, '0', '', 1697015725, 'PPPOE', 'pandean_fatimah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (380, 'Salamin', '101040044', 'Salamin@pasuruannet.com', '23-10-05', 5, 'Dsn.Menangas Kulon Ds.Kebonrejo', '085216910171', 'Aktif', 0, '0', '', 1697768972, 'PPPOE', 'menangas_salamin', 0, 1, 1, 'KTP', 1, 1, 0, '-7.731397613089616', '112.90118956892461', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (381, 'Sri Utami', '101010174', 'sriutami@pasuruannet.com', '23-10-10', 5, 'Dsn. Wedar Ds. Gading ', '08155068923', 'Aktif', 0, '0', '', 1697769865, 'PPPOE', 'wedar_sriutami', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 78, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (382, 'M. Nalam', '101010175', 'm.nalam@pasuruannet.com', '23-10-11', 5, 'Dsn. Mulyorejolor Ds.Umbulan', '085236864880', 'Aktif', 0, '0', '', 1697770065, 'PPPOE', 'umbulan_nalam', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 78, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (383, 'Siti Halimah', '101020133', 'sitihalimah@pasuruannet.com', '23-10-11', 5, 'Dsn. Gayam Ds. Gayam', '083897530019', 'Aktif', 0, '0', '', 1697770296, 'PPPOE', 'gayam_halimah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1051, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (384, 'Mukhamad Rifki Maulana', '101010176', 'mukhamadrifkimaulana01@pasuruannet.com', '23-10-11', 5, 'Dsn. Sruwi Ds. Sruwi', '083840291123', 'Non-Aktif', 0, '0', '', 1697770646, 'PPPOE', 'sruwi_rifki', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (385, 'Wawan Andrianto', '101010177', 'wawanandrianto@pasuruannet.com', '23-10-12', 5, 'Dsn. Karangsono Ds. Winongan Lor', '081233355817', 'Aktif', 0, '0', '', 1697770841, 'PPPOE', 'karangsono_wawan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (386, 'Nidom', '101020134', 'Nidom@pasuruannet.com', '23-10-17', 5, 'Dsn. Wonojati, Ds. Wonojati', '085100627177', 'Non-Aktif', 0, '0', '', 1697771283, 'PPPOE', 'wonojati_nidom', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 1060, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (387, 'Sunardi', '101010178', 'sunardi01@pasuruannet.com', '23-10-19', 5, 'Dsn. Mulyorejokidul Ds. Umbulan', '081335232622', 'Aktif', 0, '0', '', 1697771461, 'PPPOE', 'umbulan_sunardi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (388, 'Makhmuda', '101030025', 'makhmuda@pasuruannet.com', '23-10-18', 5, 'Dsn. Sadeng Ds. Sadengrejo', '083446546695', 'Non-Aktif', 0, '0', '', 1697771477, 'PPPOE', 'sadeng_makhmuda', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 1057, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (389, 'Najibudin', '101070005', 'najibudin@pasuruannet.com', '23-10-18', 5, 'Dsn. Krajan Ds. Klangrong Kejayan (Sidogiri)', '085604285882', 'Non-Aktif', 0, '0', '', 1697772035, 'PPPOE', 'sidogiri_najibudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 120000, '', 0, '', 0, 2, 1, 180, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (390, 'Muchammad Al Farissi', '101010179', 'muchammadalfarissi@pasuruannet.com', '23-10-20', 5, 'Dsn. Gading Ds. Gading (Mberan)', '083132214026', 'Aktif', 0, '0', '', 1698303930, 'PPPOE', 'beran_alfarisi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 252, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (391, 'Siti Nurjannah', '101020135', 'sitinurjannah@pasuruannet.com', '23-10-21', 5, 'Dsn. Mantingan Ds. Tenggilisrejo (Keboncandi)', '087812240689', 'Aktif', 0, '0', '', 1698304080, 'PPPOE', 'perumkeboncandi_nurjannah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 120000, '', 0, '', 0, 2, 1, 428, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (392, 'Siti Ananda Khofifah', '101030026', 'sitianandakhofifah@pasuruannet.com', '23-10-20', 5, 'Dsn. Keden Ds.Pandanrejo', '085230225092', 'Aktif', 0, '0', '', 1698304959, 'PPPOE', 'pandanrejo_ananda', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 606, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (393, 'Akhmad Mubarok', '101030027', 'akhmadmubarok@pasuruannet.com', '23-10-21', 5, 'Dsn. Keden Ds.Pandanrejo', '085962320839', 'Aktif', 0, '0', '', 1698305459, 'PPPOE', 'pandanrejo_mubarok', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 347, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (394, 'Khoirudin', '101020136', 'khoirudin@pasuruannet.com', '23-10-23', 5, 'Dsn. Macanputih Ds. Pekangkungan', '087771913355', 'Aktif', 0, '0', '', 1698306474, 'PPPOE', 'macanputih_hoirudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (395, 'Ponisri Wahyuningsih', '101010180', 'ponisriwahyuningsih@pasuruannet.com', '23-10-23', 5, 'Dsn. Talang Ds. Winongan Kidul', '085808307796', 'Aktif', 0, '0', '', 1698306757, 'PPPOE', 'talang_ponifsri', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 129, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (396, 'A\'ti Inayati', '101030028', 'atiinayati@pasuruannet.com', '23-10-10', 5, 'Dsn.Ndara Ds.Sadengrejo', '083862145579', 'Aktif', 0, '0', '', 1698390765, 'PPPOE', 'ndara_atiinayati', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (397, 'Rif\'ah', '101030029', 'rifah@pasuruannet.com', '23-10-01', 5, 'Dsn.Raket Ds.Kawisrejo', '083834359723', 'Non-Aktif', 0, '0', '', 1698714594, 'PPPOE', 'raket_rifah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 284, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (398, 'Muhamad Mu\'is', '101030030', 'muhamadmuis@pasuruannet.com', '23-10-01', 5, 'Dsn. Telbuk Ds. Kawisrejo', '081931631309', 'Aktif', 0, '0', '', 1698718952, 'PPPOE', 'telbuk_muis', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 384, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (399, 'Yoga', '101020137', 'yoga@pasuruannet.com', '23-11-08', 5, 'Kebonsawo', '085807496833', 'Non-Aktif', 0, '0', '', 1699407069, 'PPPOE', 'sawo_yoga', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (400, 'Siti Safirotus Salma', '101020138', 'sitisafirotussalma@pasuruannet.com', '23-10-27', 5, 'Dsn. Mantingan Ds. Tenggilis Rejo (karanganyar barat)', '083830227940', 'Non-Aktif', 0, '0', '', 1699942199, 'PPPOE', 'karanganyar_syafirotus', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 284, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (401, 'Moh. Ansori', '101010181', 'mohansori@pasuruannet.com', '23-10-30', 5, 'Dsn. Curah Malang Ds. Karang Tengah', '081391685061', 'Aktif', 0, '0', '', 1699946590, 'PPPOE', 'curahmalang_ansori', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 0, 0, 0, 125000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (402, 'Ahmad Luthfi Dzikrulloh', '101010182', 'ahmadluthfidzikrulloh@pasuruannet.com', '23-11-01', 5, 'Dsn. Gendol Ds. Prodo', '081334200836', 'Aktif', 0, '0', '', 1699947817, 'PPPOE', 'gendol_luthfi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (403, 'Mochammad Nasor', '101010183', 'mochammadnasor@pasuruannet.com', '23-11-02', 5, 'Dsn. Umbulan Lor Ds. Umbulan', '082332013083', 'Aktif', 0, '0', '', 1699951709, 'PPPOE', 'umbulan_nasor', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 346, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (404, 'Siti Nafisah', '101010184', 'sitinafisah@bytehome.id', '23-11-10', 5, 'Dsn. Kedungwaru Lor Ds. Sidepan', '081244098793', 'Aktif', 0, '0', '', 1700465595, 'PPPOE', 'kedungwarulor_nafisah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (405, 'M. Solekhudin', '101020139', 'msolekhudin@bytehome.id', '23-11-14', 5, 'Dsn. Klodangan Ds. Wonoajati', '085852478454', 'Aktif', 0, '0', '', 1700466282, 'PPPOE', 'klodangan_solekhudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 127, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (406, 'Musrifa', '101010185', 'musrifa@bytehome.id', '23-11-14', 5, 'Dsn. Prodo Ds. Prodo', '085852083203', 'Non-Aktif', 0, '0', '', 1700468646, 'PPPOE', 'prodo_musrifah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 0, 120000, '', 0, '', 0, 2, 1, 464, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (407, 'Saiful Arif', '101010186', 'saifularif@bytehome.id', '23-11-16', 5, 'Dsn. Ngayon Ds. Kandung', '085334928665', 'Aktif', 0, '0', '', 1700468702, 'PPPOE', 'ngayon_arif', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (408, 'Hani Sri Hartatik', '101010187', 'hanisrihartatik@bytehome.id', '23-11-14', 5, 'Dsn. Prodo Ds. Prodo', '082244104012', 'Aktif', 0, '0', '', 1700468870, 'PPPOE', 'prodo_hani', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (409, 'Aqidah', '101010188', 'aqidah@bytehome.id', '23-11-13', 5, 'Dsn. Ketonggo Ds. Lebak', '081333998499', 'Aktif', 0, '0', '', 1700469456, 'PPPOE', 'ketonggo_aqidah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 273, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (410, 'Maria Poncowati Wulansari', '101040045', 'mariaponcowatiwulansari@bytehome.id', '23-11-12', 5, 'Karang Kliwon', '085786152931', 'Non-Aktif', 0, '0', '', 1700469961, 'PPPOE', 'karangkliwon_maria', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 299, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (411, 'Chalimah / Zainal Abidin', '101020140', 'chalimah/zainalabidin@bytehome.id', '23-11-21', 5, 'Dsn. Podokaton Ds. Bayeman', '085790421051', 'Aktif', 0, '0', '', 1700703146, 'PPPOE', 'podokaton_zainal', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (412, 'Chusnul Chotimah', '101010189', 'chusnulchotimah@bytehome.id', '23-11-21', 5, 'Dsn. Karang Pandan Ds. Karang Pandan', '087859956968', 'Non-Aktif', 0, '0', '', 1700703266, 'PPPOE', 'karangpandan_chusnul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (413, 'susilowati', '101030031', 'susilowati@bytehome.id', '23-11-24', 5, 'Dsn. Bantengan Ds. Sadengrejo', '083122820618', 'Non-Aktif', 0, '0', '', 1700886805, 'PPPOE', 'bantengan_susilowati', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 167, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (414, 'Nur Yakin', '101030032', 'nuryakin@bytehome.id', '23-11-25', 5, 'Dsn. Bnatengan Ds. Sadengrejo', '083140682883', 'Non-Aktif', 0, '0', '', 1701065793, 'PPPOE', 'bantengan_yakin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 127, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (415, 'Ainul Yaqin', '101010190', 'ainulyaqin@bytehome.id', '23-11-25', 5, 'Dsn. Karang Pandan Ds. Karang Pandan', '081903033939', 'Non-Aktif', 0, '0', '', 1701066449, 'PPPOE', 'karangpandan_ainul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (416, 'Somad', '101030033', 'Somad@bytehome.id', '23-12-04', 5, 'Dsn . Lobang Ds. Pandanrejo', '083130025809', 'Aktif', 0, '0', '', 1702366768, 'PPPOE', 'lobang_somad', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 480, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (417, 'Safa\'at', '101020141', 'Safaat@bytehome.id', '23-11-29', 5, 'Dsn. Krajan Ds. Bayeman', '085778406844', 'Aktif', 0, '0', '', 1702366934, 'PPPOE', 'bayeman_safaat', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 61, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (418, 'Putri Maira Salmah', '101020142', 'putrimairasalmah@bytehome.id', '23-12-05', 5, 'Dsn. Kebonsawo Ds. Keboncandi', '085746534197', 'Aktif', 0, '0', '', 1702367006, 'PPPOE', 'kebonsawo_maira', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 248, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (419, 'Asmaul Khusnah', '101010191', 'asmaulkhusnah@bytehome.id', '23-11-29', 5, 'Dsn. Link. Prajaya Ds. Karang Tengah (Bayeman)', '085700744316', 'Aktif', 0, '0', '', 1702368108, 'PPPOE', 'bayeman_asmaul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (420, 'Ayu Asmawati', '101030034', 'ayuasnawati@bytehome.id', '23-12-07', 5, 'Dsn. Ketegan Ds. Ketegan', '082224222873', 'Aktif', 0, '0', '', 1702368383, 'PPPOE', 'ketegan_ayuasmawati', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 369, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (421, 'Fina Fatmawati/Samsul Muqorobin', '101040046', 'finafatmawati/samsulmuqorobin@bytehome.id', '23-12-07', 5, 'Dsn. Klotoan Ds, Kebonrejo', '085853670302', 'Aktif', 0, '0', '', 1702368504, 'PPPOE', 'klotokan_fina', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (422, 'Khanuniatus Sholikhah', '101010192', 'khanuniatussholikhah@bytehome.id', '23-11-30', 5, 'Dsn. Gendol Ds. Prodo', '083833440115', 'Aktif', 0, '0', '', 1702368743, 'PPPOE', 'gendol_khanuniatus', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 111, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (423, 'Maisaroh', '101040047', 'maisaroh1@bytehome.id', '23-12-08', 5, 'Dsn. Curahwulu Ds. Karanglo', '085755467938', 'Aktif', 0, '0', '', 1702369548, 'PPPOE', 'curahwulu_maisaroh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 284, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (424, 'Purnomo', '101040048', 'purnomo@bytehome.id', '23-12-02', 5, 'Dsn. Kedawung Wetan Ds. Grati Tunon (Buntalan)', '083129636166', 'Non-Aktif', 0, '0', '', 1702626463, 'PPPOE', 'buntalan_purnomo', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 566, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (425, 'Fathur Rohman', '101010193', 'fathurrohman@bytehome.id', '23-12-11', 5, 'Dsn. Mulyorejo Lor Ds. Umbulan', '082264580182', 'Aktif', 0, '0', '', 1702628294, 'PPPOE', 'mulyorejo_fathur', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 230, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (426, 'Nur Maulidah', '101030035', 'nurmaulidah@bytehome.id', '23-12-17', 5, 'Dsn. Karangpandan Ds. Karangpandan', '085708222793', 'Aktif', 0, '0', '', 1702949848, 'PPPOE', 'karangpandan_maulidah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 127, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (427, 'Achmad Baihaki', '101070006', 'achmadbaihaki@bytehome.id', '23-12-12', 5, 'Dsn. Jagan Ds. Tambakrejo', '081234613644', 'Aktif', 0, '0', '', 1702950090, 'PPPOE', 'jagan_baihaki', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 75, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (428, 'Muhamad Sudariyanto', '101040049', 'muhamadsudariyanto@bytehome.id', '23-12-13', 5, 'Dsn. Kebonrejo Ds. Kebonrejo', '085855728216', 'Aktif', 0, '0', '', 1702950332, 'PPPOE', 'kebonrejo_sudariyanto', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (429, 'Bikli Rindani / Satimah', '101040050', 'biklirindani@bytehome.id', '23-12-14', 5, 'Dsn. Kedungwaru Kidul Ds. Sidepan', '085230249532', 'Aktif', 0, '0', '', 1702951318, 'PPPOE', 'kedungwaru_satimah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 607, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (430, 'M. Kamali', '101010194', 'kamali1@bytehome.id', '23-10-17', 5, 'Dsn. Pandean Ds. Winongan Kidul', '06285755311669', 'Non-Aktif', 0, '0', '', 1702976286, 'PPPOE', 'pandean_kamali', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (431, 'M. Junaedi', '101020143', 'mjunaedi@bytehome.id', '23-12-22', 5, 'Dsn. Bangilan Ds. Keboncandi', '082335466714', 'Aktif', 0, '0', '', 1703562294, 'PPPOE', 'bangilan_junaedi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 122, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (432, 'Yuni Prihatiningsih', '101020144', 'yuniprihatiningsih@bytehome.id', '23-12-23', 5, 'Dsn. Ranggeh Ds. Ranggeh', '085655358835', 'Aktif', 0, '0', '', 1703563238, 'PPPOE', 'ranggeh_yuni', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 469, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (433, 'Muhammad Syaikhudin', '101020145', 'muhammadsyaikhudin@bytehome.id', '23-12-23', 5, 'Jln. Gus Dur Ds. Brambang', '081321923703', 'Aktif', 0, '0', '', 1703563788, 'PPPOE', 'brambang_syaikhudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 167, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (434, 'As\'adur Rosad', '101010195', 'asadurrosad@bytehome.id', '24-01-06', 5, 'Dsn. Karangmojo, Ds. Karang Tengah', '085785685334', 'Aktif', 0, '0', '', 1704521738, 'PPPOE', 'karangmojo_rosad', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (435, 'Mar\'ah Qonitatilah', '101010196', 'mar\'ahqonitatillah01@bytehome.id', '24-01-06', 5, 'Dsn.Wulu Ds.Mendalan Winongan', '085872797658', 'Aktif', 0, '0', '', 1704526669, 'PPPOE', 'wulu_qonitatillah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 0, 120000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (436, 'Nora Dianti', '101020146', 'noradianti@bytehome.id', '24-01-26', 5, 'Dsn. Siring Ds. Siring (Prajaya Bayeman)', '082139181091', 'Aktif', 0, '0', '', 1705029140, 'PPPOE', 'bayeman_noradianti', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 129, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (437, 'Imroatul Azizah', '101020147', 'imroatulazizah@bytehome.id', '23-12-29', 5, 'Dsn Krajan Ds. Srigading (Ranggeh)', '081322266988', 'Non-Aktif', 0, '0', '', 1705031921, 'PPPOE', 'ranggeh_imrotul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 0, 120000, '', 0, '', 0, 2, 1, 131, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (438, 'Maulil Ilmi', '101040051', 'maulililm@bytehome.id', '23-12-30', 5, 'Dsn. Menangas Kulon Ds. Kebonrejo', '085607525553', 'Non-Aktif', 0, '0', '', 1705032440, 'PPPOE', 'menangas_maulil', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 171, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (439, 'Dimas Ardianto', '101040052', 'dimasardianto@bytehome.id', '24-01-03', 5, 'Dsn. Krajan Ds. Karangkliwon', '085748007630', 'Aktif', 0, '0', '', 1705034767, 'PPPOE', 'karangkliwon_dimas', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 167, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (440, 'Syamsul Hadi', '101010197', 'syamsulhadi@bytehome.id', '24-01-04', 5, 'Dsn. Mulyorejo Umbulan Ds. Umbulan', '081221935928', 'Aktif', 0, '0', '', 1705136431, 'PPPOE', 'umbulan_syamsulhadi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 140, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (441, 'Mukhamad Sodek', '101030036', 'mukhamadsodek@bytehome.id', '24-01-05', 5, 'Dsn. Ketegan Ds. Ketegan', '081232146981', 'Non-Aktif', 0, '0', '', 1705382058, 'PPPOE', 'ketegan_sodek', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (442, 'Munarti', '101010198', 'munarti@bytehome.id', '24-01-05', 5, 'Dsn. Dukuh Kidul Ds. Sumberrejo (Jeladri Sentono)', '085648971034', 'Aktif', 0, '0', '', 1705382151, 'PPPOE', 'jeladri_munarti', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 179, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (443, 'Mutimul Faidah', '101010199', 'mutimulfaidah@bytehome.id', '24-01-06', 5, 'Dsn. Kletek Lor Mendalan', '083846708831', 'Non-Aktif', 0, '0', '', 1705382708, 'PPPOE', 'kleteklor_mutimul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (444, 'Sayyid Hasan Fahmi (Pabrik Malika)', '101010200', 'sayyidhasanfahmipabrikmalika@bytehome.id', '24-01-08', 5, 'Dsn. Bandaran Lor Ds.Bandaran', '085967009996', 'Non-Aktif', 0, '0', '', 1705382988, 'PPPOE', 'bandaran_sayyid', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '30Mbps', 1, 0, 1, 0, 1, 285000, '', 0, '', 0, 2, 1, 61, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (445, 'Iftita Rokhmah Aprilia', '101010201', 'iftitarokhmahaprilia@bytehome.id', '24-01-08', 5, 'Dsn. Kletek Lor Mendalan', '081331343144', 'Non-Aktif', 0, '0', '', 1705383091, 'PPPOE', 'kleteklor_iftita', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (446, 'Kusaini', '101050002', 'khusaini@bytehome.id', '24-01-10', 5, 'Dsn. Nguling Ds. Brambang', '083142155418', 'Aktif', 0, '0', '', 1705383893, 'PPPOE', 'brambang_kusaini', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 61, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (447, 'Hari Sa\'roni', '101010202', 'harisaroni@bytehome.id', '24-01-11', 5, 'Dsn. Karangmojo Ds. Karang Tengah', '081234212292', 'Aktif', 1, '0', '', 1705463731, 'PPPOE', 'karangmojo_harisaroni', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 117, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (448, 'Saifur Rokhman', '101070007', 'saifurrokhman@bytehome.id', '24-01-12', 5, 'Dsn. Rojogunting Ds. Kalirejo', '085733507897', 'Non-Aktif', 0, '0', '', 1705465664, 'PPPOE', '', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (449, 'Akhmad Asfar', '101030037', 'akhmadasfar@bytehome.id', '24-01-12', 5, 'Dsn. Pandansari Ds. Pandanrejo', '085213544456', 'Aktif', 0, '0', '', 1705467448, 'PPPOE', ' pandansari_asfar', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 131, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (450, 'Zainul Arifin', '101070008', 'zainularifin1@bytehome.id', '24-01-12', 5, 'Dsn. Lodo Ds. Kalirejo', '085735449789', 'Non-Aktif', 0, '0', '', 1705467620, 'PPPOE', 'lodo_zainul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 75, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (451, 'Slamet', '101010203', 'slamet@bytehome.id', '24-01-16', 5, 'Dsn. Lebak Ds. Lebak', '085746644600', 'Non-Aktif', 0, '0', '', 1705909555, 'PPPOE', 'lebak_slamet', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (452, 'Santi Sri Wilujeng (ranggeh)', '101020148', 'santisriwilujengranggeh@bytehome.id', '24-01-17', 5, 'Dsn. Serambi, Ds. Winongan Kidul (ranggeh)', '081232739198', 'Non-Aktif', 0, '0', '', 1705909794, 'PPPOE', 'ranggeh_santi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 0, 120000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (453, 'Yuliana', '101020149', 'yuliana@bytehome.id', '24-01-17', 5, 'Dsn. Klodangan Ds. Wonojati', '083836926989', 'Aktif', 0, '0', '', 1705909932, 'PPPOE', 'klodangan_yuliana', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (454, 'Siti Khodijah (Lesehan Beran)', '101070009', 'sitikhodijah@bytehome.id', '24-01-18', 5, 'Dsn. Krajan Ds. Ngabar (Lesehan Beran)', '082230205811', 'Aktif', 0, '0', '', 1705910099, 'PPPOE', 'beran_khodijah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 252, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (455, 'Mukhamad Tohir', '101040053', 'mukhamadtokhir@bytehome.id', '24-01-18', 5, 'Dsn. Buntalan Ds. Kedawung Wetan', '0813346286434', 'Non-Aktif', 0, '0', '', 1705910459, 'PPPOE', 'buntalan_tohir', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (456, 'Samsudin', '101010205', 'samsudin2@bytehome.id', '24-01-19', 5, 'Dsn. Kurban Ds.Gading', '082331503166', 'Non-Aktif', 0, '0', '', 1705910893, 'PPPOE', 'kurban_samsudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (457, 'Firdausi Nuzula', '101030038', 'firdausinuzula@bytehome.id', '24-01-20', 5, 'Dsn. Lobang Ds. Pandanrejo', '081223433055', 'Aktif', 0, '0', '', 1705913222, 'PPPOE', 'lobang_firda', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 167, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (458, 'Rachmat Supriyanto', '101010206', 'rachmatsupriyanto@bytehome.id', '24-01-22', 5, 'Dsn. Bandarankidul Ds. Bandaran', '085608590156', 'Non-Aktif', 0, '0', '', 1705913329, 'PPPOE', 'bandaran_supriyanto', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (459, 'Surotul A\'yuni', '101010207', 'surotulayuni@bytehome.id', '24-01-24', 5, 'Dsn. Curahmalang Ds. Karangtengah', '08813239308', 'Non-Aktif', 0, '0', '', 1706157366, 'PPPOE', 'curahmalang_surotul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (460, 'Much. Yusuf', '101010208', 'muchyusuf@bytehome.id', '24-01-24', 5, 'Dsn. Kasiman Ds. Bandaran', '081333051110', 'Aktif', 0, '0', '', 1706158536, 'PPPOE', 'kasiman_yusuf', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 14, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (461, 'Sukar', '101010209', 'sukar@bytehome.id', '24-01-24', 5, 'Dsn. Balun Ds. Gading (Gudang Mebel Balun)', '082236763829', 'Non-Aktif', 0, '0', '', 1706510446, 'PPPOE', 'balun_sukar', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (462, 'Indah Royani', '101010210', 'indahroyani@bytehome.id', '24-02-03', 5, 'Dsn. Ngayon Ds. Kandung', '085876174841', 'Aktif', 0, '0', '', 1707970511, 'PPPOE', 'ngayon_indah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 248, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (463, 'Alfaizin', '101010211', 'alfaizin@bytehome.id', '24-02-06', 5, 'Dsn. Pandean Ds. Winongan KIdul', '085730833290', 'Aktif', 0, '0', '', 1707972701, 'PPPOE', 'pandean_alfaizin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 299, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (464, 'Zaka Alfarizi', '101110001', 'zakaalfarizi@bytehome.id', '24-02-06', 5, 'Dsn. Sekargadung Ds. Purworejo ', '083115294919', 'Aktif', 0, '0', '', 1707972897, 'PPPOE', 'sekargadung_zaka', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 401, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (465, 'Farida', '101030039', 'farida@bytehome.id', '24-02-06', 5, 'Dsn. Sadeng Ds. Sadengrejo', '083854975305', 'Non-Aktif', 0, '0', '', 1707980642, 'PPPOE', 'sadeng_farida', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 171, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (466, 'Muhammad Jazuli', '101010212', 'muhammadjazuli@bytehome.id', '24-02-13', 5, 'Dsn. Kletek Lor Ds. Mendalan', '083850226001', 'Aktif', 0, '0', '', 1707981642, 'PPPOE', 'kleteklor_jazuli', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 494, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (467, 'Siti Kholifa', '101010213', 'sitikholifa@bytehome.id', '24-02-16', 5, 'Dsn. Grobyok Ds. Kedungrejo', '082337805715', 'Aktif', 0, '0', '', 1708407357, 'PPPOE', 'kedungrejo_kholifah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 151, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (468, 'M. Safi\'i', '101030040', 'm.safi\'i@bytehome.id', '24-02-16', 5, 'Dsn. Pade\'an Ds. Jarangan ', '081227430381', 'Aktif', 0, '0', '', 1708407576, 'PPPOE', 'padekan_safii', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (469, 'Toyimah', '101020150', 'toyimah@bytehome.id', '24-02-16', 5, 'Dsn. Tenggilis Ds. Tenggilis Rejo', '085706401834', 'Non-Aktif', 0, '0', '', 1708409134, 'PPPOE', 'tenggilis_toyimah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (470, 'Zamroni', '101020151', 'zamroni@bytehome.id', '24-02-16', 5, 'Dsn. Karang Asem Ds. Tenggilis Rejo', '085236514684', 'Aktif', 0, '0', '', 1708409708, 'PPPOE', 'tenggilis_zamroni', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (471, 'Rukhiyanah', '101010214', 'rukhiyanah@bytehome.id', '24-02-17', 5, 'Dsn. Bandaran Kidul Ds. Bandaran', '083110755516', 'Aktif', 0, '0', '', 1708410976, 'PPPOE', 'bandaran_rukhiyanah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15 Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (472, 'Agus Sugianto', '101070010', 'agussugianto@bytehome.id', '24-02-19', 5, 'Dsn. Krajan 04 Ds. Kedungrejo', '0882005425667', 'Aktif', 0, '0', '', 1708411394, 'PPPOE', 'kedungrejo_agus', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 273, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (473, 'Mochamad Nur Hidayat', '101010215', 'mochamadnurhidayat@bytehome.id', '24-01-30', 5, 'Dsn. Gambiran Indah Ds. Bandaran (Mbulak)', '082131430044', 'Aktif', 0, '0', '', 1708497039, 'PPPOE', 'gambiran_hidayat', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 273, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (474, 'Abd. Hasan', '101010216', 'abd.hasan@bytehome.id', '24-02-12', 5, 'Dsn. Kalongan Ds.Mendalan', '083192813656', 'Aktif', 0, '0', '', 1708497431, 'PPPOE', 'kalongan_hasan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 600, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (475, 'M. Irfan', '101010217', 'm.irfan@bytehome.id', '24-02-19', 5, 'Dsn. Gading Ds. Gading (Beran)', '081259931580', 'Aktif', 0, '0', '', 1708497712, 'PPPOE', 'beran_irfan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (476, 'Akhmad Suhendrik', '101020152', 'akhmadsuhendrik@bytehome.id', '24-02-19', 5, 'Dsn. Kebonrejo Ds. Kebonrejo', '083848831034', 'Aktif', 0, '0', '', 1708499179, 'PPPOE', 'kebonrejo_suhendrik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 335, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (477, 'Akhmad Said', '101020153', 'akhmadsaid@bytehome.id', '24-02-23', 5, 'Dsn. Tenggilis Rejo Ds. Tenggilis Rejo', '085748616147', 'Non-Aktif', 0, '0', '', 1709000729, 'PPPOE', 'tenggilis_said', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 248, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (478, 'Anwar Fuadi', '101020154', 'anwarfuadi@bytehome.id', '24-02-26', 5, 'Dsn. Kebonrejo Ds. Kebonrejo', '082244294357', 'Aktif', 0, '0', '', 1709005640, 'PPPOE', 'kebonrejo_anwar', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (479, 'Fendi Maulana', '101010218', 'fendiMaulana@bytehome.id', '24-02-23', 5, 'Dsn. Karang Mojo Ds. Karang Tengah', '085606032479', 'Aktif', 0, '0', '', 1709021013, 'PPPOE', 'karangmojo_fendi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (480, 'Indah Safitri', '101040054', 'indahsafitri@bytehome.id', '24-02-27', 5, 'Dsn. Krajan Ds. Kambingan Rejo', '085755377586', 'Aktif', 0, '0', '', 1710469966, 'PPPOE', 'kambingan_indah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 140, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (481, 'Edy Mukhlason', '101070011', 'edymukhlason@bytehome.id', '24-02-27', 5, 'Dsn. Lodo Ds. Kalirejo', '085693665655', 'Aktif', 0, '0', '', 1710470354, 'PPPOE', 'lodo_edymukhlason', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 117, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (482, 'Risalatun Nisak', '101020155', 'risalatunnisak@bytehome.id', '24-02-27', 5, 'Dsn. Mantingan Ds. Tenggilis Rejo', '083846505419', 'Aktif', 0, '0', '', 1710471572, 'PPPOE', 'mantingan_risalatun', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 171, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (483, 'Qurotul A\'yuni', '101010219', 'qurotulayuni@bytehome.id', '24-02-28', 5, 'Dsn. Gendol Ds. Prodo', '085755451004', 'Aktif', 0, '0', '', 1710473379, 'PPPOE', 'gendol_qurotul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (484, 'M. Dwiki Ilhamsyah', '101010220', 'm.dwikiilhamsyah@bytehome.id', '24-02-29', 5, 'Dsn. karangmojo Ds. Karangtengah', '088226113923', 'Aktif', 0, '0', '', 1710474215, 'PPPOE', 'karangtengah_dwiki', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (485, 'Fadhuloh', '101070012', 'fadhuloh@bytehome.id', '24-02-29', 5, 'Dsn. karanganyar Ds. Karang Sentul', '087754414441', 'Non-Aktif', 0, '0', '', 1710476756, 'PPPOE', 'karangganyar_fadhuloh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 333, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (486, 'Humairoh', '101130003', 'humairoh@bytehome.id', '24-03-01', 5, 'Dsn. Watugilang Ds. Cukur Guling (Lumbang)', '082334877786', 'Aktif', 0, '0', '', 1710477915, 'PPPOE', 'lumbang_humairoh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (487, 'Rafi ahmad', '101020156', 'rafiahmad@bytehome.id', '24-03-02', 5, 'Jl. Panglima Sudirman 16 Ds. Purworejo (sekaran)', '081515814307', 'Aktif', 0, '0', '', 1710479617, 'PPPOE', 'sekaran_rafi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 248, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (488, 'Nur Hasana', '101020157', 'nurhasana@bytehome.id', '24-03-05', 5, 'Dsn. Kiringan Ds. Wonojati', '081336007818', 'Non-Aktif', 0, '0', '', 1710558063, 'PPPOE', 'kiringan_hasana', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (489, 'Jam\'ul jawamik / Subur', '101040055', 'jamuljawamik/subur@bytehome.id', '24-03-05', 5, 'Dsn. Petang Puluh Ds. Sumber Agung', '085607138568', 'Aktif', 0, '0', '', 1710558242, 'PPPOE', 'petangpuluh_subur', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (490, 'Dzurrotun Nafisah', '101020158', 'dzurrotunnafisah@bytehome.id', '24-03-05', 5, 'Dsn. Kiringan Ds. Wonojati', '087818063253', 'Aktif', 0, '0', '', 1710558435, 'PPPOE', 'kiringan_dzurrotun', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 237, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (491, 'Hermanto', '101020159', 'hermanto@bytehome.id', '24-03-07', 5, 'Dsn. Brambang Ds. Brambang', '085708624927', 'Aktif', 0, '0', '', 1710559764, 'PPPOE', 'brambang_hermanto', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 65, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (492, 'Muhammad Machfud', '101020160', 'muhammadmachfud@bytehome.id', '24-03-09', 5, 'Dsn. Sekarputih Ds. Sekarputih', '085730030644', 'Non-Aktif', 0, '0', '', 1710562732, 'PPPOE', 'sekarputih_machfud', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 225000, '', 0, '', 0, 2, 1, 261, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (493, 'M. Ibnu Mundir', '101030041', 'm.ibnumundir@bytehome.id', '24-03-11', 5, 'Dsn. Sadengrejo Ds. Sadengrejo', '083122365399', 'Non-Aktif', 0, '0', '', 1710564385, 'PPPOE', 'sadeng_ibnumundir', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 333, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (494, 'Ta\'in', '101010221', 'tain@bytehome.id', '23-11-27', 5, 'Dsn. Kletek Kidul, Ds. Mendalan', '085888555321', 'Non-Aktif', 0, '0', '', 1710565474, 'PPPOE', 'mendalan_tain', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 72, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (495, 'Sri Wulandari', '101010222', 'sriwulandari@bytehome.id', '24-03-12', 5, 'Dsn. Bandaran Kidul Ds. Bandaran (Sentul)', '082131794717', 'Non-Aktif', 0, '0', '', 1710747344, 'PPPOE', 'sentul_wulandari', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 33, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (496, 'Muhammad Rohman', '101010223', 'muhammadrRohman@bytehome.id', '24-03-14', 5, 'Dsn. Karangmojo Ds. Karang Tengah', '085785083699', 'Non-Aktif', 0, '0', '', 1710749803, 'PPPOE', 'karangmojo_rohman', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (497, 'Maskurin', '101010224', 'maskurin@bytehome.id', '24-03-15', 5, 'Dsn. Bambang Ds. Bambang (Prodo)', '085706709452', 'Aktif', 0, '0', '', 1710749897, 'PPPOE', 'prodo_maskurin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 151, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (498, 'Maslikha', '101020161', 'maslikha@bytehome.id', '24-03-07', 5, 'Dsn. Tenggilis Ds. Tenggilis Rejo', '085646768298', 'Aktif', 0, '0', '', 1710817081, 'PPPOE', 'tenggili_maslikha', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (499, 'Sukarsih', '101010225', 'sukarsih@bytehome.id', '24-03-18', 5, 'Dsn. Pandean Ds. Winongan Kidul', '081334249863', 'Aktif', 0, '0', '', 1710898057, 'PPPOE', 'pandean_sukarsih', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 566, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (500, 'Fahrul Fuadi Al Fatih / Abd. Wakhid', '101010226', 'fahrul@bytehome.id', '24-03-18', 5, 'Dsn. Lebak Ds. Lebak', '081916611751', 'Aktif', 0, '0', '', 1710899867, 'PPPOE', 'lebak_fahrul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 370, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (501, 'Amaliyah Mukmilah', '101030042', 'amaliyahmukmilah@bytehome.id', '24-03-19', 5, 'Dsn. Suklan Ds. Pandanrejo', '083834307041', 'Aktif', 0, '0', '', 1710900181, 'PPPOE', 'suklan_amaliyah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 370, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (502, 'Lutfiyah', '101070013', 'lutfiyah@bytehome.id', '24-03-19', 5, 'Dsn. Kalimalang Ds. Kalirejo', '083869001408', 'Aktif', 0, '0', '', 1710900981, 'PPPOE', 'kalimalang_lutfiah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 167, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (503, 'Suci Setiafani', '101030043', 'sucisetiafani@bytehome.id', '24-03-19', 5, 'Dsn. Ketegan Ds. Ketegan', '083857130153', 'Aktif', 0, '0', '', 1711426826, 'PPPOE', 'ketegan_suci', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (504, 'Muhammad Arifin', '101070014', 'muhammadarifin@bytehome.id', '24-03-20', 5, 'Dsn. Ponjen Ds. Kencong (Jeruk Tengah Sidogiri)', '083131644030', 'Non-Aktif', 0, '0', '', 1711427282, 'PPPOE', 'sidogirijeruk_arifin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 2, 1, 291, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (505, 'Jainul Rozak', '101010227', 'jainulrozak@bytehome.id', '24-03-21', 5, 'Dsn. Kruyolor Ds. Umbulan', '085334653260', 'Aktif', 0, '0', '', 1711427629, 'PPPOE', 'umbulan_jainul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 347, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (506, 'Saudi Aminur', '101010228', 'saudiaminur@bytehome.id', '24-03-21', 5, 'Dsn. Sruwi Ds. Sruwi', '08565627783', 'Non-Aktif', 0, '0', '', 1711428529, 'PPPOE', 'sruwi_saudi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 120000, '', 0, '', 0, 2, 1, 561, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (507, 'Moh. Ansori', '101010229', 'moh.ansori@bytehome.id', '24-03-22', 5, 'Dsn. Karangtengah Barat Ds. Karangtengah', '085704548510', 'Non-Aktif', 0, '0', '', 1711429328, 'PPPOE', 'karangtengah_ansori', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 801, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (508, 'Inayatul Arkhiyah', '101030044', 'inayatularkhiyah@bytehome.id', '24-03-22', 5, 'Dsn. Pandansari Ds. Pandanrejo', '085646044372', 'Non-Aktif', 0, '0', '', 1711429746, 'PPPOE', 'pandansari_inayatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 863, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (509, 'Baldes Kedungrejo1', '101010230', 'mafula@bytehome.id', '24-03-25', 5, 'Dsn. Krajan 01 Ds. Kedungrejo', '088136982969', 'Non-Aktif', 0, '0', '', 1711434436, 'PPPOE', 'kedungrejo_balaidesa1', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 0, 22297, '', 0, '', 0, 2, 1, 973, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (510, 'Camat', '101020162', 'camat@bytehome.id', '24-03-29', 5, 'Dsn. Krajan Ds. Tenggilisrejo', '085334837654', 'Aktif', 0, '0', '', 1713579182, 'PPPOE', 'tenggilis_camat', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 333, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (511, 'Nafi\'i', '101010231', 'nafi\'i@bytehome.id', '24-03-30', 5, 'Dsn. Kruyokidul Ds. Umbulan', '081252012977', 'Aktif', 0, '0', '', 1713581825, 'PPPOE', 'umbulan_nafii', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 809, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (512, 'Kosim', '101010232', 'kosim01@bytehome.id', '24-03-31', 5, 'Dsn. Gading Ds. Gading', '085226048384', 'Aktif', 0, '0', '', 1713582648, 'PPPOE', 'gading_subchan', 0, 131, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 501, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (513, 'M. Nur Khayyi', '101010233', 'm.nurkhayyi@bytehome.id', '24-04-01', 5, 'Dsn. Karang Tengah timur Ds. Karang Tengah', '085608154064', 'Non-Aktif', 0, '0', '', 1713582819, 'PPPOE', 'karangtengah_nurkhayi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 1166, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (514, 'Nailul Hubad', '101010234', 'nailulhubad@bytehome.id', '24-04-02', 5, 'Dsn. Kurban Ds. Gading', '081216445404', 'Aktif', 0, '0', '', 1713585647, 'PPPOE', 'kurban_hubad', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1137, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (515, 'Nasifah', '101010235', 'nasifah@bytehome.id', '24-04-02', 5, 'Dsn. Brintik Kidul Ds. Penataan', '082137056746', 'Aktif', 0, '0', '', 1713586537, 'PPPOE', 'brintikkidul_nasifah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 335, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (516, 'Erika Amelia', '101020163', 'erikaamelia@bytehome.id', '24-04-17', 5, 'Dsn. Pekangkungan Ds. Pekangkungan', '085790424330', 'Aktif', 0, '0', '', 1713592866, 'PPPOE', 'pekangkungan_erika', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 384, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (517, 'Musarofah', '101020164', 'musarofah@bytehome.id', '24-04-17', 5, 'Dsn. Pekangkungan Ds. Pekangkungan', '083182393586', 'Non-Aktif', 0, '0', '', 1713593261, 'PPPOE', 'pekangkungan_musarofah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 1050, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (518, 'Nasihudin', '101010236', 'nasihudin2@bytehome.id', '24-04-19', 5, 'Dsn. Kruyolor Ds. Umbulan', '081259464522', 'Aktif', 0, '0', '', 1713846302, 'PPPOE', 'umbulan_nasihudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 416, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (519, 'Ismail', '101010237', 'ismail2@bytehome.id', '24-04-19', 5, 'Dsn. Umbulan Ds. Umbulan', '081252798361', 'Aktif', 0, '0', '', 1713847562, 'PPPOE', 'umbulan_ismail', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 818, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (520, 'M. Mauludin Hariyanto', '101040056', 'm.mauludinhariyanto@bytehome.id', '24-04-20', 5, 'Dsn. Buntalan Ds. Kedawung wetan', '085646570264', 'Aktif', 0, '0', '', 1713847891, 'PPPOE', 'buntalan_maulidin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 623, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (521, 'Karunia Asmaningrum', '101040057', 'karuniaasmaningrum@bytehome.id', '24-04-20', 5, 'Dsn. Krajan Ds. Kambinganrejo', '081333298311', 'Aktif', 0, '0', '', 1713848028, 'PPPOE', 'kambingan_karunia', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 529, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (522, 'Basori', '101030045', 'basori2@bytehome.id', '24-04-20', 5, 'Dsn. Sadeng Ds. Sadengrejo', '085964144704', 'Aktif', 0, '0', '', 1713849114, 'PPPOE', 'sadeng_basori', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 847, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (523, 'Hudalloh Zainul Ibad', '101010238', 'hudallohzainulibad@bytehome.id', '24-04-22', 5, 'Dsn. Sentul Ds. Winongan Lor', '085755396890', 'Aktif', 0, '0', '', 1713850590, 'PPPOE', 'sentul_hudalloh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (524, 'Sri Astutik', '101010239', 'sriastutik@bytehome.id', '24-04-22', 5, 'Dsn. Kurban Ds. Gading', '085174067378', 'Aktif', 0, '0', '', 1713850799, 'PPPOE', 'kurban_sriastutik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (525, 'Munip Afandi', '101010240', 'munipafandi@bytehome.id', '24-04-23', 5, 'Dsn. Bedilan Ds. Prodo', '085755399638', 'Aktif', 0, '0', '', 1714016560, 'PPPOE', 'bedilan_munip', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 400, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (526, 'Agus Salim', '101030046', 'agussalim1@bytehome.id', '24-04-24', 5, 'Dsn. Pekunten Ds. Bajangan (werakas)', '083821422916', 'Non-Aktif', 0, '0', '', 1714018702, 'PPPOE', 'werakas_agussalim', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 749, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (527, 'Khoiril Anam', '101010241', 'khorilanam@bytehome.id', '24-04-25', 5, 'Dsn. Mulyorejo Kidul Ds. Umbulan', '082228708902', 'Aktif', 0, '0', '', 1714209938, 'PPPOE', 'umbulan_khoirilanam', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 20, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (528, 'Akhmad Masduki Makhfud', '101030047', 'muchamadzaini@bytehome.id', '24-04-25', 5, 'Dsn. Ketegan Ds. Ketegan', '082329198041', 'Aktif', 0, '0', '', 1714211273, 'PPPOE', 'ketegan_masduki', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 20, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (529, 'Baldes Pateguhan', '101020165', 'baldespateguhan@bytehome.id', '24-05-10', 5, 'Desa Pateguhan', '081335798377', 'Non-Aktif', 0, '0', '', 1715317690, 'PPPOE', 'pateguhan_baldes', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '20Mbps', 1, 0, 1, 0, 0, 22297, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (530, 'Izam Bagus Setiyoaji', '101020166', 'izambagussetiyoaji@bytehome.id', '24-05-03', 5, 'Dsn. Kedungkidang Ds. Barurejo (Podokaton)', '085854990035', 'Aktif', 0, '0', '', 1715842596, 'PPPOE', 'podokaton_izam', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 165, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (531, 'Hasan Bisri', '101020167', 'hasanbisri@bytehome.id', '24-05-08', 5, 'Dsn. Sekaran Ds. Wonojati', '083844130279', 'Aktif', 0, '0', '', 1715913134, 'PPPOE', 'sekaran_hasan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 917, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (532, 'Cindi Cindi Kiani', '101040058', 'cindicindikiani@bytehome.id', '24-05-09', 5, 'Dsn. Bukolan Ds. Tamansari (petangpuluh)', '085790425072', 'Non-Aktif', 0, '0', '', 1715913979, 'PPPOE', 'petangpuluh_cindi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 1123, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (533, 'Mokhammad Khamim', '101010242', 'mokhammadkhamim@bytehome.id', '24-05-14', 5, 'Dsn. Kurban Ds. Gading', '085730115433', 'Aktif', 0, '0', '', 1715924395, 'PPPOE', 'kurban_khamim', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 11, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (534, 'Selamet Riyadi', '101020168', 'selametriyadi@bytehome.id', '24-05-14', 5, 'Perum. Keboncandi Permai Ds. Karang Sentul', '081238068455', 'Non-Aktif', 0, '0', '', 1715925420, 'PPPOE', 'perumkeboncandi_slametriyadi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 270, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (535, 'Tris Warti Ningsih', '101040059', 'triswartiningsih@bytehome.id', '24-05-15', 5, 'Dsn. Kedawung Wetan Ds. Kedawung Wetan (buntalan)', '085219817568', 'Non-Aktif', 0, '0', '', 1715925559, 'PPPOE', 'buntalan_tris', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 261, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (536, 'Markhumah', '101020169', 'markhumahh@bytehome.id', '24-05-17', 5, 'Dsn.Masangan Ds.Tenggilis', '082131873251', 'Aktif', 0, '0', '', 1715927247, 'PPPOE', 'masangan_markhumah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 396, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (537, 'Cholil', '101010243', 'cholil@bytehome.id', '24-05-17', 5, 'Dsn. Dukuh Kidul Ds. Sumberrejo', '085806472964', 'Aktif', 0, '0', '', 1716257499, 'PPPOE', 'dukuhkidul_cholil', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 903, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (538, 'Sulastri', '101010244', 'sulastri@bytehome.id', '24-05-21', 5, 'Dsn. Bedilan Ds. Prodo', '082264665601', 'Aktif', 0, '0', '', 1716624505, 'PPPOE', 'bedilan_sulastri', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 29, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (539, 'Siti Nur Azizah', '101010245', 'sitinurazizah@bytehome.id', '24-05-22', 5, 'Dsn. Kandung Ds. Kandung', '085895215325', 'Aktif', 0, '0', '', 1716624634, 'PPPOE', 'kandung_azizah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (540, 'Mochamad Yusuf', '101020170', 'm.yusuf@bytehome.id', '24-05-24', 5, 'Jl. Mt Haryono 6 No 18 Ds. Mandanrejo (Karangsentul)', '081233331650', 'Non-Aktif', 0, '0', '', 1716626234, 'PPPOE', 'karangsentul_yusuf', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '30Mbps', 1, 0, 1, 0, 1, 285000, '', 0, '', 0, 2, 1, 244, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (541, 'Edy Suhartono', '101020171', 'edysuhartono@bytehome.id', '24-05-25', 5, 'Dsn. Brambang D. Brambang', '082140888858', 'Non-Aktif', 0, '0', '', 1716780275, 'PPPOE', 'brambang_edysuhartono', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '3M', 1, 0, 1, 0, 0, 120000, '', 0, '', 0, 2, 1, 55, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (542, 'Sutrisno', '101020172', 'sutrisno@bytehome.id', '24-06-08', 5, 'Dsn. Wonojati desa wonojati', '081327993036', 'Aktif', 0, '0', '', 1717831998, 'PPPOE', 'wonojati_sutrisno', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 11, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (543, 'Farid Budiono', '101010246', 'faridbudiono@bytehome.id', '24-05-29', 5, 'Dsn. Bendo Ds. Winongan Lor', '085645325743', 'Aktif', 0, '0', '', 1718693356, 'PPPOE', 'bendo_faridbudiono', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 167, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (544, 'Uswatun Hasanah', '101020173', 'uswatunhasanahsekaran@bytehome.id', '24-05-28', 5, 'Dsn. Sekaran Ds. Wonojati', '085234870994', 'Aktif', 0, '0', '', 1718695546, 'PPPOE', 'sekaran_uswatun', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 151, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (545, 'M Romli', '101020174', 'romli@bytehome.id', '24-05-30', 5, 'Dsn. Brambang Ds. Brambang', '085790811204', 'Aktif', 0, '0', '', 1718696195, 'PPPOE', 'brambang_romli', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 212, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (546, 'Hermawati', '101010247', 'hermawati@bytehome.id', '24-05-31', 5, 'Dsn. Dukuh Wates Ds.Sumberejo', '085708865880', 'Non-Aktif', 0, '0', '', 1718701382, 'PPPOE', 'dukuhwates_hermawati', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 179, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (547, 'Laili Mufidah', '101020175', 'lailimufidah@bytehome.id', '24-06-01', 5, 'Dsn. Krajan Ds. Tenggilis Rejo ', '085792063093', 'Aktif', 0, '0', '', 1718701859, 'PPPOE', 'tenggilis_laili', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (548, 'Mansur', '101010248', 'mansurketonggo@bytehome.id', '24-06-01', 5, 'Dsn. Ketonggo Ds. Lebak', '085607047498', 'Aktif', 0, '0', '', 1718766054, 'PPPOE', 'ketonggo_mansur', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (549, 'Achmad Rusdi', '101010249', 'achmadrusdi@bytehome.id', '24-06-02', 5, 'Dsn. Brintik Kidul Ds. Penataan', '082336977651', 'Aktif', 0, '0', '', 1718766331, 'PPPOE', 'brintikkidul_rusdi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 167, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (550, 'Akhmad Taufiq', '101020176', 'akhmadtaufiq@bytehome.id', '24-06-03', 5, 'Dsn. Tenggilisrejo Ds. Tenggilis Rejo', '085747948753', 'Aktif', 0, '0', '', 1718767882, 'PPPOE', 'tenggilis_taufiq', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (551, 'Khoiriyah', '101030048', 'khoiriyapandansari@bytehome.id', '24-06-03', 5, 'Dsn. Pandansari Ds. Pandanrejo', '083132656577', 'Aktif', 0, '0', '', 1718939885, 'PPPOE', 'pandansari_khoiriyah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 252, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (552, 'Indah Wahyuni', '101020177', 'indahwahyunilajuk@bytehome.id', '24-06-03', 5, 'Dsn. Lajuk Ds. Lajuk', '085808462814', 'Non-Aktif', 0, '0', '', 1718942115, 'PPPOE', 'lajuk_wahyuni', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 20, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (553, 'Achmad Suhadi', '101010250', 'achmadsuhadi@bytehome.id', '24-06-06', 5, 'Dsn. Karang Tengah Ds. Karang Tengah', '085854873168', 'Aktif', 0, '0', '', 1718942315, 'PPPOE', 'karangtengah_suhadi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (554, 'Faruq Makhrujen', '101020178', 'faruqmakhrujen@bytehome.id', '24-06-05', 5, 'Dsn. Pekangkungan Ds. Pekangkungan ', '085815417501', 'Aktif', 0, '0', '', 1718942551, 'PPPOE', 'pekangkungan_faruq', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 40, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (555, 'Abdul Bagas', '101020179', 'abdulbagas@bytehome.id', '24-06-07', 5, 'Dsn. Wonosari Ds. Wonosari (wonosalam)', '083121063572', 'Non-Aktif', 0, '0', '', 1718943254, 'PPPOE', 'wonosalam_bagas', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 171, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (556, 'Mochammad Ubaidillah', '101020180', 'mochammadubaidillah@bytehome.id', '24-06-07', 5, 'Dsn. Mojosari Ds. Pekangkungan', '082230637013', 'Aktif', 0, '0', '', 1718943342, 'PPPOE', 'pekangkungan_ubaidillah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 248, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (557, 'Syariatul Fahmi', '101010251', 'syariatulfahmi@bytehome.id', '24-06-07', 5, 'Jl. Gatoy Subroto Ds. Krapyakrejo (Penataan)', '085707961320', 'Non-Aktif', 0, '0', '', 1718943439, 'PPPOE', 'penataan_syariatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 248, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (558, 'Umi Maisaroh', '101040060', 'umimaisaroh@bytehome.id', '24-06-07', 5, 'Dsn. Pande Ds. Kambinganrejo', '085706854890', 'Aktif', 0, '0', '', 1718943548, 'PPPOE', 'kambingan_umimaisaroh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (559, 'Mideye', '101010252', 'mideye@bytehome.id', '24-06-07', 5, 'Dsn. Pandean Ds. Kandung', '085746813029', 'Aktif', 0, '0', '', 1718943936, 'PPPOE', 'kandung_mideye', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (560, 'Yuliani', '101020181', 'yuliani@bytehome.id', '24-06-07', 5, 'Dsn. Terate Ds. Karangsentul ', '085857558716', 'Non-Aktif', 0, '0', '', 1718944365, 'PPPOE', 'terate_yuliani', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 140, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (561, 'Khoirul Anam', '101010253', 'khoirulanam@bytehome.id', '24-06-08', 5, 'Dsn. Jungalang Ds. Winongan Lor', '082264858560', 'Aktif', 0, '0', '', 1718945814, 'PPPOE', 'junggalang_khoirul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (562, 'Muhammad Yasak', '101010254', 'muhammayasak@bytehome.id', '24-06-10', 5, 'Dsn. Prodo Ds. Prodo', '083845497348', 'Aktif', 0, '0', '', 1718946344, 'PPPOE', 'prodo_yasak', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 252, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (563, 'Agus Harijadi', '101020182', 'agusharijadi@bytehome.id', '24-06-10', 5, 'Dsn. Bangilan Ds. Keboncandi', '083891081144', 'Non-Aktif', 1, '0', '', 1718947588, 'PPPOE', 'bangilan_agusharijadi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (564, 'Alaika Fatkhur Rokhman', '101010255', 'alaikafatkhurrokhman@nytehome.id', '24-06-11', 5, 'Dsn. Brintik Kidul Ds. Penataan', '082245936353', 'Aktif', 0, '0', '', 1718948446, 'PPPOE', 'brintikkidul_alaika', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 237, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (565, 'Luluk Puana', '101040061', 'lulukpuana@bytehome.id', '24-06-12', 5, 'Dsn. Baran Ds. Karang Kliwon', '085604434911', 'Aktif', 0, '0', '', 1718948841, 'PPPOE', 'karangkliwon_lulukpuana', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (566, 'Hermanto', '101010256', 'hermantobrintik@bytehome.id', '24-06-12', 5, 'Dsn. Brintik Lor Ds. Menyarik', '0', 'Non-Aktif', 0, '0', '', 1718949071, 'PPPOE', 'brintiklor_hermanto', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (567, 'Moch. Cholil', '101010257', 'mochcholil@bytehome.id', '24-06-13', 5, 'Dsn. kalongan Ds. Mendalan', '085645325138', 'Aktif', 0, '0', '', 1718949753, 'PPPOE', 'kalongan_cholil', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (568, 'M. Farich Hidayat', '101010258', 'farichhidayat@bytehome.id', '24-06-14', 5, 'Dsn. Ketonggo Ds. Lebak (bedilan)', '083879890881', 'Non-Aktif', 0, '0', '', 1718951439, 'PPPOE', 'bedilan_farich', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (569, 'Mochamad Taofik', '101040062', 'mochamadtaofik@bytehome.id', '24-06-15', 5, 'Dsn. Kebonrejo Ds. Kebonrejo', '085790865254', 'Aktif', 0, '0', '', 1718951563, 'PPPOE', 'kebonrejo_taofik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 11, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (570, 'Achmad Rifa\'i Setiawan', '101010259', 'achmadrifaisetiawan@bytehome.id', '24-06-15', 5, 'Dsn. Seloliman Ds. Sruwi', '085713353624', 'Aktif', 0, '0', '', 1718952102, 'PPPOE', 'seloliman_rifai', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 20, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (571, 'Santi', '101010260', 'santiseloliman@bytehome.id', '24-06-17', 5, 'Dsn. Seloliman Ds. Sruwi', '085604463775', 'Non-Aktif', 0, '0', '', 1718952360, 'PPPOE', 'seloliman_santi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (572, 'Inda Karima', '101010261', 'indahkarima@bytehome.id', '24-06-18', 5, 'Dsn. Mancilan Ds. Pohjentrek (Pandean)', '081259151210', 'Non-Aktif', 0, '0', '', 1718952649, 'PPPOE', 'pandean_indah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (573, 'Nur Faizah', '101010262', 'nurfaizahkarangtengah@bytehome.id', '24-06-18', 5, 'Dsn. Karang Tengah Ds. Karang Tengah', '085739113475', 'Aktif', 0, '0', '', 1718952856, 'PPPOE', 'karangtengah_faizah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 0, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (574, 'Safiudin', '101010263', 'safiudin@bytehome.id', '24-06-18', 5, 'Dsn. Mulyorejolor Ds. Umbulan', '081332020881', 'Aktif', 0, '0', '', 1718953167, 'PPPOE', 'umbulan_safiudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 165, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (575, 'Rita Susanti', '101030049', 'ritasusanti@bytehome.id', '24-06-19', 5, 'Dsn. Bantengan Ds. Sadengrejo', '083856725368', 'Aktif', 0, '0', '', 1718953527, 'PPPOE', 'bantengan_rita', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (576, 'Siti Fatimah', '101010264', 'sitifatimahumbulan@bytehome.id', '24-06-19', 5, 'Dsn. Umbulan Ds. Umbulan', '081217402019', 'Aktif', 0, '0', '', 1718953964, 'PPPOE', 'umbulan_fatimah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (577, 'Avia Ika Ningsih', '101010265', 'aviaikaningsih@bytehome.id', '24-06-19', 5, 'Dsn. Kalongan Ds. Mendalan', '083150788530', 'Non-Aktif', 0, '0', '', 1718954188, 'PPPOE', 'kalongan_avia', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 273, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (578, 'Nur Umi Hanik', '101010266', 'nurumihanik@bytehome.id', '24-06-21', 5, 'Dsn. Lebak Ds. Lebak (kecik)', '085791269960', 'Non-Aktif', 0, '0', '', 1718955866, 'PPPOE', 'kecik_hanik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (579, 'Sami\'an', '101010267', 'sami\'an@bytehome.id', '24-06-21', 5, 'Dsn. Kurban Ds. Gading', '081259023147', 'Aktif', 0, '0', '', 1718957111, 'PPPOE', 'kurban_samian', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (580, 'Yunus', '101040063', 'yunus@bytehome.id', '24-06-13', 5, 'Dsn. Pandan Ds. Kebonrejo', '082232231996', 'Aktif', 0, '0', '', 1718961604, 'PPPOE', 'pandan_yunus', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (581, 'Mistam', '101040064', 'mistam@bytehome.id', '24-06-23', 5, 'Dsn. Tugu Ds. Kedawung Kulon', '081333114250', 'Aktif', 0, '0', '', 1719199892, 'PPPOE', 'tugu_mistam', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 336, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (582, 'Abdul Majid', '101010268', 'abdulmajid@bytehome.id', '24-06-24', 5, 'Dsn. Kurban Ds. Gading', '08813467475', 'Aktif', 0, '0', '', 1719367917, 'PPPOE', 'kurban_majid', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 167, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (583, 'Eko Heru Setyo', '101020183', 'ekoheru@bytehome.id', '24-07-02', 5, 'Dsn. Tampung, Ds. Kalirejo', '081215013685', 'Aktif', 0, '0', '', 1719880925, 'PPPOE', 'tampung_ekoheru', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (584, 'Muhammad Idris', '101010269', 'muhammadidris@bytehome.id', '24-06-27', 5, 'Dsn. Umbulan Ds. Umbulan', '085706682913', 'Aktif', 0, '0', '', 1721101349, 'PPPOE', 'umbulan_idris', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (585, 'Tika Nur Aida', '101010270', 'tikanuraida@bytehome.id', '24-06-27', 5, 'Dsn. Kandung Ds. Kandung', '085706164104', 'Aktif', 0, '0', '', 1721101698, 'PPPOE', 'kandung_tika', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 131, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (586, 'Mokhammad Sirojudin', '101010271', 'mokhammadsirojudin@bytehome.id', '24-06-27', 5, 'Dsn. Prodo Ds. Prodo', '0', 'Aktif', 0, '0', '', 1721102372, 'PPPOE', 'prodo_sirojudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 167, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (587, 'Febri Nur Wahyuni', '101020184', 'febrinurwahyuni@bytehome.id', '24-06-27', 5, 'Dsn. Wonosalam Ds. Wonosari', '081235984638', 'Aktif', 0, '0', '', 1721102521, 'PPPOE', 'wonosalam_febri', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 248, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (588, 'Auli Silvia Rokhili', '101010272', 'aulisilviarokhili@bytehome.id', '24-06-27', 5, 'Dsn. Jungalang Ds. Winongan Lor', '085749515048', 'Aktif', 0, '0', '', 1721102746, 'PPPOE', 'winonganlor_aulisilvia', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (589, 'Sakina Maulidiyah', '101010273', 'sakinamaulidiyah@bytehome.id', '24-06-28', 5, 'Dsn. Kampung Baru Ds. Bandaran', '083119384273', 'Aktif', 0, '0', '', 1721103222, 'PPPOE', 'bandaran_sakina', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (590, 'Nur Soleh', '101010274', 'nursoleh@bytehome.id', '24-06-28', 5, 'Dsn. Dukuh Kidul Ds. Sumberejo', '082141810619', 'Aktif', 0, '0', '', 1721108368, 'PPPOE', 'dukuhkidul_nursoleh', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (591, 'Mukhamad Edrin Irfani', '101030050', 'mukhamadedrinirfani@bytehome.id', '24-06-28', 5, 'Dsn. Suklan Ds. Pandanrejo ', '082131283751', 'Aktif', 0, '0', '', 1721108498, 'PPPOE', 'suklan_edrin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 151, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (592, 'Istin Kartikawati', '101040065', 'istinkartikawati@bytehome.id', '24-06-28', 5, 'Dsn. Menangas Kulon Ds. Kebonrejo ', '082142572732', 'Aktif', 0, '0', '', 1721108646, 'PPPOE', 'menangaskulon_istin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (593, 'Hariyanto', '101020185', 'hariyanto@bytehome.id', '24-06-28', 5, 'Sidokapasan 3/26 Ds. Sidodadi (Buyutan)', '081932503484', 'Aktif', 0, '0', '', 1721109054, 'PPPOE', 'buyutan_hariyanto', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 140, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (594, 'Khoirul Anwar', '101010275', 'khoirulanwar3@bytehome.id', '24-06-29', 5, 'Dsn. Kandung Ds. Kandung', '081216574433', 'Aktif', 0, '0', '', 1721109318, 'PPPOE', 'kandung_anwar', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (595, 'Isnail Makrufah', '101020186', 'isnailmakrufah@bytehome.id', '24-06-29', 5, 'Dsn. Gayam Ds. Gayam', '081234023168', 'Aktif', 0, '0', '', 1721109574, 'PPPOE', 'gayam_isnaila', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (596, 'Umi Kulsum', '101010276', 'umikulsum@bytehome.id', '24-06-29', 5, 'Dsn. Lebak Ds. Lebak', '088231985930', 'Aktif', 0, '0', '', 1721109948, 'PPPOE', 'kemong_umikulsum', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 140, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (597, 'Sufiatul Badriyah', '101010277', 'sufiatulbadriyah@bytehome.id', '24-07-01', 5, 'Dsn. Kletek Lor Ds. Mendalan', '081249253972', 'Aktif', 0, '0', '', 1721110410, 'PPPOE', 'kleteklor_sufiatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (598, 'Mustofa', '101010278', 'mustofa3@bytehome.id', '24-07-01', 5, 'Dsn. Kandung Ds. Kandung', '081232510336', 'Non-Aktif', 0, '0', '', 1721110569, 'PPPOE', 'kandung_mustofa', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 270, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (599, 'Munip Hidayatulloh', '101010279', 'muniphidayatulloh@bytehome.id', '24-07-01', 5, 'Dsn. Menyarik Kulon Ds. Menyarik', '085236747324', 'Aktif', 0, '0', '', 1721110695, 'PPPOE', 'menyarik_munip', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (600, 'Fauzi', '101010280', 'fauzi@bytehome.id', '24-07-01', 5, 'Dsn. Kemong Ds. Winongan Kidul', '083105261109', 'Aktif', 0, '0', '', 1721110825, 'PPPOE', 'kemong_fauzi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 151, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (601, 'Muhammad Nizar', '101020187', 'muhammadnizar@bytehome.id', '24-07-01', 5, 'Dsn. Sekaran Ds. Wonojati', '085855933488', 'Aktif', 0, '0', '', 1721110962, 'PPPOE', 'sekaran_nizar', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (602, 'Ripan Arip', '101020188', 'ripanarip@bytehome.id', '24-07-01', 5, 'Dsn. Terate Ds. Karangsentul ', '083821774193', 'Aktif', 0, '0', '', 1721111088, 'PPPOE', 'terate_ripan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (603, 'Kholilah', '101020189', 'kholilah@bytehome.id', '24-07-01', 5, 'Dsn. Sekaran Ds. Wonojati', '085736670674', 'Aktif', 0, '0', '', 1721111203, 'PPPOE', 'sekaran_kholilah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 111, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (604, 'Ahyar', '101020190', 'ahyar@bytehome.id', '24-07-01', 5, 'Dsn. Lajuk Ds. Lajuk', '083845342575', 'Aktif', 0, '0', '', 1721111436, 'PPPOE', 'lajuk_ahyar', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (605, 'Muhammad Anwar', '101030051', 'muhammadanwar@bytehome.id', '24-07-01', 5, 'Dsn. Dara Ds. Sadengrejo', '085718174256', 'Aktif', 0, '0', '', 1721111778, 'PPPOE', 'ndara_anwar', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1244, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (606, 'Khoirul Anam (Rumah )', '101030052', 'khoirulanam2@bytehome.id', '24-07-03', 5, 'Dsn. Pandansari Ds. Pandanrejo', '083850167640', 'Aktif', 0, '0', '', 1721112514, 'PPPOE', 'pandansari_khoirulanam', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 459, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (607, 'Yuliana Rakhmawati', '101010281', 'yulianarakhmawati@bytehome.id', '24-07-03', 5, 'Dsn. Serambi Ds. Winongan Kidul (Bengkel Mendalan)', '085776414321', 'Aktif', 0, '0', '', 1721112891, 'PPPOE', 'mendalan_yuliana', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (608, 'Dewi', '101010282', 'dewi@bytehome.id', '24-07-03', 5, 'Dsn. Seloliman Ds. Sruwi', '0859187585996', 'Aktif', 0, '0', '', 1721113039, 'PPPOE', 'seloliman_dewi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (609, 'M. Saifudin', '101010283', 'msaifudin@bytehome.id', '24-07-03', 5, 'Dsn. Gendol Ds. Prodo', '085730230988', 'Aktif', 0, '0', '', 1721113436, 'PPPOE', 'gendol_saifudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (610, 'Dewi Vironika', '101020191', 'dewivironika@bytehome.id', '24-07-03', 5, 'Dsn. Lodo Ds. Kalirejo', '083159664711', 'Aktif', 1, '0', '', 1721113599, 'PPPOE', 'lodo_dewivironika', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (611, 'Moch. Efendi', '101010284', 'mochefendi@bytehome.id', '24-07-03', 5, 'Dsn. Umbulan Ds. Umbulan', '082181001587', 'Aktif', 0, '0', '', 1721113751, 'PPPOE', 'umbulan_efendi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (612, 'M. Saifuddin', '101040066', 'msaifuddin11@bytehome.id', '24-07-03', 5, 'Dsn. Curahwulu Ds. Karanglo', '085755347670', 'Non-Aktif', 0, '0', '', 1721116865, 'PPPOE', 'curahwulu_saifuddin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 212, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (613, 'Budi Wahyu Diantoro', '101020192', 'budiwahyudiantoro@bytehome.id', '24-07-04', 5, 'Dsn. Sekargadung Ds. Sekargadung (Sekarputih)', '082231857611', 'Aktif', 0, '0', '', 1721117029, 'PPPOE', 'sekarputih_budiwahyu', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (614, 'M. Dimas Solekhudin', '101010285', 'mdimassolekhudin11@bytehome.id', '24-07-04', 5, 'Dsn. Bandaran Kidul Ds Bandaran', '083826754462', 'Aktif', 0, '0', '', 1721117312, 'PPPOE', 'bandaran_dimas', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 171, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (615, 'Nur Hasana', '101020193', 'nurhasana11@bytehome.id', '24-07-04', 5, 'Dsn. Kiringan Ds. Wonojati (Kalimalang)', '081252944770', 'Non-Aktif', 0, '0', '', 1721117438, 'PPPOE', 'kalimalang_nurhasana', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 244, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (616, 'Afifatul Jannah', '101010286', 'afifatuljannah18@bytehome.id', '24-07-04', 5, 'Dsn. Sukun Ds. Mendalan', '085735565834', 'Aktif', 0, '0', '', 1721117853, 'PPPOE', 'lodo_afifatul', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 129, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (617, 'Mohammad Sobirin', '101010287', 'mohammadsobirin12@bytehome.id', '24-07-04', 5, 'Dsn. Jetis Ds. Prodo', '083153383056', 'Aktif', 0, '0', '', 1721118075, 'PPPOE', 'jetis_sobirin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (618, 'Rohmat', '101040067', 'rohmat12@bytehome.id', '24-07-05', 5, 'Dsn. Curahwulu Ds. Karanglo', '085812818167', 'Aktif', 0, '0', '', 1721118431, 'PPPOE', 'curahwulu_rohmat', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 131, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (619, 'Abdul Chafid', '101020194', 'abdulchafid12@bytehome.id', '24-07-05', 5, 'Dsn. Brambang Ds. Brambang (Brambang Kulon)', '085861513907', 'Aktif', 0, '0', '', 1721118775, 'PPPOE', 'brambang_chafid', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 195, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (620, 'Tri Urifani Ningsih', '101020195', 'triurifaniningsih@bytehome.id', '24-07-07', 5, 'Dsn. Karangtengah Ds. Karangtengah', '085791400639', 'Aktif', 0, '0', '', 1721119005, 'PPPOE', 'karangtengah_urifani', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (621, 'Nursani Indah Pratiwi', '101010288', 'nursaniindahpratiwi@bytehome.id', '24-07-13', 5, 'Dsn. Bandilan 2 Ds. Ranuklindugan (Bandaran)', '0895403820610', 'Aktif', 0, '0', '', 1721120061, 'PPPOE', 'bandaran_nursani', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 195, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (622, 'Vida Safitri', '101040068', 'vidasafitri@bytehome.id', '24-07-12', 5, 'Dsn. Kloto\'an Ds. Kebonrejo', '085707572508', 'Aktif', 0, '0', '', 1721120653, 'PPPOE', 'klotokan_vida', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 140, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (623, 'A. Taufik', '101040069', 'ataufik12@bytehome.id', '24-07-12', 5, 'Dsn. Kloto\'an Ds. Kebonrejo', '082151156646', 'Aktif', 0, '0', '', 1721120866, 'PPPOE', 'klotokan_taufik', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 140, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (624, 'Kusen', '101010289', 'kusen@bytehome.id', '24-07-13', 5, 'Dsn. Kalongan Ds. Kalongan', '085236074582', 'Aktif', 0, '0', '', 1721176462, 'PPPOE', 'kalongan_kusen', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 40, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (625, 'Maimunah', '101010290', 'maimunah@bytehome.id', '24-07-10', 5, 'Dsn. BandaranKidul Ds. Bandaran', '081413153086', 'Aktif', 0, '0', '', 1721178449, 'PPPOE', 'bandaran_maimunah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (626, 'Musrifah', '101010291', 'musrifah@bytehome.id', '24-07-10', 5, 'Dsn. Kandung Ds. Kandung', '085607964982', 'Aktif', 0, '0', '', 1721179613, 'PPPOE', 'kandung_musrifah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (627, 'Aji Winoto', '101020196', 'ajiwinoto@bytehome.id', '24-07-10', 5, 'Dsn. Kili Barat Ds. Wonosari', '0895343439734', 'Aktif', 0, '0', '', 1721179812, 'PPPOE', 'kilibarat_aji', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (628, 'Solihudin', '101010292', 'solihudin@bytehome.id', '24-07-12', 5, 'Dsn. Kurek Ds. Minggir', '085231649214', 'Aktif', 0, '0', '', 1721181029, 'PPPOE', 'kurek_solehudin', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 151, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (629, 'Muslimah', '101010293', 'muslimah@bytehome.id', '24-07-12', 5, 'Dsn. Kurek Ds. Minggir', '085607391178', 'Aktif', 0, '0', '', 1721181363, 'PPPOE', 'kurek_muslimah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (630, 'Fatkhur Rohman', '101070015', 'fatkhurrohmankraton@bytehome.id', '24-06-28', 5, 'Dsn. Selorentek Barat Ds. Karanganyar (kraton)', '081222208768', 'Aktif', 0, '0', '', 1721181617, 'PPPOE', 'karanganyarkraton_fathur', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 129, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (631, 'Luluk Jayati', '101010294', 'lulukjayati@bytehome.id', '24-07-16', 5, 'Dsn. Kedungwaru Kidul Ds. Sidepan', '081232279514', 'Aktif', 0, '0', '', 1721184288, 'PPPOE', 'kedungwaru_luluk', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (632, 'Yusron', '101010295', 'yusron@bytehome.id', '24-07-16', 5, 'Dsn. Jetis Ds. Prodo (Bandaran Kidul)', '085748056194', 'Aktif', 0, '0', '', 1721184388, 'PPPOE', 'bandaran_yusron', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 151, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (633, 'Siti Latifa', '101010296', 'sitilatifa@bytehome.id', '24-07-16', 5, 'Dsn. Kedungwaru Kidul Ds. Sidepan', '082234739722', 'Aktif', 0, '0', '', 1721184487, 'PPPOE', 'kedungwarukidul_siti', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (634, 'Siti Chumaidah', '101020197', 'sitichumaidah@bytehome.id', '24-07-16', 5, 'Dsn. Wonosalam Ds. Wonosari', '0895612574070', 'Non-Aktif', 0, '0', '', 1721184614, 'PPPOE', 'wonosalam_chumaidah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 111, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (635, 'Fauzi', '101010297', 'fauzijetis@bytehome.id', '24-07-16', 5, 'Dsn. Jetis Ds. Prodo', '085806570969', 'Aktif', 0, '0', '', 1721184863, 'PPPOE', 'jetis_fauzi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (636, 'Anis Laila', '101010298', 'anislail@bytehome.id', '24-07-17', 5, 'Dsn. Kedungwaru Kidul Ds. Sidepan', '082331943752', 'Aktif', 0, '0', '', 1721437924, 'PPPOE', 'kedungwarukidul_anislaila', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (637, 'Aan Rafi Ahmad', '101010299', 'aanrafiahmad@bytehome.id', '24-07-17', 5, 'Dsn. Kemong Ds. Lebak', '085259037141', 'Aktif', 0, '0', '', 1721438270, 'PPPOE', 'kemong_aan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (638, 'Sumiknah', '101030053', 'sumiknah@bytehome.id', '24-07-17', 5, 'Dsn. Sadeng Ds. Sadengrejo', '083102120342', 'Aktif', 0, '0', '', 1721438471, 'PPPOE', 'sadeng_sumiknah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 212, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (639, 'Halimatus Sakdiyah', '101010300', 'halimatussakdiyah@bytehome.id', '24-07-17', 5, 'Dsn. Kandung Ds. Kandung', '083153754556', 'Non-Aktif', 0, '0', '', 1721438564, 'PPPOE', 'kandung_halimatus', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 212, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (640, 'Nurmaini Masitoh', '101020198', 'nurmainimasitoh@bytehome.id', '24-07-18', 5, 'Dsn. Jajar Lor Ds. Gondangwetan', '083853395692', 'Aktif', 0, '0', '', 1721438788, 'PPPOE', 'jajarlor_nurmaini', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (641, 'Fiqi Yulloh', '101010301', 'fiqiyulloh@bytehome.id', '24-07-18', 5, 'Dsn. Brintik Lor Ds. Menyarik', '085940853883', 'Aktif', 0, '0', '', 1721438887, 'PPPOE', 'brintiklor_fiqi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (642, 'Sutrisno', '101020199', 'sutrisnopekangkungan@bytehome.id', '24-07-18', 5, 'Dsn. Pekangkungan Ds. Pekangkungan ', '085204858676', 'Non-Aktif', 0, '0', '', 1721439134, 'PPPOE', 'pekangkungan_sutrisno', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 129, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (643, 'Mufidah', '101030054', 'mufidah@bytehome.id', '24-07-19', 5, 'Dsn. Bantengan Ds. Sadengrejo', '083849958247', 'Aktif', 0, '0', '', 1721439863, 'PPPOE', 'bantengan_mufidah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (644, 'Bondan Puala', '101010302', 'bondanpuala@bytehome.id', '24-07-19', 5, 'Dsn. Penataan Ds. Penataan', '082229008170', 'Aktif', 0, '0', '', 1721439971, 'PPPOE', 'penataan_bondan', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (645, 'Muji', '101080001', 'mujiebak@bytehome.id', '24-07-19', 5, 'Dsn. Krajan Ds. Petung (Gondang Lebak)', '081333051110', 'Aktif', 0, '0', '', 1721440084, 'PPPOE', 'gondanglebak_muji', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (646, 'Pragadi Tio Fanni', '101040070', 'pragaditiofanni@bytehome.id', '24-07-19', 5, 'Dsn. Gratitunon Ds. Gratitunon', '089516278418', 'Aktif', 0, '0', '', 1721440199, 'PPPOE', 'gratitunon_pragadi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 151, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (647, 'Siti Fatimah', '101020200', 'sitifatimahterate@bytehome.id', '24-07-19', 5, 'Dsn. Terate I Ds. Karangsentul', '081235058346', 'Non-Aktif', 0, '0', '', 1721440297, 'PPPOE', 'terate_fatimah', 0, 1, 1, 'KTP', 1, 1, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (648, 'Agus Junaedi', '101040071', 'agusjunaedi@bytehome.id', '24-07-19', 5, 'Dsn. Karang Asem Ds. KarangKliwon', '085856373043', 'Aktif', 0, '0', '', 1721440402, 'PPPOE', 'karangkliwon_junaedi', 0, 1, 1, 'KTP', 1, 1, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 140, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (649, 'Narsi', '101010303', 'faisoldukuhkidul@bytehome.id', '24-07-21', 5, 'Dsn. Dukuh Kidul Ds. Sumberrejo', '083843652959', 'Aktif', 1, '0', '', 1721616737, 'PPPOE', 'dukuhkidul_narsi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (650, 'Farikh Fahat', '101010304', 'farikhfahat@bytehome.id', '24-07-22', 5, 'Dsn. Ketonggo Ds. Lebak (seloliman)', '085854627324', 'Non-Aktif', 0, '0', '', 1721875711, 'PPPOE', 'seloliman_farikh', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (651, 'Siti Aminah', '101020201', 'sitiaminahmacanputih@bytehome.id', '24-07-22', 5, 'Dsn. Macan Putih Ds. Pekangkungan', '083121987743', 'Aktif', 0, '0', '', 1721875851, 'PPPOE', 'macanputih_aminah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 151, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (652, 'Eko Prasetyo', '101030055', 'ekoprasetyosuklan@bytehome.id', '24-07-22', 5, 'Dsn. Suklan Ds. Pandanrejo', '083119123787', 'Aktif', 0, '0', '', 1721877041, 'PPPOE', 'suklan_ekoprasetyo', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (653, 'Choiron', '101020202', 'choironterate@bytehome.id', '24-07-22', 5, 'Jl. Halmahera 66 XI Ds. Gadingrejo (Terate)', '083135372700', 'Non-Aktif', 0, '0', '', 1721877340, 'PPPOE', 'terate_choiron', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 151, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (654, 'M. Faisol', '101010305', 'mfaisol12@bytehome.id', '24-07-23', 5, 'Dsn. Getah lor Ds. Minggir', '085888933009', 'Aktif', 0, '0', '', 1721878788, 'PPPOE', 'getahlor_faisol', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 195, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (655, 'Mukhammad Taufiq', '101030056', 'mukhammadtaufiq123@bytehome.id', '24-07-23', 5, 'Dsn. Sadeng Ds. Sadengrejo', '081332712003', 'Aktif', 0, '0', '', 1721879034, 'PPPOE', 'sadeng_taufiq', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 179, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (656, 'Suyanah', '101040072', 'suyanah12@bytehome.id', '24-07-23', 5, 'Dsn. Curahwulu Ds. Karanglo', '085649652739', 'Non-Aktif', 0, '0', '', 1721879236, 'PPPOE', 'curahwulu_suyanah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (657, 'Saihul Arip', '101010306', 'saihularip12@bytehome.id', '24-07-23', 5, 'Dsn. Krajan 04 Ds. Kedungrejo', '088989913114', 'Aktif', 0, '0', '', 1721879401, 'PPPOE', 'kedungrejo_saihularip', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (658, 'Alfia', '101040073', 'alfia123@bytehome.id', '24-07-23', 5, 'Dsn. Menangas Wetan Ds. Kebonrejo', '085739280057', 'Aktif', 0, '0', '', 1721879834, 'PPPOE', 'menangaswetan_alfia', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (659, 'Denok Setyohadidayanti', '101020203', 'denoksetyohadidayanti@bytehome.id', '24-07-24', 5, 'Dsn. Gayam Ds. Gayam (Terate)', '083115800087', 'Aktif', 0, '0', '', 1721881178, 'PPPOE', 'terate_denok', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (660, 'Bawon Tiama', '101040074', 'bawontiama@bytehome.id', '24-07-24', 5, 'Dsn. Buntalan Ds. Kedawung Wetan', '085646727295', 'Aktif', 0, '0', '', 1721881398, 'PPPOE', 'buntalan_bawon', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (661, 'Evi Parlina (RA Tampung)', '101070016', 'eviparlina@bytehome.id', '24-07-24', 5, 'Dsn. Tampung Ds. Kalirejo', '085259126867', 'Aktif', 0, '0', '', 1721898225, 'PPPOE', 'tampung_evi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (662, 'Sartini', '101010307', 'sartini@bytehome.id', '24-07-25', 5, 'Dsn. Menangas Wetan Ds. Kebonrejo', '082134586818', 'Aktif', 0, '0', '', 1721963286, 'PPPOE', 'menangaswetan_sartini', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 212, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (663, 'Khalimatus Sakdeyah', '101010308', 'khalimatussakdeyahpancian@bytehome.id', '24-07-25', 5, 'Dsn. Panci\'an Ds. Winongan Lor', '087811504429', 'Aktif', 0, '0', '', 1721965067, 'PPPOE', 'pancian_khalimatus', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (664, 'Chusnul Hotimah', '101020204', 'chusnulhotimah@bytehome.id', '24-07-25', 5, 'Dsn. Klodangan Ds. Wonojati', '085606058056', 'Aktif', 0, '0', '', 1721965248, 'PPPOE', 'klodangan_chusnul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (665, 'Srihana', '101010309', 'srihana@bytehome.id', '24-07-25', 5, 'Dsn. Dukuh Kulon Ds. Sumberejo ', '082232118850', 'Aktif', 0, '0', '', 1721974495, 'PPPOE', 'dukuhkulon_srihana', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (666, 'Sofwan Hadi', '101020205', 'sofwan@bytehome.id', '24-05-17', 5, 'Dsn.Terate Ds.Karangsentul', '081252759366', 'Non-Aktif', 0, '0', '', 1722664397, 'PPPOE', 'terate_sofwan', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (667, 'Manda Luklu Isnaini', '101010310', 'mandalukluisnaini@bytehome.id', '24-07-27', 5, 'Dsn. Bandaran Ds. Bandaran', '083875001897', 'Aktif', 0, '0', '', 1723528980, 'PPPOE', 'bandaran_manda', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 111, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (668, 'Eko Supartmanto', '101010311', 'ekosupartmanto@bytehome.id', '24-07-27', 5, 'Dsn. Kurban Ds. Gading', '085882478475', 'Aktif', 0, '0', '', 1723529872, 'PPPOE', 'kurban_eko', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (669, 'Nur Chamidah', '101010312', 'nurchamidah@bytehome.id', '24-07-27', 5, 'Dsn. Makam Ds. Bandaran', '085852669835', 'Non-Aktif', 0, '0', '', 1723530037, 'PPPOE', 'karangmakam_chamidah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 45, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (670, 'Fitria Hermawati', '101020206', 'fitriahermawati@bytehome.id', '24-07-27', 5, 'Dsn. Klodangan Ds. Wonojati', '085645752792', 'Aktif', 0, '0', '', 1723531018, 'PPPOE', 'klodangan_fitria', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 127, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (671, 'Roifah', '101010313', 'roifah@bytehome.id', '24-07-27', 5, 'Dsn. Talang Tengah Ds. Winongan Kidul', '0813330511110', 'Aktif', 0, '0', '', 1723531800, 'PPPOE', 'talang_roifah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 20, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (672, 'Sutrisno', '101010314', 'sutrisno@bytehom.id', '24-07-27', 5, 'Dsn. Gondang Ds. Lebak', '085852482144', 'Aktif', 0, '0', '', 1723604127, 'PPPOE', 'gondanglebak_sutrisno', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (673, 'Mukhammad Heri Susanto', '101040075', 'mukhammadherisusanto@bytehom.id', '24-07-27', 5, 'Dsn. Kebruan Ds. Kedawung Kulon', '083140511978', 'Aktif', 0, '0', '', 1723604323, 'PPPOE', 'kedawungkulon_heri', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (674, 'Ita Chusniati', '101010315', 'itachusniati@bytehom.id', '24-07-28', 5, 'Dsn. Lebak Ds. Lebak', '085731191745', 'Aktif', 0, '0', '', 1723604447, 'PPPOE', 'lebak_ita', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (675, 'Nurul Azizah', '101040076', 'nurulazizah2@bytehome.id', '24-07-30', 5, 'Dsn. Beji Kremun Ds. Gratitunon (Menangas Wetan)', '081615918373', 'Non-Aktif', 0, '0', '', 1723605754, 'PPPOE', 'menangaswetan_nurul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (676, 'Suhardi Khansah', '101010316', 'suhardikhansah@bytehome.id', '24-07-30', 5, 'Dsn. Krajan Ds. Kambingan Rejo', '083849841756', 'Aktif', 0, '0', '', 1723605978, 'PPPOE', 'kambingan_suhardi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (677, 'Siti Ulwiyah', '101040077', 'sitiulwiyah@bytehome.id', '24-08-01', 5, 'Dsn. Pandan Ds. Kebonrejo', '082132040971', 'Aktif', 0, '0', '', 1723606828, 'PPPOE', 'pandan_ulwiyah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (678, 'Luluk Farida', '101010317', 'lulukfarida12@bytehome.id', '24-08-01', 5, 'Dsn. Wedar Ds. Gading', '085608132209', 'Aktif', 0, '0', '', 1723616674, 'PPPOE', 'wedar_luluk', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 237, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (679, 'Moch. Safi\'i', '101010318', 'mochsafiiasd@bytehome.id', '24-08-02', 5, 'Dsn. Prodo Ds. Prodo', '085334777154', 'Aktif', 0, '0', '', 1723617673, 'PPPOE', 'prodo_safii', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (680, 'Nur Fida Fitriani', '101010319', 'nurfidafitriani@bytehome.id', '24-08-03', 5, 'Dsn. Gedok Ds. Sidepan', '083143193418', 'Non-Aktif', 0, '0', '', 1723690325, 'PPPOE', 'gedok_fida', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (681, 'Mautsiqol Maula Ruwaidah', '101020207', 'mautsiqolmaularuwaidah@bytehome.id', '24-08-03', 5, 'Dsn. Pekangkungan Ds. Pekangkungan ', '081217652155', 'Aktif', 0, '0', '', 1723690604, 'PPPOE', 'pekangkungan_mautsiqol', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (682, 'Bakhrul Ulum', '101020208', 'bakhrululum123@bytehome.id', '24-08-04', 5, 'Dsn. Ranggeh Timur Ds. Ranggeh (Wonosari)', '082233002971', 'Aktif', 0, '0', '', 1723690755, 'PPPOE', 'wonosari_bakhrul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (683, 'Salsabila Angelina Putri', '101010320', 'salsabilaangelinaputri@bytehome.id', '24-08-05', 5, 'Dsn. Karangsono Ds. Winongan Lor', '085736669662', 'Aktif', 0, '0', '', 1723690886, 'PPPOE', 'karangsono_salsabila', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (684, 'Muhamad Jafar Sodek', '101010321', 'muhamadjafarsodek@bytehome.id', '24-08-05', 5, 'Dsn. Curahmalang Ds. Karang Tengah', '085236595716', 'Aktif', 0, '0', '', 1723690991, 'PPPOE', 'curahmalang_jafar', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (685, 'Sofiatin Argariya', '101010322', 'sofiatunargariya@bytehome.id', '24-08-05', 5, 'Dsn. Kandung Ds. Kandung', '081554065882', 'Aktif', 0, '0', '', 1723691204, 'PPPOE', 'kandung_sofiatin', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 261, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (686, 'Anwar', '101010323', 'anwar123@bytehome.id', '24-08-05', 5, 'Dsn. Dukuh Kidul Ds. Sumberejo', '082245093231', 'Aktif', 0, '0', '', 1723691367, 'PPPOE', 'dukuhkidul_anwar', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 248, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (687, 'Muhammad Soleh', '101010324', 'muhammadsoleh123@bytehome.id', '24-08-05', 5, 'Dsn. Kandung Ds. Kandung', '085646684494', 'Non-Aktif', 0, '0', '', 1723691469, 'PPPOE', 'kandung_soleh', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 279, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (688, 'Ainul Zuhriyah', '101010325', 'ainulzuhriyah123@bytehome.id', '24-08-05', 5, 'Dsn. Gendol Ds. Prodo', '081515816669', 'Aktif', 0, '0', '', 1723691569, 'PPPOE', 'gendol_ainul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 248, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (689, 'Hermanto', '101010326', 'hermanto123@bytehome.id', '24-08-05', 5, 'Jl. Sulawesi Ds. Trajeng (Bica\'an)', '085737301660', 'Aktif', 0, '0', '', 1723691666, 'PPPOE', 'bicaan_hermanto', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 248, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (690, 'Lailatul Maghfiroh', '101010327', 'lailatulmaghfiroh123@bytehome.id', '24-08-05', 5, 'Dsn. Krajan Ds. Linggo (Menyarik)', '085755017910', 'Non-Aktif', 0, '0', '', 1723691860, 'PPPOE', 'menyarik_maghfiroh', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (691, 'Watiningsih', '101020209', 'watiningsih1234@bytehome.id', '24-08-05', 5, 'Dsn. Karanganyar Selatan Ds. Karangsentul', '083833177778', 'Aktif', 0, '0', '', 1723691963, 'PPPOE', 'karanganyar_watiningsih', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 171, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (692, 'M. Khoriri', '101070017', 'mkhoriri@bytehome.id', '24-08-06', 5, 'Dsn. Rejogunting Ds. Kalirejo', '081329628227', 'Aktif', 0, '0', '', 1723692265, 'PPPOE', 'rojogunting_khoriri', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 244, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (693, 'Nur Indah Fitriani', '101010328', 'nurindahfitriani@bytehome.id', '24-08-06', 5, 'Dsn. Banyubiru Lor Ds. Sumberrejo (Kiringan)', '083822691959', 'Aktif', 0, '0', '', 1723692372, 'PPPOE', 'kiringan_fitriani', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (694, 'Khuriatul Khamilah', '101040078', 'khuriatulkhamilah@bytehome.id', '24-08-06', 5, 'Dsn. Kebonrejo Ds. Kebonrejo', '085236526700', 'Aktif', 0, '0', '', 1723692473, 'PPPOE', 'kebonrejo_khuriatul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (695, 'Ali Mustofa', '101040079', 'alimustofa123@bytehome.id', '24-08-07', 5, 'Dsn. Menangas Kulon Ds. Kebonrejo ', '085851199794', 'Aktif', 0, '0', '', 1723692658, 'PPPOE', 'menangaskulon_ali', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 167, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (696, 'Muhammad Badrus Sholeh', '101070018', 'muhammadbadrussholeh123@bytehome.id', '24-08-07', 5, 'Dsn. Ngabar Krajan Ds. Ngabar', '085608926251', 'Aktif', 0, '0', '', 1723692833, 'PPPOE', 'ngabar_badrus', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (697, 'Fandi Ahmad', '101040080', 'fandiahmad123@bytehome.id', '24-08-07', 5, 'Dsn. Krajan Ds. Kambingan Rejo', '081339416466', 'Aktif', 0, '0', '', 1723693025, 'PPPOE', 'kambingan_fandi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (698, 'Kantor Desa Ngabar', '101070019', 'kantordesangabar1234@bytehome.id', '24-08-07', 5, 'Ds. Ngabar', '081232356096', 'Non-Aktif', 0, '0', '', 1723693118, 'PPPOE', 'ngabar_balaidesa', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '20Mbps', 1, 0, 1, 0, 0, 225000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (699, 'Muchammad Sochiful Rozak', '101010329', 'muchammadsochifulrozak@bytehome.id', '24-08-09', 5, 'Dsn. Wulu Ds. Mendalan', '082278305904', 'Non-Aktif', 0, '0', '', 1723693238, 'PPPOE', 'wulu_sochiful', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (700, 'Sayuti', '101010330', 'sayuti@bythome.id', '24-08-09', 5, 'Dsn. Kurek Ds. Minggir', '085790420316', 'Aktif', 0, '0', '', 1723693602, 'PPPOE', 'kurek_sayuti', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (701, 'Rokhimah', '101030057', 'rokhimah@bytehome.id', '24-08-09', 5, 'Dsn. Ketegan Ds. Ketegan', '083834518700', 'Aktif', 0, '0', '', 1723693689, 'PPPOE', 'ketegan_rokhimah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (702, 'Siti Romela', '101010331', 'sitiromela@bytehome.id', '24-08-09', 5, 'Dsn. Talang Kidul Ds. Winongan Kidul (Ndara)', '085708140118', 'Aktif', 0, '0', '', 1723693784, 'PPPOE', 'ndara_romela', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (703, 'Nurusobach', '101020210', 'nurusobach@bytehome.id', '24-08-10', 5, 'Dsn. Sekaran Ds. Wonojati', '087729432643', 'Aktif', 0, '0', '', 1723693862, 'PPPOE', 'sekaran_nurusobach', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (704, 'Supriyadi', '101020211', 'supriyadi@bytehome.id', '24-08-10', 5, 'Dsn. Gayam Ds. Gayam', '085754554794', 'Aktif', 0, '0', '', 1723693949, 'PPPOE', 'gayam_supriyadi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (705, 'Mukfiya Fuaidah', '101070020', 'mukfiyafuaidah@bytehome.id', '24-07-27', 5, 'Dsn. Kebonsari Ds. Karanganyar Kraton', '081515561932', 'Aktif', 0, '0', '', 1723694188, 'PPPOE', 'karanganyarkraton_mukfiya', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (706, 'Siti Lutfiyah', '101020212', 'sitilutfiyah@bytehome.id', '24-08-10', 5, 'Dsn. Lodo Ds. Kalirejo', '085863504220', 'Aktif', 0, '0', '', 1723694426, 'PPPOE', 'lodo_lutfiyah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (707, 'Aisatul Ilmi', '101010332', 'aisatulilmi@bytehome.id', '24-08-10', 5, 'Dsn. Kampungbaru Ds. Wates (Suklan)', '083843009507', 'Aktif', 0, '0', '', 1723694718, 'PPPOE', 'suklan_aisatul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 0, 0, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (708, 'Alif Lailah S.Pd', '101020213', 'aliflailahspd@bytehome.id', '24-08-10', 5, 'Dsn. Gayam Ds. Gayam', '082229012750', 'Aktif', 0, '0', '', 1723694934, 'PPPOE', 'gayam_alif', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (709, 'Fatimatus Zahroni', '101020214', 'fatimatuszahroni@bytehome.id', '24-08-10', 5, 'Dsn. Gayam Ds. Gayam', '083837718694', 'Non-Aktif', 0, '0', '', 1723695021, 'PPPOE', 'gayam_fatimatus', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (710, 'Zubaidah', '101020215', 'zubaidah@bytehome.id', '24-08-10', 5, 'Dsn. Kiringan Ds. Wonojati', '083153085448', 'Aktif', 0, '0', '', 1723695147, 'PPPOE', 'kiringan_zubaidah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (711, 'Naimatul Robiah', '101010333', 'naimatulrobiah@bytehome.id', '24-08-13', 5, 'Dsn. Gendol Ds. Prodo', '081232032294', 'Aktif', 0, '0', '', 1724033700, 'PPPOE', 'gendol_naimatul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 171, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (712, 'Abdulloh', '101030058', 'abdulloh222@bytehome.id', '24-08-13', 5, 'Dsn. Pandansari Ds. Pandanrejo', '083149454646', 'Aktif', 0, '0', '', 1724033783, 'PPPOE', 'pandansari_abdulloh', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 240, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (713, 'Siti Maisaroh / Makhis', '101020216', 'sitimaisaroh1243@bytehome.id', '24-08-13', 5, 'Dsn. Sekaran Ds. Wonojati', '083197160994', 'Aktif', 0, '0', '', 1724033858, 'PPPOE', 'sekaran_maisaroh', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 175, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (714, 'Maulilatul Khotija', '101020217', 'maulilatulkhotija124@bytehome.id', '24-08-13', 5, 'Dsn. Klodangan Ds. Wonojati', '081332879331', 'Aktif', 0, '0', '', 1724034047, 'PPPOE', 'klodangan_maulilatul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 195, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (715, 'Fatkhulil Jannah', '101010334', 'fatkhuliljannah@bytehome.id', '24-08-13', 5, 'Dsn. Menyarik Kulon Ds. Menyarik (Bendo Winongan Lor)', '085808454040', 'Aktif', 0, '0', '', 1724034147, 'PPPOE', 'bendo_fatkhulil', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (716, 'Khodijah', '101030059', 'khodijah12345@bytehome.id', '24-08-14', 5, 'Dsn. Pandansari Ds. Pandanrejo', '085760900385', 'Aktif', 0, '0', '', 1724034479, 'PPPOE', 'pandansari_khodijah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 175, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (717, 'Yayuk Mujiati', '101040081', 'yayukmujiati@bytehome.id', '24-08-15', 5, 'Dsn. Kebonrejo Ds. Kebonrejo', '085655105455', 'Aktif', 0, '0', '', 1724035336, 'PPPOE', 'kebonrejo_yayuk', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 179, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (718, 'Ach. Yusuf', '101020218', 'achyusuf12@bytehome.id', '24-08-16', 5, 'Dsn. Gayam Ds. Gayam', '081259544090', 'Aktif', 0, '0', '', 1724035746, 'PPPOE', 'gayam_yusuf', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (719, 'Mukhlason', '101030060', 'mukhlason12@bytehome.id', '24-08-16', 5, 'Dsn. Petahunan Ds. Ketegan ', '083848283729', 'Aktif', 0, '0', '', 1724035883, 'PPPOE', 'petahunan_mukhlason', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (720, 'Saiful', '101010335', 'saiful111@bytehome.id', '24-08-18', 5, 'Dsn. Kasiman Ds. Sidepan', '083846932312', 'Aktif', 0, '0', '', 1724207610, 'PPPOE', 'kasiman_saiful', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (721, 'Kholifatul Widad', '101020219', 'kholifatulwidad@bytehome.id', '24-08-19', 5, 'Dsn. Plalangan Ds. Wonojati', '085730344249', 'Aktif', 0, '0', '', 1724207703, 'PPPOE', 'plalangan_kholifatul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 212, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (722, 'Achmad Taufiq', '101080002', 'achmad12taufiq@bytehome.id', '24-08-20', 5, 'Dsn. Pohgading Utara Ds. Pohgading', '083871128637', 'Non-Aktif', 0, '0', '', 1724207790, 'PPPOE', 'pohgading_taufiq', 0, 1, 1, 'SIM', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (723, 'Suliati', '101020220', 'suliati123@bytehome.id', '24-08-20', 5, 'Dsn. Sarirejo Ds. Pateguhan', '082230207674', 'Aktif', 0, '0', '', 1724207861, 'PPPOE', 'pateguhan_suliati', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 195, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (724, 'Melly Turokhmi', '101040082', 'mellyturokhmi@bytehome.id', '24-08-20', 5, 'Dsn. Menangas Wetan Ds. Kebonrejo', '085259123672', 'Aktif', 0, '0', '', 1724208015, 'PPPOE', 'menangaswetan_melly', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 212, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (725, 'Khurotil Ayun', '101010336', 'khurotilayun@bytehome.id', '24-08-21', 5, 'Dsn. Banyubiru Lor Ds. Sumberrejo', '081332655221', 'Aktif', 0, '0', '', 1724291449, 'PPPOE', 'banyubirulor_khurotil', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 171, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (726, 'Ilham', '101010337', 'ilham124@bytehome.id', '24-08-22', 5, 'Dsn. Bandaran, Ds. Bandaran', '081515817065', 'Aktif', 0, '0', '', 1724291809, 'PPPOE', 'bandaran_ilham', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 167, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (727, 'Wahyu Sul Ning Tiyas', '101020221', 'wahyusulNingtiyas@bytehome.id', '24-08-22', 5, 'Jln. Gus Dur Dsn Brambang Timur Ds. Brambang', '081517718720', 'Aktif', 0, '0', '', 1724557957, 'PPPOE', 'brambang_wahyu', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 385, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (728, 'Muharomah', '101020222', 'muharomah123@bytehome.id', '24-08-22', 5, 'Dsn. Plinggisan Ds. Plinggisan', '081233600506', 'Aktif', 0, '0', '', 1724558238, 'PPPOE', 'plinggisan_mukharomah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (729, 'Ali Aziz', '101030061', 'aliaziz12@bytehome.id', '24-08-23', 5, 'Dsn. Balidono Ds. Rejoso Kidul', '081359024026', 'Non-Aktif', 0, '0', '', 1724638168, 'PPPOE', 'balidono_aliaziz', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 416, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (730, 'Muhammad Amirul Hamzah', '101070021', 'muhammadamirulhamzah@bytehome.id', '24-08-06', 5, 'Dsn. Jawari Ds. Kemiri (Pondok Al-Qodiriy Wonorejo)', '082257551108', 'Non-Aktif', 0, '0', '', 1724642046, 'PPPOE', 'arengareng_alqodiry', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (731, 'Iin Makhrudiah', '101010338', 'iinmakhrudiah@bytehome.id', '24-08-06', 5, 'Dsn. Toxwiro Ds. Winongan Lor (Sekep)', '082331133310', 'Aktif', 0, '0', '', 1724642154, 'PPPOE', 'sekep_frozen', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 151, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (732, 'Susi Ariyanti Candra', '101020223', 'susiariyanticandra@bytehome.id', '24-08-02', 5, 'Dsn Sekaran Ds.Wonojati', '085792013119', 'Non-Aktif', 0, '0', '', 1724643328, 'PPPOE', 'sekaran_susi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 195, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (733, 'Syamsiah', '101030062', 'syamsiahsadeng@bytehome.id', '24-08-24', 5, 'Dsn. Sadeng Ds. Sadengrejo', '083152034265', 'Non-Aktif', 0, '0', '', 1724738828, 'PPPOE', 'sadeng_syamsiah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (734, 'Nikmatul Islamiyah', '101070022', 'nikmatulislamiyah@bytehome.id', '24-08-26', 5, 'Dsn. Lodo Ds. Kalirejo', '085755310690', 'Aktif', 0, '0', '', 1724738952, 'PPPOE', 'lodo_nikmatul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (735, 'Syafiudin Zuhri', '101030063', 'syafiudinzuhri@bytehome.id', '24-08-26', 5, 'Dsn. Petahunan Ds. Ketegan ', '082244741505', 'Aktif', 0, '0', '', 1724739348, 'PPPOE', 'petahunan_syaifudin', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (736, 'Siti Luluk Indramia', '101030064', 'sitilulukindramia@bytehome.id', '24-08-26', 5, 'Dsn. Petahunan Ds. Ketegan ', '081233616300', 'Aktif', 0, '0', '', 1724739593, 'PPPOE', 'petahunan_indramia', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (737, 'Urifa', '101010339', 'urifa@bytehome.id', '24-08-21', 5, 'Dsn. Talang Ds. Winongan Kidul', '0', 'Non-Aktif', 0, '0', '', 1724809307, 'PPPOE', 'talang_urifa', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 20, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (738, 'Jauharil Maknun', '101020224', 'jauharilmaknun@bytehome.id', '24-08-27', 5, 'Dsn. Sambisari Ds. Gayam', '088217820385', 'Aktif', 0, '0', '', 1726360880, 'PPPOE', 'sambisari_jauharil', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (739, 'Umar Suryadi', '101040083', 'umarsuryadi@bytehome.id', '24-08-27', 5, 'Dsn. Krajan Ds. Karang Kliwon', '085856372756', 'Aktif', 0, '0', '', 1726361664, 'PPPOE', 'karangkliwon_umar', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (740, 'Yayang Dwi Fitron', '101010340', 'yayangdwifitron@bytehome.id', '24-08-27', 5, 'Dsn. Kampung Baru Ds. Bandaran', '081413153389', 'Aktif', 0, '0', '', 1726361999, 'PPPOE', 'bandaran_yayang', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (741, 'Rohmaanur Rohim', '101020225', 'rohmaanurrohim@bytehome.id', '24-08-29', 5, 'Dsn. Plalangan Ds. Wonojati', '083170121549', 'Aktif', 0, '0', '', 1726362488, 'PPPOE', 'plalangan_rohmanur', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (742, 'Agus Supriyanto', '101020226', 'agussupriyanto01@bytehome.id', '24-08-29', 5, 'Dsn. Plalangan Ds. Wonojati', '082223469170', 'Aktif', 0, '0', '', 1726362715, 'PPPOE', 'plalangan_supriyanto', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (743, 'Saichu', '101020227', 'saichu@bytehome.id', '24-08-29', 5, 'Dsn. Plalangan Ds. Wonojati', '081259664704', 'Aktif', 0, '0', '', 1726368042, 'PPPOE', 'plalangan_saichu', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (744, 'Muzaki', '101020228', 'muzaki@bytehome.id', '24-08-29', 5, 'Dsn. Nguling Ds. Brambang (Plalangan)', '085736668190', 'Aktif', 0, '0', '', 1726370092, 'PPPOE', 'plalangan_muzaki', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (745, 'Chusnia Dewi', '101020229', 'chusniadewi@bytehome.id', '24-08-30', 5, 'Dsn. Plalangan Ds. Wonojati', '085832553484', 'Aktif', 0, '0', '', 1726370423, 'PPPOE', 'plalangan_chusnia', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 0, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (746, 'Siti Nur Chalimah Putri', '101020230', 'sitinurchalimahputri@bytehome.id', '24-08-30', 5, 'Dsn. Kebonsawo Ds. Keboncandi', '085604540544', 'Aktif', 0, '0', '', 1726370648, 'PPPOE', 'kebonsawo_chalimah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (747, 'Mariyo', '101040084', 'mariyo@bytehome.id', '24-08-30', 5, 'Dsn. Sawit Ds. Kambinganrejo', '081330093525', 'Non-Aktif', 0, '0', '', 1726370950, 'PPPOE', 'kambingan_mariyo', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (748, 'Dewa Wahyudi', '101020231', 'dewawahyudi@bytehome.id', '24-08-30', 5, 'Dsn. Wonosalam Ds. Wonosari', '089536493359', 'Aktif', 0, '0', '', 1726371121, 'PPPOE', 'wonosalam_dewa', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (749, 'Sutinarmi', '101010341', 'sutirnami@bytehome.id', '24-08-30', 5, 'Dsn. Menangas Kulon Ds. Kebonrejo (Mbulak Toko Al Irza)', '085604484768', 'Aktif', 0, '0', '', 1726534237, 'PPPOE', 'mbulak_sutinarmi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (750, 'Widia Sari', '101010342', 'widiasari@bytehome.id', '24-08-30', 5, 'Dsn. Tegalpo Ds. Jeladri', '085780144275', 'Aktif', 0, '0', '', 1726534450, 'PPPOE', 'jeladri_widia', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (751, 'Nur Kholis', '101010343', 'nurkholis@bytehome.id', '24-08-30', 5, 'Dsn. Mantingan Ds. Tenggilisrejo (Kandung)', '08155766744', 'Aktif', 0, '0', '', 1726534582, 'PPPOE', 'kandung_kholis', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (752, 'Mohammad Andrianto', '101010344', 'mohammadandrianto@bytehome.id', '24-08-31', 5, 'Dsn. Seloliman Ds. Sruwi', '083834579205', 'Aktif', 0, '0', '', 1726535251, 'PPPOE', 'seloliman_andrianto', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (753, 'Didit Nur Tofiq', '101040085', 'diditnurtofiq@bytehome.id', '24-08-31', 5, 'Dsn. Krajan Ds. Kambingan Rejo', '082140325187', 'Aktif', 0, '0', '', 1726535595, 'PPPOE', 'kambingan_didit', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (754, 'Muhammad Khoiril Anwar', '101040086', 'muhammadkhoirilanwar@bytehome.id', '24-09-02', 5, 'Dsn. Kloto\'an Ds. Kebonrejo', '085546563118', 'Aktif', 0, '0', '', 1726536320, 'PPPOE', 'klotokan_khoiril', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (755, 'Nikmatu Zizah', '101040087', 'nikmatuzizah@bytehome.id', '24-09-02', 5, 'Dsn. Tugu Ds. Kedawung Kulon', '081337051226', 'Aktif', 0, '0', '', 1726536486, 'PPPOE', 'tugu_nikmatu', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (756, 'Margosono', '101010345', 'margosono@bytehome.id', '24-09-02', 5, 'Dsn. Menyarik Kulon Ds. Menyarik', '081515561829', 'Non-Aktif', 0, '0', '', 1726536601, 'PPPOE', 'menyarikkulon_margosono', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (757, 'Abdul Ghofur', '101040088', 'abdulghofur@bytehome.id', '24-09-03', 5, 'Dsn. Pandan Ds. Kebonrejo', '081333597744', 'Aktif', 0, '0', '', 1726536754, 'PPPOE', 'kebonrejo_ghafur', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (758, 'Mukhamad Socheh', '101030065', 'mukhamadsocheh@bytehome.id', '24-09-03', 5, 'Dsn. Petahunan Ds. Ketegan ', '083833440173', 'Aktif', 0, '0', '', 1726538706, 'PPPOE', 'petahunan_socheh', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (759, 'Saikhul Rokhman', '101030066', 'saikhulrokhman@bytehome.id', '24-09-03', 5, 'Dsn. Ndara Ds. Sadengrejo', '085784244575', 'Aktif', 0, '0', '', 1726538889, 'PPPOE', 'ndara_saikhul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (760, 'Mariah Ulfa', '101010346', 'mariahulfa@bytehome.id', '24-09-04', 5, 'Dsn. Brintik Kidul Ds. Penataan (Kasiman)', '085339447375', 'Aktif', 0, '0', '', 1726539145, 'PPPOE', 'kasiman_mariah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (761, 'Rofi\'i', '101010347', 'rofii@bytehome.id', '24-09-04', 5, 'Dsn. Kruyo Lor Ds. Umbulan', '085107777800', 'Aktif', 0, '0', '', 1726539379, 'PPPOE', 'kruyolor_rofii', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (762, 'Imrona', '101010348', 'imrona@bytehome.id', '24-09-04', 5, 'Dsn. Menyarik Kulon Ds. Menyarik', '081293956000', 'Aktif', 0, '0', '', 1726539533, 'PPPOE', 'menyarikkulon_imrona', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (763, 'Muh. Sutrisno', '101010349', 'muhsutrisno@bytehome.id', '24-09-04', 5, 'Dsn. Menyarik Kulon Ds. Menyarik', '085811391868', 'Aktif', 0, '0', '', 1726539824, 'PPPOE', 'menyarikkulon_sutrisno', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (764, 'Febry Nahdliyyatur Rizqiyyah', '101010350', 'febrynahdliyyaturrizqiyyah@bytehome.id', '24-09-05', 5, 'Dsn. Penataan Ds. Penataan', '087776987772', 'Aktif', 0, '0', '', 1726544013, 'PPPOE', 'penataan_febry', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (765, 'Nanik Mufida', '101020232', 'nanikmufida@bytehome.id', '24-09-05', 5, 'Dsn. Kiringan Ds. Wonojati', '082180995832', 'Aktif', 0, '0', '', 1726544920, 'PPPOE', 'kiringan_nanik', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (766, 'Sulastri', '101030067', 'sulastri1@bytehome.id', '24-09-05', 5, 'Dsn. Petahunan Ds. Ketegan ', '085231798863', 'Aktif', 0, '0', '', 1726545263, 'PPPOE', 'petahunan_sulastri', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (767, 'Ita Purnamasari', '101020233', 'itapurnamasari@bytehome.id', '24-09-06', 5, 'Dsn. Ranggeh Selatan Ds. Ranggeh', '085784281440', 'Aktif', 0, '0', '', 1726546960, 'PPPOE', 'ranggehselatan_ita', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (768, 'Siti Aminah', '101020234', 'sitiaminah@bytehome.id', '24-09-06', 5, 'Dsn. Ranggeh Selatan Ds. Ranggeh', '089530405251', 'Aktif', 0, '0', '', 1726547232, 'PPPOE', 'ranggehselatan_aminah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (769, 'Umam Fathurrohman', '101030068', 'umamfathurrohman@bytehome.id', '24-09-06', 5, 'Dsn. Bantengan Ds. Sadengrejo', '085606054303', 'Non-Aktif', 0, '0', '', 1726547378, 'PPPOE', 'bantengan_umam', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (770, 'Lestari Nur Aisyah', '101070023', 'lestarinuraisyah@bytehome.id', '24-09-06', 5, 'Dsn. Krajan Ds. Sladi (Ngempit Dompo)', '085236722740', 'Aktif', 0, '0', '', 1726547520, 'PPPOE', 'ngempit_lestari', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (771, 'Mukhamad Mukharom Hadi', '101070024', 'mukhamadmukharomhadi@bytehome.id', '24-09-06', 5, 'Dsn. Plinggisan Ds. Plinggisan', '083898701169', 'Aktif', 0, '0', '', 1726549678, 'PPPOE', 'plinggisan_mukharomhadi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (772, 'Achmad Yoni', '101040089', 'achmadyoni@bytehome.id', '24-09-07', 5, 'Dsn. Buntalan Ds. Kedawung Wetan', '082139612323', 'Aktif', 0, '0', '', 1726549911, 'PPPOE', 'buntalan_yoni', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 0, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (773, 'Siti Romlah', '101020235', 'sitiromlah@bytehome.id', '24-09-07', 5, 'Dsn. Tenggilis Ds. Tenggilisrejo', '085707282980', 'Non-Aktif', 0, '0', '', 1726551002, 'PPPOE', 'tenggilis_romlah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (774, 'Muhammad Afandi', '101030069', 'muhammadafandibantengan@bytehome.id', '24-09-09', 5, 'Dsn. Bantengan Ds. Sadengrejo', '083155874430', 'Non-Aktif', 0, '0', '', 1726554539, 'PPPOE', 'bantengan_afandi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '3M', 1, 0, 1, 0, 1, 120000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (775, 'Nur Huda', '101010351', 'nurhuda@bytehome.id', '24-09-09', 5, 'Dsn. Sentul Ds. Winongan Lor', '085645230562', 'Aktif', 0, '0', '', 1726554709, 'PPPOE', 'sentul_nurhuda', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 129, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (776, 'Hufron', '101010352', 'hufron@bytehome.id', '24-09-09', 5, 'Dsn. Kruyo Kidul Ds. Umbulan', '082132442220', 'Aktif', 0, '0', '', 1726554998, 'PPPOE', 'umbulan_hufron', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 244, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (777, 'Lailatul Waqiah', '101020236', 'lailatulwaqiah@bytehome.id', '24-09-09', 5, 'Dsn. Jajarkebon Ds. Gondangwetan', '0895367269648', 'Non-Aktif', 0, '0', '', 1726555142, 'PPPOE', 'jajarkebon_waqiah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (778, 'Sumantri', '101070025', 'sumantri@bytehome.id', '24-09-10', 5, 'Dsn. Sentong Ds. Susukan Rejo', '085856378236', 'Aktif', 0, '0', '', 1726555586, 'PPPOE', 'susukan_sumantri', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (779, 'Laila', '101020237', 'laila@bytehome.id', '24-09-11', 5, 'Dsn. Kebonsawo Ds. Keboncandi', '081217355303', 'Aktif', 0, '0', '', 1726556173, 'PPPOE', 'kebonsawo_laila', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (780, 'Aris Taufiqi', '101010353', 'aristaufiqi@bytehome.id', '24-09-12', 5, 'Dsn. Jurang Pelen Ds. Bulusari (Mendalan)', '081555914551', 'Aktif', 0, '0', '', 1726557501, 'PPPOE', 'mendalan_aris', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 127, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (781, 'Suparmi', '101030070', 'suparmi@bytehome.id', '24-09-13', 5, 'Dsn. Suklan Ds. Pandanrejo (Dara)', '083134933483', 'Aktif', 0, '0', '', 1726557797, 'PPPOE', 'ndara_suparmi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 449, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (782, 'Gufron', '101110002', 'gufron@bytehome.id', '24-09-16', 5, 'Jl. Kyai Sarkowi Ds. Tembokrejo (Sekargadung)', '085807491236', 'Aktif', 0, '0', '', 1727054560, 'PPPOE', 'sekargadung_gufron', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (783, 'Miftakhul Ulum', '101030071', 'miftakhululum@bytehome.id', '24-08-27', 5, 'Dsn. Keden Ds. Pandanrejo', '083109649445', 'Aktif', 0, '0', '', 1727056189, 'PPPOE', 'pandanrejo_miftakhul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 111, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (784, 'Emi Tri Wahyuni', '101040090', 'emitriwahyuni@bytehome.id', '24-09-05', 5, 'Dsn. Kebonrejo Ds. Kebonrejo', '081336233419', 'Aktif', 0, '0', '', 1727058209, 'PPPOE', 'kebonjero_emi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (785, 'Mukhamad Ainun Najib', '101030072', 'mukhamadainunnajib@bytehome.id', '24-09-16', 5, 'Dsn. Lobang Ds. Pandanrejo', '083140613193', 'Aktif', 0, '0', '', 1727059027, 'PPPOE', 'lobang_ainunnajib', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (786, 'Khurrotul A\'yuni', '101030073', 'khurrotulayuni@bytehome.id', '24-09-16', 5, 'Dsn. Dara Ds. Sadengrejo', '085330944823', 'Aktif', 0, '0', '', 1727059289, 'PPPOE', 'ndara_khurrotul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 20, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (787, 'Ali', '101010354', 'ali@bytehome.id', '24-09-16', 5, 'Dsn. Kecik Ds. Lebak', '085706615952', 'Aktif', 0, '0', '', 1727059530, 'PPPOE', 'kecik_ali', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (788, 'Mukhammad Basori', '101010355', 'mukhammadbasori@bytehome.id', '24-09-17', 5, 'Dsn. Karang Tengah Ds. Karang Tengah', '085755401332', 'Aktif', 0, '0', '', 1727059750, 'PPPOE', 'karangtengah_basori', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 22, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (789, 'Siti Rahayu', '101010356', 'sitirahayu1@bytehome.id', '24-09-18', 5, 'Dsn. Kemong Ds. Winongan Kidul', '081331849725', 'Aktif', 0, '0', '', 1727059985, 'PPPOE', 'kemong_rahayu', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 29, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (790, 'Nur Isnaini', '101010357', 'nurisnaini4@bytehome.id', '24-09-18', 5, 'Dsn. Sukun Ds. Mendalan', '087838305849', 'Aktif', 0, '0', '', 1727060579, 'PPPOE', 'sukun_isnaini', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (791, 'Rifki Maulana', '101020238', 'rifkimaulana@bytehome.id', '24-09-19', 5, 'Dsn. Karang Asem Ds. Tenggilis Rejo', '085731191315', 'Aktif', 0, '0', '', 1727060752, 'PPPOE', 'tenggilis_rifki', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (792, 'Amirul Khakim', '101010358', 'amirulkhakim@bytehome.id', '24-09-19', 5, 'Dsn. Mulyorejo lor Ds. Umbulan', '085746781795', 'Aktif', 0, '0', '', 1727060937, 'PPPOE', 'umbulan_amirul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 33, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (793, 'Mimin Mirani', '101020239', 'miminmirani@bytehome.id', '24-09-19', 5, 'Dsn. Klodangan Ds. Wonojati', '081553954922', 'Aktif', 0, '0', '', 1727061109, 'PPPOE', 'klodangan_mimin', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 37, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (794, 'Romiyul Khaq', '101020240', 'romiyulkhaq@bytehome.id', '24-09-19', 5, 'Dsn. Wonosalam Ds. Wonosari', '085258951150', 'Aktif', 0, '0', '', 1727061563, 'PPPOE', 'wonosalam_romiyul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 37, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (795, 'Siti Fatimah', '101010359', 'sitifatimah8@bytehome.id', '24-09-19', 5, 'Dsn. Pandean Ds. Winongan Kidul', '085733676515', 'Aktif', 0, '0', '', 1727062282, 'PPPOE', 'pandean_fatimah1', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (796, 'Markhuma', '101070026', 'markhuma@bytehome.id', '24-09-20', 5, 'Dsn. Krajan Ds. Tambaksari (Plinggisan)', '085959690300', 'Aktif', 0, '0', '', 1727063146, 'PPPOE', 'plinggisan_markhuma', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 0, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (797, 'Nurul Hidayati', '101020241', 'nurulhidayati@bytehome.id', '24-09-20', 5, 'Dsn. Kili Timur Ds. Wonosari', '081242293196', 'Aktif', 0, '0', '', 1727063482, 'PPPOE', 'kilitimur_nurul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (798, 'Siti Fauziah', '101060001', 'sitifauziah@bytehome.id', '24-09-20', 5, 'Dsn. Payangan Timur Ds. Jatirejo (Kili Timur)', '085708544936', 'Aktif', 0, '0', '', 1727064820, 'PPPOE', 'kilitimur_fauziah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 111, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (799, 'Ilmi Silviya', '101030074', 'ilmisilviya@bytehome.id', '24-09-20', 5, 'Dsn. Pandansari Ds. Pandanrejo', '082228707730', 'Aktif', 0, '0', '', 1727065584, 'PPPOE', 'pandansari_ilmi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 45, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (800, 'Siti Marisah', '101020242', 'sitimarisah@bytehome.id', '24-09-20', 5, 'Dsn. Kebonsawo Ds. Keboncandi (Podokaton)', '085739751357', 'Aktif', 0, '0', '', 1727065800, 'PPPOE', 'podokaton_marisah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 5, 0, 0, 125000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (801, 'Latifah', '101010360', 'latifah3@bytehome.id', '24-09-21', 5, 'Dsn. Seloliman Ds. Sruwi', '085855879827', 'Aktif', 0, '0', '', 1727066772, 'PPPOE', 'seloliman_latifah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 45, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (802, 'Endang Rismawati', '101030075', 'endangrismawati@bytehome.id', '24-09-04', 5, 'Dsn. Petahunan Ds. Ketegan ', '082140788144', 'Aktif', 0, '0', '', 1727405380, 'PPPOE', 'petahunan_endang', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 22, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (803, 'Fatoni', '101030076', 'fatonipandansari@bytehome.id', '24-09-24', 5, 'Dsn. Pandansari Ds. Pandanrejo', '087734801707', 'Aktif', 0, '0', '', 1727410579, 'PPPOE', 'pandansari_fatoni', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 127, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (804, 'Khilmia', '101020243', 'khilmiatanggulangin@bytehome.id', '24-09-24', 5, 'Dsn. Tanggulangin Ds. Brambang', '085230528243', 'Aktif', 0, '0', '', 1727410845, 'PPPOE', 'ngulingbrambang_khilmia', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 127, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (805, 'Saila Rizqiah', '101010361', 'sailarizqiah@bytehom.id', '24-09-24', 5, 'Dsn. Gondang Ds. Lebak (Talang)', '081236740836', 'Non-Aktif', 0, '0', '', 1727411060, 'PPPOE', 'talang_saila', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (806, 'Imam Chambali', '101020244', 'imamchambali@bytehome.id', '24-09-24', 5, 'Dsn. Sure Ds. Menyarik (Kili Wonosari)', '082144492275', 'Aktif', 0, '0', '', 1727411211, 'PPPOE', 'wonosari_imamchambali', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (807, 'Riyadus Solikhin', '101020245', 'riyadussolikhin@bytehome.id', '24-09-26', 5, 'Dsn. Pateguhan Ds. Pateguhan', '081217365323', 'Aktif', 0, '0', '', 1727418160, 'PPPOE', 'pateguhan_riyadus', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (808, 'Salman Alfarisi', '101040091', 'salmanalfarisi@bytehme.id', '24-09-26', 5, 'Dsn. Jarangan Ds. Rebalas', '085791309775', 'Aktif', 0, '0', '', 1727419445, 'PPPOE', 'rebalas_salman', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 131, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (809, 'Muslimah', '101030077', 'muslimahlobang@bytehome.id', '24-09-26', 5, 'Dsn. Lobang Ds. Pandanrejo', '081331175048', 'Non-Aktif', 0, '0', '', 1727420059, 'PPPOE', 'lobang_muslimah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (810, 'Nur Mukhammad Hasan', '101040092', 'nurmukhammadhasan@bytehome.id', '24-09-19', 5, 'Dsn. Pande Ds. Kambingan Rejo (Kedungwaru Lor)', '085607167135', 'Aktif', 0, '0', '', 1727420556, 'PPPOE', 'kedungwarulor_hasan', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 144, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (811, 'Wahyudi Yantono', '101020246', 'wahyudiyantono@bytehome.id', '24-09-27', 5, 'Dsn. Tampung Ds. Kalirejo', '088230025769', 'Aktif', 0, '0', '', 1728871838, 'PPPOE', 'tampung_wahyudi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 29, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (812, 'M. Khuzaimi', '101030078', 'mkhuzaimi@bytehome.id', '24-09-28', 5, 'Dsn. Lobang Ds. Pandanrejo', '085792136364', 'Aktif', 0, '0', '', 1728872507, 'PPPOE', 'lobang_khuzaimi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (813, 'Agus Somad', '101030079', 'agussomad@bytehome.id', '24-09-28', 5, 'Dsn. Keden Ds. Pandanrejo', '085749515069', 'Aktif', 0, '0', '', 1728872694, 'PPPOE', 'pandanrejo_agus', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (814, 'Abdillah', '101020247', 'abdillah2@bytehome.id', '24-09-30', 5, 'Dsn. Tenggilisrejo Ds. Tenggilisrejo', '085784322139', 'Aktif', 0, '0', '', 1728874124, 'PPPOE', 'tenggilis_abdillah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (815, 'Mujib', '101010362', 'mujib1@bytehome.id', '24-09-30', 5, 'Dsn. Kandung Ds. Kandung', '083832527927', 'Aktif', 0, '0', '', 1728874308, 'PPPOE', 'kandung_mujib', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (816, 'Khoirur Roziqin', '101010363', 'khoirurroziqin@bytehome.id', '24-10-01', 5, 'Dsn. Kurban Ds. Gading ', '083160394854', 'Aktif', 0, '0', '', 1728879927, 'PPPOE', 'kurban_khoirur', 0, 1, 1, 'KTP', 1, 0, 62, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (817, 'Sulaimah', '101040093', 'sulaimah@bytehome.id', '24-10-01', 5, 'Dsn. Menangas Wetan Ds. Kebonrejo', '085784471727', 'Aktif', 0, '0', '', 1728880063, 'PPPOE', 'menangaswetan_sulaimah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (818, 'Yusuf', '101010364', 'yusuf2@bytehome.id', '24-10-01', 5, 'Dsn. Kedungwaru Ds. Sidepan', '081224506977', 'Non-Aktif', 0, '0', '', 1728880498, 'PPPOE', 'kedungwarukidul_yusuf', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (819, 'Fina Rosyita', '101010365', 'finarosyita@bytehome.id', '24-10-01', 5, 'Dsn. Kurban Ds. Gading', '082333168787', 'Aktif', 0, '0', '', 1728880647, 'PPPOE', 'kurban_fina', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (820, 'Lutfi Hariono', '101010366', 'lutfihariono@bytehome.id', '24-10-01', 5, 'Dsn. Wulu Ds. Mendalan', '085708172387', 'Aktif', 0, '0', '', 1728881070, 'PPPOE', 'wulu_lutfi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (821, 'Nur Soleh', '101010367', 'nursoleh2@bytehome.id', '24-10-03', 5, 'Dsn. Watugede Ds. Jeladri', '081232146657', 'Aktif', 0, '0', '', 1728881828, 'PPPOE', 'jeladri_nursoleh', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (822, 'Nur Sobach', '101010368', 'nursobach@bytehome.id', '24-10-03', 5, 'Dsn. Mendalan Ds. Mendalan', '085784281268', 'Aktif', 0, '0', '', 1728885566, 'PPPOE', 'mendalan_soback', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 111, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (823, 'Maulana Sani', '101010369', 'maulanasani1@bytehome.id', '24-10-03', 5, 'Dsn. Karang Tengah Ds. Karang Tengah', '08155161130', 'Aktif', 0, '0', '', 1728886044, 'PPPOE', 'karangtengah_maulana', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (824, 'Ardian Maulana', '101010370', 'ardianmaulana@bytehome.id', '24-10-04', 5, 'Dsn. Krajan Ds. Kedungrejo', '088235935457', 'Non-Aktif', 0, '0', '', 1728886360, 'PPPOE', 'kedungrejo_ardian', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (825, 'Siti Lailatul Mawadah', '101020248', 'sitilailatulmawadah@bytehome.id', '24-10-04', 5, 'Dsn. Gayam Ds.Gayam', '081337967252', 'Non-Aktif', 0, '0', '', 1728886507, 'PPPOE', 'gayam_mawadah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (826, 'Samsudin', '101020249', 'samsudin3@bytehome.id', '24-10-05', 5, 'Dsn. Bambang Ds. Brambang', '085233097619', 'Aktif', 0, '0', '', 1728887207, 'PPPOE', 'brambang_samsudin', 0, 1, 1, 'KTP', 1, 0, 62, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 127, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (827, 'Siti Maria Ulfa', '101030080', 'sitimariaulfa@bytehome.id', '24-10-07', 5, 'Dsn. ndara Ds.Sadengrejo', '083836040523', 'Aktif', 0, '0', '', 1728887344, 'PPPOE', 'ndara_maria', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 131, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (828, 'Siti Chodijah', '101020250', 'sitichodijah@bytehome.id', '24-10-07', 5, 'Dsn. Kebonsawo Ds. Keboncandi', '085737047295', 'Aktif', 0, '0', '', 1728888025, 'PPPOE', 'kebonsawo_chodijah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 72, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (829, 'Lailatul Rochmah Putri', '101020251', 'lailatulrochmahputri@bytehome.id', '24-10-08', 5, 'Dsn. Ngepreng Ds. Wonosari (wonojati)', '085888555286', 'Aktif', 0, '0', '', 1728895700, 'PPPOE', 'wonojati_lailatul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (830, 'Halimah', '101020252', 'halimah@bytehome.id', '24-10-08', 5, 'Dsn. Wonosalam Ds. Wonosari', '082143623654', 'Aktif', 0, '0', '', 1728896339, 'PPPOE', 'wonosalam_halimah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 131, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (831, 'Suaibatul Aslamiya', '101010371', 'suaibatulaslamiya@bytehome.id', '24-10-08', 5, 'Dsn. Panggungrejo Ds. Panggungrejo (Gondang Lebak)', '085655808758', 'Aktif', 0, '0', '', 1728896473, 'PPPOE', 'lebak_suaibatul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 127, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (832, 'Edi Cahyono', '101070027', 'edicahyono@bytehome.id', '24-10-09', 5, 'Dsn. Jeruk Timur Ds. Jeruk', '085815474365', 'Aktif', 0, '0', '', 1728896754, 'PPPOE', 'sidogirijeruk_edi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (833, 'Misrau', '101040094', 'misrau@bytehome.id', '24-10-09', 5, 'Dsn. Adirogo Ds. Kedawung Kulon', '082167005360', 'Non-Aktif', 0, '0', '', 1728896891, 'PPPOE', 'adirogo_misrau', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (834, 'Mochammad Eko Arifianto', '101010372', 'mochammadekoarifianto@bytehome.id', '24-10-09', 5, 'Dsn. Kandung Ds. Kandung', '083135186683', 'Aktif', 0, '0', '', 1728897024, 'PPPOE', 'kandung_eko', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 127, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (835, 'Mokh. Misbahul Munir', '101010373', 'mokhmisbahulmunir@bytehome.id', '24-10-09', 5, 'Dsn. Bedilan Ds. Prodo', '085607102249', 'Aktif', 0, '0', '', 1728897161, 'PPPOE', 'bedilan_misbahul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (836, 'Akhmad Robitul Husni', '101030081', 'akhmadroitulhusni@bytehome.id', '24-10-10', 5, 'Dsn. Sadeng Ds. Sadengrejo', '083817556956', 'Aktif', 0, '0', '', 1728897346, 'PPPOE', 'sadeng_robitul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (837, 'Hidun Inafi', '101010374', 'hiduninafi@bytehome.id', '24-10-10', 5, 'Dsn. Jetis Margoutomo Ds. Prodo', '081217367363', 'Aktif', 0, '0', '', 1728897544, 'PPPOE', 'margoutomo_hidun', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (838, 'Usman Junaedi', '101010375', 'usmanjunaedi@bytehome.id', '24-10-10', 5, 'Dsn. Wulu Ds. Mendalan', '085815548458', 'Aktif', 0, '0', '', 1728897679, 'PPPOE', 'wulu_usman', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (839, 'Siti Khodijah', '101030082', 'sitikhodijah1@bytehome.id', '24-10-10', 5, 'Dsn. Pandansari Ds. Pandanrejo', '083177954477', 'Non-Aktif', 0, '0', '', 1728955981, 'PPPOE', 'pandansari_sitikhodijah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (840, 'Suhartini', '101040095', 'suhartini@bytehome.id', '24-10-11', 5, 'Dsn. Karangasem Ds. Karang Kliwon', '085790834494', 'Aktif', 0, '0', '', 1728956252, 'PPPOE', 'karangkliwon_suhartini', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (841, 'Joko Hidayat', '101020253', 'jokohidayat@bytehome.id', '24-10-12', 5, 'Dsn. Plalangan Ds. Wonojati', '081333831311', 'Aktif', 0, '0', '', 1728956565, 'PPPOE', 'plalangan_joko', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (842, 'Mukhammad Ridho', '101040096', 'mukhammadridho@bytehome.id', '24-10-12', 5, 'Dsn. Kedawungwetan Ds. Kedawungwetan (buntalan)', '08113135038', 'Aktif', 0, '0', '', 1728958020, 'PPPOE', 'buntalan_ridho', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 131, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (843, 'Ngatiaji', '101010376', 'ngatiaji@bytehome.id', '24-10-14', 5, 'Dsn. Jetis Margoutomo Ds. Prodo', '085739004620', 'Aktif', 0, '0', '', 1728960035, 'PPPOE', 'jetis_ngatiaji', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (844, 'Silfi Febriani', '101010377', 'silfifebriani@bytehome.id', '24-10-14', 5, 'Dsn. Bandaran Kidul Ds. Bandaran', '085742696701', 'Aktif', 0, '0', '', 1728960167, 'PPPOE', 'bandarankidul_silfi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 155, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (845, 'Uswatun Mufida (TK DWP 4 Sidepan)', '101010378', 'tkdwp4sidepan@bytehome.id', '24-09-27', 5, 'TK DWP Sidepan', '085730624573', 'Aktif', 0, '0', '', 1729126432, 'PPPOE', 'sidepan_tk', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 33, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (846, 'Lukman Hakim', '101020254', 'lukmanhakim2@bytehome.id', '24-09-28', 5, 'Dsn. Kebonsawo Ds. Keboncandi', '083133302197', 'Aktif', 0, '0', '', 1729126742, 'PPPOE', 'kebonsawo_lukmanhakim', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (847, 'Misnawati', '101010379', 'misnawati1@bytehome.id', '24-10-07', 5, 'Dsn. Talang Ds. Winongan kidul', '085808314965', 'Aktif', 0, '0', '', 1729126896, 'PPPOE', 'talang_misnawati', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (848, 'M. Munib', '101010380', 'mmunib@bytehome.id', '24-10-14', 5, 'Dsn. Talang Ds. Winongan Kidul', '085607139503', 'Aktif', 0, '0', '', 1729127695, 'PPPOE', 'talang_munib', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (849, 'Andi Irawan', '101030083', 'andiirawan@bytehome.id', '24-10-15', 5, 'Dsn. Gapuk Ds. Kawisrejo', '085855891425', 'Aktif', 0, '0', '', 1729127967, 'PPPOE', 'gapuk_andi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (850, 'Hoiron', '101070028', 'hoiron1@bytehome.id', '24-10-15', 5, 'Dsn. Krajan II Ds. Rejosari', '085732608741', 'Aktif', 0, '0', '', 1729128369, 'PPPOE', 'rejosari_hoiron', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 33, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (851, 'Djuarnam', '101040097', 'djuarnam@bytehome.id', '24-10-15', 5, 'Dsn. Kebonrejo Ds. Kebonrejo', '082230303915', 'Non-Aktif', 0, '0', '', 1729128489, 'PPPOE', 'kebonrejo_djuarnam', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 127, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (852, 'Andrik', '101010381', 'andrik1@bytehome.id', '24-10-16', 5, 'Dsn. Kandung Ds. Kandung', '085655863849', 'Aktif', 0, '0', '', 1729128793, 'PPPOE', 'kandung_andrik', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (853, 'Faridatul Izzah', '101020255', 'faridatulizzah@bytehome.id', '24-10-16', 5, 'Dsn. Wonosalam Ds. Wonosalam', '085850467196', 'Aktif', 0, '0', '', 1729128915, 'PPPOE', 'wonosalam_faridatul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (854, 'M. Taufik Hidayatullah', '101080003', 'mtaufikhidayatullah@bytehome.id', '24-10-17', 5, 'Dsn. Pohgading Ds. Pohgading', '087774654038', 'Aktif', 0, '0', '', 1729312829, 'PPPOE', 'pohgading_taufik', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (855, 'Edi Hermawan', '101080004', 'edihermawan@bytehome.id', '24-10-17', 5, 'Dsn. Pohgading Putih Ds. Pohgading', '085338719977', 'Aktif', 0, '0', '', 1729312973, 'PPPOE', 'pohgading_edi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 20, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (856, 'Sokhibul Anwar', '101010382', 'sokhibulanwar@bytehome.id', '24-10-17', 5, 'Dsn. Wulu Ds. Mendalan', '085707280819', 'Aktif', 0, '0', '', 1729313127, 'PPPOE', 'wulu_sokhibul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 22, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (857, 'Nurul Maulida', '101030084', 'nurulmaulida@bytehome.id', '24-10-17', 5, 'Dsn. Telbuk Ds. Kawisrejo', '083846704933', 'Aktif', 0, '0', '', 1729313255, 'PPPOE', 'telbuk_nurul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (858, 'Lailatul Hiqmi Saada', '101070029', 'lailatulhiqmisaada@bytehome.id', '24-10-18', 5, 'Dsn. Tampung Ds. Kalirejo', '081334150870', 'Aktif', 0, '0', '', 1729313425, 'PPPOE', 'tampung_hiqmi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 29, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (859, 'Chasana', '101010383', 'chasana@bytehome.id', '24-10-17', 5, 'Dsn. Mayangbang Ds. Bandaran', '081336211445', 'Aktif', 0, '0', '', 1729322056, 'PPPOE', 'bandaran_chasanah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 20, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (860, 'Saodah', '101010384', 'saodah@bytehome.id', '24-10-18', 5, 'Dsn. Kampungbaru Ds. Bandaran', '08383543722', 'Aktif', 0, '0', '', 1729322194, 'PPPOE', 'bandaran_saodah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (861, 'Safa\'ah', '101030085', 'safaah@bytehome.id', '24-10-19', 5, 'Dsn. Pandansari Ds. Pandanrejo', '082229774149', 'Aktif', 0, '0', '', 1729322801, 'PPPOE', 'pandansari_safaah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 20, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (862, 'Sugeng', '101020256', 'sugeng5@bytehome.id', '24-10-19', 5, 'Dsn. Kiringan Ds. Wonojati', '083898547721', 'Aktif', 0, '0', '', 1729322922, 'PPPOE', 'kiringan_sugeng', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (863, 'Fathur Rochman', '101070030', 'fathurrochman@bytehome.id', '24-10-19', 5, 'Dsn. Asem Kandang Barat Ds. Asem Kandang', '085804064170', 'Aktif', 0, '0', '', 1729323038, 'PPPOE', 'asemkandang_fathur', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 22, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (864, 'Abdul Mu\'ti', '101070031', 'abdulmuti@bytehome.id', '24-10-19', 5, 'Dsn. Krajan 02 Ds. Rejosari (asemkandang)', '085853180143', 'Aktif', 0, '0', '', 1729323160, 'PPPOE', 'rejosari_muti', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 0, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 109, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (865, 'Ahmad Multazam', '101030086', 'ahmadmultazam@bytehome.id', '24-10-19', 5, 'Dsn. Dara Ds. Sadengrejo', '081907254099', 'Aktif', 0, '0', '', 1729325780, 'PPPOE', 'ndara_multazam', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (866, 'Khulil Jannatul Kariam', '101020257', 'khuliljannatulkariam@bytehome.id', '24-10-02', 5, 'Dsn. Kebonsawo Ds. Kebon Candi', '085732028391', 'Aktif', 0, '0', '', 1729402661, 'PPPOE', 'kebonsawo_khulil', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (867, 'Agus Supriyadi', '101030087', 'agussupriyadi@bytehome.id', '24-10-02', 5, 'Dsn. Ketegan Ds. Ketegan', '087065457880', 'Aktif', 0, '0', '', 1729405000, 'PPPOE', 'ketegan_agus', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 22, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (868, 'Badiatul Khusnia', '101030088', 'badiatulkhusnia@bytehome.id', '24-10-19', 5, 'Dsn. Bantengan Ds. Sadengrejo', '083833203733', 'Non-Aktif', 0, '0', '', 1729406549, 'PPPOE', 'bantengan_badiatul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (869, 'Muchlason', '101020258', 'muchlason1@bytehome.id', '24-10-18', 5, 'Dsn. Karangasem Ds. Tenggilisrejo (Krajan Gondangwetan)', '082229250835', 'Aktif', 0, '0', '', 1729471459, 'PPPOE', 'gondangwetan_muchlason', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 22, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (870, 'Nadir', '101010385', 'nadir@bytehome.id', '24-10-21', 5, 'Dsn. Ketonggo Ds. Lebak', '082143554708', 'Aktif', 0, '0', '', 1729483315, 'PPPOE', 'ketonggo_nadir', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 20, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (871, 'Ahmad Syahdani', '101070032', 'ahmadsyahdani@bytehome.id', '24-10-21', 5, 'Dsn. Pagubukan Utara Ds. Lebak Sari (Ngabar)', '089529885118', 'Aktif', 0, '0', '', 1729483445, 'PPPOE', 'pagubukan_syahdani', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 22, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (872, 'Sonhaji', '101010386', 'sonhaji@bytehome.id', '24-10-21', 5, 'Dsn. Gondang Ds. Lebak', '081232287937', 'Aktif', 0, '0', '', 1729558292, 'PPPOE', 'gondanglebak_sonhaji', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 20, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (873, 'Siti Maisun', '101070033', 'sitimaisun@bytehome.id', '24-10-21', 5, 'Dsn. Asem Kandang Ds. Asem Kandang', '081547200852', 'Aktif', 0, '0', '', 1729558442, 'PPPOE', 'asemkandang_maisun', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (874, 'Dian Romandini', '101010387', 'dianromandini@bytehome.id', '24-10-21', 5, 'Dsn. Kampungbaru Ds. Bandaran', '083125346740', 'Aktif', 0, '0', '', 1729558964, 'PPPOE', 'bandaran_dian', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 72, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (875, 'Demas Irfan Azizi Romadhoni', '101020259', 'demasirfanaziziromadhoni@bytehome.id', '24-10-22', 5, 'Dsn. Karang Tengah Ds. Karang Tengah (Wonosari)', '085237180676', 'Aktif', 0, '0', '', 1729568562, 'PPPOE', 'wonosari_demas', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 29, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (876, 'Junaidi', '101020260', 'junet@bytehome.id', '24-10-22', 5, 'Dsn. Lajuk Ds. Lajuk', '085730628004', 'Non-Aktif', 0, '0', '', 1729570766, 'PPPOE', 'lajuk_junet', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '1,5M', 1, 0, 1, 0, 1, 110000, '', 0, '', 0, 2, 1, 29, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (877, 'Khamidah', '101020261', 'khamidah1@bytehome.id', '24-10-23', 5, 'Dsn. Ngemplak Ds. Kersikan', '082228844428', 'Aktif', 0, '0', '', 1729737051, 'PPPOE', 'kersikan_khamidah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (878, 'Aslicha', '101020262', 'aslicha@bytehome.id', '24-10-23', 5, 'Dsn. Brambang Barat Ds. Brambang', '083130654733', 'Aktif', 0, '0', '', 1729737326, 'PPPOE', 'brambang_aslicha', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (879, 'Siti Robiatul Adawiyah', '101010388', 'sitirobiatuladawiyah@bytehome.id', '24-10-24', 5, 'Dsn. Pradenan Ds. Winongan Lor', '085706861814', 'Aktif', 0, '0', '', 1729741897, 'PPPOE', 'winonganlor_robiatul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (880, 'Nur Cholis', '101010389', 'nurcholis1@bytehome.id', '24-10-24', 5, 'Dsn. Gedok Ds. Sidepan', '081232137192', 'Aktif', 0, '0', '', 1729751649, 'PPPOE', 'sidepan_cholis', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 29, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (881, 'Lina Agustin', '101010390', 'linaagustin@bytehome.id', '24-10-24', 5, 'Dsn. Makam Ds. Bandaran', '0', 'Aktif', 0, '0', '', 1729751764, 'PPPOE', 'karangmakam_lina', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (882, 'Nurul Aliyah', '101010391', 'nurulaliyah@bytehome.id', '24-10-24', 5, 'Dsn. Gondang Ds. Lebak', '082324343479', 'Aktif', 0, '0', '', 1729751919, 'PPPOE', 'gondanglebak_nurul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 22, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (883, 'Suntiana', '101030089', 'suntiana@bytehome.id', '24-10-24', 5, 'Dsn. Sadengrejo Ds. Sadengrejo', '083131642973', 'Aktif', 0, '0', '', 1729759173, 'PPPOE', 'sadeng_suntiana', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 22, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (884, 'Aris Sofwan', '101010392', 'arissofwan@bytehome.id', '24-10-25', 5, 'Dsn. Bicaan Ds. Mendalan', '083131571288', 'Aktif', 0, '0', '', 1729823704, 'PPPOE', 'bicaan_aris', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 0, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (885, 'Sugiono', '101020263', 'sugiono1@bytehome.id', '24-10-25', 5, 'Dsn. Sekaran Lor Ds. Wonojati', '083122163179', 'Aktif', 0, '0', '', 1729825338, 'PPPOE', 'sekaranlor_sugiono', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 20, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (886, 'Muhammad Budi Aswin', '101050003', 'muhammadbudiaswin@bytehome.id', '24-10-25', 5, 'Dsn. Kesambi Ds. Sebalong (Kili Timur)', '082334873851', 'Aktif', 0, '0', '', 1729828913, 'PPPOE', 'kilitimur_budi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (887, 'Irma Sorayah', '101020264', 'irmasorayah@bytehome.id', '24-10-26', 5, 'Dsn. Sambirasi Ds. Gayam (Trate)', '083893335895', 'Aktif', 0, '0', '', 1729922191, 'PPPOE', 'sambisari_irma', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (888, 'Mohammad Afton Tomi', '101030090', 'mohammadaftontomi@bytehome.id', '24-10-26', 5, 'Jl. Balaidesa Sekargadung Ds. Sekargadung (Bantengan)', '081585882027', 'Non-Aktif', 0, '0', '', 1729922569, 'PPPOE', 'bantengan_afton', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 23, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (889, 'Mukhamad Rizqi Syahrul', '101030091', 'mukhamadrizqisyahrul@bytehome.id', '24-10-28', 5, 'Dsn. Suklan Ds. Pandanrejo', '082264062765', 'Aktif', 0, '0', '', 1731460950, 'PPPOE', 'suklan_rizqi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (890, 'M. Sokhib', '101020265', 'msokhib@bytehome.id', '24-10-28', 5, 'Dsn. Wonosalam Ds. Wonosari', '089523609502', 'Aktif', 0, '0', '', 1731461133, 'PPPOE', 'wonosari_sokhib', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (891, 'Yazid', '101020266', 'yazid@bytehome.id', '24-10-29', 5, 'Dsn. Lodo Ds. Kalirejo (Tunjungan)', '081259347714', 'Non-Aktif', 0, '0', '', 1731461601, 'PPPOE', 'tunjungan_yazid', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (892, 'Muti\'ah', '101010393', 'Mutiah@bytehome.id', '24-10-29', 5, 'Dsn. Kruyo Kidul Ds. Umbulan', '082228906303', 'Aktif', 0, '0', '', 1731462327, 'PPPOE', 'umbulan_mutiah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (893, 'Khuzaemah', '101010394', 'khuzaemah1@bytehome.id', '24-10-29', 5, 'Dsn. Wonogriyo Ds. Sruwi', '081332546345', 'Aktif', 0, '0', '', 1731462868, 'PPPOE', 'sruwi_khuzaemah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (894, 'Syarifatun Nadhiroh', '101020267', 'syarifatunnadhiroh@bytehome.id', '24-10-29', 5, 'Dsn. Wonosalam Ds. Wonosari', '085704482937', 'Aktif', 0, '0', '', 1731569279, 'PPPOE', 'wonosalam_syarifatun', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (895, 'Musrifa', '101010395', 'musrifa1@bytehome.id', '24-10-29', 5, 'Dsn. Krajan 01 Ds. Kedungrejo', '088803896891', 'Aktif', 0, '0', '', 1731569474, 'PPPOE', 'kedungrejo_musrifa', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 273, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (896, 'Akhmadi', '101010396', 'akhmadi1@bytehome.id', '24-10-29', 5, 'Dsn. Menyarik Krajan Ds. Menyarik', '081235325894', 'Aktif', 0, '0', '', 1731569677, 'PPPOE', 'menyarik_akhmadi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 346, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (897, 'Riadus Solikhin', '101010397', 'riadussolikhin1@bytehome.id', '24-10-29', 5, 'Dsn. Kedungbendo Ds. Rejoso Lor (Gendol)', '085715332287', 'Aktif', 1, '0', '', 1731569923, 'PPPOE', 'gendol_riadus', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (898, 'Moh Saat', '101040098', 'mohsaat@bytehome.id', '24-10-30', 5, 'Dsn. Pandan Ds. Kebonrejo', '0882010466044', 'Aktif', 0, '0', '', 1731571273, 'PPPOE', 'pandan_saat', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (899, 'Mukhamad Ainul Yaqin', '101030092', 'mukhamadainulyaqin@bytehome.id', '24-10-30', 5, 'Dsn. Dara Ds. Sadengrejo', '085707434624', 'Non-Aktif', 0, '0', '', 1731571883, 'PPPOE', 'ndara_ainul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 1004, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (900, 'Rokhma Wati', '101040099', 'rokhmawati@bytehome.id', '24-10-30', 5, 'Dsn. Krajan Ds. KarangKliwon', '085797382722', 'Aktif', 0, '0', '', 1731572200, 'PPPOE', 'karangkliwon_rokhmawati', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1141, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (901, 'Mukhamad Rony Akbar (Bakso Nino)', '101010398', 'm.ronyakbar@bytehome.id', '24-10-31', 5, 'Dsn. Kalongan Ds. Mendalan (Grati)', '085730291350', 'Non-Aktif', 0, '0', '', 1731572905, 'PPPOE', 'grati_rony', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 1169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (902, 'Maria Ulfa', '101070034', 'mariaulfa01@bytehome.id', '24-10-31', 5, 'Dsn. Sungi Selatan Ds. Sungikulon', '085739657417', 'Aktif', 0, '0', '', 1731573182, 'PPPOE', 'sungi_maria', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (903, 'Aisah', '101010399', 'aisah05@bytehome.id', '24-10-31', 5, 'Dsn. Kampungbaru Ds. Bandaran', '085755400445', 'Non-Aktif', 0, '0', '', 1731573436, 'PPPOE', 'bandaran_aisah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 1174, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (904, 'Akhmad Soni', '101010400', 'akhmadsoni@bytehome.id', '24-10-31', 5, 'Dsn. Balun Ds. Gading', '081220082223', 'Aktif', 0, '0', '', 1731573723, 'PPPOE', 'balun_soni', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 88, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (905, 'Abd. Munif', '101010401', 'abdmunif@bytehome.id', '24-10-31', 5, 'Dsn. Balun Ds. Gading', '082131901771', 'Aktif', 0, '0', '', 1731574051, 'PPPOE', 'balun_munif', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1162, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (906, 'Supriyanto', '101020268', 'supriyanto02@bytehome.id', '24-10-31', 5, 'Dsn. Lodo Ds. Kalirejo', '082232878833', 'Aktif', 0, '0', '', 1731574366, 'PPPOE', 'lodo_supriyanto', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1153, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (907, 'Imam Suwondo', '101070035', 'imamsuwondo@bytehome.id', '24-11-02', 5, 'Dsn. Blusuk Ds. Parasrejo (Ngabar)', '085732777400', 'Non-Aktif', 0, '0', '', 1731632941, 'PPPOE', 'ngabar_imamsuwondo', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 1120, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (908, 'Muhamad Mustaqfirin', '101010402', 'mustaqfirin@bytehome.id', '24-11-02', 5, 'Dsn. Gondang Ds. Lebak', '085785809280', 'Aktif', 0, '0', '', 1731633168, 'PPPOE', 'gondanglebak_mustaqfirin', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 476, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (909, 'Muhamad Sukron', '101070036', 'sukron@bytehome.id', '24-11-02', 5, 'Dsn. Ngabar Ds. Ngabar', '0881036871326', 'Aktif', 0, '0', '', 1731633430, 'PPPOE', 'ngabar_sukron', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 144, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (910, 'Zuhrotul Arofa', '101070037', 'zuhrotularofa@bytehome.id', '24-11-04', 5, 'Jl. Amir Hamzah Ds. Kedung Asem (Bangilan KBC)', '081285719364', 'Aktif', 0, '0', '', 1731633605, 'PPPOE', 'bangilan_zuhrotul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 684, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (911, 'Akhmad Rifa\'i', '101010403', 'akhmadrifai@bytehome.id', '24-11-04', 5, 'Dsn. Peradenan Ds. Winongan Lor', '085739085514', 'Aktif', 0, '0', '', 1731634426, 'PPPOE', 'winonganlor_rifai', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (912, 'Siti Maimunah', '101030093', 'sitimaimunah1@bytehome.id', '24-11-04', 5, 'Dsn. Sadengrejo Ds. Sadengrejo', '082232756100', 'Aktif', 0, '0', '', 1731634632, 'PPPOE', 'sadeng_maimunah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (913, 'Dwi Mangku Sampurno', '101010404', 'dwimangkusampurno@bytehome.id', '24-11-04', 5, 'Dsn. Magersari Ds. Kedawungkulon (Kiringan)', '085755047494', 'Aktif', 0, '0', '', 1731635075, 'PPPOE', 'kiringan_dwimangko', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 270, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (914, 'Chusnul Hotimah', '101040100', 'chusnulhotimah1@bytehome.id', '24-11-04', 5, 'Dsn. Bandilan Ds. Ranuklindungan', '082339787532', 'Non-Aktif', 0, '0', '', 1731635307, 'PPPOE', 'bebekanlor_chusnul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 279, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (915, 'Rizal Pradandi', '101010405', 'rizalpradandi@bytehome.id', '24-11-05', 5, 'Dsn. Mulyorejo Lor Ds. Umbulan ', '085709609890', 'Aktif', 0, '0', '', 1731636559, 'PPPOE', 'umbulan_rizal', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 37, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (916, 'Mokh. Syafiuddin', '101010406', 'mokhsyafiuddinn@bytehome.id', '24-11-05', 5, 'Dsn. Toyowono Ds. Penataan (Sukun)', '081259347679', 'Aktif', 0, '0', '', 1731636771, 'PPPOE', 'sukun_syafiuddin', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (917, 'A. Faizal Rizqi', '101010407', 'faizalrizqii@bytehome.id', '24-11-05', 5, 'Dsn. ndara Ds.Sadengrejo', '083142682503', 'Aktif', 0, '0', '', 1731636914, 'PPPOE', 'ndara_faisal', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 120, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (918, 'Badriyah', '101020269', 'badriyah1@bytehome.id', '24-11-05', 5, 'Dsn. Tampung Ds. Kalirejo', '085707046744', 'Aktif', 0, '0', '', 1731637343, 'PPPOE', 'tampung_badriyah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 131, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (919, 'Khuzaimi', '101020270', 'khuzaimi1@bytehome.id', '24-11-10', 5, 'Dsn. Kalimalang Ds. Kalirejo', '085706073012', 'Non-Aktif', 0, '0', '', 1731637513, 'PPPOE', 'kalimalang_khuzaimi', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 212, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (920, 'M. Zakiyudin Lubis', '101030094', 'zakiyudinlubis@bytehome.id', '24-11-05', 5, 'Dsn. Suklan Ds. Pandanrejo', '083834015829', 'Aktif', 0, '0', '', 1731637650, 'PPPOE', 'suklan_zakiyudin', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 346, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (921, 'Binda Silvia Putri', '101020271', 'bindasilviaputri@bytehome.id', '24-11-05', 5, 'Dsn. Stoplas Ds. Kedungrejo (Wonosari)', '085133368988', 'Aktif', 0, '0', '', 1731638185, 'PPPOE', 'wonosari_binda', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 212, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (922, 'Mujir', '101010408', 'mujir@bytehome.id', '24-11-06', 5, 'Dsn. Umbulan Ds. Umbulan', '085335756967', 'Aktif', 0, '0', '', 1731638845, 'PPPOE', 'umbulan_mujir', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (923, 'Dewi Rukhil', '101030095', 'dewirukhil@bytehome.id', '24-11-06', 5, 'Dsn. Suklan Ds. Pandanrejo', '082245048497', 'Aktif', 0, '0', '', 1731639990, 'PPPOE', '', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (924, 'M. Kamilul Fikri', '101070038', 'mkamilulfikri@bytehome.id', '24-11-06', 5, 'Dsn. Jeruk Timur Ds. Jeruk', '085748827240', 'Aktif', 0, '0', '', 1731640177, 'PPPOE', 'jeruktimur_kamilul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (925, 'Saiful Rizal', '101020272', 'saifulrizal1@bytehome.id', '24-11-06', 5, 'Dsn. Brambang Barat Ds. Brambang', '085895347279', 'Non-Aktif', 0, '0', '', 1731640958, 'PPPOE', 'brambang_saifulrizal', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (926, 'Sutrisno', '101140001', 'sutrisno1@bytehome.id', '24-11-07', 5, 'Dsn. Krajan Ds. Curahtulis', '082234407346', 'Aktif', 0, '0', '', 1731643718, 'PPPOE', 'gading_sutrisno', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (927, 'Saliman', '101010409', 'salman@bytehome.id', '24-11-07', 5, 'Dsn. Sabungan Utara Ds. Ombol (Tenggilisrejo)', '081937140044', 'Aktif', 0, '0', '', 1731644923, 'PPPOE', 'tenggilis_saliman', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (928, 'Endang Setiowati', '101040101', 'endangsetiowati@bytehome.id', '24-11-07', 5, 'Dsn. Krawan Ds. Kedawung Wetan', '082333797646', 'Aktif', 0, '0', '', 1731645070, 'PPPOE', 'krawan_endang', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (929, 'Hidayatul Aliyah', '101020273', 'hidayatulaliyah@bytehome.id', '24-11-07', 5, 'Dsn. Pateguhan Ds. Pateguhan', '085259450974', 'Aktif', 0, '0', '', 1731645986, 'PPPOE', 'pateguhan_hidayatul', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (930, 'Subadar', '101010410', 'subadar@bytehome.id', '24-11-08', 5, 'Dsn. Kurban Ds. Gading', '082335604029', 'Aktif', 0, '0', '', 1731651161, 'PPPOE', 'kurban_subadar', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (931, 'Khudori', '101010411', 'khudori@bytehome.id', '24-11-08', 5, 'Dsn. Brintik Lor Ds. Menyarik', '085755130538', 'Non-Aktif', 0, '0', '', 1731651318, 'PPPOE', 'brintiklor_khudori', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (932, 'Muhammad Iwan Jaenuri', '101020274', 'muhammadiwanjaenuri@bytehome.id', '24-11-08', 5, 'Dsn. Tampung Ds. Kalirejo (Brambang)', '082234797919', 'Non-Aktif', 0, '0', '', 1731651872, 'PPPOE', 'brambang_iwan', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (933, 'Nurul Yatimah', '101030096', 'nurulyatimah@bytehome.id', '24-11-08', 5, 'Dsn. Dara Ds. Sadengrejo', '085854666238', 'Aktif', 0, '0', '', 1731652133, 'PPPOE', 'ndara_yatimah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (934, 'Lia Mazida Khoir', '101010412', 'liamazidakhoir@bytehome.id', '24-11-08', 5, 'Dsn. Nyangkring Ds. Menyarik', '083147653700', 'Aktif', 0, '0', '', 1731652336, 'PPPOE', 'nyangkring_lia', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (935, 'Nona Latifatul Akhifa', '101020275', 'nonalatifatulakhifa@bytehome.id', '24-11-08', 5, 'Gadel Timur Gang 11/9 Ds. Karangpoh (Rangge Selatan)', '083833118600', 'Aktif', 0, '0', '', 1731653669, 'PPPOE', 'ranggeh_nona', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (936, 'Muhammad Sukron', '101010413', 'muhammadsukronn@bytehome.id', '24-11-09', 5, 'Dsn. Tokwiro Ds. Winongan Lor (keboncandi)', '085232745021', 'Aktif', 0, '0', '', 1731654628, 'PPPOE', 'keboncandi_sukron', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 401, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (937, 'Jazuli', '101070039', 'jazuliii@bytehome.id', '24-11-09', 5, 'Dsn. Selontrek Barat Ds. Karanganyar ', '088217223465', 'Non-Aktif', 0, '0', '', 1731654917, 'PPPOE', 'selorentek_jazuli', 0, 1, 1, 'KTP', 1, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 176, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (938, 'Siti Qomariyah', '101020276', 'sitiqomariyah@bytehome.id', '24-11-09', 5, 'Dsn. Gayam Ds. Gayam (Sambi cilik)', '081559803461', 'Aktif', 0, '0', '', 1731655055, 'PPPOE', 'sambicilik_sitiqomariyah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 324, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (939, 'Cholifa', '101020277', 'cholifaa@bytyehome.id', '24-11-09', 5, 'Dsn. Wonosari Ds. Wonosari (wonosalam kulon)', '08883372417', 'Non-Aktif', 0, '0', '', 1731655490, 'PPPOE', 'wonosalam_cholifah', 0, 1, 1, 'KTP', 1, 0, 0, '', '', '5M', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 346, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
I