#
# TABLE STRUCTURE FOR: currencies
#

DROP TABLE IF EXISTS `currencies`;

CREATE TABLE `currencies` (
  `code` varchar(15) NOT NULL,
  `name` varchar(100) NOT NULL,
  `number` char(5) NOT NULL,
  `subunits_in_unit` int(11) NOT NULL,
  `countries` longtext NOT NULL COMMENT '(DC2Type:json_array)',
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AED', 'UAE Dirham', '784', 100, '[\"UNITED ARAB EMIRATES\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AFN', 'Afghani', '971', 100, '[\"AFGHANISTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ALL', 'Lek', '008', 100, '[\"ALBANIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AMD', 'Armenian Dram', '051', 100, '[\"ARMENIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ANG', 'Netherlands Antillean Guilder', '532', 100, '[\"CURA\\u00c7AO\",\"SINT MAARTEN (DUTCH PART)\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AOA', 'Kwanza', '973', 100, '[\"ANGOLA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ARS', 'Argentine Peso', '032', 100, '[\"ARGENTINA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AUD', 'Australian Dollar', '036', 100, '[\"AUSTRALIA\",\"CHRISTMAS ISLAND\",\"COCOS (KEELING) ISLANDS\",\"HEARD ISLAND AND McDONALD ISLANDS\",\"KIRIBATI\",\"NAURU\",\"NORFOLK ISLAND\",\"TUVALU\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AWG', 'Aruban Florin', '533', 100, '[\"ARUBA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AZN', 'Azerbaijanian Manat', '944', 100, '[\"AZERBAIJAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BAM', 'Convertible Mark', '977', 100, '[\"BOSNIA AND HERZEGOVINA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BBD', 'Barbados Dollar', '052', 100, '[\"BARBADOS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BDT', 'Taka', '050', 100, '[\"BANGLADESH\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BGN', 'Bulgarian Lev', '975', 100, '[\"BULGARIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BHD', 'Bahraini Dinar', '048', 1000, '[\"BAHRAIN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BIF', 'Burundi Franc', '108', 1, '[\"BURUNDI\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BMD', 'Bermudian Dollar', '060', 100, '[\"BERMUDA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BND', 'Brunei Dollar', '096', 100, '[\"BRUNEI DARUSSALAM\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BOB', 'Boliviano', '068', 100, '[\"BOLIVIA, PLURINATIONAL STATE OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BOV', 'Mvdol', '984', 100, '[\"BOLIVIA, PLURINATIONAL STATE OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BRL', 'Brazilian Real', '986', 100, '[\"BRAZIL\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BSD', 'Bahamian Dollar', '044', 100, '[\"BAHAMAS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BTN', 'Ngultrum', '064', 100, '[\"BHUTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BWP', 'Pula', '072', 100, '[\"BOTSWANA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BYR', 'Belarussian Ruble', '974', 1, '[\"BELARUS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BZD', 'Belize Dollar', '084', 100, '[\"BELIZE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CAD', 'Canadian Dollar', '124', 100, '[\"CANADA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CDF', 'Congolese Franc', '976', 100, '[\"CONGO, DEMOCRATIC REPUBLIC OF THE \"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CHE', 'WIR Euro', '947', 100, '[\"SWITZERLAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CHF', 'Swiss Franc', '756', 100, '[\"LIECHTENSTEIN\",\"SWITZERLAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CHW', 'WIR Franc', '948', 100, '[\"SWITZERLAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CLF', 'Unidad de Fomento', '990', 10000, '[\"CHILE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CLP', 'Chilean Peso', '152', 1, '[\"CHILE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CNY', 'Yuan Renminbi', '156', 100, '[\"CHINA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('COP', 'Colombian Peso', '170', 100, '[\"COLOMBIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('COU', 'Unidad de Valor Real', '970', 100, '[\"COLOMBIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CRC', 'Costa Rican Colon', '188', 100, '[\"COSTA RICA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CUC', 'Peso Convertible', '931', 100, '[\"CUBA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CUP', 'Cuban Peso', '192', 100, '[\"CUBA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CVE', 'Cape Verde Escudo', '132', 100, '[\"CAPE VERDE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CZK', 'Czech Koruna', '203', 100, '[\"CZECH REPUBLIC\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('DJF', 'Djibouti Franc', '262', 1, '[\"DJIBOUTI\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('DKK', 'Danish Krone', '208', 100, '[\"DENMARK\",\"FAROE ISLANDS\",\"GREENLAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('DOP', 'Dominican Peso', '214', 100, '[\"DOMINICAN REPUBLIC\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('DZD', 'Algerian Dinar', '012', 100, '[\"ALGERIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('EGP', 'Egyptian Pound', '818', 100, '[\"EGYPT\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ERN', 'Nakfa', '232', 100, '[\"ERITREA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ETB', 'Ethiopian Birr', '230', 100, '[\"ETHIOPIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('EUR', 'Euro', '978', 100, '[\"\\u00c5LAND ISLANDS\",\"ANDORRA\",\"AUSTRIA\",\"BELGIUM\",\"CYPRUS\",\"ESTONIA\",\"EUROPEAN UNION\",\"FINLAND\",\"FRANCE\",\"FRENCH GUIANA\",\"FRENCH SOUTHERN TERRITORIES\",\"GERMANY\",\"GREECE\",\"GUADELOUPE\",\"HOLY SEE (VATICAN CITY STATE)\",\"IRELAND\",\"ITALY\",\"LATVIA\",\"LUXEMBOURG\",\"MALTA\",\"MARTINIQUE\",\"MAYOTTE\",\"MONACO\",\"MONTENEGRO\",\"NETHERLANDS\",\"PORTUGAL\",\"R\\u00c9UNION\",\"SAINT BARTH\\u00c9LEMY\",\"SAINT MARTIN (FRENCH PART)\",\"SAINT PIERRE AND MIQUELON\",\"SAN MARINO\",\"SLOVAKIA\",\"SLOVENIA\",\"SPAIN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('FJD', 'Fiji Dollar', '242', 100, '[\"FIJI\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('FKP', 'Falkland Islands Pound', '238', 100, '[\"FALKLAND ISLANDS (MALVINAS)\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GBP', 'Pound Sterling', '826', 100, '[\"GUERNSEY\",\"ISLE OF MAN\",\"JERSEY\",\"UNITED KINGDOM\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GEL', 'Lari', '981', 100, '[\"GEORGIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GHS', 'Ghana Cedi', '936', 100, '[\"GHANA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GIP', 'Gibraltar Pound', '292', 100, '[\"GIBRALTAR\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GMD', 'Dalasi', '270', 100, '[\"GAMBIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GNF', 'Guinea Franc', '324', 1, '[\"GUINEA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GTQ', 'Quetzal', '320', 100, '[\"GUATEMALA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GYD', 'Guyana Dollar', '328', 100, '[\"GUYANA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('HKD', 'Hong Kong Dollar', '344', 100, '[\"HONG KONG\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('HNL', 'Lempira', '340', 100, '[\"HONDURAS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('HRK', 'Croatian Kuna', '191', 100, '[\"CROATIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('HTG', 'Gourde', '332', 100, '[\"HAITI\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('HUF', 'Forint', '348', 100, '[\"HUNGARY\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('IDR', 'Rupiah', '360', 100, '[\"INDONESIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ILS', 'New Israeli Sheqel', '376', 100, '[\"ISRAEL\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('INR', 'Indian Rupee', '356', 100, '[\"BHUTAN\",\"INDIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('IQD', 'Iraqi Dinar', '368', 1000, '[\"IRAQ\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('IRR', 'Iranian Rial', '364', 100, '[\"IRAN, ISLAMIC REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ISK', 'Iceland Krona', '352', 1, '[\"ICELAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('JMD', 'Jamaican Dollar', '388', 100, '[\"JAMAICA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('JOD', 'Jordanian Dinar', '400', 1000, '[\"JORDAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('JPY', 'Yen', '392', 1, '[\"JAPAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KES', 'Kenyan Shilling', '404', 100, '[\"KENYA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KGS', 'Som', '417', 100, '[\"KYRGYZSTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KHR', 'Riel', '116', 100, '[\"CAMBODIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KMF', 'Comoro Franc', '174', 1, '[\"COMOROS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KPW', 'North Korean Won', '408', 100, '[\"KOREA, DEMOCRATIC PEOPLE\\u2019S REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KRW', 'Won', '410', 1, '[\"KOREA, REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KWD', 'Kuwaiti Dinar', '414', 1000, '[\"KUWAIT\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KYD', 'Cayman Islands Dollar', '136', 100, '[\"CAYMAN ISLANDS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KZT', 'Tenge', '398', 100, '[\"KAZAKHSTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LAK', 'Kip', '418', 100, '[\"LAO PEOPLE\\u2019S DEMOCRATIC REPUBLIC\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LBP', 'Lebanese Pound', '422', 100, '[\"LEBANON\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LKR', 'Sri Lanka Rupee', '144', 100, '[\"SRI LANKA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LRD', 'Liberian Dollar', '430', 100, '[\"LIBERIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LSL', 'Loti', '426', 100, '[\"LESOTHO\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LTL', 'Lithuanian Litas', '440', 100, '[\"LITHUANIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LYD', 'Libyan Dinar', '434', 1000, '[\"LIBYA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MAD', 'Moroccan Dirham', '504', 100, '[\"MOROCCO\",\"WESTERN SAHARA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MDL', 'Moldovan Leu', '498', 100, '[\"MOLDOVA, REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MGA', 'Malagasy Ariary', '969', 100, '[\"MADAGASCAR\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MKD', 'Denar', '807', 100, '[\"MACEDONIA, THE FORMER \\nYUGOSLAV REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MMK', 'Kyat', '104', 100, '[\"MYANMAR\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MNT', 'Tugrik', '496', 100, '[\"MONGOLIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MOP', 'Pataca', '446', 100, '[\"MACAO\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MRO', 'Ouguiya', '478', 100, '[\"MAURITANIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MUR', 'Mauritius Rupee', '480', 100, '[\"MAURITIUS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MVR', 'Rufiyaa', '462', 100, '[\"MALDIVES\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MWK', 'Kwacha', '454', 100, '[\"MALAWI\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MXN', 'Mexican Peso', '484', 100, '[\"MEXICO\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MXV', 'Mexican Unidad de Inversion (UDI)', '979', 100, '[\"MEXICO\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MYR', 'Malaysian Ringgit', '458', 100, '[\"MALAYSIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MZN', 'Mozambique Metical', '943', 100, '[\"MOZAMBIQUE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('NAD', 'Namibia Dollar', '516', 100, '[\"NAMIBIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('NGN', 'Naira', '566', 100, '[\"NIGERIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('NIO', 'Cordoba Oro', '558', 100, '[\"NICARAGUA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('NOK', 'Norwegian Krone', '578', 100, '[\"BOUVET ISLAND\",\"NORWAY\",\"SVALBARD AND JAN MAYEN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('NPR', 'Nepalese Rupee', '524', 100, '[\"NEPAL\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('NZD', 'New Zealand Dollar', '554', 100, '[\"COOK ISLANDS\",\"NEW ZEALAND\",\"NIUE\",\"PITCAIRN\",\"TOKELAU\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('OMR', 'Rial Omani', '512', 1000, '[\"OMAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PAB', 'Balboa', '590', 100, '[\"PANAMA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PEN', 'Nuevo Sol', '604', 100, '[\"PERU\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PGK', 'Kina', '598', 100, '[\"PAPUA NEW GUINEA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PHP', 'Philippine Peso', '608', 100, '[\"PHILIPPINES\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PKR', 'Pakistan Rupee', '586', 100, '[\"PAKISTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PLN', 'Zloty', '985', 100, '[\"POLAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PYG', 'Guarani', '600', 1, '[\"PARAGUAY\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('QAR', 'Qatari Rial', '634', 100, '[\"QATAR\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('RON', 'New Romanian Leu', '946', 100, '[\"ROMANIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('RSD', 'Serbian Dinar', '941', 100, '[\"SERBIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('RUB', 'Russian Ruble', '643', 100, '[\"RUSSIAN FEDERATION\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('RWF', 'Rwanda Franc', '646', 1, '[\"RWANDA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SAR', 'Saudi Riyal', '682', 100, '[\"SAUDI ARABIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SBD', 'Solomon Islands Dollar', '090', 100, '[\"SOLOMON ISLANDS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SCR', 'Seychelles Rupee', '690', 100, '[\"SEYCHELLES\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SDG', 'Sudanese Pound', '938', 100, '[\"SUDAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SEK', 'Swedish Krona', '752', 100, '[\"SWEDEN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SGD', 'Singapore Dollar', '702', 100, '[\"SINGAPORE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SHP', 'Saint Helena Pound', '654', 100, '[\"SAINT HELENA, ASCENSION AND \\nTRISTAN DA CUNHA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SLL', 'Leone', '694', 100, '[\"SIERRA LEONE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SOS', 'Somali Shilling', '706', 100, '[\"SOMALIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SRD', 'Surinam Dollar', '968', 100, '[\"SURINAME\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SSP', 'South Sudanese Pound', '728', 100, '[\"SOUTH SUDAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('STD', 'Dobra', '678', 100, '[\"SAO TOME AND PRINCIPE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SVC', 'El Salvador Colon', '222', 100, '[\"EL SALVADOR\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SYP', 'Syrian Pound', '760', 100, '[\"SYRIAN ARAB REPUBLIC\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SZL', 'Lilangeni', '748', 100, '[\"SWAZILAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('THB', 'Baht', '764', 100, '[\"THAILAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TJS', 'Somoni', '972', 100, '[\"TAJIKISTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TMT', 'Turkmenistan New Manat', '934', 100, '[\"TURKMENISTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TND', 'Tunisian Dinar', '788', 1000, '[\"TUNISIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TOP', 'Pa’anga', '776', 100, '[\"TONGA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TRY', 'Turkish Lira', '949', 100, '[\"TURKEY\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TTD', 'Trinidad and Tobago Dollar', '780', 100, '[\"TRINIDAD AND TOBAGO\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TWD', 'New Taiwan Dollar', '901', 100, '[\"TAIWAN, PROVINCE OF CHINA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TZS', 'Tanzanian Shilling', '834', 100, '[\"TANZANIA, UNITED REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('UAH', 'Hryvnia', '980', 100, '[\"UKRAINE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('UGX', 'Uganda Shilling', '800', 1, '[\"UGANDA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('USD', 'US Dollar', '840', 100, '[\"AMERICAN SAMOA\",\"BONAIRE, SINT EUSTATIUS AND SABA\",\"BRITISH INDIAN OCEAN TERRITORY\",\"ECUADOR\",\"EL SALVADOR\",\"GUAM\",\"HAITI\",\"MARSHALL ISLANDS\",\"MICRONESIA, FEDERATED STATES OF\",\"NORTHERN MARIANA ISLANDS\",\"PALAU\",\"PANAMA\",\"PUERTO RICO\",\"TIMOR-LESTE\",\"TURKS AND CAICOS ISLANDS\",\"UNITED STATES\",\"UNITED STATES MINOR OUTLYING ISLANDS\",\"VIRGIN ISLANDS (BRITISH)\",\"VIRGIN ISLANDS (U.S.)\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('USN', 'US Dollar (Next day)', '997', 100, '[\"UNITED STATES\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)', '940', 1, '[\"URUGUAY\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('UYU', 'Peso Uruguayo', '858', 100, '[\"URUGUAY\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('UZS', 'Uzbekistan Sum', '860', 100, '[\"UZBEKISTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('VEF', 'Bolivar', '937', 100, '[\"VENEZUELA, BOLIVARIAN REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('VND', 'Dong', '704', 1, '[\"VIET NAM\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('VUV', 'Vatu', '548', 1, '[\"VANUATU\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('WST', 'Tala', '882', 100, '[\"SAMOA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XAF', 'CFA Franc BEAC', '950', 1, '[\"CAMEROON\",\"CENTRAL AFRICAN REPUBLIC\",\"CHAD\",\"CONGO\",\"EQUATORIAL GUINEA\",\"GABON\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XCD', 'East Caribbean Dollar', '951', 100, '[\"ANGUILLA\",\"ANTIGUA AND BARBUDA\",\"DOMINICA\",\"GRENADA\",\"MONTSERRAT\",\"SAINT KITTS AND NEVIS\",\"SAINT LUCIA\",\"SAINT VINCENT AND THE GRENADINES\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XDR', 'SDR (Special Drawing Right)', '960', 1, '[\"INTERNATIONAL MONETARY FUND (IMF)\\u00a0\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XOF', 'CFA Franc BCEAO', '952', 1, '[\"BENIN\",\"BURKINA FASO\",\"C\\u00d4TE D\'IVOIRE\",\"GUINEA-BISSAU\",\"MALI\",\"NIGER\",\"SENEGAL\",\"TOGO\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XPF', 'CFP Franc', '953', 1, '[\"FRENCH POLYNESIA\",\"NEW CALEDONIA\",\"WALLIS AND FUTUNA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XSU', 'Sucre', '994', 1, '[\"SISTEMA UNITARIO DE COMPENSACION REGIONAL DE PAGOS \\\"SUCRE\\\"\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XUA', 'ADB Unit of Account', '965', 1, '[\"MEMBER COUNTRIES OF THE AFRICAN DEVELOPMENT BANK GROUP\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('YER', 'Yemeni Rial', '886', 100, '[\"YEMEN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ZAR', 'Rand', '710', 100, '[\"LESOTHO\",\"NAMIBIA\",\"SOUTH AFRICA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ZMW', 'Zambian Kwacha', '967', 100, '[\"ZAMBIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ZWL', 'Zimbabwe Dollar', '932', 100, '[\"ZIMBABWE\"]');


